/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.misc;

import java.util.Comparator;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.misc.HighFreqTerms;
import org.apache.lucene.misc.TermStats;

public class HighFreqTermsMultiFields
extends HighFreqTerms {
    public static TermStats[] getHighFreqTermsMultiFields(IndexReader reader, int numTerms, String[] fieldNames, Comparator<TermStats> comparator) throws Exception {
        Fields fields;
        HighFreqTerms.TermStatsQueue tiq = new HighFreqTerms.TermStatsQueue(numTerms, comparator);
        if (fieldNames != null) {
            fields = MultiFields.getFields((IndexReader)reader);
            for (String field : fieldNames) {
                Terms terms = fields.terms(field);
                if (terms == null) continue;
                TermsEnum te = terms.iterator();
                tiq.fill(field, te);
            }
        } else {
            fields = MultiFields.getFields((IndexReader)reader);
            if (fields.size() == 0) {
                throw new RuntimeException("no fields found for this index");
            }
            for (String fieldName : fields) {
                Terms terms = fields.terms(fieldName);
                if (terms == null) continue;
                tiq.fill(fieldName, terms.iterator());
            }
        }
        TermStats[] result = new TermStats[tiq.size()];
        int count = tiq.size() - 1;
        while (tiq.size() != 0) {
            result[count] = (TermStats)tiq.pop();
            --count;
        }
        return result;
    }
}

