/*
 * Copyright (c) 2008, intarsys consulting GmbH
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published by the 
 * Free Software Foundation; either version 3 of the License, 
 * or (at your option) any later version.
 * <p/>
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
 * 
 */
package de.intarsys.pdf.platform.cwt.font;

import de.intarsys.pdf.font.PDGlyphs;
import de.intarsys.pdf.platform.cwt.rendering.ICSPlatformDevice;

/**
 * The platform dependent representation for a glyph.
 */
public interface IPlatformGlyphs {

	/**
	 * The associated PD level glyphs {@link PDGlyphs} instance.
	 * 
	 * @return The associated PD level glyphs {@link PDGlyphs} instance.
	 */
	public PDGlyphs getGlyphs();

	/**
	 * The platform dependent font where the {@link IPlatformGlyphs} object
	 * resides.
	 * 
	 * @return The platform dependent font where the {@link IPlatformGlyphs}
	 *         object resides.
	 */
	public IPlatformFont getPlatformFont();

	/**
	 * The glyph width encoded in the font program expressed in PDF glyph space.
	 * 
	 * @return The glyph width encoded in the font program expressed in PDF
	 *         glyph space.
	 */
	public int getWidth();

	/**
	 * Render the {@link IPlatformGlyphs} object on an {@link ICSPlatformDevice}.
	 * 
	 * @param device
	 *            The device to draw upon.
	 */
	public void render(ICSPlatformDevice device);
}
