/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.sulky.codec.filebuffer;

import de.huxhorn.sulky.buffers.BasicBufferIterator;
import de.huxhorn.sulky.buffers.Buffer;
import de.huxhorn.sulky.codec.Codec;
import de.huxhorn.sulky.codec.filebuffer.DataStrategy;
import de.huxhorn.sulky.codec.filebuffer.DefaultDataStrategy;
import de.huxhorn.sulky.codec.filebuffer.DefaultFileHeaderStrategy;
import de.huxhorn.sulky.codec.filebuffer.DefaultIndexStrategy;
import de.huxhorn.sulky.codec.filebuffer.FileHeader;
import de.huxhorn.sulky.codec.filebuffer.FileHeaderStrategy;
import de.huxhorn.sulky.codec.filebuffer.IndexStrategy;
import de.huxhorn.sulky.codec.filebuffer.MetaData;
import de.huxhorn.sulky.codec.filebuffer.SparseDataStrategy;
import de.huxhorn.sulky.io.IOUtilities;
import java.io.File;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.RandomAccessFile;
import java.util.Iterator;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadOnlyExclusiveCodecFileBuffer<E>
implements Buffer<E> {
    private final Logger logger = LoggerFactory.getLogger(ReadOnlyExclusiveCodecFileBuffer.class);
    private final Lock lock = new ReentrantLock();
    private Codec<E> codec;
    private DataStrategy<E> dataStrategy;
    private IndexStrategy indexStrategy = new DefaultIndexStrategy();
    private FileHeader fileHeader;
    private RandomAccessFile randomAccessIndexFile;
    private RandomAccessFile randomAccessDataFile;

    public ReadOnlyExclusiveCodecFileBuffer(File dataFile, File indexFile) throws IOException {
        this(dataFile, indexFile, new DefaultFileHeaderStrategy());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReadOnlyExclusiveCodecFileBuffer(File dataFile, File indexFile, FileHeaderStrategy fileHeaderStrategy) throws IOException {
        if (!dataFile.canRead()) {
            throw new IllegalArgumentException("'" + dataFile.getAbsolutePath() + "' is not readable.");
        }
        if (!indexFile.canRead()) {
            throw new IllegalArgumentException("'" + indexFile.getAbsolutePath() + "' is not readable.");
        }
        this.lock.lock();
        try {
            FileHeader header = fileHeaderStrategy.readFileHeader(dataFile);
            if (header == null) {
                throw new IllegalArgumentException("Could not read file header from file '" + dataFile.getAbsolutePath() + "'. File isn't compatible.");
            }
            this.setFileHeader(header);
            this.randomAccessIndexFile = new RandomAccessFile(indexFile, "r");
            this.randomAccessDataFile = new RandomAccessFile(dataFile, "r");
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Codec<E> getCodec() {
        this.lock.lock();
        try {
            Codec<E> codec = this.codec;
            return codec;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCodec(Codec<E> codec) {
        this.lock.lock();
        try {
            this.codec = codec;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E get(long index) {
        Throwable throwable;
        block17: {
            throwable = null;
            this.lock.lock();
            try {
                E e;
                if (this.codec == null) {
                    throw new IllegalStateException("codec must not be null!");
                }
                if (this.randomAccessIndexFile == null || this.randomAccessDataFile == null) break block17;
                try {
                    e = this.dataStrategy.get(index, this.randomAccessIndexFile, this.randomAccessDataFile, this.codec, this.indexStrategy);
                }
                catch (Throwable e2) {
                    throwable = e2;
                    break block17;
                }
                return e;
            }
            finally {
                this.lock.unlock();
            }
        }
        if (throwable != null) {
            if (throwable instanceof ClassNotFoundException || throwable instanceof InvalidClassException) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn("Couldn't deserialize object at index {}!\n{}", (Object)index, (Object)throwable);
                }
            } else if (throwable instanceof ClassCastException) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn("Couldn't cast deserialized object at index {}!\n{}", (Object)index, (Object)throwable);
                }
            } else if (this.logger.isWarnEnabled()) {
                this.logger.warn("Couldn't retrieve element at index {}!", (Object)index, (Object)throwable);
            }
            IOUtilities.interruptIfNecessary((Throwable)throwable);
        } else if (this.logger.isWarnEnabled()) {
            this.logger.warn("Buffer has already been closed.");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSize() {
        Throwable throwable;
        block10: {
            throwable = null;
            this.lock.lock();
            try {
                if (this.randomAccessIndexFile == null) break block10;
                try {
                    long l = this.indexStrategy.getSize(this.randomAccessIndexFile);
                    return l;
                }
                catch (Throwable e) {
                    throwable = e;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        if (throwable != null) {
            IOUtilities.interruptIfNecessary((Throwable)throwable);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Couldn't retrieve size!", throwable);
            }
        } else if (this.logger.isWarnEnabled()) {
            this.logger.warn("Buffer has already been closed.");
        }
        return 0L;
    }

    public Iterator<E> iterator() {
        return new BasicBufferIterator((Buffer)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.lock.lock();
        try {
            IOUtilities.closeQuietly((RandomAccessFile)this.randomAccessIndexFile);
            this.randomAccessIndexFile = null;
            IOUtilities.closeQuietly((RandomAccessFile)this.randomAccessDataFile);
            this.randomAccessDataFile = null;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileHeader getFileHeader() {
        this.lock.lock();
        try {
            FileHeader fileHeader = this.fileHeader;
            return fileHeader;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setFileHeader(FileHeader fileHeader) {
        this.lock.lock();
        try {
            MetaData metaData = fileHeader.getMetaData();
            this.dataStrategy = metaData.isSparse() ? new SparseDataStrategy() : new DefaultDataStrategy();
            this.fileHeader = fileHeader;
        }
        finally {
            this.lock.unlock();
        }
    }
}

