/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.sulky.buffers;

import de.huxhorn.sulky.buffers.BasicBufferIterator;
import de.huxhorn.sulky.buffers.FileBuffer;
import de.huxhorn.sulky.io.IOUtilities;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerializingFileBuffer<E>
implements FileBuffer<E> {
    private final Logger logger = LoggerFactory.getLogger(SerializingFileBuffer.class);
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock(true);
    private File dataFile;
    private File indexFile;
    private static final String INDEX_EXTENSION = ".index";

    public SerializingFileBuffer(File dataFile) {
        this(dataFile, null);
    }

    public SerializingFileBuffer(File dataFile, File indexFile) {
        this.setDataFile(dataFile);
        if (indexFile == null) {
            File parent = dataFile.getParentFile();
            String indexName = dataFile.getName();
            int dotIndex = indexName.lastIndexOf(46);
            if (dotIndex > 0) {
                indexName = indexName.substring(0, dotIndex);
            }
            indexName = indexName + INDEX_EXTENSION;
            indexFile = new File(parent, indexName);
        }
        this.setIndexFile(indexFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getSize() {
        Throwable throwable;
        block9: {
            long l;
            Lock lock;
            RandomAccessFile raf;
            block8: {
                raf = null;
                lock = this.readWriteLock.readLock();
                lock.lock();
                if (this.indexFile.canRead()) break block8;
                long l2 = 0L;
                IOUtilities.closeQuietly(raf);
                lock.unlock();
                return l2;
            }
            try {
                raf = new RandomAccessFile(this.indexFile, "r");
                l = this.internalGetSize(raf);
            }
            catch (Throwable e) {
                try {
                    throwable = e;
                    break block9;
                }
                catch (Throwable throwable2) {
                    throw throwable2;
                }
                finally {
                    IOUtilities.closeQuietly(raf);
                    lock.unlock();
                }
            }
            IOUtilities.closeQuietly((RandomAccessFile)raf);
            lock.unlock();
            return l;
        }
        if (throwable != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Couldn't retrieve size!", throwable);
            }
            IOUtilities.interruptIfNecessary((Throwable)throwable);
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E get(long index) {
        long elementsCount;
        Throwable throwable;
        E result;
        block19: {
            Lock lock;
            RandomAccessFile randomSerializeFile;
            RandomAccessFile randomSerializeIndexFile;
            block18: {
                E e;
                block17: {
                    randomSerializeIndexFile = null;
                    randomSerializeFile = null;
                    result = null;
                    lock = this.readWriteLock.readLock();
                    lock.lock();
                    throwable = null;
                    elementsCount = 0L;
                    if (this.dataFile.canRead() && this.indexFile.canRead()) break block17;
                    E e2 = null;
                    IOUtilities.closeQuietly(randomSerializeFile);
                    IOUtilities.closeQuietly(randomSerializeIndexFile);
                    lock.unlock();
                    return e2;
                }
                try {
                    randomSerializeIndexFile = new RandomAccessFile(this.indexFile, "r");
                    randomSerializeFile = new RandomAccessFile(this.dataFile, "r");
                    elementsCount = this.internalGetSize(randomSerializeIndexFile);
                    if (index < 0L || index >= elementsCount) break block18;
                    long offset = this.internalOffsetOfElement(randomSerializeIndexFile, index);
                    e = result = (E)this.internalReadElement(randomSerializeFile, offset);
                }
                catch (Throwable e3) {
                    try {
                        throwable = e3;
                        break block19;
                    }
                    catch (Throwable throwable2) {
                        throw throwable2;
                    }
                    finally {
                        IOUtilities.closeQuietly(randomSerializeFile);
                        IOUtilities.closeQuietly(randomSerializeIndexFile);
                        lock.unlock();
                    }
                }
                IOUtilities.closeQuietly((RandomAccessFile)randomSerializeFile);
                IOUtilities.closeQuietly((RandomAccessFile)randomSerializeIndexFile);
                lock.unlock();
                return e;
            }
            IOUtilities.closeQuietly((RandomAccessFile)randomSerializeFile);
            IOUtilities.closeQuietly((RandomAccessFile)randomSerializeIndexFile);
            lock.unlock();
        }
        if (throwable != null) {
            if (throwable instanceof ClassNotFoundException || throwable instanceof InvalidClassException) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn("Couldn't deserialize object at index {}!\n{}", (Object)index, (Object)throwable);
                }
            } else if (throwable instanceof ClassCastException) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn("Couldn't cast deserialized object at index {}!\n{}", (Object)index, (Object)throwable);
                }
            } else if (this.logger.isWarnEnabled()) {
                this.logger.warn("Couldn't retrieve element at index {}!", (Object)index, (Object)throwable);
            }
            IOUtilities.interruptIfNecessary((Throwable)throwable);
        } else if (index < 0L || index >= elementsCount) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("index ({}) must be in the range [0..<{}]. Returning null.", (Object)index, (Object)elementsCount);
            }
            return null;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(E element) {
        RandomAccessFile randomSerializeIndexFile = null;
        RandomAccessFile randomSerializeFile = null;
        IOException throwable = null;
        Lock lock = this.readWriteLock.writeLock();
        lock.lock();
        try {
            randomSerializeIndexFile = new RandomAccessFile(this.indexFile, "rw");
            randomSerializeFile = new RandomAccessFile(this.dataFile, "rw");
            long elementsCount = this.internalGetSize(randomSerializeIndexFile);
            long offset = 0L;
            if (elementsCount > 0L) {
                long prevElement = elementsCount - 1L;
                offset = this.internalOffsetOfElement(randomSerializeIndexFile, prevElement);
                offset = offset + this.internalReadElementSize(randomSerializeFile, offset) + 4L;
            }
            this.internalWriteElement(randomSerializeFile, offset, element);
            this.internalWriteOffset(randomSerializeIndexFile, elementsCount, offset);
        }
        catch (IOException e) {
            try {
                throwable = e;
            }
            catch (Throwable throwable2) {
                IOUtilities.closeQuietly(randomSerializeFile);
                IOUtilities.closeQuietly(randomSerializeIndexFile);
                lock.unlock();
                throw throwable2;
            }
            IOUtilities.closeQuietly(randomSerializeFile);
            IOUtilities.closeQuietly((RandomAccessFile)randomSerializeIndexFile);
            lock.unlock();
        }
        IOUtilities.closeQuietly((RandomAccessFile)randomSerializeFile);
        IOUtilities.closeQuietly((RandomAccessFile)randomSerializeIndexFile);
        lock.unlock();
        if (throwable != null) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Couldn't write element!", (Throwable)throwable);
            }
            IOUtilities.interruptIfNecessary((Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAll(List<E> elements) {
        block9: {
            int newElementCount;
            if (elements == null || (newElementCount = elements.size()) <= 0) break block9;
            RandomAccessFile randomSerializeIndexFile = null;
            RandomAccessFile randomSerializeFile = null;
            Throwable throwable = null;
            Lock lock = this.readWriteLock.writeLock();
            lock.lock();
            try {
                randomSerializeIndexFile = new RandomAccessFile(this.indexFile, "rw");
                randomSerializeFile = new RandomAccessFile(this.dataFile, "rw");
                long elementsCount = this.internalGetSize(randomSerializeIndexFile);
                long offset = 0L;
                if (elementsCount > 0L) {
                    long prevElement = elementsCount - 1L;
                    offset = this.internalOffsetOfElement(randomSerializeIndexFile, prevElement);
                    offset = offset + this.internalReadElementSize(randomSerializeFile, offset) + 4L;
                }
                long[] offsets = new long[elements.size()];
                int index = 0;
                for (E element : elements) {
                    offsets[index] = offset;
                    offset = offset + (long)this.internalWriteElement(randomSerializeFile, offset, element) + 4L;
                    ++index;
                }
                index = 0;
                for (long curOffset : offsets) {
                    this.internalWriteOffset(randomSerializeIndexFile, elementsCount + (long)index, curOffset);
                    ++index;
                }
            }
            catch (Throwable e) {
                try {
                    throwable = e;
                }
                catch (Throwable throwable2) {
                    IOUtilities.closeQuietly(randomSerializeFile);
                    IOUtilities.closeQuietly(randomSerializeIndexFile);
                    lock.unlock();
                    throw throwable2;
                }
                IOUtilities.closeQuietly(randomSerializeFile);
                IOUtilities.closeQuietly((RandomAccessFile)randomSerializeIndexFile);
                lock.unlock();
            }
            IOUtilities.closeQuietly((RandomAccessFile)randomSerializeFile);
            IOUtilities.closeQuietly((RandomAccessFile)randomSerializeIndexFile);
            lock.unlock();
            if (throwable != null) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn("Couldn't write element!", throwable);
                }
                IOUtilities.interruptIfNecessary((Throwable)throwable);
            }
        }
    }

    @Override
    public void addAll(E[] elements) {
        this.addAll(Arrays.asList(elements));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        boolean dataDeleted;
        boolean indexDeleted;
        Lock lock = this.readWriteLock.writeLock();
        lock.lock();
        try {
            indexDeleted = this.indexFile.delete();
            dataDeleted = this.dataFile.delete();
        }
        finally {
            lock.unlock();
        }
        if (!indexDeleted && this.logger.isDebugEnabled()) {
            this.logger.debug("Couldn't delete index file {}.", (Object)this.indexFile.getAbsolutePath());
        }
        if (!dataDeleted && this.logger.isDebugEnabled()) {
            this.logger.debug("Couldn't delete data file {}.", (Object)this.dataFile.getAbsolutePath());
        }
    }

    @Override
    public boolean isFull() {
        return false;
    }

    @Override
    public Iterator<E> iterator() {
        return new BasicBufferIterator(this);
    }

    @Override
    public File getDataFile() {
        return this.dataFile;
    }

    private long internalOffsetOfElement(RandomAccessFile randomSerializeIndexFile, long index) throws IOException {
        long offsetOffset = 8L * index;
        if (randomSerializeIndexFile.length() < offsetOffset + 8L) {
            throw new IndexOutOfBoundsException("Invalid index: " + index + "!");
        }
        randomSerializeIndexFile.seek(offsetOffset);
        return randomSerializeIndexFile.readLong();
    }

    private long internalGetSize(RandomAccessFile randomSerializeIndexFile) throws IOException {
        return randomSerializeIndexFile.length() / 8L;
    }

    private E internalReadElement(RandomAccessFile randomSerializeFile, long offset) throws IOException, ClassNotFoundException, ClassCastException {
        if (randomSerializeFile.length() < offset + 4L) {
            throw new IndexOutOfBoundsException("Invalid offset: " + offset + "! Couldn't read length of data!");
        }
        randomSerializeFile.seek(offset);
        int bufferSize = randomSerializeFile.readInt();
        if (randomSerializeFile.length() < offset + 4L + (long)bufferSize) {
            throw new IndexOutOfBoundsException("Invalid length (" + bufferSize + ") at offset: " + offset + "!");
        }
        byte[] buffer = new byte[bufferSize];
        randomSerializeFile.readFully(buffer);
        ByteArrayInputStream bis = new ByteArrayInputStream(buffer);
        GZIPInputStream gis = new GZIPInputStream(bis);
        ObjectInputStream ois = new ObjectInputStream(gis);
        Object e = ois.readObject();
        return (E)e;
    }

    private void internalWriteOffset(RandomAccessFile randomSerializeIndexFile, long index, long offset) throws IOException {
        long offsetOffset = 8L * index;
        if (randomSerializeIndexFile.length() < offsetOffset) {
            throw new IOException("Invalid offsetOffset " + offsetOffset + "!");
        }
        randomSerializeIndexFile.seek(offsetOffset);
        randomSerializeIndexFile.writeLong(offset);
    }

    private int internalWriteElement(RandomAccessFile randomSerializeFile, long offset, E element) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        GZIPOutputStream gos = new GZIPOutputStream(bos);
        ObjectOutputStream out = new ObjectOutputStream(gos);
        out.writeObject(element);
        out.flush();
        out.close();
        gos.finish();
        byte[] buffer = bos.toByteArray();
        int bufferSize = buffer.length;
        randomSerializeFile.seek(offset);
        randomSerializeFile.writeInt(bufferSize);
        randomSerializeFile.write(buffer);
        return bufferSize;
    }

    private long internalReadElementSize(RandomAccessFile randomSerializeFile, long offset) throws IOException {
        randomSerializeFile.seek(offset);
        return randomSerializeFile.readInt();
    }

    private void setDataFile(File dataFile) {
        this.prepareFile(dataFile);
        this.dataFile = dataFile;
    }

    private void setIndexFile(File indexFile) {
        this.prepareFile(indexFile);
        this.indexFile = indexFile;
    }

    private void prepareFile(File file) {
        File parent = file.getParentFile();
        if (parent != null) {
            if (parent.mkdirs() && this.logger.isDebugEnabled()) {
                this.logger.debug("Created directory {}.", (Object)parent.getAbsolutePath());
            }
            if (!parent.isDirectory()) {
                throw new IllegalArgumentException(parent.getAbsolutePath() + " is not a directory!");
            }
            if (file.isFile() && !file.canWrite()) {
                throw new IllegalArgumentException(file.getAbsolutePath() + " is not writable!");
            }
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("SerializingFileBuffer[");
        result.append("dataFile=");
        if (this.dataFile == null) {
            result.append("null");
        } else {
            result.append("\"").append(this.dataFile.getAbsolutePath()).append("\"");
        }
        result.append(", ");
        result.append("indexFile=");
        if (this.indexFile == null) {
            result.append("null");
        } else {
            result.append("\"").append(this.indexFile.getAbsolutePath()).append("\"");
        }
        result.append("]");
        return result.toString();
    }
}

