/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.logback.appender;

import ch.qos.logback.access.spi.AccessEvent;
import de.huxhorn.lilith.data.access.logback.TransformingEncoder;
import de.huxhorn.lilith.data.access.protobuf.AccessEventProtobufEncoder;
import de.huxhorn.lilith.logback.appender.MultiplexSocketAppenderBase;
import de.huxhorn.sulky.codec.Encoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccessMultiplexSocketAppender
extends MultiplexSocketAppenderBase<AccessEvent> {
    public static final int COMPRESSED_DEFAULT_PORT = 10010;
    public static final int UNCOMPRESSED_DEFAULT_PORT = 10011;
    private boolean compressing;
    private boolean usingDefaultPort = true;
    private TransformingEncoder transformingEncoder = new TransformingEncoder();

    public AccessMultiplexSocketAppender() {
        this(true);
    }

    public AccessMultiplexSocketAppender(boolean compressing) {
        this.setEncoder((Encoder)this.transformingEncoder);
        this.setCompressing(compressing);
    }

    protected void applicationIdentifierChanged() {
        this.transformingEncoder.setApplicationIdentifier(this.getApplicationIdentifier());
    }

    protected void uuidChanged() {
        this.transformingEncoder.setUUID(this.getUUID());
    }

    public void setPort(int port) {
        super.setPort(port);
        this.usingDefaultPort = false;
    }

    public void setCompressing(boolean compressing) {
        this.compressing = compressing;
        if (this.usingDefaultPort) {
            if (compressing) {
                this.setPort(10010);
            } else {
                this.setPort(10011);
            }
            this.usingDefaultPort = true;
        }
        this.transformingEncoder.setLilithEncoder((Encoder)new AccessEventProtobufEncoder(compressing));
    }

    public boolean isCompressing() {
        return this.compressing;
    }

    protected void preProcess(AccessEvent e) {
        if (e != null) {
            e.prepareForDeferredProcessing();
        }
    }
}

