/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.log4j.xml;

import de.huxhorn.lilith.data.logging.ExtendedStackTraceElement;
import de.huxhorn.lilith.data.logging.LoggingEvent;
import de.huxhorn.lilith.data.logging.Message;
import de.huxhorn.lilith.data.logging.ThreadInfo;
import de.huxhorn.lilith.data.logging.ThrowableInfo;
import de.huxhorn.lilith.data.logging.ThrowableInfoParser;
import de.huxhorn.lilith.log4j.xml.LoggingEventSchemaConstants;
import de.huxhorn.sulky.stax.GenericStreamReader;
import de.huxhorn.sulky.stax.StaxUtilities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggingEventReader
implements GenericStreamReader<LoggingEvent>,
LoggingEventSchemaConstants {
    private static final String NEWLINE = "\n";

    public LoggingEvent read(XMLStreamReader reader) throws XMLStreamException {
        LoggingEvent result = null;
        String rootNamespace = "http://jakarta.apache.org/log4j/";
        int type = reader.getEventType();
        if (7 == type) {
            do {
                reader.next();
            } while ((type = reader.getEventType()) != 1);
            rootNamespace = null;
        }
        if (1 == type && "event".equals(reader.getLocalName())) {
            result = new LoggingEvent();
            result.setLogger(StaxUtilities.readAttributeValue((XMLStreamReader)reader, (String)"http://jakarta.apache.org/log4j/", (String)"logger"));
            String levelStr = StaxUtilities.readAttributeValue((XMLStreamReader)reader, (String)"http://jakarta.apache.org/log4j/", (String)"level");
            if ("FATAL".equals(levelStr)) {
                levelStr = "ERROR";
            }
            try {
                result.setLevel(LoggingEvent.Level.valueOf((String)levelStr));
            }
            catch (IllegalArgumentException ex) {
                // empty catch block
            }
            String threadName = StaxUtilities.readAttributeValue((XMLStreamReader)reader, (String)"http://jakarta.apache.org/log4j/", (String)"thread");
            Long threadId = null;
            try {
                String threadIdStr = StaxUtilities.readAttributeValue((XMLStreamReader)reader, (String)"http://jakarta.apache.org/log4j/", (String)"threadId");
                if (threadIdStr != null) {
                    threadId = Long.valueOf(threadIdStr);
                }
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
            String threadGroupName = StaxUtilities.readAttributeValue((XMLStreamReader)reader, (String)"http://jakarta.apache.org/log4j/", (String)"threadGroup");
            Long threadGroupId = null;
            try {
                String idStr = StaxUtilities.readAttributeValue((XMLStreamReader)reader, (String)"http://jakarta.apache.org/log4j/", (String)"threadGroupId");
                if (idStr != null) {
                    threadGroupId = Long.valueOf(idStr);
                }
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
            if (threadName != null || threadId != null || threadGroupId != null || threadGroupName != null) {
                result.setThreadInfo(new ThreadInfo(threadId, threadName, threadGroupId, threadGroupName));
            }
            String timeStamp = StaxUtilities.readAttributeValue((XMLStreamReader)reader, (String)"http://jakarta.apache.org/log4j/", (String)"timestamp");
            try {
                result.setTimeStamp(Long.valueOf(Long.parseLong(timeStamp)));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            reader.nextTag();
            String messagePattern = StaxUtilities.readSimpleTextNodeIfAvailable((XMLStreamReader)reader, null, (String)"message");
            if (messagePattern != null) {
                result.setMessage(new Message(messagePattern));
            }
            result.setNdc(this.readNdc(reader));
            result.setThrowable(this.readThrowable(reader));
            result.setCallStack(this.readLocationInfo(reader));
            result.setMdc(this.readMdc(reader));
            return result;
        }
        return result;
    }

    private Map<String, String> readMdc(XMLStreamReader reader) throws XMLStreamException {
        int type = reader.getEventType();
        if (1 == type && "properties".equals(reader.getLocalName())) {
            MdcEntry entry;
            HashMap<String, String> mdc = new HashMap<String, String>();
            reader.nextTag();
            while ((entry = this.readMdcEntry(reader)) != null) {
                mdc.put(entry.key, entry.value);
            }
            reader.require(2, null, "properties");
            reader.nextTag();
            return mdc;
        }
        return null;
    }

    private MdcEntry readMdcEntry(XMLStreamReader reader) throws XMLStreamException {
        int type = reader.getEventType();
        if (1 == type && "data".equals(reader.getLocalName())) {
            MdcEntry entry = new MdcEntry();
            entry.key = StaxUtilities.readAttributeValue((XMLStreamReader)reader, (String)"http://jakarta.apache.org/log4j/", (String)"name");
            entry.value = StaxUtilities.readAttributeValue((XMLStreamReader)reader, (String)"http://jakarta.apache.org/log4j/", (String)"value");
            reader.nextTag();
            reader.require(2, null, "data");
            reader.nextTag();
            return entry;
        }
        return null;
    }

    private ExtendedStackTraceElement[] readLocationInfo(XMLStreamReader reader) throws XMLStreamException {
        int type = reader.getEventType();
        if (1 == type && "locationInfo".equals(reader.getLocalName())) {
            String className = StaxUtilities.readAttributeValue((XMLStreamReader)reader, (String)"http://jakarta.apache.org/log4j/", (String)"class");
            String methodName = StaxUtilities.readAttributeValue((XMLStreamReader)reader, (String)"http://jakarta.apache.org/log4j/", (String)"method");
            String fileName = StaxUtilities.readAttributeValue((XMLStreamReader)reader, (String)"http://jakarta.apache.org/log4j/", (String)"file");
            String lineStr = StaxUtilities.readAttributeValue((XMLStreamReader)reader, (String)"http://jakarta.apache.org/log4j/", (String)"line");
            int line = -1;
            if (lineStr != null) {
                try {
                    line = Integer.parseInt(lineStr);
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
            }
            ExtendedStackTraceElement ste = new ExtendedStackTraceElement(className, methodName, fileName, line);
            reader.nextTag();
            reader.require(2, null, "locationInfo");
            reader.nextTag();
            return new ExtendedStackTraceElement[]{ste};
        }
        return null;
    }

    private ThrowableInfo readThrowable(XMLStreamReader reader) throws XMLStreamException {
        String throwableString = StaxUtilities.readSimpleTextNodeIfAvailable((XMLStreamReader)reader, null, (String)"throwable");
        if (throwableString != null) {
            StringTokenizer tok = new StringTokenizer(throwableString, NEWLINE, true);
            ArrayList<String> lines = new ArrayList<String>();
            boolean wasNewline = false;
            while (tok.hasMoreTokens()) {
                String current = tok.nextToken();
                if (NEWLINE.equals(current)) {
                    if (wasNewline) {
                        lines.add("");
                        wasNewline = false;
                        continue;
                    }
                    wasNewline = true;
                    continue;
                }
                wasNewline = false;
                lines.add(current);
            }
            return ThrowableInfoParser.parse(lines);
        }
        return null;
    }

    private Message[] readNdc(XMLStreamReader reader) throws XMLStreamException {
        String ndcString = StaxUtilities.readSimpleTextNodeIfAvailable((XMLStreamReader)reader, null, (String)"NDC");
        if (ndcString == null) {
            return null;
        }
        ArrayList<Message> ndcs = new ArrayList<Message>();
        StringTokenizer tok = new StringTokenizer(ndcString, " ", false);
        while (tok.hasMoreTokens()) {
            ndcs.add(new Message(tok.nextToken()));
        }
        return ndcs.toArray(new Message[ndcs.size()]);
    }

    private static class MdcEntry {
        public String key;
        public String value;

        private MdcEntry() {
        }
    }
}

