/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.handler;

import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class Slf4JHandler
extends Handler {
    private static final int TRACE_LEVEL_THRESHOLD = Level.FINEST.intValue();
    private static final int DEBUG_LEVEL_THRESHOLD = Level.FINE.intValue();
    private static final int INFO_LEVEL_THRESHOLD = Level.INFO.intValue();
    private static final int WARN_LEVEL_THRESHOLD = Level.WARNING.intValue();
    private static final String LEVEL_MDC_KEY = "JUL-Level";
    private static final String SOURCE_CLASS_NAME_MDC_KEY = "JUL-SourceClassName";
    private static final String SOURCE_METHOD_NAME_MDC_KEY = "JUL-SourceMethodName";

    public void publish(LogRecord record) {
        if (record != null) {
            this.logRecord(record);
        }
    }

    public void flush() {
    }

    public void close() throws SecurityException {
    }

    private void logRecord(LogRecord record) {
        Level julLevel = record.getLevel();
        int julLevelValue = julLevel.intValue();
        if (julLevelValue <= TRACE_LEVEL_THRESHOLD) {
            this.logTrace(record);
        } else if (julLevelValue <= DEBUG_LEVEL_THRESHOLD) {
            this.logDebug(record);
        } else if (julLevelValue <= INFO_LEVEL_THRESHOLD) {
            this.logInfo(record);
        } else if (julLevelValue <= WARN_LEVEL_THRESHOLD) {
            this.logWarn(record);
        } else {
            this.logError(record);
        }
    }

    private void logTrace(LogRecord record) {
        String loggerName = record.getLoggerName();
        Logger logger = LoggerFactory.getLogger((String)loggerName);
        if (logger.isTraceEnabled()) {
            this.initMDC(record);
            String message = record.getMessage();
            Throwable throwable = record.getThrown();
            if (throwable != null) {
                logger.trace(message, throwable);
            } else {
                logger.trace(message);
            }
            this.clearMDC();
        }
    }

    private void logDebug(LogRecord record) {
        String loggerName = record.getLoggerName();
        Logger logger = LoggerFactory.getLogger((String)loggerName);
        if (logger.isDebugEnabled()) {
            this.initMDC(record);
            String message = record.getMessage();
            Throwable throwable = record.getThrown();
            if (throwable != null) {
                logger.debug(message, throwable);
            } else {
                logger.debug(message);
            }
            this.clearMDC();
        }
    }

    private void logInfo(LogRecord record) {
        String loggerName = record.getLoggerName();
        Logger logger = LoggerFactory.getLogger((String)loggerName);
        if (logger.isInfoEnabled()) {
            this.initMDC(record);
            String message = record.getMessage();
            Throwable throwable = record.getThrown();
            if (throwable != null) {
                logger.info(message, throwable);
            } else {
                logger.info(message);
            }
            this.clearMDC();
        }
    }

    private void logWarn(LogRecord record) {
        String loggerName = record.getLoggerName();
        Logger logger = LoggerFactory.getLogger((String)loggerName);
        if (logger.isWarnEnabled()) {
            this.initMDC(record);
            String message = record.getMessage();
            Throwable throwable = record.getThrown();
            if (throwable != null) {
                logger.warn(message, throwable);
            } else {
                logger.warn(message);
            }
            this.clearMDC();
        }
    }

    private void logError(LogRecord record) {
        String loggerName = record.getLoggerName();
        Logger logger = LoggerFactory.getLogger((String)loggerName);
        if (logger.isErrorEnabled()) {
            this.initMDC(record);
            String message = record.getMessage();
            Throwable throwable = record.getThrown();
            if (throwable != null) {
                logger.error(message, throwable);
            } else {
                logger.error(message);
            }
            this.clearMDC();
        }
    }

    private void initMDC(LogRecord record) {
        String sourceMethodName;
        Level julLevel = record.getLevel();
        MDC.put((String)LEVEL_MDC_KEY, (String)julLevel.getName());
        String sourceClassName = record.getSourceClassName();
        if (sourceClassName != null) {
            MDC.put((String)SOURCE_CLASS_NAME_MDC_KEY, (String)sourceClassName);
        }
        if ((sourceMethodName = record.getSourceMethodName()) != null) {
            MDC.put((String)SOURCE_METHOD_NAME_MDC_KEY, (String)sourceMethodName);
        }
    }

    private void clearMDC() {
        MDC.remove((String)LEVEL_MDC_KEY);
        MDC.remove((String)SOURCE_CLASS_NAME_MDC_KEY);
        MDC.remove((String)SOURCE_METHOD_NAME_MDC_KEY);
    }
}

