/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.runtime;

import de.flapdoodle.embed.process.config.ExecutableProcessConfig;
import de.flapdoodle.embed.process.config.IRuntimeConfig;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.embed.process.io.file.Files;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;

public abstract class Executable<T extends ExecutableProcessConfig, P> {
    private static Logger logger = Logger.getLogger(Executable.class.getName());
    private final T config;
    private final IRuntimeConfig runtimeConfig;
    private final File executable;
    private boolean stopped;
    private final Distribution distribution;

    public Executable(Distribution distribution, T config, IRuntimeConfig runtimeConfig, File executable) {
        this.distribution = distribution;
        this.config = config;
        this.runtimeConfig = runtimeConfig;
        this.executable = executable;
        Runtime.getRuntime().addShutdownHook(new JobKiller());
    }

    public synchronized void cleanup() {
        if (!this.stopped) {
            if (this.executable.exists() && !Files.forceDelete(this.executable)) {
                logger.warning("Could not delete executable NOW: " + this.executable);
            }
            this.stopped = true;
        }
    }

    public File getFile() {
        return this.executable;
    }

    public P start() throws IOException {
        return this.start(this.distribution, this.config, this.runtimeConfig);
    }

    protected abstract P start(Distribution var1, T var2, IRuntimeConfig var3) throws IOException;

    class JobKiller
    extends Thread {
        JobKiller() {
        }

        @Override
        public void run() {
            Executable.this.cleanup();
        }
    }
}

