/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.util.Debug;
import com.unboundid.util.FileValuePatternComponent;
import com.unboundid.util.HTTPValuePatternComponent;
import com.unboundid.util.NotMutable;
import com.unboundid.util.RandomValuePatternComponent;
import com.unboundid.util.SequentialValuePatternComponent;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.StringValuePatternComponent;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.UtilityMessages;
import com.unboundid.util.Validator;
import com.unboundid.util.ValuePatternComponent;
import java.io.IOException;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ValuePattern
implements Serializable {
    private static final long serialVersionUID = 4502778464751705304L;
    private final String pattern;
    private final ThreadLocal<StringBuilder> buffers;
    private final ValuePatternComponent[] components;

    public ValuePattern(String s) throws ParseException {
        Validator.ensureNotNull(s);
        this.pattern = s;
        this.buffers = new ThreadLocal();
        Random r = new Random();
        ArrayList<ValuePatternComponent> l = new ArrayList<ValuePatternComponent>(3);
        ValuePattern.parse(s, 0, l, r);
        this.components = new ValuePatternComponent[l.size()];
        l.toArray(this.components);
    }

    private static void parse(String s, int o, ArrayList<ValuePatternComponent> l, Random r) throws ParseException {
        int pos = s.indexOf("[[");
        if (pos >= 0) {
            if (pos > 0) {
                ValuePattern.parse(s.substring(0, pos), o, l, r);
            }
            l.add(new StringValuePatternComponent("["));
            if (pos < s.length() - 2) {
                ValuePattern.parse(s.substring(pos + 2), o + pos + 2, l, r);
            }
            return;
        }
        pos = s.indexOf("]]");
        if (pos >= 0) {
            if (pos > 0) {
                ValuePattern.parse(s.substring(0, pos), o, l, r);
            }
            l.add(new StringValuePatternComponent("]"));
            if (pos < s.length() - 2) {
                ValuePattern.parse(s.substring(pos + 2), o + pos + 2, l, r);
            }
            return;
        }
        pos = s.indexOf(91);
        if (pos >= 0) {
            String bracketedToken;
            int closePos = s.indexOf(93);
            if (closePos < 0) {
                throw new ParseException(UtilityMessages.ERR_VALUE_PATTERN_UNMATCHED_OPEN.get(o + pos), o + pos);
            }
            if (closePos < pos) {
                throw new ParseException(UtilityMessages.ERR_VALUE_PATTERN_UNMATCHED_CLOSE.get(o + closePos), o + closePos);
            }
            if (pos > 0) {
                l.add(new StringValuePatternComponent(s.substring(0, pos)));
            }
            if ((bracketedToken = s.substring(pos + 1, closePos)).startsWith("file:/")) {
                String path = bracketedToken.substring(5);
                try {
                    l.add(new FileValuePatternComponent(path, r.nextLong()));
                }
                catch (IOException ioe) {
                    Debug.debugException(ioe);
                    throw new ParseException(UtilityMessages.ERR_FILE_VALUE_PATTERN_NOT_USABLE.get(path, StaticUtils.getExceptionMessage(ioe)), o + pos);
                }
            } else if (bracketedToken.startsWith("http://")) {
                try {
                    l.add(new HTTPValuePatternComponent(bracketedToken, r.nextLong()));
                }
                catch (IOException ioe) {
                    Debug.debugException(ioe);
                    throw new ParseException(UtilityMessages.ERR_HTTP_VALUE_PATTERN_NOT_USABLE.get(bracketedToken, StaticUtils.getExceptionMessage(ioe)), o + pos);
                }
            } else {
                l.add(ValuePattern.parseNumericComponent(s.substring(pos + 1, closePos), o + pos + 1, r));
            }
            if (closePos < s.length() - 1) {
                ValuePattern.parse(s.substring(closePos + 1), o + closePos + 1, l, r);
            }
            return;
        }
        pos = s.indexOf(93);
        if (pos >= 0) {
            throw new ParseException(UtilityMessages.ERR_VALUE_PATTERN_UNMATCHED_CLOSE.get(o + pos), o + pos);
        }
        l.add(new StringValuePatternComponent(s));
    }

    private static ValuePatternComponent parseNumericComponent(String s, int o, Random r) throws ParseException {
        int pos;
        boolean delimiterFound = false;
        boolean sequential = false;
        long lowerBound = 0L;
        block30: for (pos = 0; pos < s.length(); ++pos) {
            switch (s.charAt(pos)) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    continue block30;
                }
                case '-': {
                    if (pos == 0) continue block30;
                    delimiterFound = true;
                    sequential = false;
                    try {
                        lowerBound = Long.parseLong(s.substring(0, pos));
                    }
                    catch (NumberFormatException nfe) {
                        Debug.debugException(nfe);
                        throw new ParseException(UtilityMessages.ERR_VALUE_PATTERN_VALUE_NOT_LONG.get(o - 1, Long.MIN_VALUE, Long.MAX_VALUE), o - 1);
                    }
                    ++pos;
                    break block30;
                }
                case ':': {
                    delimiterFound = true;
                    sequential = true;
                    if (pos == 0) {
                        throw new ParseException(UtilityMessages.ERR_VALUE_PATTERN_EMPTY_LOWER_BOUND.get(o - 1), o - 1);
                    }
                    try {
                        lowerBound = Long.parseLong(s.substring(0, pos));
                    }
                    catch (NumberFormatException nfe) {
                        Debug.debugException(nfe);
                        throw new ParseException(UtilityMessages.ERR_VALUE_PATTERN_VALUE_NOT_LONG.get(o - 1, Long.MIN_VALUE, Long.MAX_VALUE), o - 1);
                    }
                    ++pos;
                    break block30;
                }
                default: {
                    throw new ParseException(UtilityMessages.ERR_VALUE_PATTERN_INVALID_CHARACTER.get(Character.valueOf(s.charAt(pos)), o + pos), o + pos);
                }
            }
        }
        if (!delimiterFound) {
            throw new ParseException(UtilityMessages.ERR_VALUE_PATTERN_NO_DELIMITER.get(o - 1), o - 1);
        }
        boolean hasIncrement = false;
        int startPos = pos;
        long upperBound = lowerBound;
        long increment = 1L;
        String formatString = null;
        delimiterFound = false;
        block31: while (pos < s.length()) {
            switch (s.charAt(pos)) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    break;
                }
                case '-': {
                    if (pos == startPos) break;
                    throw new ParseException(UtilityMessages.ERR_VALUE_PATTERN_INVALID_CHARACTER.get(Character.valueOf('-'), o + pos), o + pos);
                }
                case 'x': {
                    delimiterFound = true;
                    hasIncrement = true;
                    if (pos == startPos) {
                        throw new ParseException(UtilityMessages.ERR_VALUE_PATTERN_EMPTY_UPPER_BOUND.get(o - 1), o - 1);
                    }
                    try {
                        upperBound = Long.parseLong(s.substring(startPos, pos));
                    }
                    catch (NumberFormatException nfe) {
                        Debug.debugException(nfe);
                        throw new ParseException(UtilityMessages.ERR_VALUE_PATTERN_VALUE_NOT_LONG.get(o - 1, Long.MIN_VALUE, Long.MAX_VALUE), o - 1);
                    }
                    ++pos;
                    break block31;
                }
                case '%': {
                    delimiterFound = true;
                    hasIncrement = false;
                    if (pos == startPos) {
                        throw new ParseException(UtilityMessages.ERR_VALUE_PATTERN_EMPTY_UPPER_BOUND.get(o - 1), o - 1);
                    }
                    try {
                        upperBound = Long.parseLong(s.substring(startPos, pos));
                    }
                    catch (NumberFormatException nfe) {
                        Debug.debugException(nfe);
                        throw new ParseException(UtilityMessages.ERR_VALUE_PATTERN_VALUE_NOT_LONG.get(o - 1, Long.MIN_VALUE, Long.MAX_VALUE), o - 1);
                    }
                    ++pos;
                    break block31;
                }
                default: {
                    throw new ParseException(UtilityMessages.ERR_VALUE_PATTERN_INVALID_CHARACTER.get(Character.valueOf(s.charAt(pos)), o + pos), o + pos);
                }
            }
            ++pos;
        }
        if (!delimiterFound) {
            if (pos == startPos) {
                throw new ParseException(UtilityMessages.ERR_VALUE_PATTERN_EMPTY_UPPER_BOUND.get(o - 1), o - 1);
            }
            try {
                upperBound = Long.parseLong(s.substring(startPos, pos));
            }
            catch (NumberFormatException nfe) {
                Debug.debugException(nfe);
                throw new ParseException(UtilityMessages.ERR_VALUE_PATTERN_VALUE_NOT_LONG.get(o - 1, Long.MIN_VALUE, Long.MAX_VALUE), o - 1);
            }
            if (sequential) {
                return new SequentialValuePatternComponent(lowerBound, upperBound, 1L, null);
            }
            return new RandomValuePatternComponent(lowerBound, upperBound, r.nextLong(), null);
        }
        if (hasIncrement) {
            delimiterFound = false;
            startPos = pos;
            block32: while (pos < s.length()) {
                switch (s.charAt(pos)) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        break;
                    }
                    case '-': {
                        if (pos == startPos) break;
                        throw new ParseException(UtilityMessages.ERR_VALUE_PATTERN_INVALID_CHARACTER.get(Character.valueOf('-'), o + pos), o + pos);
                    }
                    case '%': {
                        delimiterFound = true;
                        if (pos == startPos) {
                            throw new ParseException(UtilityMessages.ERR_VALUE_PATTERN_EMPTY_INCREMENT.get(o - 1), o - 1);
                        }
                        if (pos == s.length() - 1) {
                            throw new ParseException(UtilityMessages.ERR_VALUE_PATTERN_EMPTY_FORMAT.get(o - 1), o - 1);
                        }
                        try {
                            increment = Long.parseLong(s.substring(startPos, pos));
                        }
                        catch (NumberFormatException nfe) {
                            Debug.debugException(nfe);
                            throw new ParseException(UtilityMessages.ERR_VALUE_PATTERN_VALUE_NOT_LONG.get(o - 1, Long.MIN_VALUE, Long.MAX_VALUE), o - 1);
                        }
                        formatString = s.substring(pos + 1);
                        break block32;
                    }
                    default: {
                        throw new ParseException(UtilityMessages.ERR_VALUE_PATTERN_INVALID_CHARACTER.get(Character.valueOf(s.charAt(pos)), o + pos), o + pos);
                    }
                }
                ++pos;
            }
            if (!delimiterFound) {
                if (pos == startPos) {
                    throw new ParseException(UtilityMessages.ERR_VALUE_PATTERN_EMPTY_INCREMENT.get(o - 1), o - 1);
                }
                try {
                    increment = Long.parseLong(s.substring(startPos, pos));
                }
                catch (NumberFormatException nfe) {
                    Debug.debugException(nfe);
                    throw new ParseException(UtilityMessages.ERR_VALUE_PATTERN_VALUE_NOT_LONG.get(o - 1, Long.MIN_VALUE, Long.MAX_VALUE), o - 1);
                }
            }
        } else {
            formatString = s.substring(pos);
            if (formatString.length() == 0) {
                throw new ParseException(UtilityMessages.ERR_VALUE_PATTERN_EMPTY_FORMAT.get(o - 1), o - 1);
            }
        }
        if (sequential) {
            return new SequentialValuePatternComponent(lowerBound, upperBound, increment, formatString);
        }
        return new RandomValuePatternComponent(lowerBound, upperBound, r.nextLong(), formatString);
    }

    public String nextValue() {
        StringBuilder buffer = this.buffers.get();
        if (buffer == null) {
            buffer = new StringBuilder();
            this.buffers.set(buffer);
        } else {
            buffer.setLength(0);
        }
        for (ValuePatternComponent c : this.components) {
            c.append(buffer);
        }
        return buffer.toString();
    }

    public String toString() {
        return this.pattern;
    }
}

