/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.examples;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPSearchException;
import com.unboundid.ldap.sdk.Modification;
import com.unboundid.ldap.sdk.ModificationType;
import com.unboundid.ldap.sdk.ModifyRequest;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchRequest;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.ldap.sdk.controls.ProxiedAuthorizationV2RequestControl;
import com.unboundid.util.FixedRateBarrier;
import com.unboundid.util.ResultCodeCounter;
import com.unboundid.util.ValuePattern;
import java.util.Random;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

final class SearchAndModRateThread
extends Thread {
    private static final long serialVersionUID = -8238795420559281873L;
    private final AtomicBoolean stopRequested;
    private final AtomicLong errorCounter;
    private final AtomicLong modCounter;
    private final AtomicLong modDurations;
    private final AtomicLong searchCounter;
    private final AtomicLong searchDurations;
    private final AtomicReference<Thread> searchAndModThread;
    private final LDAPConnection connection;
    private final AtomicReference<ResultCode> resultCode;
    private final byte[] charSet;
    private final CyclicBarrier startBarrier;
    private final int valueLength;
    private final Random random;
    private final ResultCodeCounter rcCounter;
    private final SearchRequest searchRequest;
    private final SearchScope scope;
    private final String[] modAttributes;
    private final String[] returnAttributes;
    private final ValuePattern authzID;
    private final ValuePattern baseDN;
    private final ValuePattern filter;
    private final FixedRateBarrier fixedRateBarrier;

    SearchAndModRateThread(int threadNumber, LDAPConnection connection, ValuePattern baseDN, SearchScope scope, ValuePattern filter, String[] returnAttributes, String[] modAttributes, int valueLength, byte[] charSet, ValuePattern authzID, long randomSeed, CyclicBarrier startBarrier, AtomicLong searchCounter, AtomicLong modCounter, AtomicLong searchDurations, AtomicLong modDurations, AtomicLong errorCounter, ResultCodeCounter rcCounter, FixedRateBarrier rateBarrier) {
        this.setName("SearchRate Thread " + threadNumber);
        this.setDaemon(true);
        this.connection = connection;
        this.baseDN = baseDN;
        this.scope = scope;
        this.filter = filter;
        this.returnAttributes = returnAttributes;
        this.modAttributes = modAttributes;
        this.valueLength = valueLength;
        this.charSet = charSet;
        this.authzID = authzID;
        this.searchCounter = searchCounter;
        this.modCounter = modCounter;
        this.searchDurations = searchDurations;
        this.modDurations = modDurations;
        this.errorCounter = errorCounter;
        this.rcCounter = rcCounter;
        this.startBarrier = startBarrier;
        this.fixedRateBarrier = rateBarrier;
        connection.setConnectionName("search-and-mod-" + threadNumber);
        this.random = new Random(randomSeed);
        this.resultCode = new AtomicReference<Object>(null);
        this.searchAndModThread = new AtomicReference<Object>(null);
        this.stopRequested = new AtomicBoolean(false);
        this.searchRequest = new SearchRequest("", scope, Filter.createPresenceFilter("objectClass"), returnAttributes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.searchAndModThread.set(SearchAndModRateThread.currentThread());
        Modification[] mods = new Modification[this.modAttributes.length];
        byte[] valueBytes = new byte[this.valueLength];
        ASN1OctetString[] values = new ASN1OctetString[1];
        ModifyRequest modifyRequest = new ModifyRequest("", mods);
        try {
            this.startBarrier.await();
        }
        catch (Exception e) {
            // empty catch block
        }
        while (!this.stopRequested.get()) {
            int i;
            SearchResult r;
            block25: {
                if (this.fixedRateBarrier != null) {
                    this.fixedRateBarrier.await();
                }
                try {
                    this.searchRequest.setBaseDN(this.baseDN.nextValue());
                    this.searchRequest.setFilter(this.filter.nextValue());
                    if (this.authzID == null) break block25;
                    this.searchRequest.setControls(new ProxiedAuthorizationV2RequestControl(this.authzID.nextValue()));
                }
                catch (LDAPException le) {
                    this.errorCounter.incrementAndGet();
                    ResultCode rc = le.getResultCode();
                    this.rcCounter.increment(rc);
                    this.resultCode.compareAndSet(null, rc);
                    continue;
                }
            }
            long searchStartTime = System.nanoTime();
            try {
                r = this.connection.search(this.searchRequest);
            }
            catch (LDAPSearchException lse) {
                this.errorCounter.incrementAndGet();
                ResultCode rc = lse.getResultCode();
                this.rcCounter.increment(rc);
                this.resultCode.compareAndSet(null, rc);
                if (lse.getResultCode().isConnectionUsable()) continue;
                try {
                    this.connection.reconnect();
                }
                catch (LDAPException le2) {
                    // empty catch block
                }
                continue;
            }
            finally {
                this.searchCounter.incrementAndGet();
                this.searchDurations.addAndGet(System.nanoTime() - searchStartTime);
                continue;
            }
            for (i = 0; i < this.valueLength; ++i) {
                valueBytes[i] = this.charSet[this.random.nextInt(this.charSet.length)];
            }
            values[0] = new ASN1OctetString(valueBytes);
            for (i = 0; i < this.modAttributes.length; ++i) {
                mods[i] = new Modification(ModificationType.REPLACE, this.modAttributes[i], values);
            }
            modifyRequest.setModifications(mods);
            if (this.authzID != null) {
                modifyRequest.setControls(new ProxiedAuthorizationV2RequestControl(this.authzID.nextValue()));
            }
            for (SearchResultEntry e : r.getSearchEntries()) {
                if (this.fixedRateBarrier != null) {
                    this.fixedRateBarrier.await();
                }
                modifyRequest.setDN(e.getDN());
                long modStartTime = System.nanoTime();
                try {
                    this.connection.modify(modifyRequest);
                }
                catch (LDAPException le) {
                    this.errorCounter.incrementAndGet();
                    ResultCode rc = le.getResultCode();
                    this.rcCounter.increment(rc);
                    this.resultCode.compareAndSet(null, rc);
                    if (le.getResultCode().isConnectionUsable()) continue;
                    try {
                        this.connection.reconnect();
                    }
                    catch (LDAPException le2) {
                        // empty catch block
                    }
                }
                finally {
                    this.modCounter.incrementAndGet();
                    this.modDurations.addAndGet(System.nanoTime() - modStartTime);
                }
            }
        }
        this.connection.close();
        this.searchAndModThread.set(null);
    }

    public ResultCode stopRunning() {
        Thread t;
        this.stopRequested.set(true);
        if (this.fixedRateBarrier != null) {
            this.fixedRateBarrier.shutdownRequested();
        }
        if ((t = this.searchAndModThread.get()) != null) {
            try {
                t.join();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.resultCode.compareAndSet(null, ResultCode.SUCCESS);
        return this.resultCode.get();
    }
}

