/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.DisconnectHandler;
import com.unboundid.ldap.sdk.UnsolicitedNotificationHandler;
import com.unboundid.util.Mutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;

@Mutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class LDAPConnectionOptions {
    static final boolean DEFAULT_AUTO_RECONNECT = false;
    static final boolean DEFAULT_BIND_WITH_DN_REQUIRES_PASSWORD = true;
    static final boolean DEFAULT_CAPTURE_CONNECT_STACK_TRACE = false;
    static final boolean DEFAULT_FOLLOW_REFERRALS = false;
    static final boolean DEFAULT_USE_KEEPALIVE = true;
    static final boolean DEFAULT_USE_LINGER = true;
    static final boolean DEFAULT_USE_REUSE_ADDRESS = true;
    static final boolean DEFAULT_USE_SCHEMA = false;
    static final boolean DEFAULT_USE_SYNCHRONOUS_MODE = false;
    static final boolean DEFAULT_USE_TCP_NODELAY = true;
    static final int DEFAULT_CONNECT_TIMEOUT_MILLIS = 60000;
    static final int DEFAULT_LINGER_TIMEOUT_SECONDS = 5;
    static final int DEFAULT_MAX_MESSAGE_SIZE = 0x1400000;
    static final int DEFAULT_RECEIVE_BUFFER_SIZE = 0;
    static final int DEFAULT_REFERRAL_HOP_LIMIT = 5;
    static final int DEFAULT_SEND_BUFFER_SIZE = 0;
    static final long DEFAULT_RESPONSE_TIMEOUT_MILLIS = 300000L;
    private boolean autoReconnect = false;
    private boolean bindWithDNRequiresPassword = true;
    private boolean captureConnectStackTrace = false;
    private boolean followReferrals = false;
    private boolean useKeepAlive = true;
    private boolean useLinger = true;
    private boolean useReuseAddress = true;
    private boolean useSchema = false;
    private boolean useSynchronousMode = false;
    private boolean useTCPNoDelay = true;
    private DisconnectHandler disconnectHandler = null;
    private int connectTimeout = 60000;
    private int lingerTimeout = 5;
    private int maxMessageSize = 0x1400000;
    private int receiveBufferSize = 0;
    private int referralHopLimit = 5;
    private int sendBufferSize = 0;
    private long responseTimeout = 300000L;
    private UnsolicitedNotificationHandler unsolicitedNotificationHandler = null;

    public LDAPConnectionOptions duplicate() {
        LDAPConnectionOptions o = new LDAPConnectionOptions();
        o.autoReconnect = this.autoReconnect;
        o.bindWithDNRequiresPassword = this.bindWithDNRequiresPassword;
        o.captureConnectStackTrace = this.captureConnectStackTrace;
        o.followReferrals = this.followReferrals;
        o.useKeepAlive = this.useKeepAlive;
        o.useLinger = this.useLinger;
        o.useReuseAddress = this.useReuseAddress;
        o.useSchema = this.useSchema;
        o.useSynchronousMode = this.useSynchronousMode;
        o.useTCPNoDelay = this.useTCPNoDelay;
        o.connectTimeout = this.connectTimeout;
        o.lingerTimeout = this.lingerTimeout;
        o.maxMessageSize = this.maxMessageSize;
        o.responseTimeout = this.responseTimeout;
        o.referralHopLimit = this.referralHopLimit;
        o.disconnectHandler = this.disconnectHandler;
        o.unsolicitedNotificationHandler = this.unsolicitedNotificationHandler;
        o.receiveBufferSize = this.receiveBufferSize;
        o.sendBufferSize = this.sendBufferSize;
        return o;
    }

    public boolean autoReconnect() {
        return this.autoReconnect;
    }

    public void setAutoReconnect(boolean autoReconnect) {
        this.autoReconnect = autoReconnect;
    }

    public boolean bindWithDNRequiresPassword() {
        return this.bindWithDNRequiresPassword;
    }

    public void setBindWithDNRequiresPassword(boolean bindWithDNRequiresPassword) {
        this.bindWithDNRequiresPassword = bindWithDNRequiresPassword;
    }

    public boolean captureConnectStackTrace() {
        return this.captureConnectStackTrace;
    }

    public void setCaptureConnectStackTrace(boolean captureConnectStackTrace) {
        this.captureConnectStackTrace = captureConnectStackTrace;
    }

    public int getConnectTimeoutMillis() {
        return this.connectTimeout;
    }

    public void setConnectTimeoutMillis(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public long getResponseTimeoutMillis() {
        return this.responseTimeout;
    }

    public void setResponseTimeoutMillis(long responseTimeout) {
        this.responseTimeout = responseTimeout < 0L ? 0L : responseTimeout;
    }

    public boolean useKeepAlive() {
        return this.useKeepAlive;
    }

    public void setUseKeepAlive(boolean useKeepAlive) {
        this.useKeepAlive = useKeepAlive;
    }

    public boolean useLinger() {
        return this.useLinger;
    }

    public int getLingerTimeoutSeconds() {
        return this.lingerTimeout;
    }

    public void setUseLinger(boolean useLinger, int lingerTimeout) {
        this.useLinger = useLinger;
        this.lingerTimeout = lingerTimeout;
    }

    public boolean useReuseAddress() {
        return this.useReuseAddress;
    }

    public void setUseReuseAddress(boolean useReuseAddress) {
        this.useReuseAddress = useReuseAddress;
    }

    public boolean useSchema() {
        return this.useSchema;
    }

    public void setUseSchema(boolean useSchema) {
        this.useSchema = useSchema;
    }

    public boolean useSynchronousMode() {
        return this.useSynchronousMode;
    }

    public void setUseSynchronousMode(boolean useSynchronousMode) {
        this.useSynchronousMode = useSynchronousMode;
    }

    public boolean useTCPNoDelay() {
        return this.useTCPNoDelay;
    }

    public void setUseTCPNoDelay(boolean useTCPNoDelay) {
        this.useTCPNoDelay = useTCPNoDelay;
    }

    public boolean followReferrals() {
        return this.followReferrals;
    }

    public void setFollowReferrals(boolean followReferrals) {
        this.followReferrals = followReferrals;
    }

    public int getReferralHopLimit() {
        return this.referralHopLimit;
    }

    public void setReferralHopLimit(int referralHopLimit) {
        Validator.ensureTrue(referralHopLimit > 0, "LDAPConnectionOptions.referralHopLimit must be greater than 0.");
        this.referralHopLimit = referralHopLimit;
    }

    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public void setMaxMessageSize(int maxMessageSize) {
        this.maxMessageSize = maxMessageSize > 0 ? maxMessageSize : 0;
    }

    public DisconnectHandler getDisconnectHandler() {
        return this.disconnectHandler;
    }

    public void setDisconnectHandler(DisconnectHandler handler) {
        this.disconnectHandler = handler;
    }

    public UnsolicitedNotificationHandler getUnsolicitedNotificationHandler() {
        return this.unsolicitedNotificationHandler;
    }

    public void setUnsolicitedNotificationHandler(UnsolicitedNotificationHandler handler) {
        this.unsolicitedNotificationHandler = handler;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public void setReceiveBufferSize(int receiveBufferSize) {
        this.receiveBufferSize = receiveBufferSize < 0 ? 0 : receiveBufferSize;
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public void setSendBufferSize(int sendBufferSize) {
        this.sendBufferSize = sendBufferSize < 0 ? 0 : sendBufferSize;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("LDAPConnectionOptions(autoReconnect=");
        buffer.append(this.autoReconnect);
        buffer.append(", followReferrals=");
        buffer.append(this.followReferrals);
        if (this.followReferrals) {
            buffer.append(", referralHopLimit=");
            buffer.append(this.referralHopLimit);
        }
        buffer.append(", useKeepAlive=");
        buffer.append(this.useKeepAlive);
        buffer.append(", useLinger=");
        if (this.useLinger) {
            buffer.append("true, lingerTimeoutSeconds=");
            buffer.append(this.lingerTimeout);
        } else {
            buffer.append("false");
        }
        buffer.append(", useReuseAddress=");
        buffer.append(this.useReuseAddress);
        buffer.append(", useSchema=");
        buffer.append(this.useSchema);
        buffer.append(", useSynchronousMode=");
        buffer.append(this.useSynchronousMode);
        buffer.append(", useTCPNoDelay=");
        buffer.append(this.useTCPNoDelay);
        buffer.append(", captureConnectStackTrace=");
        buffer.append(this.captureConnectStackTrace);
        buffer.append(", connectTimeoutMillis=");
        buffer.append(this.connectTimeout);
        buffer.append(", responseTimeoutMillis=");
        buffer.append(this.responseTimeout);
        buffer.append(", maxMessageSize=");
        buffer.append(this.maxMessageSize);
        buffer.append(", receiveBufferSize=");
        buffer.append(this.receiveBufferSize);
        buffer.append(", sendBufferSize=");
        buffer.append(this.sendBufferSize);
        buffer.append(')');
    }
}

