/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.jpeg;

import com.twelvemonkeys.image.ImageUtil;
import com.twelvemonkeys.imageio.ImageReaderBase;
import com.twelvemonkeys.imageio.color.ColorSpaces;
import com.twelvemonkeys.imageio.metadata.CompoundDirectory;
import com.twelvemonkeys.imageio.metadata.Directory;
import com.twelvemonkeys.imageio.metadata.Entry;
import com.twelvemonkeys.imageio.metadata.exif.EXIFReader;
import com.twelvemonkeys.imageio.metadata.jpeg.JPEGSegment;
import com.twelvemonkeys.imageio.metadata.jpeg.JPEGSegmentUtil;
import com.twelvemonkeys.imageio.plugins.jpeg.AdobeDCTSegment;
import com.twelvemonkeys.imageio.plugins.jpeg.EXIFThumbnailReader;
import com.twelvemonkeys.imageio.plugins.jpeg.FastCMYKToRGB;
import com.twelvemonkeys.imageio.plugins.jpeg.JFIFSegment;
import com.twelvemonkeys.imageio.plugins.jpeg.JFIFThumbnailReader;
import com.twelvemonkeys.imageio.plugins.jpeg.JFXXSegment;
import com.twelvemonkeys.imageio.plugins.jpeg.JFXXThumbnailReader;
import com.twelvemonkeys.imageio.plugins.jpeg.JPEGColorSpace;
import com.twelvemonkeys.imageio.plugins.jpeg.JPEGImage10MetadataCleaner;
import com.twelvemonkeys.imageio.plugins.jpeg.JPEGSegmentImageInputStream;
import com.twelvemonkeys.imageio.plugins.jpeg.SOFComponent;
import com.twelvemonkeys.imageio.plugins.jpeg.SOFSegment;
import com.twelvemonkeys.imageio.plugins.jpeg.ThumbnailReadProgressListener;
import com.twelvemonkeys.imageio.plugins.jpeg.ThumbnailReader;
import com.twelvemonkeys.imageio.util.ProgressListenerBase;
import com.twelvemonkeys.lang.Validate;
import com.twelvemonkeys.xml.XMLSerializer;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.RasterOp;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.event.IIOReadProgressListener;
import javax.imageio.event.IIOReadUpdateListener;
import javax.imageio.event.IIOReadWarningListener;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPEGImageReader
extends ImageReaderBase {
    static final boolean DEBUG = "true".equalsIgnoreCase(System.getProperty("com.twelvemonkeys.imageio.plugins.jpeg.debug"));
    static final int ALL_APP_MARKERS = -1;
    private static final Map<Integer, List<String>> SEGMENT_IDENTIFIERS = JPEGImageReader.createSegmentIds();
    private final ImageReader delegate;
    private final ProgressDelegator progressDelegator;
    private ImageReader thumbnailReader;
    private List<ThumbnailReader> thumbnails;
    private JPEGImage10MetadataCleaner metadataCleaner;
    private List<JPEGSegment> segments;

    private static Map<Integer, List<String>> createSegmentIds() {
        LinkedHashMap<Integer, List> linkedHashMap = new LinkedHashMap<Integer, List>();
        for (int i = 65504; i <= 65519; ++i) {
            linkedHashMap.put(i, JPEGSegmentUtil.ALL_IDS);
        }
        linkedHashMap.put(65472, null);
        linkedHashMap.put(65473, null);
        linkedHashMap.put(65474, null);
        linkedHashMap.put(65475, null);
        linkedHashMap.put(65477, null);
        linkedHashMap.put(65478, null);
        linkedHashMap.put(65479, null);
        linkedHashMap.put(65481, null);
        linkedHashMap.put(65482, null);
        linkedHashMap.put(65483, null);
        linkedHashMap.put(65485, null);
        linkedHashMap.put(65486, null);
        linkedHashMap.put(65487, null);
        return Collections.unmodifiableMap(linkedHashMap);
    }

    JPEGImageReader(ImageReaderSpi imageReaderSpi, ImageReader imageReader) {
        super(imageReaderSpi);
        this.delegate = (ImageReader)Validate.notNull((Object)imageReader);
        this.progressDelegator = new ProgressDelegator();
    }

    private void installListeners() {
        this.delegate.addIIOReadProgressListener((IIOReadProgressListener)((Object)this.progressDelegator));
        this.delegate.addIIOReadUpdateListener(this.progressDelegator);
        this.delegate.addIIOReadWarningListener(this.progressDelegator);
    }

    protected void resetMembers() {
        this.delegate.reset();
        this.segments = null;
        this.thumbnails = null;
        if (this.thumbnailReader != null) {
            this.thumbnailReader.reset();
        }
        this.metadataCleaner = null;
        this.installListeners();
    }

    public void dispose() {
        super.dispose();
        if (this.thumbnailReader != null) {
            this.thumbnailReader.dispose();
            this.thumbnailReader = null;
        }
        this.delegate.dispose();
    }

    public String getFormatName() throws IOException {
        return this.delegate.getFormatName();
    }

    public int getNumImages(boolean bl) throws IOException {
        return this.delegate.getNumImages(bl);
    }

    public int getWidth(int n) throws IOException {
        return this.delegate.getWidth(n);
    }

    public int getHeight(int n) throws IOException {
        return this.delegate.getHeight(n);
    }

    public Iterator<ImageTypeSpecifier> getImageTypes(int n) throws IOException {
        Iterator<ImageTypeSpecifier> iterator = this.delegate.getImageTypes(n);
        JPEGColorSpace jPEGColorSpace = JPEGImageReader.getSourceCSType(this.getAdobeDCT(), this.getSOF());
        if (iterator == null || !iterator.hasNext() || jPEGColorSpace == JPEGColorSpace.CMYK || jPEGColorSpace == JPEGColorSpace.YCCK) {
            ArrayList<ImageTypeSpecifier> arrayList = new ArrayList<ImageTypeSpecifier>();
            arrayList.add(ImageTypeSpecifier.createFromBufferedImageType(5));
            arrayList.add(ImageTypeSpecifier.createFromBufferedImageType(1));
            arrayList.add(ImageTypeSpecifier.createFromBufferedImageType(4));
            ICC_Profile iCC_Profile = this.getEmbeddedICCProfile(false);
            if (jPEGColorSpace == JPEGColorSpace.CMYK || jPEGColorSpace == JPEGColorSpace.YCCK) {
                if (iCC_Profile != null) {
                    arrayList.add(ImageTypeSpecifier.createInterleaved(ColorSpaces.createColorSpace((ICC_Profile)iCC_Profile), new int[]{3, 2, 1, 0}, 0, false, false));
                }
                arrayList.add(ImageTypeSpecifier.createInterleaved(ColorSpaces.getColorSpace((int)5001), new int[]{3, 2, 1, 0}, 0, false, false));
            } else if (jPEGColorSpace == JPEGColorSpace.YCbCr || jPEGColorSpace == JPEGColorSpace.RGB) {
                if (iCC_Profile != null) {
                    arrayList.add(ImageTypeSpecifier.createInterleaved(ColorSpaces.createColorSpace((ICC_Profile)iCC_Profile), new int[]{0, 1, 2}, 0, false, false));
                }
            } else if (jPEGColorSpace == JPEGColorSpace.YCbCrA || jPEGColorSpace == JPEGColorSpace.RGBA) {
                arrayList.addAll(0, Arrays.asList(ImageTypeSpecifier.createFromBufferedImageType(2), ImageTypeSpecifier.createFromBufferedImageType(6), ImageTypeSpecifier.createFromBufferedImageType(3), ImageTypeSpecifier.createFromBufferedImageType(7)));
                if (iCC_Profile != null) {
                    arrayList.add(ImageTypeSpecifier.createInterleaved(ColorSpaces.createColorSpace((ICC_Profile)iCC_Profile), new int[]{0, 1, 2, 3}, 0, false, false));
                }
            }
            return arrayList.iterator();
        }
        return iterator;
    }

    public ImageTypeSpecifier getRawImageType(int n) throws IOException {
        ImageTypeSpecifier imageTypeSpecifier = this.delegate.getRawImageType(n);
        if (imageTypeSpecifier != null) {
            return imageTypeSpecifier;
        }
        JPEGColorSpace jPEGColorSpace = JPEGImageReader.getSourceCSType(this.getAdobeDCT(), this.getSOF());
        switch (jPEGColorSpace) {
            case CMYK: {
                ICC_Profile iCC_Profile = this.getEmbeddedICCProfile(false);
                if (iCC_Profile != null) {
                    return ImageTypeSpecifier.createInterleaved(ColorSpaces.createColorSpace((ICC_Profile)iCC_Profile), new int[]{3, 2, 1, 0}, 0, false, false);
                }
                return ImageTypeSpecifier.createInterleaved(ColorSpaces.getColorSpace((int)5001), new int[]{3, 2, 1, 0}, 0, false, false);
            }
        }
        return null;
    }

    public void setInput(Object object, boolean bl, boolean bl2) {
        super.setInput(object, bl, bl2);
        this.delegate.setInput(this.imageInput != null ? new JPEGSegmentImageInputStream(this.imageInput) : null, bl, bl2);
    }

    public boolean isRandomAccessEasy(int n) throws IOException {
        return this.delegate.isRandomAccessEasy(n);
    }

    public BufferedImage read(int n, ImageReadParam imageReadParam) throws IOException {
        this.assertInput();
        this.checkBounds(n);
        ICC_Profile iCC_Profile = this.getEmbeddedICCProfile(false);
        AdobeDCTSegment adobeDCTSegment = this.getAdobeDCT();
        SOFSegment sOFSegment = this.getSOF();
        JPEGColorSpace jPEGColorSpace = JPEGImageReader.getSourceCSType(adobeDCTSegment, sOFSegment);
        if (this.delegate.canReadRaster() && (jPEGColorSpace == JPEGColorSpace.CMYK || jPEGColorSpace == JPEGColorSpace.YCCK || adobeDCTSegment != null && adobeDCTSegment.getTransform() == 2 || iCC_Profile != null && !ColorSpaces.isCS_sRGB((ICC_Profile)iCC_Profile)) || jPEGColorSpace == JPEGColorSpace.YCbCr && this.getRawImageType(n) != null) {
            if (DEBUG) {
                System.out.println("Reading using raster and extra conversion");
                System.out.println("ICC color profile: " + iCC_Profile);
            }
            return this.readImageAsRasterAndReplaceColorProfile(n, imageReadParam, sOFSegment, jPEGColorSpace, adobeDCTSegment, this.ensureDisplayProfile(iCC_Profile));
        }
        if (DEBUG) {
            System.out.println("Reading using delegate");
        }
        return this.delegate.read(n, imageReadParam);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage readImageAsRasterAndReplaceColorProfile(int n, ImageReadParam imageReadParam, SOFSegment sOFSegment, JPEGColorSpace jPEGColorSpace, AdobeDCTSegment adobeDCTSegment, ICC_Profile iCC_Profile) throws IOException {
        Serializable serializable;
        ICC_ColorSpace iCC_ColorSpace;
        int n2 = this.getWidth(n);
        int n3 = this.getHeight(n);
        Iterator<ImageTypeSpecifier> iterator = this.getImageTypes(n);
        BufferedImage bufferedImage = JPEGImageReader.getDestination((ImageReadParam)imageReadParam, iterator, (int)n2, (int)n3);
        WritableRaster writableRaster = bufferedImage.getRaster();
        RasterOp rasterOp = null;
        ICC_ColorSpace iCC_ColorSpace2 = iCC_ColorSpace = iCC_Profile != null ? ColorSpaces.createColorSpace((ICC_Profile)iCC_Profile) : null;
        if (iCC_Profile == null || jPEGColorSpace != JPEGColorSpace.Gray && jPEGColorSpace != JPEGColorSpace.GrayA) {
            if (iCC_ColorSpace != null) {
                if (sOFSegment.componentsInFrame() != iCC_ColorSpace.getNumComponents()) {
                    if (sOFSegment.componentsInFrame() < 4 && (jPEGColorSpace == JPEGColorSpace.CMYK || jPEGColorSpace == JPEGColorSpace.YCCK)) {
                        this.processWarningOccurred(String.format("Invalid Adobe App14 marker. Indicates YCCK/CMYK data, but SOF%d has %d color components. Ignoring Adobe App14 marker, assuming YCbCr/RGB data.", sOFSegment.marker & 0xF, sOFSegment.componentsInFrame()));
                        jPEGColorSpace = JPEGColorSpace.YCbCr;
                    } else {
                        this.processWarningOccurred(String.format("Embedded ICC color profile is incompatible with image data. Profile indicates %d components, but SOF%d has %d color components. Ignoring ICC profile, assuming source color space %s.", new Object[]{iCC_ColorSpace.getNumComponents(), sOFSegment.marker & 0xF, sOFSegment.componentsInFrame(), jPEGColorSpace}));
                    }
                } else if (iCC_ColorSpace != bufferedImage.getColorModel().getColorSpace()) {
                    if (DEBUG) {
                        System.err.println("Converting from " + iCC_ColorSpace + " to " + (bufferedImage.getColorModel().getColorSpace().isCS_sRGB() ? "sRGB" : bufferedImage.getColorModel().getColorSpace()));
                    }
                    rasterOp = new ColorConvertOp(iCC_ColorSpace, bufferedImage.getColorModel().getColorSpace(), null);
                }
            } else if (jPEGColorSpace == JPEGColorSpace.YCCK || jPEGColorSpace == JPEGColorSpace.CMYK) {
                serializable = ColorSpaces.getColorSpace((int)5001);
                if (serializable instanceof ICC_ColorSpace) {
                    this.processWarningOccurred("No embedded ICC color profile, defaulting to \"generic\" CMYK ICC profile. Colors may look incorrect.");
                    rasterOp = new ColorConvertOp((ColorSpace)serializable, bufferedImage.getColorModel().getColorSpace(), null);
                } else {
                    this.processWarningOccurred("No embedded ICC color profile, will convert using inaccurate CMYK to RGB conversion. Colors may look incorrect.");
                    rasterOp = new FastCMYKToRGB();
                }
            } else if (iCC_Profile != null) {
                this.processWarningOccurred("Embedded ICC color profile is incompatible with Java 2D, color profile will be ignored.");
            }
        }
        if (imageReadParam == null) {
            imageReadParam = this.delegate.getDefaultReadParam();
            serializable = null;
        } else {
            serializable = imageReadParam.getSourceRegion();
        }
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        JPEGImageReader.computeRegions((ImageReadParam)imageReadParam, (int)n2, (int)n3, (BufferedImage)bufferedImage, (Rectangle)rectangle, (Rectangle)rectangle2);
        this.processImageStarted(n);
        try {
            int n4 = Math.max(1024, rectangle.height / 10);
            int n5 = rectangle.y + rectangle.height;
            int n6 = rectangle2.y;
            for (int i = rectangle.y; i < n5; i += n4) {
                int n7 = Math.min(n4, n5 - i);
                this.progressDelegator.updateProgressRange(100.0f * (float)(i + n7) / (float)rectangle.height);
                Rectangle rectangle3 = new Rectangle(rectangle.x, i, rectangle.width, n7);
                imageReadParam.setSourceRegion(rectangle3);
                Raster raster = this.delegate.readRaster(n, imageReadParam);
                if (jPEGColorSpace == JPEGColorSpace.YCbCr || jPEGColorSpace == JPEGColorSpace.YCbCrA) {
                    YCbCrConverter.convertYCbCr2RGB(raster);
                } else if (jPEGColorSpace == JPEGColorSpace.YCCK) {
                    YCbCrConverter.convertYCCK2CMYK(raster);
                } else if (jPEGColorSpace == JPEGColorSpace.CMYK) {
                    JPEGImageReader.invertCMYK(raster);
                }
                int n8 = Math.min(raster.getHeight(), rectangle2.height - n6);
                Raster raster2 = raster.createChild(0, 0, raster.getWidth(), n8, 0, 0, imageReadParam.getSourceBands());
                WritableRaster writableRaster2 = writableRaster.createWritableChild(rectangle2.x, n6, raster.getWidth(), n8, 0, 0, imageReadParam.getDestinationBands());
                if (rasterOp != null) {
                    rasterOp.filter(raster2, writableRaster2);
                } else {
                    writableRaster2.setRect(0, 0, raster2);
                }
                n6 += raster.getHeight();
                if (!this.abortRequested()) continue;
                this.processReadAborted();
                break;
            }
        }
        finally {
            this.progressDelegator.resetProgressRange();
            imageReadParam.setSourceRegion((Rectangle)serializable);
        }
        this.processImageComplete();
        return bufferedImage;
    }

    static JPEGColorSpace getSourceCSType(AdobeDCTSegment adobeDCTSegment, SOFSegment sOFSegment) throws IIOException {
        if (adobeDCTSegment != null) {
            switch (adobeDCTSegment.getTransform()) {
                case 1: {
                    return JPEGColorSpace.YCbCr;
                }
                case 2: {
                    return JPEGColorSpace.YCCK;
                }
                case 0: {
                    if (sOFSegment.components.length == 1) {
                        return JPEGColorSpace.Gray;
                    }
                    if (sOFSegment.components.length == 3) {
                        return JPEGColorSpace.RGB;
                    }
                    if (sOFSegment.components.length != 4) break;
                    return JPEGColorSpace.CMYK;
                }
            }
        }
        switch (sOFSegment.components.length) {
            case 1: {
                return JPEGColorSpace.Gray;
            }
            case 2: {
                return JPEGColorSpace.GrayA;
            }
            case 3: {
                if (sOFSegment.components[0].id == 1 && sOFSegment.components[1].id == 2 && sOFSegment.components[2].id == 3) {
                    return JPEGColorSpace.YCbCr;
                }
                if (sOFSegment.components[0].id == 82 && sOFSegment.components[1].id == 71 && sOFSegment.components[2].id == 66) {
                    return JPEGColorSpace.RGB;
                }
                if (sOFSegment.components[0].id == 89 && sOFSegment.components[1].id == 67 && sOFSegment.components[2].id == 99) {
                    return JPEGColorSpace.PhotoYCC;
                }
                for (SOFComponent sOFComponent : sOFSegment.components) {
                    if (sOFComponent.hSub == 1 && sOFComponent.vSub == 1) continue;
                    return JPEGColorSpace.YCbCr;
                }
                return JPEGColorSpace.RGB;
            }
            case 4: {
                if (sOFSegment.components[0].id == 1 && sOFSegment.components[1].id == 2 && sOFSegment.components[2].id == 3 && sOFSegment.components[3].id == 4) {
                    return JPEGColorSpace.YCbCrA;
                }
                if (sOFSegment.components[0].id == 82 && sOFSegment.components[1].id == 71 && sOFSegment.components[2].id == 66 && sOFSegment.components[3].id == 65) {
                    return JPEGColorSpace.RGBA;
                }
                if (sOFSegment.components[0].id == 89 && sOFSegment.components[1].id == 67 && sOFSegment.components[2].id == 99 && sOFSegment.components[3].id == 65) {
                    return JPEGColorSpace.PhotoYCCA;
                }
                if (sOFSegment.components[0].id == 67 && sOFSegment.components[1].id == 77 && sOFSegment.components[2].id == 89 && sOFSegment.components[3].id == 75) {
                    return JPEGColorSpace.CMYK;
                }
                if (sOFSegment.components[0].id == 89 && sOFSegment.components[1].id == 67 && sOFSegment.components[2].id == 99 && sOFSegment.components[3].id == 75) {
                    return JPEGColorSpace.YCCK;
                }
                for (SOFComponent sOFComponent : sOFSegment.components) {
                    if (sOFComponent.hSub == 1 && sOFComponent.vSub == 1) continue;
                    return JPEGColorSpace.YCCK;
                }
                return JPEGColorSpace.CMYK;
            }
        }
        throw new IIOException("Cannot determine source color space");
    }

    private ICC_Profile ensureDisplayProfile(ICC_Profile iCC_Profile) {
        byte[] byArray;
        if (iCC_Profile != null && iCC_Profile.getProfileClass() != 1 && (byArray = iCC_Profile.getData())[64] == 0) {
            this.processWarningOccurred("ICC profile is Perceptual but Display class, treating as Display class");
            JPEGImageReader.intToBigEndian(1835955314, byArray, 12);
            return ICC_Profile.getInstance(byArray);
        }
        return iCC_Profile;
    }

    static void intToBigEndian(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)(n >> 24);
        byArray[n2 + 1] = (byte)(n >> 16);
        byArray[n2 + 2] = (byte)(n >> 8);
        byArray[n2 + 3] = (byte)n;
    }

    private void initHeader() throws IOException {
        if (this.segments == null) {
            long l = DEBUG ? System.currentTimeMillis() : 0L;
            this.readSegments();
            if (DEBUG) {
                System.out.println("Read metadata in " + (System.currentTimeMillis() - l) + " ms");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readSegments() throws IOException {
        this.imageInput.mark();
        try {
            this.imageInput.seek(0L);
            this.segments = JPEGSegmentUtil.readSegments((ImageInputStream)this.imageInput, SEGMENT_IDENTIFIERS);
        }
        catch (IIOException iIOException) {
            if (DEBUG) {
                iIOException.printStackTrace();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (DEBUG) {
                illegalArgumentException.printStackTrace();
            }
        }
        finally {
            this.imageInput.reset();
        }
        if (this.segments == null) {
            this.segments = Collections.emptyList();
        }
    }

    List<JPEGSegment> getAppSegments(int n, String string) throws IOException {
        this.initHeader();
        List<JPEGSegment> list = Collections.emptyList();
        for (JPEGSegment jPEGSegment : this.segments) {
            if ((n != -1 || jPEGSegment.marker() < 65504 || jPEGSegment.marker() > 65519) && jPEGSegment.marker() != n || string != null && !string.equals(jPEGSegment.identifier())) continue;
            if (list == Collections.EMPTY_LIST) {
                list = new ArrayList<JPEGSegment>(this.segments.size());
            }
            list.add(jPEGSegment);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SOFSegment getSOF() throws IOException {
        for (JPEGSegment jPEGSegment : this.segments) {
            if (!(65472 >= jPEGSegment.marker() && jPEGSegment.marker() <= 65475 || 65477 >= jPEGSegment.marker() && jPEGSegment.marker() <= 65479 || 65481 >= jPEGSegment.marker() && jPEGSegment.marker() <= 65483) && (65485 < jPEGSegment.marker() || jPEGSegment.marker() > 65487)) continue;
            DataInputStream dataInputStream = new DataInputStream(jPEGSegment.data());
            try {
                int n = dataInputStream.readUnsignedByte();
                int n2 = dataInputStream.readUnsignedShort();
                int n3 = dataInputStream.readUnsignedShort();
                int n4 = dataInputStream.readUnsignedByte();
                SOFComponent[] sOFComponentArray = new SOFComponent[n4];
                for (int i = 0; i < n4; ++i) {
                    int n5 = dataInputStream.readUnsignedByte();
                    int n6 = dataInputStream.readUnsignedByte();
                    int n7 = dataInputStream.readUnsignedByte();
                    sOFComponentArray[i] = new SOFComponent(n5, (n6 & 0xF0) >> 4, n6 & 0xF, n7);
                }
                SOFSegment sOFSegment = new SOFSegment(jPEGSegment.marker(), n, n2, n3, sOFComponentArray);
                return sOFSegment;
            }
            finally {
                dataInputStream.close();
            }
        }
        return null;
    }

    AdobeDCTSegment getAdobeDCT() throws IOException {
        List<JPEGSegment> list = this.getAppSegments(65518, "Adobe");
        if (!list.isEmpty()) {
            DataInputStream dataInputStream = new DataInputStream(list.get(0).data());
            return new AdobeDCTSegment(dataInputStream.readUnsignedByte(), dataInputStream.readUnsignedShort(), dataInputStream.readUnsignedShort(), dataInputStream.readUnsignedByte());
        }
        return null;
    }

    JFIFSegment getJFIF() throws IOException {
        List<JPEGSegment> list = this.getAppSegments(65504, "JFIF");
        if (!list.isEmpty()) {
            JPEGSegment jPEGSegment = list.get(0);
            return JFIFSegment.read(jPEGSegment.data());
        }
        return null;
    }

    JFXXSegment getJFXX() throws IOException {
        List<JPEGSegment> list = this.getAppSegments(65504, "JFXX");
        if (!list.isEmpty()) {
            JPEGSegment jPEGSegment = list.get(0);
            return JFXXSegment.read(jPEGSegment.data(), jPEGSegment.length());
        }
        return null;
    }

    private CompoundDirectory getExif() throws IOException {
        List<JPEGSegment> list = this.getAppSegments(65505, "Exif");
        if (!list.isEmpty()) {
            JPEGSegment jPEGSegment = list.get(0);
            InputStream inputStream = jPEGSegment.data();
            if (inputStream.read() == -1) {
                this.processWarningOccurred("Exif chunk has no data.");
            } else {
                ImageInputStream imageInputStream = ImageIO.createImageInputStream(inputStream);
                return (CompoundDirectory)new EXIFReader().read(imageInputStream);
            }
        }
        return null;
    }

    static byte[] readFully(DataInput dataInput, int n) throws IOException {
        if (n == 0) {
            return null;
        }
        byte[] byArray = new byte[n];
        dataInput.readFully(byArray);
        return byArray;
    }

    ICC_Profile getEmbeddedICCProfile(boolean bl) throws IOException {
        List<JPEGSegment> list = this.getAppSegments(65506, "ICC_PROFILE");
        if (list.size() == 1) {
            JPEGSegment jPEGSegment = list.get(0);
            DataInputStream dataInputStream = new DataInputStream(jPEGSegment.data());
            int n = dataInputStream.readUnsignedByte();
            int n2 = dataInputStream.readUnsignedByte();
            if (n != 1 && n2 != 1) {
                this.processWarningOccurred(String.format("Unexpected number of 'ICC_PROFILE' chunks: %d of %d. Ignoring ICC profile.", n, n2));
                return null;
            }
            return this.readICCProfileSafe(dataInputStream);
        }
        if (!list.isEmpty()) {
            DataInputStream dataInputStream = new DataInputStream(list.get(0).data());
            int n = dataInputStream.readUnsignedByte();
            int n3 = dataInputStream.readUnsignedByte();
            boolean bl2 = false;
            if (n3 != list.size()) {
                this.processWarningOccurred(String.format("Bad 'ICC_PROFILE' chunk count: %d. Ignoring ICC profile.", n3));
                bl2 = true;
                if (!bl) {
                    return null;
                }
            }
            if (!bl2 && n < 1) {
                this.processWarningOccurred(String.format("Invalid 'ICC_PROFILE' chunk index: %d. Ignoring ICC profile.", n));
                if (!bl) {
                    return null;
                }
            }
            int n4 = bl2 ? list.size() : n3;
            InputStream[] inputStreamArray = new InputStream[n4];
            inputStreamArray[bl2 ? 0 : n - 1] = dataInputStream;
            for (int i = 1; i < n4; ++i) {
                dataInputStream = new DataInputStream(list.get(i).data());
                n = dataInputStream.readUnsignedByte();
                if (!bl2 && dataInputStream.readUnsignedByte() != n3) {
                    throw new IIOException(String.format("Bad number of 'ICC_PROFILE' chunks: %d of %d.", n, n3));
                }
                inputStreamArray[bl2 ? i : n - 1] = dataInputStream;
            }
            return this.readICCProfileSafe(new SequenceInputStream(Collections.enumeration(Arrays.asList(inputStreamArray))));
        }
        return null;
    }

    private ICC_Profile readICCProfileSafe(InputStream inputStream) throws IOException {
        try {
            return ICC_Profile.getInstance(inputStream);
        }
        catch (RuntimeException runtimeException) {
            this.processWarningOccurred(String.format("Bad 'ICC_PROFILE' chunk(s): %s. Ignoring ICC profile.", runtimeException.getMessage()));
            return null;
        }
    }

    public boolean canReadRaster() {
        return this.delegate.canReadRaster();
    }

    public Raster readRaster(int n, ImageReadParam imageReadParam) throws IOException {
        return this.delegate.readRaster(n, imageReadParam);
    }

    public RenderedImage readAsRenderedImage(int n, ImageReadParam imageReadParam) throws IOException {
        return this.read(n, imageReadParam);
    }

    public void abort() {
        super.abort();
        this.delegate.abort();
    }

    public boolean readerSupportsThumbnails() {
        return true;
    }

    private void readThumbnailMetadata(int n) throws IOException {
        this.checkBounds(n);
        if (this.thumbnails == null) {
            List<JPEGSegment> list;
            JFXXSegment jFXXSegment;
            this.thumbnails = new ArrayList<ThumbnailReader>();
            ThumbnailProgressDelegate thumbnailProgressDelegate = new ThumbnailProgressDelegate();
            JFIFSegment jFIFSegment = this.getJFIF();
            if (jFIFSegment != null && jFIFSegment.thumbnail != null) {
                this.thumbnails.add(new JFIFThumbnailReader(thumbnailProgressDelegate, n, this.thumbnails.size(), jFIFSegment));
            }
            if ((jFXXSegment = this.getJFXX()) != null && jFXXSegment.thumbnail != null) {
                switch (jFXXSegment.extensionCode) {
                    case 16: 
                    case 17: 
                    case 19: {
                        this.thumbnails.add(new JFXXThumbnailReader(thumbnailProgressDelegate, this.getThumbnailReader(), n, this.thumbnails.size(), jFXXSegment));
                        break;
                    }
                    default: {
                        this.processWarningOccurred("Unknown JFXX extension code: " + jFXXSegment.extensionCode);
                    }
                }
            }
            if (!(list = this.getAppSegments(65505, "Exif")).isEmpty()) {
                JPEGSegment jPEGSegment = list.get(0);
                InputStream inputStream = jPEGSegment.data();
                if (inputStream.read() == -1) {
                    this.processWarningOccurred("Exif chunk has no data.");
                } else {
                    MemoryCacheImageInputStream memoryCacheImageInputStream = new MemoryCacheImageInputStream(inputStream);
                    CompoundDirectory compoundDirectory = (CompoundDirectory)new EXIFReader().read((ImageInputStream)memoryCacheImageInputStream);
                    if (compoundDirectory.directoryCount() == 2) {
                        Directory directory = compoundDirectory.getDirectory(1);
                        Entry entry = directory.getEntryById((Object)259);
                        if (entry == null || entry.getValue().equals(1) || entry.getValue().equals(6)) {
                            Entry entry2 = directory.getEntryById((Object)514);
                            if (entry2 == null || ((Number)entry2.getValue()).longValue() > 0L) {
                                this.thumbnails.add(new EXIFThumbnailReader(thumbnailProgressDelegate, this.getThumbnailReader(), 0, this.thumbnails.size(), directory, memoryCacheImageInputStream));
                            } else {
                                this.processWarningOccurred("EXIF IFD with empty (zero-length) thumbnail");
                            }
                        } else {
                            this.processWarningOccurred("EXIF IFD with unknown compression (expected 1 or 6): " + entry.getValue());
                        }
                    }
                }
            }
        }
    }

    ImageReader getThumbnailReader() throws IOException {
        if (this.thumbnailReader == null) {
            this.thumbnailReader = this.delegate.getOriginatingProvider().createReaderInstance();
        }
        return this.thumbnailReader;
    }

    public int getNumThumbnails(int n) throws IOException {
        this.readThumbnailMetadata(n);
        return this.thumbnails.size();
    }

    private void checkThumbnailBounds(int n, int n2) throws IOException {
        Validate.isTrue((n2 >= 0 ? 1 : 0) != 0, (Object)n2, (String)"thumbnailIndex < 0; %d");
        Validate.isTrue((this.getNumThumbnails(n) > n2 ? 1 : 0) != 0, (Object)n2, (String)"thumbnailIndex >= numThumbnails; %d");
    }

    public int getThumbnailWidth(int n, int n2) throws IOException {
        this.checkThumbnailBounds(n, n2);
        return this.thumbnails.get(n2).getWidth();
    }

    public int getThumbnailHeight(int n, int n2) throws IOException {
        this.checkThumbnailBounds(n, n2);
        return this.thumbnails.get(n2).getHeight();
    }

    public BufferedImage readThumbnail(int n, int n2) throws IOException {
        this.checkThumbnailBounds(n, n2);
        return this.thumbnails.get(n2).read();
    }

    public IIOMetadata getImageMetadata(int n) throws IOException {
        IIOMetadata iIOMetadata = this.delegate.getImageMetadata(n);
        if (iIOMetadata != null && Arrays.asList(iIOMetadata.getMetadataFormatNames()).contains("javax_imageio_jpeg_image_1.0")) {
            if (this.metadataCleaner == null) {
                this.metadataCleaner = new JPEGImage10MetadataCleaner(this);
            }
            return this.metadataCleaner.cleanMetadata(iIOMetadata);
        }
        return iIOMetadata;
    }

    public IIOMetadata getStreamMetadata() throws IOException {
        return this.delegate.getStreamMetadata();
    }

    protected void processWarningOccurred(String string) {
        super.processWarningOccurred(string);
    }

    private static void invertCMYK(Raster raster) {
        byte[] byArray = ((DataBufferByte)raster.getDataBuffer()).getData();
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)(255 - byArray[i] & 0xFF);
        }
    }

    protected static void showIt(BufferedImage bufferedImage, String string) {
        ImageReaderBase.showIt((BufferedImage)bufferedImage, (String)string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws IOException {
        for (final String string : stringArray) {
            File file = new File(string);
            ImageInputStream imageInputStream = ImageIO.createImageInputStream(file);
            if (imageInputStream == null) {
                System.err.println("Could not read file: " + file);
                continue;
            }
            Iterator<ImageReader> iterator = ImageIO.getImageReaders(imageInputStream);
            if (!iterator.hasNext()) {
                System.err.println("No reader for: " + file);
                continue;
            }
            ImageReader imageReader = iterator.next();
            imageReader.addIIOReadWarningListener(new IIOReadWarningListener(){

                public void warningOccurred(ImageReader imageReader, String string2) {
                    System.err.println("Warning: " + string + ": " + string2);
                }
            });
            imageReader.addIIOReadProgressListener((IIOReadProgressListener)new ProgressListenerBase(){
                private static final int MAX_W = 78;
                int lastProgress = 0;

                public void imageStarted(ImageReader imageReader, int n) {
                    System.out.print("[");
                }

                public void imageProgress(ImageReader imageReader, float f) {
                    int n = (int)(f * 78.0f) / 100;
                    for (int i = this.lastProgress; i < n; ++i) {
                        System.out.print(".");
                    }
                    System.out.flush();
                    this.lastProgress = n;
                }

                public void imageComplete(ImageReader imageReader) {
                    for (int i = this.lastProgress; i < 78; ++i) {
                        System.out.print(".");
                    }
                    System.out.println("]");
                }
            });
            imageReader.setInput(imageInputStream);
            try {
                ImageReadParam imageReadParam = imageReader.getDefaultReadParam();
                BufferedImage bufferedImage = imageReader.read(0, imageReadParam);
                int n = 1280;
                int n2 = 800;
                if (bufferedImage.getWidth() > n || bufferedImage.getHeight() > n2) {
                    float f = imageReader.getAspectRatio(0);
                    bufferedImage = f >= 1.0f ? ImageUtil.createResampled((BufferedImage)bufferedImage, (int)n, (int)Math.round((float)n / f), (int)4) : ImageUtil.createResampled((BufferedImage)bufferedImage, (int)Math.round((float)n2 * f), (int)n2, (int)4);
                }
                JPEGImageReader.showIt(bufferedImage, String.format("Image: %s [%d x %d]", file.getName(), imageReader.getWidth(0), imageReader.getHeight(0)));
                try {
                    IIOMetadata iIOMetadata = imageReader.getImageMetadata(0);
                    System.out.println("Metadata for File: " + file.getName());
                    System.out.println("Native:");
                    new XMLSerializer((OutputStream)System.out, System.getProperty("file.encoding")).serialize(iIOMetadata.getAsTree(iIOMetadata.getNativeMetadataFormatName()), false);
                    System.out.println("Standard:");
                    new XMLSerializer((OutputStream)System.out, System.getProperty("file.encoding")).serialize(iIOMetadata.getAsTree("javax_imageio_1.0"), false);
                    System.out.println();
                    int n3 = imageReader.getNumThumbnails(0);
                    for (int i = 0; i < n3; ++i) {
                        BufferedImage bufferedImage2 = imageReader.readThumbnail(0, i);
                        JPEGImageReader.showIt(bufferedImage2, String.format("Thumbnail: %s [%d x %d]", file.getName(), bufferedImage2.getWidth(), bufferedImage2.getHeight()));
                    }
                }
                catch (IIOException iIOException) {
                    System.err.println("Could not read thumbnails: " + string + ": " + iIOException.getMessage());
                    iIOException.printStackTrace();
                }
            }
            catch (Throwable throwable) {
                System.err.println(file);
                throwable.printStackTrace();
            }
            finally {
                imageInputStream.close();
            }
        }
    }

    private class ThumbnailProgressDelegate
    implements ThumbnailReadProgressListener {
        private ThumbnailProgressDelegate() {
        }

        public void processThumbnailStarted(int n, int n2) {
            JPEGImageReader.this.processThumbnailStarted(n, n2);
        }

        public void processThumbnailProgress(float f) {
            JPEGImageReader.this.processThumbnailProgress(f);
        }

        public void processThumbnailComplete() {
            JPEGImageReader.this.processThumbnailComplete();
        }
    }

    private class ProgressDelegator
    extends ProgressListenerBase
    implements IIOReadUpdateListener,
    IIOReadWarningListener {
        float readProgressStart = -1.0f;
        float readProgressStop = -1.0f;

        private ProgressDelegator() {
        }

        void resetProgressRange() {
            this.readProgressStart = -1.0f;
            this.readProgressStop = -1.0f;
        }

        private boolean isProgressRangeCorrected() {
            return this.readProgressStart == -1.0f && this.readProgressStop == -1.0f;
        }

        void updateProgressRange(float f) {
            Validate.isTrue((f >= 0.0f ? 1 : 0) != 0, (Object)Float.valueOf(f), (String)"Negative range limit");
            this.readProgressStart = this.readProgressStop != -1.0f ? this.readProgressStop : 0.0f;
            this.readProgressStop = f;
        }

        public void imageComplete(ImageReader imageReader) {
            if (this.isProgressRangeCorrected()) {
                JPEGImageReader.this.processImageComplete();
            }
        }

        public void imageProgress(ImageReader imageReader, float f) {
            if (this.isProgressRangeCorrected()) {
                JPEGImageReader.this.processImageProgress(f);
            } else {
                JPEGImageReader.this.processImageProgress(this.readProgressStart + f * (this.readProgressStop - this.readProgressStart) / 100.0f);
            }
        }

        public void imageStarted(ImageReader imageReader, int n) {
            if (this.isProgressRangeCorrected()) {
                JPEGImageReader.this.processImageStarted(n);
            }
        }

        public void readAborted(ImageReader imageReader) {
            if (this.isProgressRangeCorrected()) {
                JPEGImageReader.this.processReadAborted();
            }
        }

        public void sequenceComplete(ImageReader imageReader) {
            JPEGImageReader.this.processSequenceComplete();
        }

        public void sequenceStarted(ImageReader imageReader, int n) {
            JPEGImageReader.this.processSequenceStarted(n);
        }

        public void thumbnailComplete(ImageReader imageReader) {
            JPEGImageReader.this.processThumbnailComplete();
        }

        public void thumbnailProgress(ImageReader imageReader, float f) {
            JPEGImageReader.this.processThumbnailProgress(f);
        }

        public void thumbnailStarted(ImageReader imageReader, int n, int n2) {
            JPEGImageReader.this.processThumbnailStarted(n, n2);
        }

        public void passStarted(ImageReader imageReader, BufferedImage bufferedImage, int n, int n2, int n3, int n4, int n5, int n6, int n7, int[] nArray) {
            JPEGImageReader.this.processPassStarted(bufferedImage, n, n2, n3, n4, n5, n6, n7, nArray);
        }

        public void imageUpdate(ImageReader imageReader, BufferedImage bufferedImage, int n, int n2, int n3, int n4, int n5, int n6, int[] nArray) {
            JPEGImageReader.this.processImageUpdate(bufferedImage, n, n2, n3, n4, n5, n6, nArray);
        }

        public void passComplete(ImageReader imageReader, BufferedImage bufferedImage) {
            JPEGImageReader.this.processPassComplete(bufferedImage);
        }

        public void thumbnailPassStarted(ImageReader imageReader, BufferedImage bufferedImage, int n, int n2, int n3, int n4, int n5, int n6, int n7, int[] nArray) {
            JPEGImageReader.this.processThumbnailPassStarted(bufferedImage, n, n2, n3, n4, n5, n6, n7, nArray);
        }

        public void thumbnailUpdate(ImageReader imageReader, BufferedImage bufferedImage, int n, int n2, int n3, int n4, int n5, int n6, int[] nArray) {
            JPEGImageReader.this.processThumbnailUpdate(bufferedImage, n, n2, n3, n4, n5, n6, nArray);
        }

        public void thumbnailPassComplete(ImageReader imageReader, BufferedImage bufferedImage) {
            JPEGImageReader.this.processThumbnailPassComplete(bufferedImage);
        }

        public void warningOccurred(ImageReader imageReader, String string) {
            JPEGImageReader.this.processWarningOccurred(string);
        }
    }

    static final class YCbCrConverter {
        private static final int SCALEBITS = 16;
        private static final int MAXJSAMPLE = 255;
        private static final int CENTERJSAMPLE = 128;
        private static final int ONE_HALF = 32768;
        private static final int[] Cr_R_LUT = new int[256];
        private static final int[] Cb_B_LUT = new int[256];
        private static final int[] Cr_G_LUT = new int[256];
        private static final int[] Cb_G_LUT = new int[256];

        YCbCrConverter() {
        }

        private static void buildYCCtoRGBtable() {
            if (DEBUG) {
                System.err.println("Building YCC conversion table");
            }
            int n = 0;
            int n2 = -128;
            while (n <= 255) {
                YCbCrConverter.Cr_R_LUT[n] = (int)(91881.972 * (double)n2 + 32768.0) >> 16;
                YCbCrConverter.Cb_B_LUT[n] = (int)(116130.292 * (double)n2 + 32768.0) >> 16;
                YCbCrConverter.Cr_G_LUT[n] = -46802 * n2;
                YCbCrConverter.Cb_G_LUT[n] = -22554 * n2 + 32768;
                ++n;
                ++n2;
            }
        }

        static void convertYCbCr2RGB(Raster raster) {
            int n = raster.getHeight();
            int n2 = raster.getWidth();
            byte[] byArray = ((DataBufferByte)raster.getDataBuffer()).getData();
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    YCbCrConverter.convertYCbCr2RGB(byArray, byArray, (j + i * n2) * 3);
                }
            }
        }

        static void convertYCbCr2RGB(byte[] byArray, byte[] byArray2, int n) {
            int n2 = byArray[n] & 0xFF;
            int n3 = byArray[n + 2] & 0xFF;
            int n4 = byArray[n + 1] & 0xFF;
            byArray2[n] = YCbCrConverter.clamp(n2 + Cr_R_LUT[n3]);
            byArray2[n + 1] = YCbCrConverter.clamp(n2 + (Cb_G_LUT[n4] + Cr_G_LUT[n3] >> 16));
            byArray2[n + 2] = YCbCrConverter.clamp(n2 + Cb_B_LUT[n4]);
        }

        static void convertYCCK2CMYK(Raster raster) {
            int n = raster.getHeight();
            int n2 = raster.getWidth();
            byte[] byArray = ((DataBufferByte)raster.getDataBuffer()).getData();
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    YCbCrConverter.convertYCCK2CMYK(byArray, byArray, (j + i * n2) * 4);
                }
            }
        }

        private static void convertYCCK2CMYK(byte[] byArray, byte[] byArray2, int n) {
            int n2 = 255 - byArray[n] & 0xFF;
            int n3 = 255 - byArray[n + 1] & 0xFF;
            int n4 = 255 - byArray[n + 2] & 0xFF;
            int n5 = 255 - byArray[n + 3] & 0xFF;
            int n6 = 255 - (n2 + Cr_R_LUT[n4]);
            int n7 = 255 - (n2 + (Cb_G_LUT[n3] + Cr_G_LUT[n4] >> 16));
            int n8 = 255 - (n2 + Cb_B_LUT[n3]);
            byArray2[n] = YCbCrConverter.clamp(n6);
            byArray2[n + 1] = YCbCrConverter.clamp(n7);
            byArray2[n + 2] = YCbCrConverter.clamp(n8);
            byArray2[n + 3] = (byte)n5;
        }

        private static byte clamp(int n) {
            return (byte)Math.max(0, Math.min(255, n));
        }

        static {
            YCbCrConverter.buildYCCtoRGBtable();
        }
    }
}

