/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.wsdl;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Messages;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.SEIModel;
import com.sun.xml.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.model.AbstractSEIModelImpl;
import com.sun.xml.ws.model.JavaMethodImpl;
import com.sun.xml.ws.resources.AddressingMessages;
import com.sun.xml.ws.wsdl.ActionBasedOperationSignature;
import com.sun.xml.ws.wsdl.DispatchException;
import com.sun.xml.ws.wsdl.PayloadQNameBasedOperationFinder;
import com.sun.xml.ws.wsdl.WSDLOperationFinder;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;

final class ActionBasedOperationFinder
extends WSDLOperationFinder {
    private static final Logger LOGGER = Logger.getLogger(ActionBasedOperationFinder.class.getName());
    private final Map<ActionBasedOperationSignature, QName> uniqueOpSignatureMap;
    private final Map<String, QName> actionMap;
    @NotNull
    private final AddressingVersion av;

    public ActionBasedOperationFinder(WSDLPort wsdlModel, WSBinding binding, @Nullable SEIModel seiModel) {
        super(wsdlModel, binding, seiModel);
        assert (binding.getAddressingVersion() != null);
        this.av = binding.getAddressingVersion();
        this.uniqueOpSignatureMap = new HashMap<ActionBasedOperationSignature, QName>();
        this.actionMap = new HashMap<String, QName>();
        if (seiModel != null) {
            for (JavaMethodImpl javaMethodImpl : ((AbstractSEIModelImpl)seiModel).getJavaMethods()) {
                if (javaMethodImpl.getMEP().isAsync) continue;
                String action = javaMethodImpl.getInputAction();
                QName payloadName = javaMethodImpl.getRequestPayloadName();
                if (payloadName == null) {
                    payloadName = PayloadQNameBasedOperationFinder.EMPTY_PAYLOAD;
                }
                if (action == null || action.equals("")) {
                    action = javaMethodImpl.getOperation().getOperation().getInput().getAction();
                }
                if (action == null) continue;
                ActionBasedOperationSignature opSignature = new ActionBasedOperationSignature(action, payloadName);
                if (this.uniqueOpSignatureMap.get(opSignature) != null) {
                    LOGGER.warning(AddressingMessages.NON_UNIQUE_OPERATION_SIGNATURE(this.uniqueOpSignatureMap.get(opSignature), javaMethodImpl.getOperation().getName(), action, payloadName));
                }
                this.uniqueOpSignatureMap.put(opSignature, javaMethodImpl.getOperation().getName());
                this.actionMap.put(action, javaMethodImpl.getOperation().getName());
            }
        } else {
            for (WSDLBoundOperation wSDLBoundOperation : wsdlModel.getBinding().getBindingOperations()) {
                String action;
                ActionBasedOperationSignature opSignature;
                QName payloadName = wSDLBoundOperation.getReqPayloadName();
                if (payloadName == null) {
                    payloadName = PayloadQNameBasedOperationFinder.EMPTY_PAYLOAD;
                }
                if (this.uniqueOpSignatureMap.get(opSignature = new ActionBasedOperationSignature(action = wSDLBoundOperation.getOperation().getInput().getAction(), payloadName)) != null) {
                    LOGGER.warning(AddressingMessages.NON_UNIQUE_OPERATION_SIGNATURE(this.uniqueOpSignatureMap.get(opSignature), wSDLBoundOperation.getName(), action, payloadName));
                }
                this.uniqueOpSignatureMap.put(opSignature, wSDLBoundOperation.getName());
                this.actionMap.put(action, wSDLBoundOperation.getName());
            }
        }
    }

    public QName getWSDLOperationQName(Packet request) throws DispatchException {
        QName payloadName;
        HeaderList hl = request.getMessage().getHeaders();
        String action = hl.getAction(this.av, this.binding.getSOAPVersion());
        if (action == null) {
            return null;
        }
        Message message = request.getMessage();
        String localPart = message.getPayloadLocalPart();
        if (localPart == null) {
            payloadName = PayloadQNameBasedOperationFinder.EMPTY_PAYLOAD;
        } else {
            String nsUri = message.getPayloadNamespaceURI();
            if (nsUri == null) {
                nsUri = "";
            }
            payloadName = new QName(nsUri, localPart);
        }
        QName opName = this.uniqueOpSignatureMap.get(new ActionBasedOperationSignature(action, payloadName));
        if (opName != null) {
            return opName;
        }
        opName = this.actionMap.get(action);
        if (opName != null) {
            return opName;
        }
        Message result = Messages.create(action, this.av, this.binding.getSOAPVersion());
        throw new DispatchException(result);
    }
}

