/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.schemaframework;

import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.databaseaccess.DatabaseAccessor;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.sequencing.Sequencing;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.sequencing.DefaultSequence;
import org.eclipse.persistence.sequencing.NativeSequence;
import org.eclipse.persistence.sequencing.Sequence;
import org.eclipse.persistence.sequencing.TableSequence;
import org.eclipse.persistence.sequencing.UnaryTableSequence;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.tools.schemaframework.DatabaseObjectDefinition;
import org.eclipse.persistence.tools.schemaframework.DefaultTableGenerator;
import org.eclipse.persistence.tools.schemaframework.SequenceDefinition;
import org.eclipse.persistence.tools.schemaframework.SequenceObjectDefinition;
import org.eclipse.persistence.tools.schemaframework.StoredProcedureDefinition;
import org.eclipse.persistence.tools.schemaframework.StoredProcedureGenerator;
import org.eclipse.persistence.tools.schemaframework.TableCreator;
import org.eclipse.persistence.tools.schemaframework.TableDefinition;
import org.eclipse.persistence.tools.schemaframework.TableSequenceDefinition;
import org.eclipse.persistence.tools.schemaframework.UnaryTableSequenceDefinition;

public class SchemaManager {
    protected DatabaseSessionImpl session;
    protected Writer createSchemaWriter;
    protected Writer dropSchemaWriter;
    protected boolean createSQLFiles = true;
    protected TableCreator defaultTableCreator;
    public static boolean FAST_TABLE_CREATOR = false;
    public static boolean FORCE_DROP = true;

    public SchemaManager(DatabaseSessionImpl session) {
        this.session = session;
    }

    public SchemaManager(DatabaseSession session) {
        this.session = (DatabaseSessionImpl)session;
    }

    protected Writer getDropSchemaWriter() {
        if (this.dropSchemaWriter == null) {
            return this.createSchemaWriter;
        }
        return this.dropSchemaWriter;
    }

    public void appendToDDLWriter(String stringToWrite) {
        this.appendToDDLWriter(this.createSchemaWriter, stringToWrite);
    }

    public void appendToDDLWriter(Writer schemaWriter, String stringToWrite) {
        if (schemaWriter == null) {
            return;
        }
        try {
            schemaWriter.write(stringToWrite);
            schemaWriter.flush();
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
    }

    public void buildFieldTypes(TableDefinition tableDef) {
        tableDef.buildFieldTypes(this.getSession());
    }

    public void closeDDLWriter() {
        this.closeDDLWriter(this.createSchemaWriter);
        this.closeDDLWriter(this.dropSchemaWriter);
        this.createSchemaWriter = null;
        this.dropSchemaWriter = null;
    }

    public void closeDDLWriter(Writer schemaWriter) {
        if (schemaWriter == null) {
            return;
        }
        try {
            schemaWriter.flush();
            schemaWriter.close();
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
    }

    public void createConstraints(TableDefinition tableDefinition) throws EclipseLinkException {
        boolean usesBatchWriting = false;
        if (this.getSession().getPlatform().usesBatchWriting()) {
            usesBatchWriting = true;
            this.getSession().getPlatform().setUsesBatchWriting(false);
        }
        try {
            if (this.shouldWriteToDatabase()) {
                tableDefinition.createConstraintsOnDatabase(this.getSession());
            } else {
                tableDefinition.setCreateSQLFiles(this.createSQLFiles);
                tableDefinition.createConstraints(this.getSession(), this.createSchemaWriter);
            }
        }
        finally {
            if (usesBatchWriting) {
                this.getSession().getPlatform().setUsesBatchWriting(true);
            }
        }
    }

    void createUniqueConstraints(TableDefinition tableDefinition) throws EclipseLinkException {
        if (this.shouldWriteToDatabase()) {
            tableDefinition.createUniqueConstraintsOnDatabase(this.getSession());
        } else {
            tableDefinition.setCreateSQLFiles(this.createSQLFiles);
            tableDefinition.createUniqueConstraints(this.getSession(), this.createSchemaWriter);
        }
    }

    void createForeignConstraints(TableDefinition tableDefinition) throws EclipseLinkException {
        if (this.shouldWriteToDatabase()) {
            tableDefinition.createForeignConstraintsOnDatabase(this.getSession());
        } else {
            tableDefinition.setCreateSQLFiles(this.createSQLFiles);
            tableDefinition.createForeignConstraints(this.getSession(), this.createSchemaWriter);
        }
    }

    public void createObject(DatabaseObjectDefinition databaseObjectDefinition) throws EclipseLinkException {
        boolean usesBatchWriting = false;
        if (this.getSession().getPlatform().usesBatchWriting()) {
            usesBatchWriting = true;
            this.getSession().getPlatform().setUsesBatchWriting(false);
        }
        try {
            if (this.shouldWriteToDatabase()) {
                databaseObjectDefinition.createOnDatabase(this.getSession());
            } else {
                databaseObjectDefinition.createObject(this.getSession(), this.createSchemaWriter);
                if (this.createSQLFiles) {
                    this.appendToDDLWriter(this.createSchemaWriter, this.getSession().getPlatform().getStoredProcedureTerminationToken());
                }
                this.appendToDDLWriter(this.createSchemaWriter, "\n");
            }
            databaseObjectDefinition.postCreateObject(this.getSession(), this.createSchemaWriter, this.createSQLFiles);
        }
        finally {
            if (usesBatchWriting) {
                this.getSession().getPlatform().setUsesBatchWriting(true);
            }
        }
    }

    public void createSequences() throws EclipseLinkException {
        this.createOrReplaceSequences(true);
    }

    public void setCreateSQLFiles(boolean genFlag) {
        this.createSQLFiles = genFlag;
    }

    public void replaceSequences() throws EclipseLinkException {
        this.createOrReplaceSequences(false);
    }

    protected void createOrReplaceSequences(boolean create) throws EclipseLinkException {
        this.createOrReplaceSequences(create, create);
    }

    protected void createOrReplaceSequences(boolean createSequenceTables, boolean createSequenceObjects) throws EclipseLinkException {
        boolean fast = FAST_TABLE_CREATOR;
        if (fast) {
            return;
        }
        Sequencing sequencing = this.getSession().getSequencing();
        if (sequencing == null || sequencing.whenShouldAcquireValueForAll() == 1) {
            return;
        }
        HashMap tableDefinitions = new HashMap();
        HashSet sequenceDefinitions = new HashSet();
        HashSet processedSequenceNames = new HashSet();
        this.buildTableAndSequenceDefinitions(sequenceDefinitions, processedSequenceNames, tableDefinitions);
        this.processTableDefinitions(tableDefinitions, createSequenceTables);
        this.processSequenceDefinitions(sequenceDefinitions, createSequenceObjects);
    }

    private void buildTableAndSequenceDefinitions(HashSet sequenceDefinitions, HashSet processedSequenceNames, HashMap tableDefinitions) {
        for (ClassDescriptor descriptor : this.getSession().getDescriptors().values()) {
            String tableName;
            TableDefinition otherTableDefinition;
            if (!descriptor.usesSequenceNumbers()) continue;
            String seqName = descriptor.getSequenceNumberName();
            if (seqName == null) {
                seqName = this.getSession().getDatasourcePlatform().getDefaultSequence().getName();
            }
            if (processedSequenceNames.contains(seqName)) continue;
            processedSequenceNames.add(seqName);
            Sequence sequence = this.getSession().getDatasourcePlatform().getSequence(seqName);
            SequenceDefinition sequenceDefinition = this.buildSequenceDefinition(sequence);
            if (sequenceDefinition == null) continue;
            sequenceDefinitions.add(sequenceDefinition);
            TableDefinition tableDefinition = sequenceDefinition.buildTableDefinition();
            if (tableDefinition == null || (otherTableDefinition = (TableDefinition)tableDefinitions.get(tableName = tableDefinition.getName())) != null) continue;
            tableDefinitions.put(tableName, tableDefinition);
        }
    }

    private void processTableDefinitions(HashMap tableDefinitions, boolean create) throws EclipseLinkException {
        Iterator itTableDefinitions = tableDefinitions.values().iterator();
        boolean shouldLogExceptionStackTrace = this.session.getSessionLog().shouldLogExceptionStackTrace();
        while (itTableDefinitions.hasNext()) {
            TableDefinition tableDefinition = (TableDefinition)itTableDefinitions.next();
            this.processDatabaseObjectDefinition(tableDefinition, create, shouldLogExceptionStackTrace);
        }
    }

    private void processSequenceDefinitions(HashSet sequenceDefinitions, boolean create) throws EclipseLinkException {
        boolean shouldLogExceptionStackTrace = this.session.getSessionLog().shouldLogExceptionStackTrace();
        for (SequenceDefinition sequenceDefinition : sequenceDefinitions) {
            this.processDatabaseObjectDefinition(sequenceDefinition, create, shouldLogExceptionStackTrace);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processDatabaseObjectDefinition(DatabaseObjectDefinition definition, boolean create, boolean shouldLogExceptionStackTrace) throws EclipseLinkException {
        block15: {
            if (shouldLogExceptionStackTrace) {
                this.session.getSessionLog().setShouldLogExceptionStackTrace(false);
            }
            if (create) {
                try {
                    try {
                        this.createObject(definition);
                        return;
                    }
                    catch (DatabaseException databaseException) {
                        if (!shouldLogExceptionStackTrace) return;
                        this.session.getSessionLog().setShouldLogExceptionStackTrace(true);
                    }
                    return;
                }
                finally {
                    if (shouldLogExceptionStackTrace) {
                        this.session.getSessionLog().setShouldLogExceptionStackTrace(true);
                    }
                }
            }
            try {
                try {
                    this.dropObject(definition);
                }
                catch (DatabaseException databaseException) {
                    if (shouldLogExceptionStackTrace) {
                        this.session.getSessionLog().setShouldLogExceptionStackTrace(true);
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (!shouldLogExceptionStackTrace) throw throwable;
                this.session.getSessionLog().setShouldLogExceptionStackTrace(true);
                throw throwable;
            }
            if (shouldLogExceptionStackTrace) {
                this.session.getSessionLog().setShouldLogExceptionStackTrace(true);
            }
        }
        this.createObject(definition);
    }

    protected SequenceDefinition buildSequenceDefinition(Sequence sequence) {
        if (sequence.shouldAcquireValueAfterInsert()) {
            return null;
        }
        if (sequence instanceof TableSequence || sequence instanceof DefaultSequence && ((DefaultSequence)sequence).getDefaultSequence() instanceof TableSequence) {
            return new TableSequenceDefinition(sequence);
        }
        if (sequence instanceof UnaryTableSequence || sequence instanceof DefaultSequence && ((DefaultSequence)sequence).getDefaultSequence() instanceof UnaryTableSequence) {
            return new UnaryTableSequenceDefinition(sequence);
        }
        if (sequence instanceof NativeSequence || sequence instanceof DefaultSequence && ((DefaultSequence)sequence).getDefaultSequence() instanceof NativeSequence) {
            return new SequenceObjectDefinition(sequence);
        }
        return null;
    }

    public void dropConstraints(TableDefinition tableDefinition) throws EclipseLinkException {
        boolean usesBatchWriting = false;
        if (this.getSession().getPlatform().usesBatchWriting()) {
            usesBatchWriting = true;
            this.getSession().getPlatform().setUsesBatchWriting(false);
        }
        try {
            if (this.shouldWriteToDatabase()) {
                tableDefinition.dropConstraintsOnDatabase(this.getSession());
            } else {
                tableDefinition.setCreateSQLFiles(this.createSQLFiles);
                tableDefinition.dropConstraints(this.getSession(), this.getDropSchemaWriter());
            }
        }
        finally {
            if (usesBatchWriting) {
                this.getSession().getPlatform().setUsesBatchWriting(true);
            }
        }
    }

    public void dropObject(DatabaseObjectDefinition databaseObjectDefinition) throws EclipseLinkException {
        boolean usesBatchWriting = false;
        if (this.getSession().getPlatform().usesBatchWriting()) {
            usesBatchWriting = true;
            this.getSession().getPlatform().setUsesBatchWriting(false);
        }
        try {
            databaseObjectDefinition.preDropObject(this.getSession(), this.getDropSchemaWriter(), this.createSQLFiles);
            if (this.shouldWriteToDatabase()) {
                databaseObjectDefinition.dropFromDatabase(this.getSession());
            } else {
                Writer dropSchemaWriter = this.getDropSchemaWriter();
                databaseObjectDefinition.dropObject(this.getSession(), dropSchemaWriter, this.createSQLFiles);
                if (this.createSQLFiles) {
                    this.appendToDDLWriter(dropSchemaWriter, this.getSession().getPlatform().getStoredProcedureTerminationToken());
                }
                this.appendToDDLWriter(dropSchemaWriter, "\n");
            }
        }
        finally {
            if (usesBatchWriting) {
                this.getSession().getPlatform().setUsesBatchWriting(true);
            }
        }
    }

    public void dropTable(String tableName) throws EclipseLinkException {
        TableDefinition tableDefinition = new TableDefinition();
        tableDefinition.setName(tableName);
        this.dropObject(tableDefinition);
    }

    public void finalize() {
        try {
            this.closeDDLWriter();
        }
        catch (ValidationException validationException) {}
    }

    public void generateStoredProcedures() throws EclipseLinkException {
        new StoredProcedureGenerator(this).generateStoredProcedures();
    }

    public void generateStoredProcedures(Writer writer) throws EclipseLinkException {
        new StoredProcedureGenerator(this).generateStoredProcedures(writer);
    }

    public void generateStoredProceduresAndAmendmentClass(Writer writer, String fullyQualifiedClassName) throws EclipseLinkException {
        String className = fullyQualifiedClassName.substring(fullyQualifiedClassName.lastIndexOf(46) + 1);
        String packageName = fullyQualifiedClassName.substring(0, fullyQualifiedClassName.lastIndexOf(46));
        StoredProcedureGenerator storedProcedureGenerator = new StoredProcedureGenerator(this);
        storedProcedureGenerator.generateStoredProcedures();
        storedProcedureGenerator.generateAmendmentClass(writer, packageName, className);
    }

    public void generateStoredProceduresAndAmendmentClass(String path, String fullyQualifiedClassName) throws EclipseLinkException {
        FileWriter fileWriter = null;
        try {
            try {
                StoredProcedureGenerator storedProcedureGenerator = new StoredProcedureGenerator(this);
                if (!path.endsWith("\\") && !path.endsWith("/")) {
                    path = String.valueOf(path) + "\\";
                }
                String className = fullyQualifiedClassName.substring(fullyQualifiedClassName.lastIndexOf(46) + 1);
                String packageName = fullyQualifiedClassName.substring(0, fullyQualifiedClassName.lastIndexOf(46));
                String fileName = String.valueOf(path) + className + ".java";
                fileWriter = new FileWriter(fileName);
                storedProcedureGenerator.generateStoredProcedures();
                storedProcedureGenerator.generateAmendmentClass(fileWriter, packageName, className);
                fileWriter.close();
            }
            catch (IOException ioException) {
                throw ValidationException.fileError(ioException);
            }
        }
        catch (Throwable throwable) {
            Helper.close(fileWriter);
            throw throwable;
        }
        Helper.close(fileWriter);
    }

    protected DatabaseAccessor getAccessor() {
        return (DatabaseAccessor)this.getSession().getAccessor();
    }

    public Vector getAllColumnNames(String tableName) throws DatabaseException {
        return this.getAccessor().getColumnInfo(null, null, tableName, null, this.getSession());
    }

    public Vector getAllColumnNames(String creatorName, String tableName) throws DatabaseException {
        return this.getAccessor().getColumnInfo(null, creatorName, tableName, null, this.getSession());
    }

    public Vector getAllTableNames() throws DatabaseException {
        return this.getAccessor().getTableInfo(null, null, null, null, this.getSession());
    }

    public Vector getAllTableNames(String creatorName) throws DatabaseException {
        return this.getAccessor().getTableInfo(null, creatorName, null, null, this.getSession());
    }

    public Vector getColumnInfo(String catalog, String schema, String tableName, String columnName) throws DatabaseException {
        return this.getAccessor().getColumnInfo(catalog, schema, tableName, columnName, this.getSession());
    }

    public AbstractSession getSession() {
        return this.session;
    }

    public Vector getTableInfo(String catalog, String schema, String tableName, String[] types) throws DatabaseException {
        return this.getAccessor().getTableInfo(catalog, schema, tableName, types, this.getSession());
    }

    public void outputDDLToDatabase() {
        this.createSchemaWriter = null;
        this.dropSchemaWriter = null;
    }

    public void outputDDLToFile(String fileName) {
        try {
            this.createSchemaWriter = new FileWriter(fileName);
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
    }

    public void outputCreateDDLToFile(String fileName) {
        try {
            this.createSchemaWriter = new FileWriter(fileName);
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
    }

    public void outputDropDDLToFile(String fileName) {
        try {
            this.dropSchemaWriter = new FileWriter(fileName);
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
    }

    public void outputDDLToWriter(Writer schemaWriter) {
        this.createSchemaWriter = schemaWriter;
    }

    public void outputCreateDDLToWriter(Writer createWriter) {
        this.createSchemaWriter = createWriter;
    }

    public void outputDropDDLToWriter(Writer dropWriter) {
        this.dropSchemaWriter = dropWriter;
    }

    public void replaceObject(DatabaseObjectDefinition databaseDefinition) throws EclipseLinkException {
        boolean fast = FAST_TABLE_CREATOR;
        if (fast && databaseDefinition instanceof TableDefinition) {
            this.session.executeNonSelectingSQL("DELETE FROM " + databaseDefinition.getName());
        } else if (!fast || !(databaseDefinition instanceof StoredProcedureDefinition)) {
            block12: {
                boolean shouldLogExceptionStackTrace = this.getSession().getSessionLog().shouldLogExceptionStackTrace();
                if (shouldLogExceptionStackTrace) {
                    this.getSession().getSessionLog().setShouldLogExceptionStackTrace(false);
                }
                try {
                    try {
                        this.dropObject(databaseDefinition);
                    }
                    catch (DatabaseException databaseException) {
                        if (shouldLogExceptionStackTrace) {
                            this.getSession().getSessionLog().setShouldLogExceptionStackTrace(true);
                        }
                        break block12;
                    }
                }
                catch (Throwable throwable) {
                    if (shouldLogExceptionStackTrace) {
                        this.getSession().getSessionLog().setShouldLogExceptionStackTrace(true);
                    }
                    throw throwable;
                }
                if (shouldLogExceptionStackTrace) {
                    this.getSession().getSessionLog().setShouldLogExceptionStackTrace(true);
                }
            }
            this.createObject(databaseDefinition);
        }
    }

    protected TableCreator getDefaultTableCreator(boolean generateFKConstraints) {
        if (this.defaultTableCreator == null) {
            this.defaultTableCreator = new DefaultTableGenerator(this.session.getProject(), generateFKConstraints).generateDefaultTableCreator();
            this.defaultTableCreator.setIgnoreDatabaseException(true);
        }
        return this.defaultTableCreator;
    }

    public void createDefaultTables(boolean generateFKConstraints) {
        block6: {
            boolean shouldLogExceptionStackTrace = this.getSession().getSessionLog().shouldLogExceptionStackTrace();
            this.getSession().getSessionLog().setShouldLogExceptionStackTrace(false);
            try {
                try {
                    TableCreator tableCreator = this.getDefaultTableCreator(generateFKConstraints);
                    tableCreator.createTables(this.session, this);
                }
                catch (DatabaseException databaseException) {
                    this.getSession().getSessionLog().setShouldLogExceptionStackTrace(shouldLogExceptionStackTrace);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.getSession().getSessionLog().setShouldLogExceptionStackTrace(shouldLogExceptionStackTrace);
                throw throwable;
            }
            this.getSession().getSessionLog().setShouldLogExceptionStackTrace(shouldLogExceptionStackTrace);
        }
        if (this.session.getDatabaseEventListener() != null) {
            this.session.getDatabaseEventListener().remove(this.session);
            this.session.getDatabaseEventListener().register(this.session);
        }
    }

    public void replaceDefaultTables() throws EclipseLinkException {
        this.replaceDefaultTables(true, true, true);
    }

    public void replaceDefaultTables(boolean dontReplaceSequenceTable, boolean generateFKConstraints) throws EclipseLinkException {
        this.replaceDefaultTables(dontReplaceSequenceTable, false, generateFKConstraints);
    }

    public void replaceDefaultTables(boolean dontReplaceSequenceTable, boolean dontReplaceSequences, boolean generateFKConstraints) throws EclipseLinkException {
        block6: {
            boolean shouldLogExceptionStackTrace = this.getSession().getSessionLog().shouldLogExceptionStackTrace();
            this.session.getSessionLog().setShouldLogExceptionStackTrace(false);
            try {
                try {
                    TableCreator tableCreator = this.getDefaultTableCreator(generateFKConstraints);
                    tableCreator.replaceTables(this.session, this, dontReplaceSequenceTable, dontReplaceSequences);
                }
                catch (DatabaseException databaseException) {
                    this.session.getSessionLog().setShouldLogExceptionStackTrace(shouldLogExceptionStackTrace);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.session.getSessionLog().setShouldLogExceptionStackTrace(shouldLogExceptionStackTrace);
                throw throwable;
            }
            this.session.getSessionLog().setShouldLogExceptionStackTrace(shouldLogExceptionStackTrace);
        }
        if (this.session.getDatabaseEventListener() != null) {
            this.session.getDatabaseEventListener().remove(this.session);
            this.session.getDatabaseEventListener().register(this.session);
        }
    }

    public void setSession(DatabaseSessionImpl session) {
        this.session = session;
    }

    public boolean shouldWriteToDatabase() {
        return this.createSchemaWriter == null && this.dropSchemaWriter == null;
    }

    public void alterSequence(SequenceDefinition sequenceDefinition) throws EclipseLinkException {
        if (!sequenceDefinition.isAlterSupported(this.getSession())) {
            return;
        }
        boolean usesBatchWriting = false;
        if (this.getSession().getPlatform().usesBatchWriting()) {
            usesBatchWriting = true;
            this.getSession().getPlatform().setUsesBatchWriting(false);
        }
        try {
            if (this.shouldWriteToDatabase()) {
                sequenceDefinition.alterOnDatabase(this.getSession());
            } else {
                sequenceDefinition.alter(this.getSession(), this.createSchemaWriter);
            }
        }
        finally {
            if (usesBatchWriting) {
                this.getSession().getPlatform().setUsesBatchWriting(true);
            }
        }
    }
}

