/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo;

import commonj.sdo.DataObject;
import commonj.sdo.Property;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.sdo.SDODataObject;
import org.eclipse.persistence.sdo.SDOProperty;
import org.eclipse.persistence.sdo.ValueStore;

public class DefaultValueStore
implements ValueStore {
    private Map openContentValues;
    private Object[] typePropertyValues;
    private boolean[] typePropertiesIsSetStatus;
    private DataObject dataObject;

    public Object getDeclaredProperty(int propertyIndex) {
        if (this.typePropertyValues != null) {
            return this.typePropertyValues[propertyIndex];
        }
        return null;
    }

    public Object getOpenContentProperty(Property property) {
        return this.getOpenContentValues().get(property);
    }

    public void setDeclaredProperty(int propertyIndex, Object value) {
        this.getTypePropertyValues()[propertyIndex] = value;
        this.getTypePropertiesIsSetStatus()[propertyIndex] = true;
    }

    public void setOpenContentProperty(Property property, Object value) {
        this.getOpenContentValues().put(property, value);
    }

    public boolean isSetDeclaredProperty(int propertyIndex) {
        return this.getTypePropertiesIsSetStatus()[propertyIndex];
    }

    public boolean isSetOpenContentProperty(Property property) {
        return this.getOpenContentValues().containsKey(property);
    }

    public void unsetDeclaredProperty(int propertyIndex) {
        SDOProperty prop = ((SDODataObject)this.dataObject).getInstanceProperty(propertyIndex);
        if (!prop.isMany()) {
            this.getTypePropertyValues()[propertyIndex] = null;
        }
        this.getTypePropertiesIsSetStatus()[propertyIndex] = false;
    }

    public void unsetOpenContentProperty(Property property) {
        this.getOpenContentValues().remove(property);
    }

    public void initialize(DataObject aDataObject) {
        this.dataObject = aDataObject;
        this.setTypePropertiesIsSetStatus(new boolean[aDataObject.getType().getProperties().size()]);
        this.setTypePropertyValues(new Object[aDataObject.getType().getProperties().size()]);
    }

    public void setTypePropertyValues(Object[] typePropertyValuesArray) {
        this.typePropertyValues = typePropertyValuesArray;
    }

    public void setTypePropertiesIsSetStatus(boolean[] typePropertiesIsSetStatusArray) {
        this.typePropertiesIsSetStatus = typePropertiesIsSetStatusArray;
    }

    public Object[] getTypePropertyValues() {
        return this.typePropertyValues;
    }

    public boolean[] getTypePropertiesIsSetStatus() {
        return this.typePropertiesIsSetStatus;
    }

    public void setOpenContentValues(Map openContentValues) {
        this.openContentValues = openContentValues;
    }

    public Map getOpenContentValues() {
        if (this.openContentValues == null) {
            this.openContentValues = new HashMap();
        }
        return this.openContentValues;
    }

    public void setManyProperty(Property property, Object value) {
    }

    public ValueStore copy() {
        DefaultValueStore anOriginalValueStore = new DefaultValueStore();
        anOriginalValueStore.dataObject = this.dataObject;
        boolean[] currentIsSet = this.getTypePropertiesIsSetStatus();
        boolean[] isSetCopy = new boolean[currentIsSet.length];
        System.arraycopy(currentIsSet, 0, isSetCopy, 0, currentIsSet.length);
        Object[] currentValues = this.getTypePropertyValues();
        Object[] valueCopy = new Object[currentValues.length];
        System.arraycopy(currentValues, 0, valueCopy, 0, currentValues.length);
        anOriginalValueStore.setTypePropertiesIsSetStatus(isSetCopy);
        anOriginalValueStore.setTypePropertyValues(valueCopy);
        HashMap clonedMap = new HashMap();
        clonedMap.putAll(this.getOpenContentValues());
        anOriginalValueStore.setOpenContentValues(clonedMap);
        return anOriginalValueStore;
    }

    public boolean equals(Object obj) {
        DefaultValueStore dvs;
        try {
            dvs = (DefaultValueStore)obj;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        if (dvs.dataObject != this.dataObject) {
            return false;
        }
        if (dvs.getTypePropertyValues().length != this.getTypePropertyValues().length || dvs.getTypePropertiesIsSetStatus().length != this.getTypePropertiesIsSetStatus().length) {
            return false;
        }
        int i = 0;
        while (i < dvs.getTypePropertyValues().length) {
            if (dvs.isSetDeclaredProperty(i) != this.isSetDeclaredProperty(i)) {
                return false;
            }
            Object dvsPropVal = dvs.getDeclaredProperty(i);
            Object thisPropVal = this.getDeclaredProperty(i);
            if (dvsPropVal == null ? thisPropVal != null : !dvsPropVal.equals(thisPropVal)) {
                return false;
            }
            ++i;
        }
        if (dvs.getOpenContentValues().size() != this.getOpenContentValues().size()) {
            return false;
        }
        for (Property key : dvs.getOpenContentValues().keySet()) {
            Object dvsOCVal = dvs.getOpenContentProperty(key);
            Object thisOCVal = this.getOpenContentProperty(key);
            if (!(dvsOCVal == null ? thisOCVal != null : !dvsOCVal.equals(thisOCVal))) continue;
            return false;
        }
        return true;
    }
}

