/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.queries;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.annotations.CacheKeyType;
import org.eclipse.persistence.internal.identitymaps.CacheId;
import org.eclipse.persistence.internal.queries.CollectionContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ChangeRecord;
import org.eclipse.persistence.internal.sessions.CollectionChangeRecord;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;

public class ListContainerPolicy
extends CollectionContainerPolicy {
    public ListContainerPolicy() {
    }

    public ListContainerPolicy(Class containerClass) {
        super(containerClass);
    }

    public ListContainerPolicy(String containerClassName) {
        super(containerClassName);
    }

    public Object get(int index, Object container, AbstractSession session) {
        if (index < 0 || index >= this.sizeFor(container)) {
            return null;
        }
        Object object = ((List)container).get(index);
        if (this.hasElementDescriptor() && this.getElementDescriptor().hasWrapperPolicy()) {
            object = this.getElementDescriptor().getObjectBuilder().unwrapObject(object, session);
        }
        return object;
    }

    public boolean isValidContainer(Object container) {
        return container instanceof List;
    }

    public boolean hasOrder() {
        return true;
    }

    public boolean isListPolicy() {
        return true;
    }

    public int indexOf(Object element, Object container, AbstractSession session) {
        if (this.hasElementDescriptor() && this.getElementDescriptor().hasWrapperPolicy()) {
            int count = -1;
            Object iterator = this.iteratorFor(container);
            while (this.hasNext(iterator)) {
                ++count;
                Object next = this.next(iterator);
                if (!this.getElementDescriptor().getObjectBuilder().unwrapObject(next, session).equals(element)) continue;
                return count;
            }
            return -1;
        }
        return ((List)container).indexOf(element);
    }

    public void recordAddToCollectionInChangeRecord(ObjectChangeSet changeSetToAdd, CollectionChangeRecord collectionChangeRecord) {
        if (collectionChangeRecord.getRemoveObjectList().containsKey(changeSetToAdd)) {
            collectionChangeRecord.getRemoveObjectList().remove(changeSetToAdd);
        } else if (collectionChangeRecord.getAddObjectList().containsKey(changeSetToAdd)) {
            collectionChangeRecord.getAddOverFlow().add(changeSetToAdd);
        } else {
            collectionChangeRecord.getAddObjectList().put(changeSetToAdd, changeSetToAdd);
        }
    }

    public void recordRemoveFromCollectionInChangeRecord(ObjectChangeSet changeSetToRemove, CollectionChangeRecord collectionChangeRecord) {
        if (collectionChangeRecord.getAddObjectList().containsKey(changeSetToRemove)) {
            if (collectionChangeRecord.getAddOverFlow().contains(changeSetToRemove)) {
                collectionChangeRecord.getAddOverFlow().remove(changeSetToRemove);
            } else {
                collectionChangeRecord.getAddObjectList().remove(changeSetToRemove);
            }
        } else {
            collectionChangeRecord.getRemoveObjectList().put(changeSetToRemove, changeSetToRemove);
        }
    }

    public void updateChangeRecordForSelfMerge(ChangeRecord changeRecord, Object source, Object target, ForeignReferenceMapping mapping, UnitOfWorkChangeSet parentUOWChangeSet, UnitOfWorkImpl unitOfWork) {
        ObjectChangeSet sourceSet;
        Map<ObjectChangeSet, ObjectChangeSet> list = ((CollectionChangeRecord)changeRecord).getAddObjectList();
        if (list.containsKey(sourceSet = parentUOWChangeSet.getCloneToObjectChangeSet().get(source))) {
            ObjectChangeSet targetSet = ((UnitOfWorkChangeSet)unitOfWork.getUnitOfWorkChangeSet()).findOrCreateLocalObjectChangeSet(target, mapping.getReferenceDescriptor(), unitOfWork.isCloneNewObject(target));
            parentUOWChangeSet.addObjectChangeSetForIdentity(targetSet, parentUOWChangeSet);
            list.remove(sourceSet);
            list.put(targetSet, targetSet);
            return;
        }
        List<ObjectChangeSet> overFlow = ((CollectionChangeRecord)changeRecord).getAddOverFlow();
        int index = 0;
        for (ObjectChangeSet changeSet : overFlow) {
            if (changeSet == sourceSet) {
                overFlow.set(index, ((UnitOfWorkChangeSet)unitOfWork.getUnitOfWorkChangeSet()).findOrCreateLocalObjectChangeSet(target, mapping.getReferenceDescriptor(), unitOfWork.isCloneNewObject(target)));
                return;
            }
            ++index;
        }
    }

    public Object valueFromPKList(Object[] pks, ForeignReferenceMapping mapping, AbstractSession session) {
        Object result = this.containerInstance(pks.length);
        Map<Object, Object> fromCache = session.getIdentityMapAccessor().getAllFromIdentityMapWithEntityPK(pks, this.elementDescriptor);
        DatabaseRecord translationRow = new DatabaseRecord();
        ArrayList<Object> foreignKeyValues = new ArrayList<Object>(pks.length - fromCache.size());
        int index = 0;
        while (index < pks.length) {
            Object pk = pks[index];
            if (!fromCache.containsKey(pk)) {
                if (this.elementDescriptor.getCachePolicy().getCacheKeyType() == CacheKeyType.CACHE_ID) {
                    foreignKeyValues.add(Arrays.asList(((CacheId)pk).getPrimaryKey()));
                } else {
                    foreignKeyValues.add(pk);
                }
            }
            ++index;
        }
        if (!foreignKeyValues.isEmpty()) {
            translationRow.put("query-batch-parameter", (Object)foreignKeyValues);
            ReadAllQuery query = new ReadAllQuery();
            query.setReferenceClass(this.elementDescriptor.getJavaClass());
            query.setIsExecutionClone(true);
            query.setTranslationRow(translationRow);
            query.setSession(session);
            query.setSelectionCriteria(this.elementDescriptor.buildBatchCriteriaByPK(query.getExpressionBuilder(), query));
            Collection temp = (Collection)session.executeQuery(query);
            for (Object element : temp) {
                Object pk = this.elementDescriptor.getObjectBuilder().extractPrimaryKeyFromObject(element, session);
                fromCache.put(pk, element);
            }
        }
        Object[] objectArray = pks;
        int n = pks.length;
        int n2 = 0;
        while (n2 < n) {
            Object key = objectArray[n2];
            this.addInto(fromCache.get(key), result, session);
            ++n2;
        }
        return result;
    }
}

