/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm.record;

import org.eclipse.persistence.internal.oxm.ContainerValue;
import org.eclipse.persistence.internal.oxm.Reference;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.record.UnmarshalContext;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.record.UnmarshalRecord;
import org.eclipse.persistence.oxm.sequenced.SequencedObject;
import org.eclipse.persistence.oxm.sequenced.Setting;

public class SequencedUnmarshalContext
implements UnmarshalContext {
    private Setting currentSetting;

    public void startElement(UnmarshalRecord unmarshalRecord) {
        Setting parentSetting = this.currentSetting == null ? null : ("text()".equals(this.currentSetting.getName()) ? null : this.currentSetting);
        XPathFragment xPathFragment = unmarshalRecord.getXPathNode().getXPathFragment();
        this.currentSetting = xPathFragment != null ? new Setting(xPathFragment.getNamespaceURI(), xPathFragment.getLocalName()) : new Setting();
        int levelIndex = unmarshalRecord.getLevelIndex();
        if (levelIndex != 0) {
            if (1 == levelIndex) {
                ((SequencedObject)unmarshalRecord.getCurrentObject()).getSettings().add(this.currentSetting);
            } else {
                parentSetting.addChild(this.currentSetting);
            }
        }
    }

    public void characters(UnmarshalRecord unmarshalRecord) {
        if (this.currentSetting == null || this.currentSetting.getName() == null) {
            this.currentSetting = new Setting(null, "text()");
            ((SequencedObject)unmarshalRecord.getCurrentObject()).getSettings().add(this.currentSetting);
        } else if (!"text()".equals(this.currentSetting.getName())) {
            Setting parentSetting = this.currentSetting;
            this.currentSetting = new Setting(null, "text()");
            if (parentSetting != null) {
                parentSetting.addChild(this.currentSetting);
            }
        }
    }

    public void endElement(UnmarshalRecord unmarshalRecord) {
        if (this.currentSetting == null) {
            return;
        }
        this.currentSetting = "text()".equals(this.currentSetting.getName()) ? (this.currentSetting.getParent() == null ? null : this.currentSetting.getParent().getParent()) : this.currentSetting.getParent();
    }

    public void setAttributeValue(UnmarshalRecord unmarshalRecord, Object value, DatabaseMapping mapping) {
        this.currentSetting.setMapping(mapping);
        this.currentSetting.setObject(unmarshalRecord.getCurrentObject());
        this.currentSetting.setValue(value);
    }

    public void addAttributeValue(UnmarshalRecord unmarshalRecord, ContainerValue containerValue, Object value) {
        this.addAttributeValue(unmarshalRecord, containerValue, value, unmarshalRecord.getContainerInstance(containerValue));
    }

    public void addAttributeValue(UnmarshalRecord unmarshalRecord, ContainerValue containerValue, Object value, Object collection) {
        this.currentSetting.setMapping(containerValue.getMapping());
        this.currentSetting.setObject(unmarshalRecord.getCurrentObject());
        this.currentSetting.addValue(value, true, collection);
    }

    public void reference(Reference reference) {
        this.currentSetting.setObject(reference.getSourceObject());
        this.currentSetting.setMapping((DatabaseMapping)((Object)reference.getMapping()));
        reference.setSetting(this.currentSetting);
    }

    public void unmappedContent(UnmarshalRecord unmarshalRecord) {
        Setting parentSetting = this.currentSetting.getParent();
        if (parentSetting == null) {
            ((SequencedObject)unmarshalRecord.getCurrentObject()).getSettings().remove(this.currentSetting);
        }
        this.currentSetting = parentSetting;
    }
}

