/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.deployment.osgi;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeClassLoader
extends ClassLoader {
    private List<ClassLoader> classLoaders = new ArrayList<ClassLoader>();

    public CompositeClassLoader(ClassLoader loader1, ClassLoader loader2) {
        this.classLoaders.add(loader1);
        this.classLoaders.add(loader2);
    }

    public CompositeClassLoader(List<ClassLoader> loaders) {
        this.classLoaders.addAll(loaders);
    }

    public List<ClassLoader> getClassLoaders() {
        return this.classLoaders;
    }

    @Override
    public synchronized void clearAssertionStatus() {
        for (ClassLoader classLoader : this.getClassLoaders()) {
            classLoader.clearAssertionStatus();
        }
    }

    @Override
    public URL getResource(String name) {
        for (ClassLoader classLoader : this.getClassLoaders()) {
            URL resource = classLoader.getResource(name);
            if (resource == null) continue;
            return resource;
        }
        return null;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        for (ClassLoader classLoader : this.getClassLoaders()) {
            InputStream stream = classLoader.getResourceAsStream(name);
            if (stream == null) continue;
            return stream;
        }
        return null;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Vector<URL> resourceList = new Vector<URL>();
        int i = 0;
        while (i < this.getClassLoaders().size()) {
            Enumeration<URL> localResources = this.getClassLoaders().get(i).getResources(name);
            while (localResources.hasMoreElements()) {
                URL resource = localResources.nextElement();
                if (resourceList.contains(resource)) continue;
                resourceList.add(resource);
            }
            ++i;
        }
        return resourceList.elements();
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        for (ClassLoader classLoader : this.getClassLoaders()) {
            try {
                Class<?> aClass = classLoader.loadClass(name);
                return aClass;
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    public synchronized void setClassAssertionStatus(String className, boolean enabled) {
        for (ClassLoader classLoader : this.getClassLoaders()) {
            classLoader.setClassAssertionStatus(className, enabled);
        }
    }

    @Override
    public synchronized void setDefaultAssertionStatus(boolean enabled) {
        for (ClassLoader classLoader : this.getClassLoaders()) {
            classLoader.setDefaultAssertionStatus(enabled);
        }
    }

    @Override
    public synchronized void setPackageAssertionStatus(String packageName, boolean enabled) {
        for (ClassLoader classLoader : this.getClassLoaders()) {
            classLoader.setPackageAssertionStatus(packageName, enabled);
        }
    }
}

