/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.jmq.jmsclient.ConnectionConsumerImpl;
import com.sun.messaging.jmq.jmsclient.XAResourceImpl;
import com.sun.messaging.jmq.util.XidImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.transaction.xa.XAException;

public class XAResourceMap {
    private static HashMap<XidImpl, Set<XAResourceImpl>> resourceMap = new HashMap();
    private static ArrayList<ConnectionConsumerImpl> unregisterListenerCC = new ArrayList();

    public static synchronized void register(XidImpl xidImpl, XAResourceImpl xAResourceImpl, boolean bl) throws XAException {
        Set<XAResourceImpl> set = resourceMap.get(xidImpl);
        if (set == null) {
            if (bl) {
                XAException xAException = new XAException("Trying to add an XAResource using the JOIN flag when no existing XAResource has been added with this XID");
                xAException.errorCode = -5;
                throw xAException;
            }
            set = new HashSet<XAResourceImpl>();
            resourceMap.put(xidImpl, set);
        } else if (!bl) {
            XAException xAException = new XAException("Trying to add an XAResource to an existing xid without using the JOIN flag");
            xAException.errorCode = -8;
            throw xAException;
        }
        set.add(xAResourceImpl);
    }

    public static synchronized void unregister(XidImpl xidImpl) {
        resourceMap.remove(xidImpl);
        if (unregisterListenerCC.size() > 0) {
            Iterator<ConnectionConsumerImpl> iterator = unregisterListenerCC.iterator();
            ConnectionConsumerImpl connectionConsumerImpl = null;
            while (iterator.hasNext()) {
                connectionConsumerImpl = iterator.next();
                connectionConsumerImpl.unregisteredXAResource();
            }
        }
    }

    public static synchronized void unregisterResource(XAResourceImpl xAResourceImpl, XidImpl xidImpl) {
        Object object;
        if (unregisterListenerCC.size() > 0 && (object = xAResourceImpl.getConnectionConsumer()) != null && unregisterListenerCC.contains(object)) {
            ((ConnectionConsumerImpl)object).unregisteredXAResource();
        }
        if ((object = resourceMap.get(xidImpl)) != null) {
            object.remove(xAResourceImpl);
            if (object.size() == 0) {
                resourceMap.remove(xidImpl);
            }
        }
    }

    public static synchronized XAResourceImpl[] getXAResources(XidImpl xidImpl, boolean bl) throws XAException {
        Set<XAResourceImpl> set = resourceMap.get(xidImpl);
        if (set == null) {
            if (bl) {
                XAException xAException = new XAException("Unknown XID (was start() called?");
                throw xAException;
            }
            return new XAResourceImpl[0];
        }
        return set.toArray(new XAResourceImpl[set.size()]);
    }

    public static boolean isEmpty() {
        return resourceMap.isEmpty();
    }

    public static int hasXAResourceForCC(ConnectionConsumerImpl connectionConsumerImpl) {
        return XAResourceMap.hasXAResourceForCC(connectionConsumerImpl, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static int hasXAResourceForCC(ConnectionConsumerImpl connectionConsumerImpl, boolean bl) {
        XidImpl[] xidImplArray = null;
        Object object = XAResourceMap.class;
        // MONITORENTER : com.sun.messaging.jmq.jmsclient.XAResourceMap.class
        xidImplArray = resourceMap.keySet().toArray(new XidImpl[0]);
        // MONITOREXIT : object
        object = new ArrayList();
        Set<XAResourceImpl> set = null;
        for (int i = 0; i < xidImplArray.length; ++i) {
            Class<XAResourceMap> clazz = XAResourceMap.class;
            // MONITORENTER : com.sun.messaging.jmq.jmsclient.XAResourceMap.class
            set = resourceMap.get(xidImplArray[i]);
            if (set == null) {
                // MONITOREXIT : clazz
                continue;
            }
            ((ArrayList)object).addAll(set);
            // MONITOREXIT : clazz
        }
        XAResourceImpl[] xAResourceImplArray = ((ArrayList)object).toArray(new XAResourceImpl[0]);
        int n = 0;
        XAResourceImpl xAResourceImpl = null;
        ConnectionConsumerImpl connectionConsumerImpl2 = null;
        for (int i = 0; i < xAResourceImplArray.length; ++i) {
            xAResourceImpl = xAResourceImplArray[i];
            connectionConsumerImpl2 = xAResourceImpl.getConnectionConsumer();
            if (connectionConsumerImpl2 == null || connectionConsumerImpl2 != connectionConsumerImpl) continue;
            ++n;
        }
        if (!bl) {
            return n;
        }
        if (n > 0) {
            XAResourceMap.addUnregisterListenerCC(connectionConsumerImpl);
            return n;
        }
        XAResourceMap.removeUnregisterListenerCC(connectionConsumerImpl);
        return n;
    }

    public static synchronized void addUnregisterListenerCC(ConnectionConsumerImpl connectionConsumerImpl) {
        unregisterListenerCC.add(connectionConsumerImpl);
    }

    public static synchronized void removeUnregisterListenerCC(ConnectionConsumerImpl connectionConsumerImpl) {
        unregisterListenerCC.remove(connectionConsumerImpl);
    }
}

