/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.test.framework.spi.container.grizzly.web;

import com.sun.grizzly.http.embed.GrizzlyWebServer;
import com.sun.grizzly.http.servlet.ServletAdapter;
import com.sun.grizzly.tcp.http11.GrizzlyAdapter;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.test.framework.AppDescriptor;
import com.sun.jersey.test.framework.WebAppDescriptor;
import com.sun.jersey.test.framework.spi.container.TestContainer;
import com.sun.jersey.test.framework.spi.container.TestContainerException;
import com.sun.jersey.test.framework.spi.container.TestContainerFactory;
import java.io.IOException;
import java.net.URI;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.ws.rs.core.UriBuilder;

public class GrizzlyWebTestContainerFactory
implements TestContainerFactory {
    public Class<WebAppDescriptor> supports() {
        return WebAppDescriptor.class;
    }

    public TestContainer create(URI baseUri, AppDescriptor ad) {
        if (!(ad instanceof WebAppDescriptor)) {
            throw new IllegalArgumentException("The application descriptor must be an instance of WebAppDescriptor");
        }
        return new GrizzlyWebTestContainer(baseUri, (WebAppDescriptor)ad);
    }

    private static class GrizzlyWebTestContainer
    implements TestContainer {
        private static final Logger LOGGER = Logger.getLogger(GrizzlyWebTestContainer.class.getName());
        final URI baseUri;
        final String contextPath;
        final String servletPath;
        final Class servletClass;
        List<WebAppDescriptor.FilterDescriptor> filters = null;
        final List<Class<? extends EventListener>> eventListeners;
        final Map<String, String> initParams;
        final Map<String, String> contextParams;
        private GrizzlyWebServer webServer;

        private GrizzlyWebTestContainer(URI baseUri, WebAppDescriptor ad) {
            this.baseUri = UriBuilder.fromUri((URI)baseUri).path(ad.getContextPath()).path(ad.getServletPath()).build(new Object[0]);
            LOGGER.info("Creating Grizzly Web Container configured at the base URI " + this.baseUri);
            this.contextPath = ad.getContextPath();
            this.servletPath = ad.getServletPath();
            this.servletClass = ad.getServletClass();
            this.filters = ad.getFilters();
            this.initParams = ad.getInitParams();
            this.contextParams = ad.getContextParams();
            this.eventListeners = ad.getListeners();
            this.instantiateGrizzlyWebServer();
        }

        public Client getClient() {
            return null;
        }

        public URI getBaseUri() {
            return this.baseUri;
        }

        public void start() {
            LOGGER.info("Starting the Grizzly Web Container...");
            try {
                this.webServer.start();
            }
            catch (IOException ex) {
                throw new TestContainerException((Throwable)ex);
            }
        }

        public void stop() {
            LOGGER.info("Stopping the Grizzly Web Container...");
            this.webServer.stop();
            this.webServer.getSelectorThread().stopEndpoint();
        }

        private void instantiateGrizzlyWebServer() {
            this.webServer = new GrizzlyWebServer(this.baseUri.getPort());
            ServletAdapter sa = new ServletAdapter();
            if (this.servletClass != null) {
                Servlet servletInstance;
                try {
                    servletInstance = (Servlet)this.servletClass.newInstance();
                }
                catch (InstantiationException ex) {
                    throw new TestContainerException((Throwable)ex);
                }
                catch (IllegalAccessException ex) {
                    throw new TestContainerException((Throwable)ex);
                }
                sa.setServletInstance(servletInstance);
            }
            for (Class<? extends EventListener> eventListener : this.eventListeners) {
                sa.addServletListener(eventListener.getName());
            }
            if (this.filters != null) {
                try {
                    for (WebAppDescriptor.FilterDescriptor d : this.filters) {
                        sa.addFilter((Filter)d.getFilterClass().newInstance(), d.getFilterName(), d.getInitParams());
                    }
                }
                catch (InstantiationException ex) {
                    throw new TestContainerException((Throwable)ex);
                }
                catch (IllegalAccessException ex) {
                    throw new TestContainerException((Throwable)ex);
                }
            }
            for (String contextParamName : this.contextParams.keySet()) {
                sa.addContextParameter(contextParamName, this.contextParams.get(contextParamName));
            }
            for (String initParamName : this.initParams.keySet()) {
                sa.addInitParameter(initParamName, this.initParams.get(initParamName));
            }
            if (this.contextPath != null && this.contextPath.length() > 0) {
                if (!this.contextPath.startsWith("/")) {
                    sa.setContextPath("/" + this.contextPath);
                } else {
                    sa.setContextPath(this.contextPath);
                }
            }
            if (this.servletPath != null && this.servletPath.length() > 0) {
                if (!this.servletPath.startsWith("/")) {
                    sa.setServletPath("/" + this.servletPath);
                } else {
                    sa.setServletPath(this.servletPath);
                }
            }
            String[] mapping = null;
            this.webServer.addGrizzlyAdapter((GrizzlyAdapter)sa, mapping);
        }
    }
}

