/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Locale;
import org.sagacity.sqltoy.utils.NumberUtil;
import org.sagacity.sqltoy.utils.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtil {
    private static final Logger logger = LoggerFactory.getLogger(DateUtil.class);
    private static final String[] CHINA_DATE_KEYS = new String[]{"\u25cb", "\u041e", "0", "\u039f", "O", "\u96f6", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d", "\u5341", "\u5e74", "\u6708", "\u65e5", "\u65f6", "\u5206", "\u79d2"};
    private static final String[] CHINA_DATE_KEY_MAP = new String[]{"0", "0", "0", "0", "0", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "-", "-", " ", ":", ":", " "};
    private static final String[] MONTH_ENGLISH_NAME = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    private static final String[] WEEK_CHINA_NAME = new String[]{"\u661f\u671f\u4e00", "\u661f\u671f\u4e8c", "\u661f\u671f\u4e09", "\u661f\u671f\u56db", "\u661f\u671f\u4e94", "\u661f\u671f\u516d", "\u661f\u671f\u65e5"};
    private static final Collection<String> DEFAULT_PATTERNS = Arrays.asList("EEE MMM d HH:mm:ss yyyy", "EEE MMM dd HH:mm:ss Z yyyy", "EEE MMM dd Z yyyy", "EEE MMM dd yyyy", "EEEE, dd-MMM-yy HH:mm:ss zzz", "EEE, dd MMM yyyy HH:mm:ss zzz");

    private DateUtil() {
    }

    public static java.util.Date parse(Object data, String format) {
        return DateUtil.parse(data, format, null);
    }

    public static java.util.Date parse(Object data, String format, Locale locale) {
        if (null == data) {
            logger.error("The date string is null!");
            return null;
        }
        if (data instanceof String) {
            String dateString = data.toString().trim();
            if ("".equals(dateString) || "null".equals(dateString.toLowerCase())) {
                logger.error("The date string is null!");
                return null;
            }
            return DateUtil.parseString(dateString, format, locale);
        }
        if (format == null) {
            return DateUtil.convertDateObject(data, null, locale);
        }
        String result = DateUtil.formatDate(data, format, locale);
        return DateUtil.parseString(result, format, locale);
    }

    public static java.util.Date parseString(String dateStr) {
        return DateUtil.parseString(dateStr, null, null);
    }

    public static java.util.Date parseString(String dateVar, String dateFormat, Locale locale) {
        if (dateVar == null) {
            return null;
        }
        String dateStr = dateVar.trim();
        if ("".equals(dateStr)) {
            return null;
        }
        String realDF = null;
        if (StringUtil.isNotBlank(dateFormat)) {
            realDF = dateFormat;
        } else {
            boolean hasBlank;
            if (StringUtil.matches(dateStr, "[a-zA-Z]{2}")) {
                SimpleDateFormat dateParser = null;
                Iterator<String> formatIter = DEFAULT_PATTERNS.iterator();
                java.util.Date result = null;
                while (formatIter.hasNext()) {
                    String format = formatIter.next();
                    if (dateParser == null) {
                        dateParser = new SimpleDateFormat(format, locale == null ? Locale.US : locale);
                    } else {
                        dateParser.applyPattern(format);
                    }
                    try {
                        result = dateParser.parse(dateStr);
                        if (result == null) continue;
                        break;
                    }
                    catch (ParseException parseException) {
                    }
                }
                return result;
            }
            if (StringUtil.matches(dateStr, "[\u5e74\u6708\u65e5\u65f6\u5206\u79d2]")) {
                dateStr = DateUtil.parseChinaDate(dateStr);
            } else if (StringUtil.hasChinese(dateStr)) {
                return null;
            }
            boolean bl = hasBlank = dateStr.indexOf(" ") != -1 || dateStr.toUpperCase().indexOf("T") >= 6;
            if (hasBlank) {
                dateStr = dateStr.replaceFirst("\\s+", " ").replaceFirst("(?i)T", " ").replace("-", "").replace(".", "").replace(":", "").replace("/", "");
                int preSize = dateStr.indexOf(" ");
                size = dateStr.length();
                realDF = size > 16 ? "yyyyMMdd HHmmssSSS" : (size == 16 ? (preSize == 8 ? "yyyyMMdd HHmmssS" : "yyMMdd HHmmssSSS") : (size == 13 ? (preSize == 8 ? "yyyyMMdd HHmm" : "yyMMdd HHmmss") : (size == 11 ? (preSize == 8 ? "yyyyMMdd HH" : "yyMMdd HHmm") : (size == 9 ? "yyMMdd HH" : "yyyyMMdd HHmmss"))));
            } else {
                dateStr = dateStr.replace(",", "");
                size = dateStr.length();
                if (dateStr.indexOf(":") != -1) {
                    realDF = dateStr.indexOf(".") != -1 ? "HH:mm:ss.SSS" : (size == 5 ? "HH:mm" : "HH:mm:ss");
                } else {
                    int splitCount = StringUtil.matchCnt(dateStr = dateStr.replace("-", "/").replace(".", "/"), "\\/");
                    if (splitCount == 2) {
                        int startIndex = dateStr.indexOf("/");
                        realDF = startIndex == 2 ? "yy/MM/dd" : "yyyy/MM/dd";
                    } else if (splitCount == 1) {
                        realDF = size > 5 ? "yyyy/MM" : "yy/MM";
                    } else if (size >= 15) {
                        realDF = "yyyyMMddHHmmssSSS";
                    } else if (size == 14) {
                        realDF = "yyyyMMddHHmmss";
                    } else {
                        if (size == 13) {
                            return new java.util.Date(Long.valueOf(dateStr));
                        }
                        realDF = size == 12 ? "yyMMddHHmmss" : (size == 10 ? "yyyyMMddHH" : (size == 6 ? "yyyyMM" : (size == 4 ? "yyyy" : "yyyyMMdd")));
                    }
                }
            }
            if (realDF == null) {
                realDF = hasBlank ? "yyyy-MM-dd HH:mm:ss" : "yyyy-MM-dd";
            }
        }
        SimpleDateFormat df = locale == null ? new SimpleDateFormat(realDF) : new SimpleDateFormat(realDF, locale);
        try {
            return df.parse(dateStr);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static java.util.Date convertDateObject(Object dt) {
        return DateUtil.convertDateObject(dt, null, null);
    }

    public static java.util.Date convertDateObject(Object dt, String format, Locale locale) {
        if (dt == null) {
            logger.warn("\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u6b63\u786e\u8f93\u5165!");
            return null;
        }
        java.util.Date result = null;
        String dtStr = dt.toString().trim();
        result = dt instanceof String ? (dtStr.length() == 13 && NumberUtil.isInteger(dtStr) ? new java.util.Date(Long.valueOf(dtStr)) : DateUtil.parseString(dtStr, format, locale)) : (dt instanceof java.util.Date ? new java.util.Date(((java.util.Date)dt).getTime()) : (dt instanceof LocalDate ? DateUtil.asDate((LocalDate)dt) : (dt instanceof LocalDateTime ? DateUtil.asDate((LocalDateTime)dt) : (dt instanceof Number ? (dtStr.length() != 13 ? DateUtil.parseString(dtStr, format, locale) : new java.util.Date(((Number)dt).longValue())) : (dt instanceof LocalTime ? DateUtil.asDate((LocalTime)dt) : DateUtil.parseString(dtStr, format, locale))))));
        return result;
    }

    public static String formatDate(Object dt, String fmt) {
        return DateUtil.formatDate(dt, fmt, null);
    }

    public static String formatDate(Object dt, String fmt, Locale locale) {
        if (dt == null) {
            return null;
        }
        if (fmt == null) {
            throw new IllegalArgumentException("\u683c\u5f0f\u5316\u65e5\u671f\u6307\u5b9a\u7684format \u4e3anull,\u8bf7\u6b63\u786e\u8f93\u5165\u53c2\u6570!");
        }
        String fmtUpper = fmt.toUpperCase();
        if ("YY".equals(fmtUpper)) {
            String year = Integer.toString(DateUtil.getYear(dt));
            return year.substring(year.length() - 2);
        }
        if ("YYYY".equals(fmtUpper)) {
            return Integer.toString(DateUtil.getYear(dt));
        }
        if ("MM".equals(fmtUpper)) {
            int month = DateUtil.getMonth(dt);
            return (month < 10 ? "0" : "").concat(Integer.toString(month));
        }
        if ("DD".equals(fmtUpper)) {
            int day = DateUtil.getDay(dt);
            return (day < 10 ? "0" : "").concat(Integer.toString(day));
        }
        SimpleDateFormat df = locale == null ? new SimpleDateFormat(fmt) : new SimpleDateFormat(fmt, locale);
        java.util.Date tmp = DateUtil.convertDateObject(dt, null, locale);
        return null == tmp ? null : df.format(tmp);
    }

    public static String formatDate(Object dt, String fmt, String targetFmt, Locale locale) {
        java.util.Date result = DateUtil.parse(dt, fmt, locale);
        return DateUtil.formatDate(result, targetFmt);
    }

    public static Date getSqlDate(Object date) {
        return new Date(DateUtil.convertDateObject(date == null ? new java.util.Date() : date).getTime());
    }

    public static Timestamp getTimestamp(Object date) {
        return new Timestamp(date == null ? System.currentTimeMillis() : DateUtil.convertDateObject(date).getTime());
    }

    public static java.util.Date getNowTime() {
        return Calendar.getInstance().getTime();
    }

    public static LocalDate getDate() {
        return LocalDate.now();
    }

    public static LocalDate getDate(Object date) {
        if (date instanceof LocalDate) {
            return (LocalDate)date;
        }
        return DateUtil.asLocalDate(DateUtil.convertDateObject(date));
    }

    public static LocalDateTime getDateTime() {
        return LocalDateTime.now();
    }

    public static LocalDateTime getDateTime(Object date) {
        if (date instanceof LocalDateTime) {
            return (LocalDateTime)date;
        }
        return DateUtil.asLocalDateTime(DateUtil.convertDateObject(date));
    }

    public static LocalTime getTime() {
        return LocalTime.now();
    }

    public static java.util.Date addMilliSecond(Object dt, long millisecond) {
        java.util.Date result = DateUtil.convertDateObject(dt);
        if (millisecond != 0L) {
            result.setTime(result.getTime() + millisecond);
        }
        return result;
    }

    public static java.util.Date addSecond(Object dt, double second) {
        Double millisecond = 1000.0 * second;
        return DateUtil.addMilliSecond(dt, millisecond.longValue());
    }

    public static java.util.Date addDay(Object dt, long day) {
        return DateUtil.addMilliSecond(dt, 86400000L * day);
    }

    public static java.util.Date addDay(Object dt, double day) {
        Double millisecond = 8.64E7 * day;
        return DateUtil.addMilliSecond(dt, millisecond.longValue());
    }

    public static java.util.Date addMonth(Object dt, int month) {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(DateUtil.convertDateObject(dt));
        gc.add(2, month);
        return gc.getTime();
    }

    public static java.util.Date addYear(Object dt, int year) {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(DateUtil.convertDateObject(dt));
        gc.add(1, year);
        return gc.getTime();
    }

    public static int getYear(Object dateValue) {
        GregorianCalendar currentDate = new GregorianCalendar();
        if (dateValue != null) {
            currentDate.setTime(DateUtil.convertDateObject(dateValue));
        }
        return currentDate.get(1);
    }

    public static int getMonth(Object dateValue) {
        GregorianCalendar currentDate = new GregorianCalendar();
        if (dateValue != null) {
            currentDate.setTime(DateUtil.convertDateObject(dateValue));
        }
        return currentDate.get(2) + 1;
    }

    public static int getDay(Object dateValue) {
        GregorianCalendar currentDate = new GregorianCalendar();
        if (null != dateValue) {
            currentDate.setTime(DateUtil.convertDateObject(dateValue));
        }
        return currentDate.get(5);
    }

    public static int getIntervalDays(Object floorDate, Object goalDate) {
        BigDecimal result = new BigDecimal(Double.valueOf(DateUtil.getIntervalMillSeconds(DateUtil.formatDate(floorDate, "yyyy-MM-dd"), DateUtil.formatDate(goalDate, "yyyy-MM-dd"))) / 8.64E7);
        return result.setScale(1, RoundingMode.HALF_UP).intValue();
    }

    public static long getIntervalMillSeconds(Object floorDate, Object goalDate) {
        return DateUtil.convertDateObject(goalDate).getTime() - DateUtil.convertDateObject(floorDate).getTime();
    }

    public static String format2China(Object dateValue) {
        java.util.Date date = DateUtil.convertDateObject(dateValue);
        if (null == date) {
            return null;
        }
        GregorianCalendar pointDate = new GregorianCalendar();
        pointDate.setTime(DateUtil.convertDateObject(dateValue));
        StringBuilder result = new StringBuilder();
        if (dateValue instanceof String) {
            String tmpDate = (String)dateValue;
            if (tmpDate.length() >= 4) {
                result.append(pointDate.get(1) + "\u5e74");
            }
            if (tmpDate.length() >= 6) {
                result.append(pointDate.get(2) + 1 + "\u6708");
            }
            if (tmpDate.length() >= 8) {
                result.append(pointDate.get(5) + "\u65e5");
            }
            if (tmpDate.length() > 10) {
                result.append(pointDate.get(11) + "\u65f6");
                result.append(pointDate.get(12) + "\u5206");
                result.append(pointDate.get(13) + "\u79d2");
            }
        } else {
            result.append(pointDate.get(1) + "\u5e74");
            result.append(pointDate.get(2) + 1 + "\u6708");
            result.append(pointDate.get(5) + "\u65e5");
            result.append(pointDate.get(11) + "\u65f6");
            result.append(pointDate.get(12) + "\u5206");
            result.append(pointDate.get(13) + "\u79d2");
        }
        return result.toString();
    }

    public static String parseChinaDate(String chinaDate, String fmt) {
        if (StringUtil.isBlank(chinaDate)) {
            return null;
        }
        String tmp = chinaDate.replaceAll("\\s+", "");
        for (int i = 0; i < CHINA_DATE_KEYS.length; ++i) {
            tmp = tmp.replaceAll(CHINA_DATE_KEYS[i], CHINA_DATE_KEY_MAP[i]);
        }
        if ((tmp = tmp.replace("\u6574", "").trim()).endsWith("-") || tmp.endsWith(":")) {
            tmp = tmp.substring(0, tmp.length() - 1);
        }
        if (StringUtil.isBlank(fmt)) {
            return tmp.toString();
        }
        return DateUtil.formatDate(tmp, fmt);
    }

    public static String parseChinaDate(String chinaDate) {
        return DateUtil.parseChinaDate(chinaDate, null);
    }

    public static java.util.Date firstDayOfMonth(Object objectDate) {
        java.util.Date date = DateUtil.convertDateObject(objectDate);
        if (null == date) {
            return null;
        }
        String tmp = DateUtil.formatDate(date, "yyyy-MM-dd");
        return DateUtil.parse(tmp, "yyyy-MM");
    }

    public static java.util.Date lastDayOfMonth(Object objectDate) {
        java.util.Date date = DateUtil.convertDateObject(objectDate);
        if (null == date) {
            return null;
        }
        String tmp = DateUtil.formatDate(date, "yyyy-MM-dd");
        java.util.Date result = DateUtil.parse(tmp, "yyyy-MM");
        result = DateUtil.addMonth(result, 1);
        result = DateUtil.addDay((Object)result, -1L);
        return result;
    }

    public static java.util.Date asDate(LocalDate localDate) {
        if (localDate == null) {
            return null;
        }
        return java.util.Date.from(localDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
    }

    public static java.util.Date asSqlDate(LocalDate localDate) {
        if (localDate == null) {
            return null;
        }
        return java.util.Date.from(localDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
    }

    public static java.util.Date asDate(LocalTime localTime) {
        if (localTime == null) {
            return null;
        }
        return DateUtil.parseString(localTime.toString());
    }

    public static Time asTime(LocalTime localTime) {
        if (localTime == null) {
            return null;
        }
        return Time.valueOf(localTime);
    }

    public static java.util.Date asDate(LocalDateTime localDateTime) {
        if (localDateTime == null) {
            return null;
        }
        return java.util.Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static LocalDate asLocalDate(java.util.Date date) {
        if (date == null) {
            return null;
        }
        return Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public static LocalTime asLocalTime(java.util.Date date) {
        if (date == null) {
            return null;
        }
        return Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.systemDefault()).toLocalTime();
    }

    public static LocalDateTime asLocalDateTime(java.util.Date date) {
        if (date == null) {
            return null;
        }
        return Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    public static final class FORMAT {
        public static final String YEAR_MONTH = "yyyy-MM";
        public static final String DATE_6CHAR = "yyMMdd";
        public static final String DATE_8CHAR = "yyyyMMdd";
        public static final String DATE_DOT = "yyyy.MM.dd";
        public static final String DATE_SLASH = "yyyy/MM/dd";
        public static final String DATE_HORIZONTAL = "yyyy-MM-dd";
        public static final String DATETIME_DOT = "yyyy.MM.dd HH:mm:ss";
        public static final String DATETIME_SLASH = "yyyy/MM/dd HH:mm:ss";
        public static final String DATETIME_HORIZONTAL = "yyyy-MM-dd HH:mm:ss";
    }
}

