/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.plugins.interceptors;

import org.sagacity.sqltoy.SqlToyContext;
import org.sagacity.sqltoy.config.model.EntityMeta;
import org.sagacity.sqltoy.config.model.OperateType;
import org.sagacity.sqltoy.config.model.SqlToyConfig;
import org.sagacity.sqltoy.config.model.SqlToyResult;
import org.sagacity.sqltoy.plugins.SqlInterceptor;
import org.sagacity.sqltoy.utils.ReservedWordsUtil;
import org.sagacity.sqltoy.utils.SqlUtil;
import org.sagacity.sqltoy.utils.StringUtil;

public class TenantFilterInterceptor
implements SqlInterceptor {
    @Override
    public SqlToyResult decorate(SqlToyContext sqlToyContext, SqlToyConfig sqlToyConfig, OperateType operateType, SqlToyResult sqlToyResult, Class entityClass, Integer dbType) {
        String where;
        if (sqlToyContext.getUnifyFieldsHandler() == null || entityClass == null) {
            return sqlToyResult;
        }
        EntityMeta entityMeta = sqlToyContext.getEntityMeta(entityClass);
        String tenantColumn = null;
        if (entityMeta.getTenantField() != null) {
            tenantColumn = entityMeta.getColumnName(entityMeta.getTenantField());
        }
        if (tenantColumn == null) {
            return sqlToyResult;
        }
        String[] tenants = sqlToyContext.getUnifyFieldsHandler().authTenants(entityClass, operateType);
        if (tenants == null || tenants.length == 0) {
            return sqlToyResult;
        }
        String sql = sqlToyResult.getSql();
        tenantColumn = ReservedWordsUtil.convertWord(tenantColumn, dbType);
        int whereIndex = StringUtil.matchIndex(sql, "(?i)\\Wwhere\\W");
        if (whereIndex > 0 && StringUtil.matches(sql.substring(whereIndex), "(?i)\\W" + tenantColumn + "(\\s*\\=|\\s+in)")) {
            return sqlToyResult;
        }
        String sqlPart = where = " where ";
        sqlPart = tenants.length == 1 ? sqlPart.concat(tenantColumn).concat("='").concat(tenants[0]).concat("' and ") : sqlPart.concat(tenantColumn).concat("in (").concat(SqlUtil.combineQueryInStr(tenants, null, null, true).concat(") and "));
        if (operateType.equals((Object)OperateType.load) || operateType.equals((Object)OperateType.loadAll) || operateType.equals((Object)OperateType.update) || operateType.equals((Object)OperateType.updateAll) || operateType.equals((Object)OperateType.delete) || operateType.equals((Object)OperateType.deleteAll) || operateType.equals((Object)OperateType.unique) || operateType.equals((Object)OperateType.saveOrUpdate) || operateType.equals((Object)OperateType.singleTable)) {
            if (operateType.equals((Object)OperateType.saveOrUpdate) && sql.indexOf(" when matched then update set ") > 0) {
                int onTenantIndex = sql.indexOf(") tv on (");
                int end = onTenantIndex + ") tv on (".length();
                String aliasName = sql.substring(end, sql.indexOf(".", end)).trim();
                sqlPart = sqlPart.replaceFirst(where, "").replaceFirst(tenantColumn, aliasName + "." + tenantColumn);
                sql = sql.replaceFirst("\\)\\s+tv\\s+on\\s+\\(", ") tv on (".concat(sqlPart));
                sqlToyResult.setSql(sql);
            } else {
                sql = sql.replaceFirst("(?i)\\swhere\\s", sqlPart);
                sqlToyResult.setSql(sql);
            }
        }
        return sqlToyResult;
    }
}

