/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;

public class IOUtil {
    private IOUtil() {
    }

    public static InputStream strToInputStream(String str, String charset) throws Exception {
        if (charset != null) {
            return new ByteArrayInputStream(str.getBytes(charset));
        }
        return new ByteArrayInputStream(str.getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] objectToBytes(Object obj) {
        byte[] byArray;
        if (obj == null) {
            return null;
        }
        ByteArrayOutputStream out = null;
        ObjectOutputStream outputStream = null;
        try {
            out = new ByteArrayOutputStream();
            outputStream = new ObjectOutputStream(out);
            outputStream.writeObject(obj);
            outputStream.flush();
            byArray = out.toByteArray();
        }
        catch (Exception e) {
            byte[] byArray2;
            try {
                e.printStackTrace();
                byArray2 = null;
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(outputStream, out);
                throw throwable;
            }
            IOUtil.closeQuietly(outputStream, out);
            return byArray2;
        }
        IOUtil.closeQuietly(outputStream, out);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object bytesToObject(byte[] objBytes) {
        if (objBytes == null || objBytes.length == 0) {
            return null;
        }
        Object obj = null;
        ObjectInputStream in = null;
        try {
            in = new ObjectInputStream(new ByteArrayInputStream(objBytes));
            obj = in.readObject();
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(in);
                throw throwable;
            }
            IOUtil.closeQuietly(in);
        }
        IOUtil.closeQuietly(in);
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object streamToObject(InputStream is) {
        if (is == null) {
            return null;
        }
        Object obj = null;
        ObjectInputStream in = null;
        try {
            in = new ObjectInputStream(is);
            obj = in.readObject();
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(in);
                throw throwable;
            }
            IOUtil.closeQuietly(in);
        }
        IOUtil.closeQuietly(in);
        return obj;
    }

    public static byte[] getBytes(InputStream is) throws IOException {
        int len;
        if (is == null) {
            return null;
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((len = is.read(buffer)) != -1) {
            outputStream.write(buffer, 0, len);
        }
        return outputStream.toByteArray();
    }

    public static ByteBuffer getByteBuffer(Object obj) throws IOException {
        ByteBuffer byteBuffer;
        if (obj == null) {
            return null;
        }
        ByteArrayOutputStream bOut = null;
        ObjectOutputStream out = null;
        try {
            bOut = new ByteArrayOutputStream();
            out = new ObjectOutputStream(bOut);
            out.writeObject(obj);
            out.flush();
            byteBuffer = ByteBuffer.wrap(bOut.toByteArray());
        }
        catch (IOException ie) {
            try {
                throw ie;
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(out, bOut);
                throw throwable;
            }
        }
        IOUtil.closeQuietly(out, bOut);
        return byteBuffer;
    }

    public static void close(Closeable ... closeables) throws IOException {
        if (closeables != null) {
            for (Closeable closeable : closeables) {
                if (closeable == null) continue;
                closeable.close();
            }
        }
    }

    public static void closeQuietly(Closeable ... closeables) {
        try {
            IOUtil.close(closeables);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

