/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.utils;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.LocalTime;
import java.util.Date;
import java.util.List;
import org.sagacity.sqltoy.SqlToyConstants;
import org.sagacity.sqltoy.config.model.EntityMeta;
import org.sagacity.sqltoy.config.model.SqlToyConfig;
import org.sagacity.sqltoy.plugins.TypeHandler;
import org.sagacity.sqltoy.utils.DateUtil;
import org.sagacity.sqltoy.utils.SqlUtil;
import org.sagacity.sqltoy.utils.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlUtilsExt {
    private static final Logger logger = LoggerFactory.getLogger(SqlUtilsExt.class);

    private SqlUtilsExt() {
    }

    public static Long batchUpdateForPOJO(TypeHandler typeHandler, String updateSql, List<Object[]> rowDatas, Integer[] fieldsType, String[] fieldsDefaultValue, int batchSize, Boolean autoCommit, Connection conn, Integer dbType) throws Exception {
        if (rowDatas == null || rowDatas.isEmpty()) {
            logger.warn("batchUpdateForPOJO\u6279\u91cf\u63d2\u5165\u6216\u4fee\u6539\u6570\u636e\u64cd\u4f5c\u6570\u636e\u4e3a\u7a7a!");
            return 0L;
        }
        long updateCount = 0L;
        Statement pst = null;
        boolean hasDefaultValue = fieldsDefaultValue != null && fieldsType != null;
        try {
            boolean hasSetAutoCommit = false;
            if (autoCommit != null && autoCommit.booleanValue() != conn.getAutoCommit()) {
                conn.setAutoCommit(autoCommit);
                hasSetAutoCommit = true;
            }
            pst = conn.prepareStatement(updateSql);
            int totalRows = rowDatas.size();
            boolean useBatch = totalRows > 1;
            int meter = 0;
            boolean hasFieldType = fieldsType != null;
            boolean notSqlServer = dbType == null || dbType != 30;
            int index = 0;
            for (int i = 0; i < totalRows; ++i) {
                Object[] rowData = rowDatas.get(i);
                if (rowData == null) continue;
                index = 0;
                int n = rowData.length;
                for (int j = 0; j < n; ++j) {
                    int fieldType;
                    int n2 = fieldType = hasFieldType ? fieldsType[j] : -1;
                    if (!notSqlServer && fieldType == 93) continue;
                    Object cellValue = hasDefaultValue ? SqlUtilsExt.getDefaultValue(rowData[j], fieldsDefaultValue[j], fieldType) : rowData[j];
                    SqlUtil.setParamValue(typeHandler, conn, dbType, (PreparedStatement)pst, cellValue, fieldType, index + 1);
                    ++index;
                }
                ++meter;
                if (useBatch) {
                    int[] updateRows;
                    pst.addBatch();
                    if (meter % batchSize != 0 && i + 1 != totalRows) continue;
                    for (int t : updateRows = pst.executeBatch()) {
                        updateCount += (long)(t > 0 ? t : 0);
                    }
                    pst.clearBatch();
                    continue;
                }
                updateCount = pst.executeUpdate();
            }
            if (hasSetAutoCommit) {
                conn.setAutoCommit(autoCommit == false);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            try {
                if (pst != null) {
                    pst.close();
                    pst = null;
                }
            }
            catch (SQLException se) {
                logger.error(se.getMessage(), (Throwable)se);
            }
        }
        return updateCount;
    }

    public static Object[] getDefaultValues(EntityMeta entityMeta) {
        if (null == entityMeta || null == entityMeta.getFieldsDefaultValue()) {
            return null;
        }
        int size = entityMeta.getFieldsDefaultValue().length;
        Object[] result = new Object[size];
        for (int i = 0; i < size; ++i) {
            String defaultValue = entityMeta.getFieldsDefaultValue()[i];
            if (null == defaultValue) continue;
            int fieldType = entityMeta.getFieldsTypeArray()[i];
            result[i] = SqlUtilsExt.getDefaultValue(null, defaultValue, fieldType);
        }
        return result;
    }

    public static Object getDefaultValue(Object paramValue, String defaultValue, int jdbcType) {
        Comparable<Boolean> realValue = paramValue;
        if (realValue == null && defaultValue != null) {
            realValue = jdbcType == 12 ? defaultValue : (jdbcType == 4 || jdbcType == -6 || jdbcType == 5 ? Integer.valueOf(defaultValue) : (jdbcType == 91 ? (SqlUtilsExt.isCurrentTime(defaultValue) ? new Date() : DateUtil.convertDateObject(defaultValue)) : (jdbcType == 93 ? (SqlUtilsExt.isCurrentTime(defaultValue) ? DateUtil.getTimestamp(null) : DateUtil.getTimestamp(defaultValue)) : (jdbcType == 3 || jdbcType == 2 ? new BigDecimal(defaultValue) : (jdbcType == -5 ? new BigInteger(defaultValue) : (jdbcType == 92 ? (SqlUtilsExt.isCurrentTime(defaultValue) ? LocalTime.now() : DateUtil.asLocalTime(DateUtil.convertDateObject(defaultValue))) : (jdbcType == 8 ? Double.valueOf(defaultValue) : (jdbcType == 16 ? Boolean.valueOf(Boolean.parseBoolean(defaultValue)) : (jdbcType == 6 || jdbcType == 7 ? Float.valueOf(defaultValue) : (jdbcType == -7 ? ("true".equalsIgnoreCase(defaultValue) || "false".equalsIgnoreCase(defaultValue) ? (Comparable<Boolean>)Boolean.valueOf(Boolean.parseBoolean(defaultValue.toLowerCase())) : (Comparable<Boolean>)Integer.valueOf(Integer.parseInt(defaultValue))) : defaultValue))))))))));
        }
        return realValue;
    }

    private static boolean isCurrentTime(String defaultValue) {
        String defaultLow = defaultValue.toLowerCase();
        return defaultLow.contains("sysdate") || defaultLow.contains("now") || defaultLow.contains("current") || defaultLow.contains("sysdatetime") || defaultLow.contains("systime") || defaultLow.contains("timestamp");
    }

    public static String signSql(String sql, Integer dbType, SqlToyConfig sqlToyConfig) {
        if (!SqlToyConstants.openSqlSign() || dbType.equals(140)) {
            return sql;
        }
        if (sqlToyConfig != null && StringUtil.isNotBlank(sqlToyConfig.getId())) {
            return "/* id=".concat(sqlToyConfig.getId()).concat(" */ ").concat(sql);
        }
        return sql;
    }
}

