/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.utils;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.sagacity.sqltoy.SqlToyContext;
import org.sagacity.sqltoy.config.model.CacheFilterModel;
import org.sagacity.sqltoy.config.model.ParamFilterModel;
import org.sagacity.sqltoy.model.ParamsFilter;
import org.sagacity.sqltoy.utils.CollectionUtil;
import org.sagacity.sqltoy.utils.DateUtil;
import org.sagacity.sqltoy.utils.NumberUtil;
import org.sagacity.sqltoy.utils.SqlUtil;
import org.sagacity.sqltoy.utils.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParamFilterUtils {
    protected static final Logger logger = LoggerFactory.getLogger(ParamFilterUtils.class);
    private static final String DAY_FORMAT = "yyyy-MM-dd";

    private ParamFilterUtils() {
    }

    public static Object[] filterValue(SqlToyContext sqlToyContext, String[] paramArgs, Object[] values, List<ParamFilterModel> filters) {
        String[] paramsName;
        if (filters == null || filters.size() == 0 || values == null || values.length == 0) {
            return values;
        }
        if (paramArgs == null || paramArgs.length == 0) {
            paramsName = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                paramsName[i] = "param_" + i;
            }
        } else {
            paramsName = paramArgs;
        }
        HashMap<String, Integer> paramIndexMap = new HashMap<String, Integer>();
        int paramSize = paramsName.length;
        Object[] paramValues = new Object[paramSize];
        for (int i = 0; i < paramSize; ++i) {
            paramIndexMap.put(paramsName[i].toLowerCase(), i);
            paramValues[i] = values[i];
        }
        for (ParamFilterModel paramFilterModel : filters) {
            int index;
            String filterParam;
            String[] filterParams = paramFilterModel.getParams();
            String filterType = paramFilterModel.getFilterType();
            if (filterParams.length == 1 && "*".equals(filterParams[0])) {
                filterParams = paramsName;
            }
            if ("exclusive".equals(filterType) && paramFilterModel.getUpdateParams() != null) {
                ParamFilterUtils.filterExclusive(paramIndexMap, paramFilterModel, paramValues);
                continue;
            }
            if ("cache-arg".equals(filterType)) {
                ParamFilterUtils.filterCache(sqlToyContext, paramIndexMap, paramFilterModel, paramValues);
                continue;
            }
            if ("clone".equals(filterType)) {
                ParamFilterUtils.filterClone(paramIndexMap, paramFilterModel, paramValues);
                continue;
            }
            if ("primary".equals(filterType)) {
                filterParam = paramFilterModel.getParam().toLowerCase();
                index = paramIndexMap.get(filterParam) == null ? -1 : paramIndexMap.get(filterParam);
                if (index == -1 || paramValues[index] == null) continue;
                for (int j = 0; j < paramSize; ++j) {
                    if (j == index || paramFilterModel.getExcludes().contains(paramsName[j].toLowerCase())) continue;
                    paramValues[j] = null;
                }
                continue;
            }
            int n = filterParams.length;
            for (int i = 0; i < n; ++i) {
                filterParam = filterParams[i].toLowerCase();
                int n2 = index = paramIndexMap.get(filterParam) == null ? -1 : paramIndexMap.get(filterParam);
                if (index == -1 || paramValues[index] == null || paramFilterModel.getExcludes().contains(filterParam)) continue;
                paramValues[index] = ParamFilterUtils.filterSingleParam(sqlToyContext, paramValues[index], paramFilterModel);
            }
        }
        return paramValues;
    }

    private static void filterCache(SqlToyContext sqlToyContext, HashMap<String, Integer> paramIndexMap, ParamFilterModel paramFilterModel, Object[] paramValues) {
        try {
            String paramName = paramFilterModel.getParam().toLowerCase();
            int index = paramIndexMap.get(paramName) == null ? -1 : paramIndexMap.get(paramName);
            ArrayList<String> paramValueAry = new ArrayList<String>();
            if (index >= 0 && paramValues[index] != null) {
                Object[] tmp;
                if (paramValues[index] instanceof Collection) {
                    for (Object obj : tmp = ((Collection)paramValues[index]).toArray()) {
                        paramValueAry.add(obj == null ? null : obj.toString().trim().toLowerCase());
                    }
                } else if (paramValues[index] instanceof Object[]) {
                    for (Object obj : tmp = (Object[])paramValues[index]) {
                        paramValueAry.add(obj == null ? null : obj.toString().trim().toLowerCase());
                    }
                } else {
                    paramValueAry.add(paramValues[index].toString().trim().toLowerCase());
                }
            }
            if (paramValueAry.isEmpty()) {
                return;
            }
            String aliasName = paramFilterModel.getAliasName();
            if (StringUtil.isBlank(aliasName)) {
                aliasName = paramFilterModel.getParam();
            }
            if (!paramIndexMap.containsKey(aliasName.toLowerCase())) {
                logger.warn("cache-arg \u4ece\u7f13\u5b58:{}\u53d6\u5b9e\u9645\u6761\u4ef6\u503c\u522b\u540d:{}\u914d\u7f6e\u9519\u8bef,\u5176\u4e0d\u5728\u4e8e\u5b9e\u9645sql\u8bed\u53e5\u4e2d!", (Object)paramFilterModel.getCacheName(), (Object)aliasName);
                return;
            }
            HashMap<String, Object[]> cacheDataMap = sqlToyContext.getTranslateManager().getCacheData(paramFilterModel.getCacheName(), paramFilterModel.getCacheType());
            if (cacheDataMap == null || cacheDataMap.isEmpty()) {
                logger.warn("\u7f13\u5b58:{} \u53ef\u80fd\u4e0d\u5b58\u5728,\u5728\u901a\u8fc7\u7f13\u5b58\u83b7\u53d6\u67e5\u8be2\u6761\u4ef6key\u503c\u65f6\u5f02\u5e38,\u8bf7\u68c0\u67e5!", (Object)paramFilterModel.getCacheName());
                return;
            }
            CacheFilterModel[] cacheFilters = paramFilterModel.getCacheFilters();
            boolean hasFilter = cacheFilters != null;
            ArrayList filterValues = new ArrayList();
            if (hasFilter) {
                for (int i = 0; i < cacheFilters.length; ++i) {
                    CacheFilterModel cacheFilter = cacheFilters[i];
                    Integer cacheValueIndex = paramIndexMap.get(cacheFilter.getCompareParam().toLowerCase());
                    Object compareValue = cacheFilter.getCompareParam();
                    if (cacheValueIndex != null) {
                        compareValue = paramValues[cacheValueIndex];
                    }
                    HashMap<String, String> tmp = new HashMap<String, String>();
                    if (compareValue.getClass().isArray()) {
                        Object[] ary;
                        for (Object obj : ary = (Object[])compareValue) {
                            tmp.put(obj.toString(), "1");
                        }
                    } else if (compareValue instanceof Collection) {
                        Iterator iter = ((Collection)compareValue).iterator();
                        while (iter.hasNext()) {
                            tmp.put(iter.next().toString(), "1");
                        }
                    } else {
                        tmp.put(compareValue.toString(), "1");
                    }
                    filterValues.add(tmp);
                }
            }
            int matchCnt = 0;
            int[] matchIndexes = paramFilterModel.getCacheMappingIndexes();
            int maxLimit = paramFilterModel.getCacheMappingMax();
            ArrayList<Object> matchedKeys = new ArrayList<Object>();
            int cacheKeyIndex = paramFilterModel.getCacheKeyIndex();
            boolean include = true;
            boolean priorMatchEqual = paramFilterModel.isPriorMatchEqual();
            boolean isEqual = false;
            for (Object[] cacheRow : cacheDataMap.values()) {
                int i;
                Object keyCode = cacheRow[cacheKeyIndex];
                include = true;
                if (hasFilter) {
                    for (i = 0; i < cacheFilters.length; ++i) {
                        CacheFilterModel cacheFilter = cacheFilters[i];
                        isEqual = cacheRow[cacheFilter.getCacheIndex()] == null ? false : ((Map)filterValues.get(i)).containsKey(cacheRow[cacheFilter.getCacheIndex()].toString());
                        if ((!"eq".equals(cacheFilter.getCompareType()) || isEqual) && (!"neq".equals(cacheFilter.getCompareType()) || !isEqual)) continue;
                        include = false;
                        break;
                    }
                }
                if (!include) continue;
                block9: for (i = 0; i < paramValueAry.size(); ++i) {
                    Object compareValue;
                    String matchStr = (String)paramValueAry.get(i);
                    if (priorMatchEqual) {
                        if (matchStr.equals(keyCode.toString().toLowerCase())) {
                            matchedKeys.add(keyCode);
                            ++matchCnt;
                            paramValueAry.remove(i);
                            break;
                        }
                        for (int matchIndex : matchIndexes) {
                            compareValue = cacheRow[matchIndex];
                            if (compareValue == null || !matchStr.equals(compareValue.toString().toLowerCase())) continue;
                            matchedKeys.add(keyCode);
                            ++matchCnt;
                            paramValueAry.remove(i);
                            break block9;
                        }
                    }
                    String[] matchWords = matchStr.split("\\s+");
                    for (int matchIndex : matchIndexes) {
                        compareValue = cacheRow[matchIndex];
                        if (compareValue == null || !StringUtil.like(compareValue.toString().toLowerCase(), matchWords)) continue;
                        matchedKeys.add(keyCode);
                        ++matchCnt;
                        break block9;
                    }
                }
                if (!paramValueAry.isEmpty() && matchCnt < maxLimit) continue;
                break;
            }
            Object[] realMatched = null;
            if (matchedKeys.isEmpty()) {
                if (paramFilterModel.getCacheNotMatchedValue() != null) {
                    realMatched = new Object[]{paramFilterModel.getCacheNotMatchedValue()};
                } else if (paramFilterModel.isCacheNotMatchedReturnSelf()) {
                    realMatched = new String[paramValueAry.size()];
                    paramValueAry.toArray(realMatched);
                } else {
                    realMatched = new Object[]{};
                }
            } else {
                realMatched = new Object[matchedKeys.size()];
                matchedKeys.toArray(realMatched);
            }
            if (StringUtil.isNotBlank(paramFilterModel.getAliasName())) {
                int aliasIndex = paramIndexMap.get(paramFilterModel.getAliasName().toLowerCase());
                paramValues[aliasIndex] = realMatched;
            } else {
                paramValues[index] = realMatched;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u901a\u8fc7\u7f13\u5b58\u5339\u914d\u67e5\u8be2\u6761\u4ef6key\u5931\u8d25:{}", (Object)e.getMessage());
        }
    }

    private static void filterExclusive(HashMap<String, Integer> paramIndexMap, ParamFilterModel paramFilterModel, Object[] paramValues) {
        int index;
        boolean isExclusive = false;
        String filterParam = paramFilterModel.getParam().toLowerCase();
        int n = index = paramIndexMap.get(filterParam) == null ? -1 : paramIndexMap.get(filterParam);
        if (index != -1) {
            Object paramValue = paramValues[index];
            String compareType = paramFilterModel.getCompareType();
            Object[] compareValues = paramFilterModel.getCompareValues();
            if ("==".equals(compareType)) {
                if (null == paramValue && null == compareValues) {
                    isExclusive = true;
                } else if (null != paramValue && null != compareValues && null == ParamFilterUtils.filterEquals(paramValue, compareValues)) {
                    isExclusive = true;
                }
            } else if (null != paramValue && null != compareValues) {
                Object result = paramValue;
                if (">=".equals(compareType)) {
                    result = ParamFilterUtils.filterMoreEquals(paramValue, compareValues[0]);
                } else if (">".equals(compareType)) {
                    result = ParamFilterUtils.filterMore(paramValue, compareValues[0]);
                } else if ("<=".equals(compareType)) {
                    result = ParamFilterUtils.filterLessEquals(paramValue, compareValues[0]);
                } else if ("<".equals(compareType)) {
                    result = ParamFilterUtils.filterLess(paramValue, compareValues[0]);
                } else if ("<>".equals(compareType)) {
                    result = ParamFilterUtils.filterNotEquals(paramValue, compareValues);
                } else if ("between".equals(compareType)) {
                    result = ParamFilterUtils.filterBetween(paramValue, compareValues[0], compareValues[compareValues.length - 1]);
                } else if ("in".equals(compareType)) {
                    result = ParamFilterUtils.filterEquals(paramValue, compareValues);
                }
                if (null == result) {
                    isExclusive = true;
                }
            }
        }
        if (isExclusive) {
            String updateValue = paramFilterModel.getUpdateValue();
            int n2 = paramFilterModel.getUpdateParams().length;
            for (int i = 0; i < n2; ++i) {
                String updateParam = paramFilterModel.getUpdateParams()[i].toLowerCase();
                int n3 = index = paramIndexMap.get(updateParam) == null ? -1 : paramIndexMap.get(updateParam);
                if (index == -1) continue;
                paramValues[index] = null == updateValue ? null : (null == paramValues[index] ? updateValue : (paramValues[index] instanceof Date ? DateUtil.convertDateObject(updateValue) : (paramValues[index] instanceof Number ? new BigDecimal(updateValue) : updateValue)));
            }
        }
    }

    private static void filterClone(HashMap<String, Integer> paramIndexMap, ParamFilterModel paramFilterModel, Object[] paramValues) {
        int updateIndex;
        if (paramFilterModel.getParam() == null || paramFilterModel.getUpdateParams() == null || paramFilterModel.getUpdateParams().length != 1) {
            return;
        }
        String filterParam = paramFilterModel.getParam().toLowerCase();
        String updateParam = paramFilterModel.getUpdateParams()[0].toLowerCase();
        int paramIndex = paramIndexMap.get(filterParam) == null ? -1 : paramIndexMap.get(filterParam);
        int n = updateIndex = paramIndexMap.get(updateParam) == null ? -1 : paramIndexMap.get(updateParam);
        if (paramIndex != -1 && updateIndex != -1) {
            Object paramValue = paramValues[paramIndex];
            if (paramValue == null) {
                return;
            }
            Object cloneValue = null;
            if (paramValue instanceof String) {
                cloneValue = paramValue.toString();
            } else if (paramValue instanceof Timestamp) {
                cloneValue = ((Timestamp)paramValue).clone();
            } else if (paramValue instanceof Date) {
                cloneValue = ((Date)paramValue).clone();
            } else if (paramValue instanceof LocalDate) {
                LocalDate date = (LocalDate)paramValue;
                cloneValue = LocalDate.of(date.getYear(), date.getMonthValue(), date.getDayOfMonth());
            } else if (paramValue instanceof LocalDateTime) {
                LocalDateTime date = (LocalDateTime)paramValue;
                cloneValue = LocalDateTime.of(date.getYear(), date.getMonthValue(), date.getDayOfMonth(), date.getHour(), date.getMinute(), date.getSecond());
            } else if (paramValue instanceof LocalTime) {
                LocalTime date = (LocalTime)paramValue;
                cloneValue = LocalTime.of(date.getHour(), date.getMinute(), date.getSecond());
            } else {
                cloneValue = paramValue.getClass().isArray() ? ((Object[])paramValue).clone() : paramValue;
            }
            if (cloneValue != null) {
                paramValues[updateIndex] = cloneValue;
            }
        }
    }

    private static Object filterSingleParam(SqlToyContext sqlToyContext, Object paramValue, ParamFilterModel paramFilterModel) {
        if (null == paramValue) {
            return null;
        }
        Object result = paramValue;
        String filterType = paramFilterModel.getFilterType();
        if ("blank".equals(filterType)) {
            result = paramValue;
            if (paramValue instanceof CharSequence) {
                if ("".equals(paramValue.toString().trim())) {
                    result = null;
                }
            } else if (paramValue instanceof Collection) {
                if (((Collection)paramValue).isEmpty()) {
                    result = null;
                }
            } else if (paramValue instanceof Map) {
                if (((Map)paramValue).isEmpty()) {
                    result = null;
                }
            } else if (paramValue.getClass().isArray() && CollectionUtil.convertArray(paramValue).length == 0) {
                result = null;
            }
        } else if ("eq".equals(filterType)) {
            result = ParamFilterUtils.filterEquals(paramValue, paramFilterModel.getValues());
        } else if ("gt".equals(filterType)) {
            result = ParamFilterUtils.filterMore(paramValue, paramFilterModel.getValues()[0]);
        } else if ("gte".equals(filterType)) {
            result = ParamFilterUtils.filterMoreEquals(paramValue, paramFilterModel.getValues()[0]);
        } else if ("lt".equals(filterType)) {
            result = ParamFilterUtils.filterLess(paramValue, paramFilterModel.getValues()[0]);
        } else if ("lte".equals(filterType)) {
            result = ParamFilterUtils.filterLessEquals(paramValue, paramFilterModel.getValues()[0]);
        } else if ("between".equals(filterType)) {
            result = ParamFilterUtils.filterBetween(paramValue, paramFilterModel.getValues()[0], paramFilterModel.getValues()[paramFilterModel.getValues().length - 1]);
        } else if ("replace".equals(filterType)) {
            result = ParamFilterUtils.replace(paramValue, paramFilterModel.getRegex(), paramFilterModel.getValues()[0], paramFilterModel.isFirst());
        } else if ("split".equals(filterType)) {
            result = ParamFilterUtils.splitToArray(paramValue, paramFilterModel.getSplit(), paramFilterModel.getDataType());
        } else if ("date-format".equals(filterType)) {
            result = ParamFilterUtils.dateFormat(paramValue, paramFilterModel.getFormat());
        } else if ("neq".equals(filterType)) {
            result = ParamFilterUtils.filterNotEquals(paramValue, paramFilterModel.getValues());
        } else if ("to-date".equals(filterType)) {
            if (paramValue.getClass().isArray()) {
                Object[] arrays = CollectionUtil.convertArray(paramValue);
                int n = arrays.length;
                for (int i = 0; i < n; ++i) {
                    arrays[i] = ParamFilterUtils.toDate(arrays[i], paramFilterModel);
                }
                result = arrays;
            } else if (paramValue instanceof List) {
                List valueList = (List)paramValue;
                int n = valueList.size();
                for (int i = 0; i < n; ++i) {
                    valueList.set(i, ParamFilterUtils.toDate(valueList.get(i), paramFilterModel));
                }
                result = valueList;
            } else {
                result = ParamFilterUtils.toDate(paramValue, paramFilterModel);
            }
        } else if ("to-number".equals(filterType)) {
            if (paramValue.getClass().isArray()) {
                Object[] arrays = CollectionUtil.convertArray(paramValue);
                int n = arrays.length;
                for (int i = 0; i < n; ++i) {
                    arrays[i] = ParamFilterUtils.toNumber(arrays[i], paramFilterModel.getDataType());
                }
                result = arrays;
            } else if (paramValue instanceof List) {
                List valueList = (List)paramValue;
                int n = valueList.size();
                for (int i = 0; i < n; ++i) {
                    valueList.set(i, ParamFilterUtils.toNumber(valueList.get(i), paramFilterModel.getDataType()));
                }
                result = valueList;
            } else {
                result = ParamFilterUtils.toNumber(paramValue, paramFilterModel.getDataType());
            }
        } else if ("to-array".equals(filterType)) {
            result = ParamFilterUtils.toArray(paramValue, paramFilterModel.getDataType());
        } else if ("l-like".equals(filterType)) {
            result = ParamFilterUtils.like(paramValue, true);
        } else if ("r-like".equals(filterType)) {
            result = ParamFilterUtils.like(paramValue, false);
        } else if ("to-in-arg".equals(filterType)) {
            if (paramValue instanceof CharSequence) {
                String inArg = paramValue.toString();
                if (!paramFilterModel.isSingleQuote()) {
                    result = inArg;
                } else if (inArg.startsWith("'") && inArg.endsWith("'")) {
                    result = inArg;
                } else {
                    String[] args = inArg.split("\\,");
                    StringBuilder inStr = new StringBuilder();
                    int cnt = 0;
                    for (String arg : args) {
                        String tmp = arg.trim();
                        if ("".equals(tmp)) continue;
                        if (cnt > 0) {
                            inStr.append(",");
                        }
                        if (!tmp.startsWith("'")) {
                            inStr.append("'");
                        }
                        inStr.append(tmp);
                        if (!tmp.endsWith("'")) {
                            inStr.append("'");
                        }
                        ++cnt;
                    }
                    result = inStr.toString();
                }
            } else {
                try {
                    result = SqlUtil.combineQueryInStr(paramValue, null, null, paramFilterModel.isSingleQuote());
                }
                catch (Exception e) {
                    logger.error("sql \u53c2\u6570\u8fc7\u6ee4\u8f6c\u6362\u8fc7\u7a0b:\u5c06\u6570\u7ec4\u8f6c\u6210in (:params) \u5f62\u5f0f\u7684\u6761\u4ef6\u503c\u8fc7\u7a0b\u9519\u8bef:{}", (Object)e.getMessage());
                }
            }
        } else if ("custom-handler".equals(filterType)) {
            if (sqlToyContext.getCustomFilterHandler() == null) {
                throw new RuntimeException("sql\u4e2dfilter\u4f7f\u7528\u4e86custom-handler\u7c7b\u578b,\u4f46spring.sqltoy.customFilterHandler\u672a\u5b9a\u4e49\u5177\u4f53\u5b9e\u73b0\u7c7b!");
            }
            result = sqlToyContext.getCustomFilterHandler().process(paramValue, paramFilterModel.getType());
        } else {
            logger.warn("sql\u4e2dfilters\u5b9a\u4e49\u7684filterType={} \u76ee\u524d\u6ca1\u6709\u5bf9\u5e94\u7684\u5b9e\u73b0!", (Object)filterType);
        }
        return result;
    }

    private static String like(Object paramValue, boolean isLeft) {
        if (StringUtil.isBlank(paramValue)) {
            return null;
        }
        if (isLeft) {
            return "%".concat(paramValue.toString());
        }
        return paramValue.toString().concat("%");
    }

    private static Object replace(Object paramValue, String regex, Object valueVar, boolean isFirst) {
        if (paramValue == null || regex == null || valueVar == null) {
            return null;
        }
        String value = valueVar.toString();
        if (paramValue instanceof String) {
            value = Matcher.quoteReplacement(value);
            if (isFirst) {
                return paramValue.toString().replaceFirst(regex, value);
            }
            return paramValue.toString().replaceAll(regex, value);
        }
        return paramValue;
    }

    private static Object dateFormat(Object paramValue, String format) {
        Object result;
        if (paramValue == null) {
            return null;
        }
        if (format == null) {
            return paramValue;
        }
        if (paramValue.getClass().isArray()) {
            Object[] arrays = CollectionUtil.convertArray(paramValue);
            int n = arrays.length;
            for (int i = 0; i < n; ++i) {
                arrays[i] = DateUtil.formatDate(arrays[i], format);
            }
            result = arrays;
        } else if (paramValue instanceof List) {
            List valueList = (List)paramValue;
            int n = valueList.size();
            for (int i = 0; i < n; ++i) {
                valueList.set(i, DateUtil.formatDate(valueList.get(i), format));
            }
            result = valueList;
        } else {
            result = DateUtil.formatDate(paramValue, format);
        }
        return result;
    }

    private static Object[] splitToArray(Object paramValue, String splitSign, String dataType) {
        if (paramValue == null) {
            return null;
        }
        Object[] result = null;
        if (paramValue.getClass().isArray() || paramValue instanceof Collection) {
            result = CollectionUtil.convertArray(paramValue);
            if (dataType == null) {
                return result;
            }
        } else {
            Object[] arrays = null;
            String split = splitSign.trim();
            arrays = ",".equals(split) ? paramValue.toString().split("\\,") : (";".equals(split) ? paramValue.toString().split("\\;") : (":".equals(split) ? paramValue.toString().split("\\:") : ("".equals(split) ? paramValue.toString().split("\\s+") : paramValue.toString().split(splitSign))));
            if (dataType == null || "string".equals(dataType)) {
                return arrays;
            }
            result = new Object[arrays.length];
            System.arraycopy(arrays, 0, result, 0, arrays.length);
        }
        int n = result.length;
        for (int i = 0; i < n; ++i) {
            if (null == result[i]) continue;
            String value = result[i].toString();
            if ("integer".equals(dataType) || "int".equals(dataType)) {
                result[i] = Integer.valueOf(value);
                continue;
            }
            if ("long".equals(dataType)) {
                result[i] = Long.valueOf(value);
                continue;
            }
            if ("float".equals(dataType)) {
                result[i] = Float.valueOf(value);
                continue;
            }
            if ("double".equals(dataType)) {
                result[i] = Double.valueOf(value);
                continue;
            }
            if ("decimal".equals(dataType) || "number".equals(dataType)) {
                result[i] = new BigDecimal(value);
                continue;
            }
            if ("date".equals(dataType)) {
                result[i] = DateUtil.parseString(value);
                continue;
            }
            if (!"biginteger".equals(dataType)) continue;
            result[i] = new BigInteger(value);
        }
        return result;
    }

    private static Object[] toArray(Object paramValue, String dataType) {
        if (paramValue == null) {
            return null;
        }
        Object[] result = CollectionUtil.convertArray(paramValue);
        if (dataType == null) {
            return result;
        }
        int n = result.length;
        for (int i = 0; i < n; ++i) {
            if (result[i] == null) continue;
            String value = result[i].toString();
            if ("integer".equals(dataType) || "int".equals(dataType)) {
                result[i] = Integer.valueOf(value);
                continue;
            }
            if ("long".equals(dataType)) {
                result[i] = Long.valueOf(value);
                continue;
            }
            if ("float".equals(dataType)) {
                result[i] = Float.valueOf(value);
                continue;
            }
            if ("double".equals(dataType)) {
                result[i] = Double.valueOf(value);
                continue;
            }
            if ("decimal".equals(dataType) || "number".equals(dataType)) {
                result[i] = new BigDecimal(value);
                continue;
            }
            if ("string".equals(dataType)) {
                result[i] = value;
                continue;
            }
            if (!"biginteger".equals(dataType)) continue;
            result[i] = new BigInteger(value);
        }
        return result;
    }

    private static Object toNumber(Object paramValue, String dataType) {
        BigDecimal value = new BigDecimal(paramValue.toString().replaceAll(",", ""));
        Number result = dataType == null ? value : ("integer".equals(dataType) || "int".equals(dataType) ? (Number)value.intValue() : (Number)("long".equals(dataType) ? (Number)value.longValue() : (Number)("float".equals(dataType) ? (Number)Float.valueOf(value.floatValue()) : (Number)("double".equals(dataType) ? (Number)value.doubleValue() : (Number)("biginteger".equals(dataType) ? value.toBigInteger() : value)))));
        return result;
    }

    private static Object toDate(Object paramValue, ParamFilterModel paramFilterModel) {
        Object result;
        String format = paramFilterModel.getFormat() == null ? "" : paramFilterModel.getFormat();
        String fmtStyle = format.toLowerCase();
        String realFmt = DAY_FORMAT;
        String type = paramFilterModel.getType();
        if (StringUtil.isBlank(type)) {
            type = "localdate";
            if (fmtStyle.contains("hhmmss") || fmtStyle.contains("hh:mm:ss")) {
                type = "hhmmss".equals(fmtStyle) || "hh:mm:ss".equals(fmtStyle) ? "localtime" : "localdatetime";
            }
        }
        if ("first_of_month".equals(fmtStyle)) {
            result = DateUtil.firstDayOfMonth(paramValue);
        } else if ("first_of_year".equals(fmtStyle)) {
            result = DateUtil.getYear(paramValue) + "-01-01";
        } else if ("last_of_month".equals(fmtStyle)) {
            result = DateUtil.lastDayOfMonth(paramValue);
        } else if ("last_of_year".equals(fmtStyle)) {
            result = DateUtil.getYear(paramValue) + "-12-31";
        } else if ("first_of_week".equals(fmtStyle)) {
            Calendar ca = Calendar.getInstance();
            ca.setTime(DateUtil.parse(paramValue, DAY_FORMAT));
            ca.add(7, -ca.get(7) + 2);
            result = ca.getTime();
        } else if ("last_of_week".equals(fmtStyle)) {
            Calendar ca = Calendar.getInstance();
            ca.setTime(DateUtil.parse(paramValue, DAY_FORMAT));
            ca.add(7, -ca.get(7) + 8);
            result = ca.getTime();
        } else {
            result = DateUtil.convertDateObject(paramValue);
            realFmt = StringUtil.isNotBlank(format) ? format : null;
        }
        if (paramFilterModel.getIncrementTime() != 0.0) {
            switch (paramFilterModel.getTimeUnit()) {
                case DAYS: {
                    result = DateUtil.addDay(result, paramFilterModel.getIncrementTime());
                    break;
                }
                case SECONDS: {
                    result = DateUtil.addSecond(result, paramFilterModel.getIncrementTime());
                    break;
                }
                case MILLISECONDS: {
                    result = DateUtil.addMilliSecond(result, paramFilterModel.getIncrementTime().longValue());
                    break;
                }
                case MINUTES: {
                    result = DateUtil.addSecond(result, 60.0 * paramFilterModel.getIncrementTime());
                    break;
                }
                case HOURS: {
                    result = DateUtil.addSecond(result, 3600.0 * paramFilterModel.getIncrementTime());
                    break;
                }
                case MONTHS: {
                    result = DateUtil.addMonth(result, paramFilterModel.getIncrementTime().intValue());
                    break;
                }
                case YEARS: {
                    result = DateUtil.addYear(result, paramFilterModel.getIncrementTime().intValue());
                    break;
                }
                default: {
                    result = DateUtil.addDay(result, paramFilterModel.getIncrementTime());
                }
            }
        }
        if (realFmt != null) {
            result = DateUtil.parse(result, realFmt);
        }
        if ("localdate".equals(type)) {
            return DateUtil.asLocalDate((Date)result);
        }
        if ("localdatetime".equals(type)) {
            return DateUtil.asLocalDateTime((Date)result);
        }
        if ("timestamp".equals(type)) {
            return Timestamp.valueOf(DateUtil.asLocalDateTime((Date)result));
        }
        if ("localtime".equals(type)) {
            return DateUtil.asLocalTime((Date)result);
        }
        if ("time".equals(type)) {
            return Time.valueOf(DateUtil.asLocalTime((Date)result));
        }
        return result;
    }

    private static Object filterEquals(Object param, Object[] contrasts) {
        if (null == param || contrasts == null || contrasts.length == 0) {
            return null;
        }
        if (param.getClass().isArray() && contrasts.length == 1) {
            Object[] ary = CollectionUtil.convertArray(param);
            String contrast = contrasts[0].toString();
            for (Object var : ary) {
                if (var == null || !var.toString().equals(contrast)) continue;
                return null;
            }
            return param;
        }
        int type = 0;
        if (param instanceof Date || param instanceof LocalDate || param instanceof LocalTime || param instanceof LocalDateTime) {
            type = 1;
        } else if (param instanceof Number) {
            type = 2;
        }
        for (Object tmp : contrasts) {
            String contrast = tmp.toString();
            if (type == 1) {
                Date compareDate;
                if (contrast.length() < 6) continue;
                if (param instanceof LocalTime) {
                    if (((LocalTime)param).compareTo(LocalTime.parse(contrast)) != 0) continue;
                    return null;
                }
                Date date = compareDate = "sysdate".equals(contrast.toLowerCase()) ? DateUtil.parse(DateUtil.getNowTime(), DAY_FORMAT) : DateUtil.convertDateObject(contrast);
                if (compareDate == null || DateUtil.convertDateObject(param).compareTo(compareDate) != 0) continue;
                return null;
            }
            if (!(type == 2 ? NumberUtil.isNumber(contrast) && new BigDecimal(param.toString()).compareTo(new BigDecimal(contrast)) == 0 : param.toString().compareTo(contrast) == 0)) continue;
            return null;
        }
        return param;
    }

    private static Object filterNotEquals(Object param, Object[] contrasts) {
        if (null == param) {
            return null;
        }
        if (contrasts == null || contrasts.length == 0) {
            return param;
        }
        if (param.getClass().isArray() && contrasts.length == 1) {
            Object[] ary = CollectionUtil.convertArray(param);
            String contrast = contrasts[0] == null ? null : contrasts[0].toString();
            for (Object var : ary) {
                if (var == null || !var.toString().equals(contrast)) continue;
                return param;
            }
            return null;
        }
        int type = 0;
        if (param instanceof Date || param instanceof LocalDate || param instanceof LocalTime || param instanceof LocalDateTime) {
            type = 1;
        } else if (param instanceof Number) {
            type = 2;
        }
        for (Object tmp : contrasts) {
            String contrast;
            String string = contrast = tmp == null ? null : tmp.toString();
            if (StringUtil.isBlank(contrast)) {
                return param;
            }
            if (type == 1) {
                Date compareDate;
                if (contrast.length() < 6) continue;
                if (param instanceof LocalTime) {
                    if (((LocalTime)param).compareTo(LocalTime.parse(contrast)) != 0) continue;
                    return param;
                }
                Date date = compareDate = "sysdate".equalsIgnoreCase(contrast) ? DateUtil.parse(DateUtil.getNowTime(), DAY_FORMAT) : DateUtil.convertDateObject(contrast);
                if (DateUtil.convertDateObject(param).compareTo(compareDate) != 0) continue;
                return param;
            }
            if (!(type == 2 ? !NumberUtil.isNumber(contrast) || new BigDecimal(param.toString()).compareTo(new BigDecimal(contrast)) == 0 : param.toString().compareTo(contrast) == 0)) continue;
            return param;
        }
        return null;
    }

    private static Object filterLess(Object param, Object contrastParam) {
        if (null == param) {
            return null;
        }
        String contrast = contrastParam.toString();
        if (param instanceof Date || param instanceof LocalDate || param instanceof LocalDateTime) {
            Date compareDate = "sysdate".equals(contrast.toLowerCase()) ? DateUtil.parse(DateUtil.getNowTime(), DAY_FORMAT) : DateUtil.convertDateObject(contrast);
            if (DateUtil.convertDateObject(param).before(compareDate)) {
                return null;
            }
        } else if (param instanceof LocalTime ? ((LocalTime)param).isBefore(LocalTime.parse(contrast)) : (param instanceof Number ? new BigDecimal(param.toString()).compareTo(new BigDecimal(contrast)) < 0 : param.toString().compareTo(contrast) < 0)) {
            return null;
        }
        return param;
    }

    private static Object filterLessEquals(Object param, Object contrastParam) {
        if (null == param) {
            return null;
        }
        String contrast = contrastParam.toString();
        if (param instanceof Date || param instanceof LocalDate || param instanceof LocalDateTime) {
            Date compareDate = "sysdate".equals(contrast.toLowerCase()) ? DateUtil.parse(DateUtil.getNowTime(), DAY_FORMAT) : DateUtil.convertDateObject(contrast);
            if (DateUtil.convertDateObject(param).compareTo(compareDate) <= 0) {
                return null;
            }
        } else if (param instanceof LocalTime ? ((LocalTime)param).compareTo(LocalTime.parse(contrast)) <= 0 : (param instanceof Number ? new BigDecimal(param.toString()).compareTo(new BigDecimal(contrast)) <= 0 : param.toString().compareTo(contrast) <= 0)) {
            return null;
        }
        return param;
    }

    private static Object filterMore(Object param, Object contrastParam) {
        if (null == param) {
            return null;
        }
        String contrast = contrastParam.toString();
        if (param instanceof Date || param instanceof LocalDate || param instanceof LocalDateTime) {
            Date compareDate = "sysdate".equals(contrast.toLowerCase()) ? DateUtil.parse(DateUtil.getNowTime(), DAY_FORMAT) : DateUtil.convertDateObject(contrast);
            if (DateUtil.convertDateObject(param).compareTo(compareDate) > 0) {
                return null;
            }
        } else if (param instanceof LocalTime ? ((LocalTime)param).compareTo(LocalTime.parse(contrast)) > 0 : (param instanceof Number ? new BigDecimal(param.toString()).compareTo(new BigDecimal(contrast)) > 0 : param.toString().compareTo(contrast) > 0)) {
            return null;
        }
        return param;
    }

    private static Object filterMoreEquals(Object param, Object contrastParam) {
        if (null == param) {
            return null;
        }
        String contrast = contrastParam.toString();
        if (param instanceof Date || param instanceof LocalDate || param instanceof LocalDateTime) {
            Date compareDate = "sysdate".equals(contrast.toLowerCase()) ? DateUtil.parse(DateUtil.getNowTime(), DAY_FORMAT) : DateUtil.convertDateObject(contrast);
            if (DateUtil.convertDateObject(param).compareTo(compareDate) >= 0) {
                return null;
            }
        } else if (param instanceof LocalTime ? ((LocalTime)param).compareTo(LocalTime.parse(contrast)) >= 0 : (param instanceof Number ? new BigDecimal(param.toString()).compareTo(new BigDecimal(contrast)) >= 0 : param.toString().compareTo(contrast) >= 0)) {
            return null;
        }
        return param;
    }

    private static Object filterBetween(Object param, Object beginValue, Object endValue) {
        Date var;
        if (null == param) {
            return null;
        }
        String beginContrast = beginValue.toString();
        String endContrast = endValue.toString();
        if (param instanceof Date || param instanceof LocalDate || param instanceof LocalDateTime ? (var = DateUtil.convertDateObject(param)).compareTo(DateUtil.convertDateObject(beginContrast)) >= 0 && var.compareTo(DateUtil.convertDateObject(endContrast)) <= 0 : (param instanceof LocalTime ? ((LocalTime)param).compareTo(LocalTime.parse(beginContrast)) >= 0 && ((LocalTime)param).compareTo(LocalTime.parse(endContrast)) <= 0 : (param instanceof Number ? new BigDecimal(param.toString()).compareTo(new BigDecimal(beginContrast)) >= 0 && new BigDecimal(param.toString()).compareTo(new BigDecimal(endContrast)) <= 0 : param.toString().compareTo(beginContrast) >= 0 && param.toString().compareTo(endContrast) <= 0))) {
            return null;
        }
        return param;
    }

    public static List<ParamFilterModel> combineFilters(List<ParamFilterModel> filters, List<ParamsFilter> extFilters) {
        if (extFilters == null || extFilters.isEmpty()) {
            return filters;
        }
        ArrayList<ParamFilterModel> result = new ArrayList<ParamFilterModel>();
        if (filters != null && !filters.isEmpty()) {
            result.addAll(filters);
        }
        for (ParamsFilter filter : extFilters) {
            ParamFilterModel paramFilter = new ParamFilterModel();
            paramFilter.setFilterType(filter.getType());
            paramFilter.setParams(filter.getParams());
            if (filter.getParams().length == 1) {
                paramFilter.setParam(filter.getParams()[0]);
            }
            if (filter.getExcludes() != null) {
                for (String s : filter.getExcludes()) {
                    paramFilter.addExclude(s);
                }
            }
            paramFilter.setFormat(filter.getDateType());
            paramFilter.setValues(filter.getValue());
            paramFilter.setIncrementTime(Double.valueOf(filter.getIncrease()));
            paramFilter.setTimeUnit(filter.getTimeUnit());
            result.add(paramFilter);
        }
        return result;
    }
}

