/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.utils;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.sagacity.sqltoy.SqlToyConstants;
import org.sagacity.sqltoy.SqlToyContext;
import org.sagacity.sqltoy.callback.DataSourceCallbackHandler;
import org.sagacity.sqltoy.utils.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceUtils {
    protected static final Logger logger = LoggerFactory.getLogger(DataSourceUtils.class);
    public static ConcurrentHashMap<String, String> DBDialectMap = new ConcurrentHashMap();
    public static ConcurrentHashMap<String, Integer> DBTypeMap = new ConcurrentHashMap();
    public static ConcurrentHashMap<String, Integer> DBNameTypeMap = new ConcurrentHashMap();

    private DataSourceUtils() {
    }

    public static void initialize() {
        DBNameTypeMap.put("db2", 20);
        DBNameTypeMap.put("oracle", 10);
        DBNameTypeMap.put("oracle11", 11);
        DBNameTypeMap.put("sqlserver", 30);
        DBNameTypeMap.put("mysql", 40);
        DBNameTypeMap.put("mysql57", 42);
        DBNameTypeMap.put("mariadb", 40);
        DBNameTypeMap.put("innosql", 40);
        DBNameTypeMap.put("postgresql", 50);
        DBNameTypeMap.put("postgresql15", 51);
        DBNameTypeMap.put("greenplum", 50);
        DBNameTypeMap.put("gaussdb", 70);
        DBNameTypeMap.put("mongo", 130);
        DBNameTypeMap.put("elastic", 140);
        DBNameTypeMap.put("sqlite", 80);
        DBNameTypeMap.put("clickhouse", 60);
        DBNameTypeMap.put("oceanbase", 100);
        DBNameTypeMap.put("dm", 110);
        DBNameTypeMap.put("kingbase", 120);
        DBNameTypeMap.put("tidb", 90);
        DBNameTypeMap.put("tdengine", 150);
        DBNameTypeMap.put("impala", 160);
        DBNameTypeMap.put("UNDEFINE", 0);
        DBNameTypeMap.put("h2", 170);
    }

    public static String getDialect(Integer dbType) {
        switch (dbType) {
            case 40: {
                return "mysql";
            }
            case 42: {
                return "mysql57";
            }
            case 10: {
                return "oracle";
            }
            case 50: {
                return "postgresql";
            }
            case 51: {
                return "postgresql15";
            }
            case 30: {
                return "sqlserver";
            }
            case 20: {
                return "db2";
            }
            case 100: {
                return "oceanbase";
            }
            case 70: {
                return "gaussdb";
            }
            case 60: {
                return "clickhouse";
            }
            case 80: {
                return "sqlite";
            }
            case 90: {
                return "tidb";
            }
            case 110: {
                return "dm";
            }
            case 11: {
                return "oracle11";
            }
            case 140: {
                return "elastic";
            }
            case 130: {
                return "mongo";
            }
            case 160: {
                return "impala";
            }
            case 150: {
                return "tdengine";
            }
            case 170: {
                return "h2";
            }
        }
        return "UNDEFINE";
    }

    public static String getDatabaseSqlSplitSign(Connection conn) {
        try {
            int dbType = DataSourceUtils.getDBType(conn);
            if (dbType == 30) {
                return " go ";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ";";
    }

    public static String getCurrentDBDialect(Connection conn) throws SQLException {
        if (null != conn) {
            String dbDialect = conn.getMetaData().getDatabaseProductName().replaceAll("\\s*", "");
            if (StringUtil.indexOfIgnoreCase(dbDialect, "oracle") != -1) {
                return "oracle";
            }
            if (StringUtil.indexOfIgnoreCase(dbDialect, "mysql") != -1 || StringUtil.indexOfIgnoreCase(dbDialect, "mariadb") != -1 || StringUtil.indexOfIgnoreCase(dbDialect, "innosql") != -1) {
                return "mysql";
            }
            if (StringUtil.indexOfIgnoreCase(dbDialect, "postgresql") != -1) {
                return "postgresql";
            }
            if (StringUtil.indexOfIgnoreCase(dbDialect, "sqlserver") != -1 || StringUtil.indexOfIgnoreCase(dbDialect, "mssql") != -1 || StringUtil.indexOfIgnoreCase(dbDialect, "microsoftsqlserver") != -1) {
                return "sqlserver";
            }
            if (StringUtil.indexOfIgnoreCase(dbDialect, "db2") != -1) {
                return "db2";
            }
            if (StringUtil.indexOfIgnoreCase(dbDialect, "clickhouse") != -1) {
                return "clickhouse";
            }
            if (StringUtil.indexOfIgnoreCase(dbDialect, "oceanbase") != -1) {
                return "oceanbase";
            }
            if (StringUtil.indexOfIgnoreCase(dbDialect, "gaussdb") != -1) {
                return "gaussdb";
            }
            if (StringUtil.indexOfIgnoreCase(dbDialect, "sqlite") != -1) {
                return "sqlite";
            }
            if (StringUtil.indexOfIgnoreCase(dbDialect, "dm") != -1) {
                return "dm";
            }
            if (StringUtil.indexOfIgnoreCase(dbDialect, "tidb") != -1) {
                return "tidb";
            }
            if (StringUtil.indexOfIgnoreCase(dbDialect, "tdengine") != -1) {
                return "tdengine";
            }
            if (StringUtil.indexOfIgnoreCase(dbDialect, "kingbase") != -1) {
                return "kingbase";
            }
            if (StringUtil.indexOfIgnoreCase(dbDialect, "greenplum") != -1) {
                return "postgresql";
            }
            if (StringUtil.indexOfIgnoreCase(dbDialect, "impala") != -1) {
                return "impala";
            }
            if (StringUtil.indexOfIgnoreCase(dbDialect, "elastic") != -1) {
                return "elastic";
            }
            if (StringUtil.indexOfIgnoreCase(dbDialect, "h2") != -1) {
                return "h2";
            }
        }
        return "UNDEFINE";
    }

    private static int getDBVersion(Connection conn) throws SQLException {
        int result = -1;
        try {
            result = conn.getMetaData().getDatabaseMajorVersion();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static int getDBType(Connection conn) throws SQLException {
        int majorVersion;
        String productName = conn.getMetaData().getDatabaseProductName();
        String dbKey = productName + (majorVersion = DataSourceUtils.getDBVersion(conn));
        if (!DBNameTypeMap.containsKey(dbKey)) {
            String dbDialect = DataSourceUtils.getCurrentDBDialect(conn);
            int dbType = 0;
            if (dbDialect.equals("oracle")) {
                dbType = 10;
                if (majorVersion <= 11) {
                    dbType = 11;
                }
            } else if (dbDialect.equals("mysql")) {
                dbType = 40;
                if (majorVersion <= 5) {
                    dbType = 42;
                }
            } else if (dbDialect.equals("postgresql")) {
                dbType = 50;
                if (majorVersion >= 15) {
                    dbType = 51;
                }
            } else if (dbDialect.equals("greenplum")) {
                dbType = 50;
            } else if (dbDialect.equals("sqlserver")) {
                dbType = 30;
            } else if (dbDialect.equals("db2")) {
                dbType = 20;
            } else if (dbDialect.equals("clickhouse")) {
                dbType = 60;
            } else if (dbDialect.equals("oceanbase")) {
                dbType = 100;
            } else if (dbDialect.equals("gaussdb")) {
                dbType = 70;
            } else if (dbDialect.equals("sqlite")) {
                dbType = 80;
            } else if (dbDialect.equals("dm")) {
                dbType = 110;
            } else if (dbDialect.equals("tidb")) {
                dbType = 90;
            } else if (dbDialect.equals("impala")) {
                dbType = 160;
            } else if (dbDialect.equals("tdengine")) {
                dbType = 150;
            } else if (dbDialect.equals("kingbase")) {
                dbType = 120;
            } else if (dbDialect.equals("elastic")) {
                dbType = 140;
            } else if (dbDialect.equals("h2")) {
                dbType = 170;
            }
            DBNameTypeMap.put(dbKey, dbType);
        }
        return DBNameTypeMap.get(dbKey);
    }

    public static int getDBType(String dialect) {
        if (StringUtil.isBlank(dialect)) {
            return 0;
        }
        String dialectLow = dialect.toLowerCase();
        if (!DBNameTypeMap.containsKey(dialectLow)) {
            logger.warn("sqltoy\u521d\u59cb\u5316\u7684\u65b9\u8a00map\u4e2d\u672a\u5305\u542b\u7684\u6570\u636e\u5e93\u65b9\u8a00[" + dialectLow + "]");
            return 0;
        }
        return DBNameTypeMap.get(dialectLow);
    }

    public static String getValidateQuery(Connection conn) throws Exception {
        int dbType = DataSourceUtils.getDBType(conn);
        switch (dbType) {
            case 20: {
                return "select 1 from sysibm.sysdummy1";
            }
            case 10: 
            case 11: 
            case 100: 
            case 110: {
                return "select 1 from dual";
            }
            case 50: 
            case 51: 
            case 70: {
                return "select version()";
            }
        }
        return "select 1";
    }

    public static Object processDataSource(SqlToyContext sqltoyContext, DataSource datasource, DataSourceCallbackHandler handler) {
        if (datasource == null) {
            throw new IllegalArgumentException("dataSource\u4e3anull,\u5f02\u5e38\u539f\u56e0\u53c2\u8003:\n 1\u3001\u591a\u6570\u636e\u6e90\u573a\u666f\u672a\u914d\u7f6espring.sqltoy.defaultDataSoure=xxx \u9ed8\u8ba4\u6570\u636e\u6e90;\n 2\u3001dao\u4e2d\u6307\u5b9a\u7684dataSource\u540d\u79f0\u4e0d\u5b58\u5728!");
        }
        Connection conn = sqltoyContext.getConnection(datasource);
        try {
            Integer dbType;
            String dialect;
            if (null != sqltoyContext && StringUtil.isNotBlank(sqltoyContext.getDialect())) {
                dialect = sqltoyContext.getDialect();
                dbType = DataSourceUtils.getDBType(dialect);
            } else {
                dbType = DataSourceUtils.getDBType(conn);
                dialect = DataSourceUtils.getDialect(dbType);
            }
            if (SqlToyConstants.showDatasourceInfo()) {
                logger.debug("db.dialect={};conn.url={};schema={};catalog={};username={}", new Object[]{dialect, conn.getMetaData().getURL(), conn.getSchema(), conn.getCatalog(), conn.getMetaData().getUserName()});
            }
            handler.doConnection(conn, dbType, dialect);
        }
        catch (Exception e) {
            sqltoyContext.releaseConnection(conn, datasource);
            conn = null;
            throw new RuntimeException(e);
        }
        finally {
            sqltoyContext.releaseConnection(conn, datasource);
        }
        return handler.getResult();
    }

    public static int getDBType(SqlToyContext sqltoyContext, DataSource datasource) {
        if (datasource == null) {
            return 0;
        }
        String dsKey = "dataSource&" + datasource.hashCode();
        Integer dbType = DBTypeMap.get(dsKey);
        if (dbType != null) {
            return dbType;
        }
        Connection conn = sqltoyContext.getConnection(datasource);
        dbType = 0;
        try {
            dbType = DataSourceUtils.getDBType(conn);
            DBTypeMap.put(dsKey, dbType);
        }
        catch (Exception e) {
            e.printStackTrace();
            sqltoyContext.releaseConnection(conn, datasource);
            conn = null;
            throw new RuntimeException(e);
        }
        finally {
            sqltoyContext.releaseConnection(conn, datasource);
        }
        return dbType;
    }

    public static String getDialect(SqlToyContext sqltoyContext, DataSource datasource) {
        if (datasource == null) {
            return "";
        }
        String dsKey = "dataSource&" + datasource.hashCode();
        String dialect = DBDialectMap.get(dsKey);
        if (dialect != null) {
            return dialect;
        }
        Connection conn = sqltoyContext.getConnection(datasource);
        try {
            dialect = DataSourceUtils.getDialect(conn);
            DBDialectMap.put(dsKey, dialect);
        }
        catch (Exception e) {
            e.printStackTrace();
            sqltoyContext.releaseConnection(conn, datasource);
            conn = null;
            throw new RuntimeException(e);
        }
        finally {
            sqltoyContext.releaseConnection(conn, datasource);
        }
        return dialect;
    }

    private static String getDialect(Connection conn) throws Exception {
        if (conn == null) {
            return "";
        }
        int dbType = DataSourceUtils.getDBType(conn);
        switch (dbType) {
            case 20: {
                return "db2";
            }
            case 10: 
            case 11: {
                return "oracle";
            }
            case 50: 
            case 51: {
                return "postgresql";
            }
            case 40: 
            case 42: {
                return "mysql";
            }
            case 30: {
                return "sqlserver";
            }
            case 80: {
                return "sqlite";
            }
            case 60: {
                return "clickhouse";
            }
            case 90: {
                return "tidb";
            }
            case 100: {
                return "oceanbase";
            }
            case 110: {
                return "dm";
            }
            case 120: {
                return "kingbase";
            }
            case 150: {
                return "tdengine";
            }
            case 160: {
                return "impala";
            }
            case 170: {
                return "h2";
            }
        }
        return "";
    }

    static {
        DataSourceUtils.initialize();
    }

    public static final class DBType {
        public static final int UNDEFINE = 0;
        public static final int ORACLE = 10;
        public static final int ORACLE11 = 11;
        public static final int DB2 = 20;
        public static final int SQLSERVER = 30;
        public static final int MYSQL = 40;
        public static final int MYSQL57 = 42;
        public static final int POSTGRESQL = 50;
        public static final int POSTGRESQL15 = 51;
        public static final int CLICKHOUSE = 60;
        public static final int GAUSSDB = 70;
        public static final int SQLITE = 80;
        public static final int TIDB = 90;
        public static final int OCEANBASE = 100;
        public static final int DM = 110;
        public static final int KINGBASE = 120;
        public static final int MONGO = 130;
        public static final int ES = 140;
        public static final int TDENGINE = 150;
        public static final int IMPALA = 160;
        public static final int H2 = 170;
    }

    public static final class Dialect {
        public static final String ORACLE = "oracle";
        public static final String ORACLE11 = "oracle11";
        public static final String DB2 = "db2";
        public static final String SQLSERVER = "sqlserver";
        public static final String MYSQL = "mysql";
        public static final String MYSQL57 = "mysql57";
        public static final String INNOSQL = "innosql";
        public static final String MARIADB = "mariadb";
        public static final String POSTGRESQL = "postgresql";
        public static final String POSTGRESQL15 = "postgresql15";
        public static final String GREENPLUM = "greenplum";
        public static final String GAUSSDB = "gaussdb";
        public static final String SQLITE = "sqlite";
        public static final String MONGO = "mongo";
        public static final String ES = "elastic";
        public static final String CLICKHOUSE = "clickhouse";
        public static final String OCEANBASE = "oceanbase";
        public static final String TIDB = "tidb";
        public static final String DM = "dm";
        public static final String KINGBASE = "kingbase";
        public static final String IMPALA = "impala";
        public static final String TDENGINE = "tdengine";
        public static final String H2 = "h2";
        public static final String UNDEFINE = "UNDEFINE";
    }
}

