/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql.spatial;

import com.querydsl.sql.spatial.SQLServerGeometryReader;
import com.querydsl.sql.spatial.SQLServerGeometryWriter;
import com.querydsl.sql.types.AbstractType;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.annotation.Nullable;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.codec.Wkt;

class SQLServerGeometryType
extends AbstractType<Geometry> {
    public static final SQLServerGeometryType DEFAULT = new SQLServerGeometryType();
    private static final int DEFAULT_SRID = 4326;

    public SQLServerGeometryType() {
        super(2004);
    }

    public Class<Geometry> getReturnedClass() {
        return Geometry.class;
    }

    @Nullable
    public Geometry getValue(ResultSet rs, int startIndex) throws SQLException {
        try {
            byte[] bytes = rs.getBytes(startIndex);
            if (bytes != null) {
                return new SQLServerGeometryReader().read(bytes);
            }
            return null;
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    public void setValue(PreparedStatement st, int startIndex, Geometry value) throws SQLException {
        try {
            byte[] bytes = new SQLServerGeometryWriter().write(value);
            st.setBytes(startIndex, bytes);
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    public String getLiteral(Geometry geometry) {
        String str = Wkt.newEncoder((Wkt.Dialect)Wkt.Dialect.POSTGIS_EWKT_1).encode(geometry);
        if (geometry.getSRID() > -1) {
            return "geometry::STGeomFromText('" + str + "', " + geometry.getSRID() + ")";
        }
        return "geometry::STGeomFromText('" + str + "', " + 4326 + ")";
    }
}

