/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.common.utils;

import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.Random;
import javax.net.ServerSocketFactory;
import org.springframework.util.Assert;

public final class TcpPortAvailableUtils {
    public static final int PORT_RANGE_MIN = 1024;
    public static final int PORT_RANGE_MAX = 65535;
    private static final Random random = new Random(System.nanoTime());

    public static int findAvailableTcpPort() {
        return TcpPortAvailableUtils.findAvailableTcpPort(1024);
    }

    public static int findAvailableTcpPort(int minPort) {
        return TcpPortAvailableUtils.findAvailableTcpPort(minPort, 65535);
    }

    public static int findAvailableTcpPort(int minPort, int maxPort) {
        return SocketType.TCP.findAvailablePort(minPort, maxPort);
    }

    public static int findAvailableUdpPort() {
        return TcpPortAvailableUtils.findAvailableUdpPort(1024);
    }

    public static int findAvailableUdpPort(int minPort) {
        return TcpPortAvailableUtils.findAvailableUdpPort(minPort, 65535);
    }

    public static int findAvailableUdpPort(int minPort, int maxPort) {
        return SocketType.UDP.findAvailablePort(minPort, maxPort);
    }

    private TcpPortAvailableUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static enum SocketType {
        TCP{

            @Override
            protected boolean isPortAvailable(int port) {
                try {
                    ServerSocket serverSocket = ServerSocketFactory.getDefault().createServerSocket(port, 1, InetAddress.getByName("localhost"));
                    serverSocket.close();
                    return true;
                }
                catch (Exception ex) {
                    return false;
                }
            }
        }
        ,
        UDP{

            @Override
            protected boolean isPortAvailable(int port) {
                try {
                    DatagramSocket socket = new DatagramSocket(port, InetAddress.getByName("localhost"));
                    socket.close();
                    return true;
                }
                catch (Exception ex) {
                    return false;
                }
            }
        };


        protected abstract boolean isPortAvailable(int var1);

        private int findRandomPort(int minPort, int maxPort) {
            int portRange = maxPort - minPort;
            return minPort + random.nextInt(portRange + 1);
        }

        int findAvailablePort(int minPort, int maxPort) {
            int candidatePort;
            Assert.isTrue((minPort > 0 ? 1 : 0) != 0, (String)"'minPort' must be greater than 0");
            Assert.isTrue((maxPort >= minPort ? 1 : 0) != 0, (String)"'maxPort' must be greater than or equal to 'minPort'");
            Assert.isTrue((maxPort <= 65535 ? 1 : 0) != 0, (String)"'maxPort' must be less than or equal to 65535");
            int portRange = maxPort - minPort;
            int searchCounter = 0;
            do {
                if (searchCounter > portRange) {
                    throw new IllegalStateException(String.format("Could not find an available %s port in the range [%d, %d] after %d attempts", this.name(), minPort, maxPort, searchCounter));
                }
                candidatePort = this.findRandomPort(minPort, maxPort);
                ++searchCounter;
            } while (!this.isPortAvailable(candidatePort));
            return candidatePort;
        }
    }
}

