/*
 * Decompiled with CFR 0.152.
 */
package com.orientimport.easyfck.components;

import com.orientimport.easyfck.base.AbstractEditorTextField;
import com.orientimport.easyfck.services.FckEditorLocaleService;
import com.orientimport.easyfck.services.FckEditorService;
import com.orientimport.easyfck.util.LegacyT5ServiceHelper;
import java.util.Locale;
import org.apache.tapestry5.Asset;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.RenderSupport;
import org.apache.tapestry5.annotations.AfterRender;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.IncludeJavaScriptLibrary;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.services.ApplicationGlobals;
import org.apache.tapestry5.services.FormSupport;

@IncludeJavaScriptLibrary(value={"classpath:com/orientimport/easyfck/fckeditor/fckeditor.js"})
public class FckEditor
extends AbstractEditorTextField {
    @Parameter(defaultPrefix="literal", value="300px")
    private String _height;
    @Parameter(defaultPrefix="literal", value="600px")
    private String _width;
    @Parameter(allowNull=false)
    private Asset _configuration;
    @Parameter(defaultPrefix="literal")
    private String _skinPath;
    @Parameter(allowNull=false)
    private Locale customLocale;
    @Parameter(defaultPrefix="literal", value="Default")
    private String _toolbarSet;
    @Inject
    @Symbol(value="com.orientimport.easyfckeditor.fckeditor-context")
    private String location;
    @Environmental
    private RenderSupport _pageRenderSupport;
    @Inject
    private FckEditorService editorService;
    private String _value;
    @Inject
    private Locale locale;
    @Inject
    private ApplicationGlobals applicationGlobals;
    @Inject
    private ComponentResources componentResources;
    @Inject
    private FormSupport formSupport;

    protected final void writeFieldTag(MarkupWriter writer, String value) {
        writer.element("textarea", new Object[]{"name", this.getControlName(), "id", this.getClientId(), "cols", this.getWidth()});
        this._value = value;
    }

    @AfterRender
    final void afterRender(MarkupWriter writer) {
        if (this._value != null) {
            writer.write(this._value);
        }
        writer.end();
        this.writeScript();
    }

    final void writeScript() {
        String editorVar = "easy_fck_editor_" + this.getClientId().replace(':', '_');
        this._pageRenderSupport.addScript("var %s = new FCKeditor(\"%s\");", new Object[]{editorVar, this.getClientId()});
        this._pageRenderSupport.addScript("%s.BasePath = '%s';", new Object[]{editorVar, this.editorService.getEditorBasePath()});
        if (this._configuration != null) {
            if (this._skinPath != null) {
                this.editorService.persistEditorConfiguration(this._configuration, this._skinPath);
            } else {
                this.editorService.persistEditorConfiguration(this._configuration);
            }
            this._pageRenderSupport.addScript("%s.Config['CustomConfigurationsPath'] = '%s';", new Object[]{editorVar, this.editorService.getApplicationContext() + "assets/" + this.location + "/configure?id=" + this._configuration.getResource().getPath()});
        }
        if (this._toolbarSet != null) {
            this._pageRenderSupport.addScript("%s.ToolbarSet = '%s';", new Object[]{editorVar, this._toolbarSet});
        }
        this._pageRenderSupport.addScript("%s.Config['AutoDetectLanguage'] = false;", new Object[]{editorVar});
        if (this.componentResources.isBound("customLocale")) {
            this._pageRenderSupport.addScript("%s.Config['DefaultLanguage'] = '%s';", new Object[]{editorVar, this.customLocale.getLanguage()});
        } else {
            FckEditorLocaleService localeService = LegacyT5ServiceHelper.getService(FckEditorLocaleService.class, this.applicationGlobals.getServletContext());
            if (localeService != null && localeService.getLocale() != null) {
                this._pageRenderSupport.addScript("%s.Config['DefaultLanguage'] = '%s';", new Object[]{editorVar, localeService.getLocale().getLanguage()});
            } else {
                this._pageRenderSupport.addScript("%s.Config['DefaultLanguage'] = '%s';", new Object[]{editorVar, this.locale.getLanguage()});
            }
        }
        this._pageRenderSupport.addScript("%s.Height = '%s';", new Object[]{editorVar, this._height});
        this._pageRenderSupport.addScript("%s.Width = '%s';", new Object[]{editorVar, this._width});
        this._pageRenderSupport.addScript("%s.ReplaceTextarea();", new Object[]{editorVar});
        this._pageRenderSupport.addScript("$('%s').observe(Tapestry.FORM_PROCESS_SUBMIT_EVENT, function() { FCKeditorAPI.GetInstance('%s').UpdateLinkedField(); });", new Object[]{this.formSupport.getClientId(), this.getClientId()});
    }
}

