/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.etl.loader;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.exception.OSchemaException;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.intent.OIntent;
import com.orientechnologies.orient.core.intent.OIntentMassiveInsert;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OClassImpl;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.etl.OETLPipeline;
import com.orientechnologies.orient.etl.OETLProcessor;
import com.orientechnologies.orient.etl.loader.OAbstractLoader;
import com.orientechnologies.orient.etl.loader.OLoader;
import com.orientechnologies.orient.etl.loader.OLoaderException;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientElement;
import com.tinkerpop.blueprints.impls.orient.OrientGraph;
import com.tinkerpop.blueprints.impls.orient.OrientGraphFactory;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

public class OOrientDBLoader
extends OAbstractLoader
implements OLoader {
    protected String clusterName;
    protected String className;
    protected List<ODocument> classes;
    protected List<ODocument> indexes;
    protected OClass schemaClass;
    protected String dbURL;
    protected String dbUser = "admin";
    protected String dbPassword = "admin";
    protected boolean dbAutoCreate = true;
    protected boolean dbAutoDropIfExists = false;
    protected boolean dbAutoCreateProperties = false;
    protected boolean useLightweightEdges = false;
    protected boolean standardElementConstraints = true;
    protected boolean tx = false;
    protected int batchCommitSize = 0;
    protected AtomicLong batchCounter = new AtomicLong(0L);
    protected DB_TYPE dbType = DB_TYPE.DOCUMENT;
    protected boolean wal = true;
    protected boolean txUseLog = false;

    @Override
    public void load(OETLPipeline pipeline, Object input, OCommandContext context) {
        ODatabaseDocumentTx documentDatabase;
        if (input == null) {
            return;
        }
        if (this.dbAutoCreateProperties) {
            this.autoCreateProperties(pipeline, input);
        }
        if (this.tx && this.dbType == DB_TYPE.DOCUMENT && !(documentDatabase = pipeline.getDocumentDatabase()).getTransaction().isActive()) {
            this.beginTransaction(documentDatabase);
        }
        if (input instanceof OrientVertex) {
            OrientVertex v = (OrientVertex)input;
            if (this.clusterName != null) {
                v.save(this.clusterName);
            } else {
                v.save();
            }
        } else if (input instanceof ODocument) {
            ODocument doc = (ODocument)input;
            if (this.className != null) {
                doc.setClassName(this.className);
            }
            if (this.clusterName != null) {
                doc.save(this.clusterName);
            } else {
                doc.save();
            }
        }
        this.progress.incrementAndGet();
        if (this.batchCommitSize > 0 && this.batchCounter.get() > (long)this.batchCommitSize) {
            if (this.dbType == DB_TYPE.DOCUMENT) {
                documentDatabase = pipeline.getDocumentDatabase();
                this.log(OETLProcessor.LOG_LEVELS.DEBUG, "committing batch", new Object[0]);
                documentDatabase.commit();
                this.beginTransaction(documentDatabase);
            } else {
                this.log(OETLProcessor.LOG_LEVELS.DEBUG, "committing batch", new Object[0]);
                pipeline.getGraphDatabase().commit();
            }
            this.batchCounter.set(0L);
        } else {
            this.batchCounter.incrementAndGet();
        }
    }

    private void autoCreateProperties(OETLPipeline pipeline, Object input) {
        block5: {
            block4: {
                if (this.dbType != DB_TYPE.DOCUMENT) break block4;
                if (!(input instanceof ODocument)) break block5;
                ODocument doc = (ODocument)input;
                OClass cls = this.className != null ? this.getOrCreateClass(pipeline, this.className, null) : doc.getSchemaClass();
                for (String f : doc.fieldNames()) {
                    String newName = this.transformFieldName(f);
                    String fName = newName != null ? newName : f;
                    OProperty p = cls.getProperty(fName);
                    if (p != null) continue;
                    Object fValue = doc.field(f);
                    this.createProperty(cls, fName, fValue);
                    if (newName == null) continue;
                    doc.removeField(f);
                    doc.field(newName, fValue);
                }
                break block5;
            }
            if (this.dbType == DB_TYPE.GRAPH && input instanceof OrientElement) {
                String clsName;
                OrientElement element = (OrientElement)input;
                String string = this.className != null ? this.className : (clsName = element instanceof OrientVertex ? element.getLabel() : element.getLabel());
                if (clsName == null) {
                    throw new IllegalArgumentException("No class defined on graph element: " + input);
                }
                OClass cls = this.getOrCreateClass(pipeline, clsName, element.getBaseClassName());
                for (String f : element.getPropertyKeys()) {
                    String newName = this.transformFieldName(f);
                    String fName = newName != null ? newName : f;
                    OProperty p = cls.getProperty(fName);
                    if (p != null) continue;
                    Object fValue = element.getProperty(f);
                    this.createProperty(cls, fName, fValue);
                    if (newName == null) continue;
                    element.removeProperty(f);
                    element.setProperty(newName, fValue);
                }
            }
        }
    }

    @Override
    public String getUnit() {
        return this.dbType == DB_TYPE.DOCUMENT ? "documents" : "vertices";
    }

    @Override
    public void rollback(OETLPipeline pipeline) {
        if (this.tx) {
            if (this.dbType == DB_TYPE.DOCUMENT) {
                ODatabaseDocumentTx documentDatabase = pipeline.getDocumentDatabase();
                if (documentDatabase.getTransaction().isActive()) {
                    documentDatabase.rollback();
                }
            } else {
                pipeline.getGraphDatabase().rollback();
            }
        }
    }

    protected OClass getOrCreateClass(OETLPipeline pipeline, String iClassName, String iSuperClass) {
        OClass cls;
        if (this.dbType == DB_TYPE.DOCUMENT) {
            ODatabaseDocumentTx documentDatabase = pipeline.getDocumentDatabase();
            if (documentDatabase.getMetadata().getSchema().existsClass(iClassName)) {
                cls = documentDatabase.getMetadata().getSchema().getClass(iClassName);
            } else if (iSuperClass != null) {
                OClass superClass = documentDatabase.getMetadata().getSchema().getClass(iSuperClass);
                if (superClass == null) {
                    throw new OLoaderException("Cannot find super class '" + iSuperClass + "'");
                }
                cls = documentDatabase.getMetadata().getSchema().createClass(iClassName, superClass);
                this.log(OETLProcessor.LOG_LEVELS.DEBUG, "- OrientDBLoader: created class '%s' extends '%s'", iClassName, iSuperClass);
            } else {
                cls = documentDatabase.getMetadata().getSchema().createClass(iClassName);
                this.log(OETLProcessor.LOG_LEVELS.DEBUG, "- OrientDBLoader: created class '%s'", iClassName);
            }
        } else {
            OrientBaseGraph graphDatabase = pipeline.getGraphDatabase();
            cls = graphDatabase.getRawGraph().getMetadata().getSchema().getClass(iClassName);
            if (cls == null) {
                if (iSuperClass != null) {
                    OClass superClass = graphDatabase.getRawGraph().getMetadata().getSchema().getClass(iSuperClass);
                    if (superClass == null) {
                        throw new OLoaderException("Cannot find super class '" + iSuperClass + "'");
                    }
                    if (graphDatabase.getVertexBaseType().isSuperClassOf(superClass)) {
                        cls = graphDatabase.createVertexType(iClassName, superClass);
                        this.log(OETLProcessor.LOG_LEVELS.DEBUG, "- OrientDBLoader: created vertex class '%s' extends '%s'", iClassName, iSuperClass);
                    } else {
                        cls = graphDatabase.createEdgeType(iClassName, superClass);
                        this.log(OETLProcessor.LOG_LEVELS.DEBUG, "- OrientDBLoader: created edge class '%s' extends '%s'", iClassName, iSuperClass);
                    }
                } else {
                    cls = graphDatabase.createVertexType(iClassName);
                    this.log(OETLProcessor.LOG_LEVELS.DEBUG, "- OrientDBLoader: created vertex class '%s'", iClassName);
                }
            }
        }
        return cls;
    }

    private String transformFieldName(String f) {
        char first = f.charAt(0);
        if (Character.isDigit(first)) {
            return "field" + Character.toUpperCase(first) + (f.length() > 1 ? f.substring(1) : "");
        }
        return null;
    }

    protected void createProperty(OClass cls, String f, Object fValue) {
        if (fValue != null) {
            OType fType = OType.getTypeByClass(fValue.getClass());
            try {
                cls.createProperty(f, fType);
            }
            catch (OSchemaException oSchemaException) {
                // empty catch block
            }
            this.log(OETLProcessor.LOG_LEVELS.DEBUG, "created property [%s.%s] of type [%s]", cls.getName(), f, fType);
        }
    }

    private void beginTransaction(ODatabaseDocumentTx db) {
        db.begin();
        db.getTransaction().setUsingLog(this.txUseLog);
    }

    @Override
    public ODocument getConfiguration() {
        return new ODocument().fromJSON("{parameters:[{dbUrl:{optional:false,description:'Database URL'}},{dbUser:{optional:true,description:'Database user, default is admin'}},{dbPassword:{optional:true,description:'Database password, default is admin'}},{dbType:{optional:true,description:'Database type, default is document',values:" + this.stringArray2Json((Object[])DB_TYPE.values()) + "}}," + "{class:{optional:true,description:'Record class name'}}," + "{tx:{optional:true,description:'Transaction mode: true executes in transaction, false for atomic operations'}}," + "{dbAutoCreate:{optional:true,description:'Auto create the database if not exists. Default is true'}}," + "{dbAutoCreateProperties:{optional:true,description:'Auto create properties in schema'}}," + "{dbAutoDropIfExists:{optional:true,description:'Auto drop the database if already exists. Default is false.'}}," + "{batchCommit:{optional:true,description:'Auto commit every X items. This speed up creation of edges.'}}," + "{wal:{optional:true,description:'Use the WAL (Write Ahead Log)'}}," + "{useLightweightEdges:{optional:true,description:'Enable/Disable LightweightEdges in Graphs. Default is false'}}," + "{standardElementConstraints:{optional:true,description:'Enable/Disable Standard Blueprints constraints on names. Default is true'}}," + "{cluster:{optional:true,description:'Cluster name where to store the new record'}}," + "{settings:{optional:true,description:'OrientDB settings as a map'}}," + "{classes:{optional:true,description:'Classes used. It assure the classes exist or in case create them'}}," + "{indexes:{optional:true,description:'Indexes used. It assure the indexes exist or in case create them'}}]," + "input:['OrientVertex','ODocument']}");
    }

    @Override
    public void configure(OETLProcessor iProcessor, ODocument iConfiguration, OCommandContext iContext) {
        super.configure(iProcessor, iConfiguration, iContext);
        if (iConfiguration.containsField("dbURL")) {
            this.dbURL = (String)this.resolve(iConfiguration.field("dbURL"));
        }
        if (iConfiguration.containsField("dbUser")) {
            this.dbUser = (String)this.resolve(iConfiguration.field("dbUser"));
        }
        if (iConfiguration.containsField("dbPassword")) {
            this.dbPassword = (String)this.resolve(iConfiguration.field("dbPassword"));
        }
        if (iConfiguration.containsField("dbType")) {
            this.dbType = DB_TYPE.valueOf(iConfiguration.field("dbType").toString().toUpperCase());
        }
        if (iConfiguration.containsField("tx")) {
            this.tx = (Boolean)iConfiguration.field("tx");
        }
        if (iConfiguration.containsField("wal")) {
            this.wal = (Boolean)iConfiguration.field("wal");
        }
        if (iConfiguration.containsField("txUseLog")) {
            this.txUseLog = (Boolean)iConfiguration.field("txUseLog");
        }
        if (iConfiguration.containsField("batchCommit")) {
            this.batchCommitSize = (Integer)iConfiguration.field("batchCommit");
        }
        if (iConfiguration.containsField("dbAutoCreate")) {
            this.dbAutoCreate = (Boolean)iConfiguration.field("dbAutoCreate");
        }
        if (iConfiguration.containsField("dbAutoDropIfExists")) {
            this.dbAutoDropIfExists = (Boolean)iConfiguration.field("dbAutoDropIfExists");
        }
        if (iConfiguration.containsField("dbAutoCreateProperties")) {
            this.dbAutoCreateProperties = (Boolean)iConfiguration.field("dbAutoCreateProperties");
        }
        if (iConfiguration.containsField("useLightweightEdges")) {
            this.useLightweightEdges = (Boolean)iConfiguration.field("useLightweightEdges");
        }
        if (iConfiguration.containsField("standardElementConstraints")) {
            this.standardElementConstraints = (Boolean)iConfiguration.field("standardElementConstraints");
        }
        this.clusterName = (String)iConfiguration.field("cluster");
        this.className = (String)iConfiguration.field("class");
        this.indexes = (List)iConfiguration.field("indexes");
        this.classes = (List)iConfiguration.field("classes");
        if (iConfiguration.containsField("settings")) {
            ODocument settings = (ODocument)iConfiguration.field("settings");
            settings.setAllowChainedAccess(false);
            for (String s : settings.fieldNames()) {
                OGlobalConfiguration v = OGlobalConfiguration.findByKey((String)s);
                if (v == null) continue;
                v.setValue(settings.field(s));
            }
        }
        OGlobalConfiguration.USE_WAL.setValue((Object)this.wal);
        switch (this.dbType) {
            case DOCUMENT: {
                ODatabaseDocumentTx documentDatabase = new ODatabaseDocumentTx(this.dbURL);
                if (documentDatabase.exists() && this.dbAutoDropIfExists) {
                    this.log(OETLProcessor.LOG_LEVELS.INFO, "Dropping existent database '%s'...", this.dbURL);
                    documentDatabase.open(this.dbUser, this.dbPassword);
                    documentDatabase.drop();
                }
                if (documentDatabase.exists()) {
                    this.log(OETLProcessor.LOG_LEVELS.DEBUG, "Opening database '%s'...", this.dbURL);
                    documentDatabase.open(this.dbUser, this.dbPassword);
                } else if (this.dbAutoCreate) {
                    documentDatabase.create();
                } else {
                    throw new IllegalArgumentException("Database '" + this.dbURL + "' not exists and 'dbAutoCreate' setting is false");
                }
                documentDatabase.close();
                break;
            }
            case GRAPH: {
                OrientGraphFactory factory = new OrientGraphFactory(this.dbURL, this.dbUser, this.dbPassword);
                if (this.dbAutoDropIfExists && factory.exists()) {
                    this.log(OETLProcessor.LOG_LEVELS.INFO, "Dropping existent database '%s'...", this.dbURL);
                    factory.drop();
                }
                OrientGraph graphDatabase = this.tx ? factory.getTx() : factory.getNoTx();
                graphDatabase.shutdown();
            }
        }
    }

    @Override
    public void begin() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beginLoader(OETLPipeline pipeline) {
        OOrientDBLoader oOrientDBLoader = this;
        synchronized (oOrientDBLoader) {
            ODatabaseDocumentTx documentDatabase = null;
            OrientGraph graphDatabase = null;
            switch (this.dbType) {
                case DOCUMENT: {
                    documentDatabase = new ODatabaseDocumentTx(this.dbURL);
                    documentDatabase.open(this.dbUser, this.dbPassword);
                    break;
                }
                case GRAPH: {
                    OrientGraphFactory factory = new OrientGraphFactory(this.dbURL, this.dbUser, this.dbPassword);
                    graphDatabase = this.tx ? factory.getTx() : factory.getNoTx();
                    graphDatabase.setUseLightweightEdges(this.useLightweightEdges);
                    graphDatabase.setStandardElementConstraints(this.standardElementConstraints);
                    pipeline.setGraphDatabase((OrientBaseGraph)graphDatabase);
                    documentDatabase = graphDatabase.getRawGraph();
                }
            }
            pipeline.setDocumentDatabase(documentDatabase);
            pipeline.setGraphDatabase((OrientBaseGraph)graphDatabase);
            if (this.classes != null) {
                for (ODocument cls : this.classes) {
                    this.schemaClass = this.getOrCreateClass(pipeline, (String)cls.field("name"), (String)cls.field("extends"));
                    Integer clusters = (Integer)cls.field("clusters");
                    if (clusters != null) {
                        OClassImpl.addClusters((OClass)this.schemaClass, (int)clusters);
                    }
                    this.log(OETLProcessor.LOG_LEVELS.DEBUG, "%s: found %d %s in class '%s'", this.getName(), this.schemaClass.count(), this.getUnit(), this.className);
                }
            }
            if (this.className != null) {
                this.schemaClass = this.getOrCreateClass(pipeline, this.className, null);
                this.log(OETLProcessor.LOG_LEVELS.DEBUG, "%s: found %d %s in class '%s'", this.getName(), this.schemaClass.count(), this.getUnit(), this.className);
            }
            if (this.indexes != null) {
                for (ODocument idx : this.indexes) {
                    OIndex index;
                    ODocument metadata = (ODocument)this.resolve(idx.field("metadata"));
                    this.log(OETLProcessor.LOG_LEVELS.DEBUG, "%s: found metadata field '%s'", this.getName(), metadata);
                    String idxName = (String)this.resolve(idx.field("name"));
                    if (idxName != null && (index = documentDatabase.getMetadata().getIndexManager().getIndex(idxName)) != null) continue;
                    String idxClass = (String)this.resolve(idx.field("class"));
                    if (idxClass == null) {
                        throw new OConfigurationException("Index 'class' missed in OrientDB Loader");
                    }
                    OClass cls = this.getOrCreateClass(pipeline, idxClass, null);
                    String idxType = (String)idx.field("type");
                    if (idxType == null) {
                        throw new OConfigurationException("Index 'type' missed in OrientDB Loader for index '" + idxName + "'");
                    }
                    List idxFields = (List)idx.field("fields");
                    if (idxFields == null) {
                        throw new OConfigurationException("Index 'fields' missed in OrientDB Loader");
                    }
                    String[] fields = new String[idxFields.size()];
                    for (int f = 0; f < fields.length; ++f) {
                        String fieldName = (String)idxFields.get(f);
                        String[] fieldNameParts = fieldName.split(":");
                        if (!cls.existsProperty(fieldNameParts[0])) {
                            if (fieldNameParts.length < 2) {
                                throw new OConfigurationException("Index field type missed in OrientDB Loader for field '" + fieldName + "'");
                            }
                            String fieldType = fieldNameParts[1].toUpperCase();
                            OType type = OType.valueOf((String)fieldType);
                            cls.createProperty(fieldNameParts[0], type);
                            this.log(OETLProcessor.LOG_LEVELS.DEBUG, "- OrientDBLoader: created property '%s.%s' of type: %s", idxClass, fieldNameParts[0], fieldNameParts[1]);
                        }
                        fields[f] = fieldNameParts[0];
                    }
                    if (idxName == null) {
                        idxName = idxClass + ".";
                        for (int i = 0; i < fields.length; ++i) {
                            if (i > 0) {
                                idxName = idxName + '_';
                            }
                            idxName = idxName + fields[i];
                        }
                    }
                    if ((index = documentDatabase.getMetadata().getIndexManager().getIndex(idxName)) != null) continue;
                    index = cls.createIndex(idxName, idxType, null, metadata, fields);
                    this.log(OETLProcessor.LOG_LEVELS.DEBUG, "- OrientDocumentLoader: created index '%s' type '%s' against Class '%s', fields %s", idxName, idxType, idxClass, idxFields);
                }
            }
            documentDatabase.declareIntent((OIntent)new OIntentMassiveInsert());
        }
    }

    @Override
    public void endLoader(OETLPipeline pipeline) {
        this.log(OETLProcessor.LOG_LEVELS.INFO, "committing", new Object[0]);
        if (this.dbType == DB_TYPE.DOCUMENT) {
            pipeline.getDocumentDatabase().commit();
        } else {
            pipeline.getGraphDatabase().commit();
        }
    }

    @Override
    public void end() {
    }

    @Override
    public String getName() {
        return "orientdb";
    }

    protected static enum DB_TYPE {
        DOCUMENT,
        GRAPH;

    }
}

