/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.Connection;
import java.sql.ParameterMetaData;
import java.sql.SQLException;
import java.sql.SQLSyntaxErrorException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.LRUParameterMetadataCache;
import oracle.jdbc.driver.OracleParameterMetaDataParser;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OracleSql;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.utils.SQLTokenizer;
import oracle.jdbc.internal.OracleConnection;

class OracleParameterMetaData
implements oracle.jdbc.internal.OracleParameterMetaData {
    static final Set<Integer> BAD_SQL = Collections.synchronizedSet(new HashSet());
    static final int BAD_SQL_LIMIT = 10000;
    private static final LRUParameterMetadataCache cache;
    int parameterCount;
    OracleParameterMetaDataParser.ParameterMetadataSql pmdSql;
    OracleParameterMetaDataParser.ParameterMetadataSql[] pmdSqls;
    ParameterMetaData compressedParamMetadata;
    CompressedStatement compressedStatement;
    int[] isNullable;
    boolean[] isSigned;
    int[] precision;
    int[] scale;
    int[] parameterType;
    String[] parameterTypeName;
    String[] parameterClassName;
    int[] parameterMode;
    boolean throwUnsupportedFeature;
    boolean isPlsqlOrCall;
    boolean isReturningParameters;
    SQLSyntaxErrorException syntaxError;
    int parameterNoNulls;
    int parameterNullable;
    int parameterNullableUnknown;
    int parameterModeUnknown;
    int parameterModeIn;
    int parameterModeInOut;
    int parameterModeOut;
    Object acProxy;

    static final ParameterMetaData getParameterMetaData(OracleSql sqlObject, Connection connection, OraclePreparedStatement stmt) throws SQLException {
        ParameterMetaData result = null;
        String sql = sqlObject.getOriginalSql();
        int paramCount = sqlObject.getParameterCount();
        if (paramCount != 0 && !sqlObject.sqlKind.isPlsqlOrCall() && sqlObject.getReturnParameterCount() < 1 && !BAD_SQL.contains(sql.hashCode())) {
            CompressedStatement compressedStatement = null;
            PhysicalConnection pConnection = (PhysicalConnection)connection;
            if (paramCount > 0 && pConnection.parameterMetadataPreprocess) {
                compressedStatement = OracleParameterMetaData.compressInClauses(sqlObject);
                sql = compressedStatement.compressedStatement;
                if (sqlObject.getOriginalSql().length() != sql.length()) {
                    sqlObject = new OracleSql(pConnection.conversion);
                    sqlObject.initialize(sql);
                    sqlObject.computeBasicInfo();
                }
            }
            if (cache != null && (result = cache.searchCache(sql, pConnection.sessionProperties.getProperty("AUTH_DB_ID"), connection.getSchema(), connection.getMetaData().getUserName())) != null) {
                if (compressedStatement != null) {
                    return new OracleParameterMetaData((OracleParameterMetaData)result, compressedStatement);
                }
                return result;
            }
            OracleParameterMetaData _result = new OracleParameterMetaData(connection, sqlObject);
            if (_result.syntaxError != null) {
                stmt.sqlWarning = DatabaseError.addSqlWarning(stmt.sqlWarning, _result.syntaxError.getMessage(), _result.syntaxError.getErrorCode());
                if (compressedStatement != null) {
                    return new OracleParameterMetaData(_result, compressedStatement);
                }
                return _result;
            }
            result = _result;
            if (cache != null && result != null) {
                cache.add(result, sql, pConnection.sessionProperties.getProperty("AUTH_DB_ID"), connection.getSchema(), connection.getMetaData().getUserName());
            }
            if (compressedStatement != null && result != null) {
                result = new OracleParameterMetaData((OracleParameterMetaData)result, compressedStatement);
            }
        } else {
            result = new OracleParameterMetaData(sqlObject.sqlKind.isPlsqlOrCall(), sqlObject.getReturnParameterCount() > 0, paramCount);
        }
        return result;
    }

    private OracleParameterMetaData(Connection conn, OracleSql sqlObject) throws SQLException {
        block5: {
            this.parameterCount = 0;
            this.pmdSql = null;
            this.pmdSqls = null;
            this.compressedParamMetadata = null;
            this.compressedStatement = null;
            this.throwUnsupportedFeature = false;
            this.isPlsqlOrCall = false;
            this.isReturningParameters = false;
            this.syntaxError = null;
            this.parameterNoNulls = 0;
            this.parameterNullable = 1;
            this.parameterNullableUnknown = 2;
            this.parameterModeUnknown = 0;
            this.parameterModeIn = 1;
            this.parameterModeInOut = 2;
            this.parameterModeOut = 4;
            if (sqlObject == null) {
                throw new IllegalArgumentException("sqlObject can not be null");
            }
            String sql = sqlObject.originalSql;
            this.parameterCount = sqlObject.parameterCount;
            OracleParameterMetaDataParser parser = new OracleParameterMetaDataParser();
            parser.initialize(sql, sqlObject.sqlKind, this.parameterCount);
            this.pmdSql = parser.getParameterMetaDataSql();
            try {
                this.query(conn);
            }
            catch (SQLSyntaxErrorException e) {
                if (!e.getMessage().startsWith("ORA-00918")) break block5;
                try {
                    this.pmdSql = null;
                    this.pmdSqls = parser.getParameterMetaDataSqls();
                    this.query(conn);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private OracleParameterMetaData(boolean _isPlsqlOrCall, boolean _isReturningParameters, int _parameterCount) throws SQLException {
        this.parameterCount = 0;
        this.pmdSql = null;
        this.pmdSqls = null;
        this.compressedParamMetadata = null;
        this.compressedStatement = null;
        this.throwUnsupportedFeature = false;
        this.isPlsqlOrCall = false;
        this.isReturningParameters = false;
        this.syntaxError = null;
        this.parameterNoNulls = 0;
        this.parameterNullable = 1;
        this.parameterNullableUnknown = 2;
        this.parameterModeUnknown = 0;
        this.parameterModeIn = 1;
        this.parameterModeInOut = 2;
        this.parameterModeOut = 4;
        this.isPlsqlOrCall = _isPlsqlOrCall;
        this.isReturningParameters = _isReturningParameters;
        this.parameterCount = _parameterCount;
        this.throwUnsupportedFeature = true;
    }

    private OracleParameterMetaData(OracleParameterMetaData parentParamMetadata, CompressedStatement compressedStatement) throws SQLException {
        this.parameterCount = 0;
        this.pmdSql = null;
        this.pmdSqls = null;
        this.compressedParamMetadata = null;
        this.compressedStatement = null;
        this.throwUnsupportedFeature = false;
        this.isPlsqlOrCall = false;
        this.isReturningParameters = false;
        this.syntaxError = null;
        this.parameterNoNulls = 0;
        this.parameterNullable = 1;
        this.parameterNullableUnknown = 2;
        this.parameterModeUnknown = 0;
        this.parameterModeIn = 1;
        this.parameterModeInOut = 2;
        this.parameterModeOut = 4;
        this.compressedStatement = compressedStatement;
        this.parameterCount = compressedStatement.nbBindsInCompressedStatement;
        this.syntaxError = parentParamMetadata.syntaxError;
        if (parentParamMetadata.pmdSql != null) {
            this.pmdSql = parentParamMetadata.pmdSql;
            this.storeParametersMetadata(this.pmdSql);
        } else if (parentParamMetadata.pmdSqls != null) {
            for (OracleParameterMetaDataParser.ParameterMetadataSql myPmdSql : this.pmdSqls = parentParamMetadata.pmdSqls) {
                this.storeParametersMetadata(myPmdSql);
            }
        }
    }

    private static CompressedStatement compressInClauses(OracleSql sqlObject) {
        if (sqlObject == null) {
            throw new IllegalArgumentException();
        }
        StringBuilder compressedStatementBuilder = new StringBuilder();
        boolean inINClause = false;
        int parentheseTracker = 0;
        boolean isFirstBindInINClause = true;
        int nbDuplicateBinds = 0;
        int lastToken = 0;
        int lastCommaInINClauseIndex = -1;
        int parameterCount = 0;
        ArrayList<Integer> compressedBindsList = new ArrayList<Integer>();
        for (int i = 0; i < sqlObject.sqlTokenizer.getNbTokens(); ++i) {
            SQLTokenizer.TokenType currentToken = sqlObject.sqlTokenizer.getTokenType(i);
            if (i > 0 && currentToken == SQLTokenizer.TokenType.OPEN_PARENTHESE && lastToken > 0 && sqlObject.sqlTokenizer.getTokenLength(lastToken) == 2 && "IN".equalsIgnoreCase(sqlObject.sqlTokenizer.getToken(lastToken))) {
                inINClause = true;
                compressedStatementBuilder.append(sqlObject.sqlTokenizer.getToken(i));
                continue;
            }
            if (inINClause) {
                if (parentheseTracker > 0) {
                    if (currentToken == SQLTokenizer.TokenType.OPEN_PARENTHESE) {
                        ++parentheseTracker;
                        continue;
                    }
                    if (currentToken != SQLTokenizer.TokenType.CLOSE_PARENTHESE) continue;
                    --parentheseTracker;
                    continue;
                }
                if (currentToken == SQLTokenizer.TokenType.CLOSE_PARENTHESE) {
                    inINClause = false;
                    isFirstBindInINClause = true;
                    compressedStatementBuilder.append(sqlObject.sqlTokenizer.getToken(i));
                    continue;
                }
                if (currentToken == SQLTokenizer.TokenType.BIND) {
                    if (isFirstBindInINClause) {
                        compressedStatementBuilder.append(sqlObject.sqlTokenizer.getToken(i));
                        isFirstBindInINClause = false;
                    } else {
                        ++nbDuplicateBinds;
                    }
                    compressedBindsList.add(parameterCount - nbDuplicateBinds);
                    ++parameterCount;
                    continue;
                }
                if (currentToken == SQLTokenizer.TokenType.COMMA) {
                    lastCommaInINClauseIndex = i;
                    continue;
                }
                if (currentToken == SQLTokenizer.TokenType.TOKEN && sqlObject.sqlTokenizer.getTokenLength(i) == 6 && "SELECT".equalsIgnoreCase(sqlObject.sqlTokenizer.getToken(i))) {
                    inINClause = false;
                    isFirstBindInINClause = true;
                    compressedStatementBuilder.append(sqlObject.sqlTokenizer.getToken(i));
                    continue;
                }
                if (currentToken == SQLTokenizer.TokenType.WHITESPACES || currentToken == SQLTokenizer.TokenType.COMMENT) continue;
                if (lastCommaInINClauseIndex > 0) {
                    for (int j = lastCommaInINClauseIndex; j <= i; ++j) {
                        compressedStatementBuilder.append(sqlObject.sqlTokenizer.getToken(j));
                    }
                    continue;
                }
                compressedStatementBuilder.append(sqlObject.sqlTokenizer.getToken(i));
                continue;
            }
            if (currentToken == SQLTokenizer.TokenType.BIND) {
                compressedBindsList.add(parameterCount - nbDuplicateBinds);
                ++parameterCount;
            } else if (currentToken == SQLTokenizer.TokenType.TOKEN) {
                lastToken = i;
            }
            compressedStatementBuilder.append(sqlObject.sqlTokenizer.getToken(i));
        }
        int[] compressedBinds = new int[compressedBindsList.size()];
        for (int j = 0; j < compressedBinds.length; ++j) {
            compressedBinds[j] = (Integer)compressedBindsList.get(j);
        }
        return new CompressedStatement(compressedStatementBuilder.toString(), sqlObject.parameterCount - nbDuplicateBinds, compressedBinds);
    }

    private void storeParametersMetadata(OracleParameterMetaDataParser.ParameterMetadataSql myPmdSql) {
        OracleParameterMetaDataParser.ParameterMetadataSql.ParameterMetadata[] binds = myPmdSql.getParametersMetadata();
        if (this.syntaxError != null) {
            return;
        }
        if (this.isNullable == null) {
            this.isNullable = new int[this.parameterCount];
            this.isSigned = new boolean[this.parameterCount];
            this.precision = new int[this.parameterCount];
            this.scale = new int[this.parameterCount];
            this.parameterType = new int[this.parameterCount];
            this.parameterTypeName = new String[this.parameterCount];
            this.parameterClassName = new String[this.parameterCount];
            this.parameterMode = new int[this.parameterCount];
        }
        for (int j = 0; j < binds.length; ++j) {
            int arrayPos = binds[j].bindNumber - 1;
            this.isNullable[arrayPos] = binds[j].isNullable;
            this.isSigned[arrayPos] = binds[j].isSigned;
            this.precision[arrayPos] = binds[j].precision;
            this.scale[arrayPos] = binds[j].scale;
            this.parameterType[arrayPos] = binds[j].parameterType;
            this.parameterTypeName[arrayPos] = binds[j].parameterTypeName;
            this.parameterClassName[arrayPos] = binds[j].parameterClassName;
            this.parameterMode[arrayPos] = binds[j].parameterMode;
        }
    }

    @Override
    public void query(Connection conn) throws SQLException {
        block9: {
            this.syntaxError = null;
            if (this.compressedParamMetadata != null) {
                throw new UnsupportedOperationException();
            }
            try {
                if (this.pmdSqls != null) {
                    int allParametersFound = 0;
                    for (OracleParameterMetaDataParser.ParameterMetadataSql myPmdSql : this.pmdSqls) {
                        int nbParametersFound = myPmdSql.getNbParameters();
                        myPmdSql.query(conn);
                        if ((allParametersFound += nbParametersFound) > this.parameterCount) {
                            throw new SQLException("ParameterMetadata MultiSQLs returned an invalid number of parameters");
                        }
                        this.storeParametersMetadata(myPmdSql);
                    }
                    break block9;
                }
                if (this.pmdSql != null) {
                    if (this.pmdSql.getNbParameters() != this.parameterCount) {
                        throw new SQLSyntaxErrorException("Error parsing statement");
                    }
                    this.pmdSql.query(conn);
                    this.storeParametersMetadata(this.pmdSql);
                    break block9;
                }
                if (this.isPlsqlOrCall || this.isReturningParameters) {
                    return;
                }
                throw new SQLException("Could not parse Statement");
            }
            catch (SQLSyntaxErrorException e) {
                this.syntaxError = e;
                throw e;
            }
        }
    }

    @Override
    public int getParameterCount() throws SQLException {
        if (this.compressedStatement != null) {
            return this.compressedStatement.compressedBinds.length;
        }
        return this.parameterCount;
    }

    void checkValidIndex(int index) throws SQLException {
        if (this.throwUnsupportedFeature) {
            if (this.isPlsqlOrCall) {
                throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("API not supported with PL/SQL").fillInStackTrace();
            }
            if (this.isReturningParameters) {
                throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("API not supported with DML returning").fillInStackTrace();
            }
            throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("checkValidIndex").fillInStackTrace();
        }
        if (this.syntaxError != null) {
            throw new SQLSyntaxErrorException(this.syntaxError.getMessage(), this.syntaxError.getSQLState(), this.syntaxError.getErrorCode(), this.syntaxError.getCause());
        }
        if (!(index >= 1 && index <= this.parameterCount || this.compressedStatement != null && this.compressedStatement.compressedBinds != null && index <= this.compressedStatement.compressedBinds.length)) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
        }
    }

    @Override
    public int isNullable(int param) throws SQLException {
        this.checkValidIndex(param);
        if (this.compressedStatement != null) {
            return this.isNullable[this.compressedStatement.compressedBinds[param - 1]];
        }
        return this.isNullable[param - 1];
    }

    @Override
    public boolean isSigned(int param) throws SQLException {
        this.checkValidIndex(param);
        if (this.compressedStatement != null) {
            return this.isSigned[this.compressedStatement.compressedBinds[param - 1]];
        }
        return this.isSigned[param - 1];
    }

    @Override
    public int getPrecision(int param) throws SQLException {
        this.checkValidIndex(param);
        if (this.compressedStatement != null) {
            return this.precision[this.compressedStatement.compressedBinds[param - 1]];
        }
        return this.precision[param - 1];
    }

    @Override
    public int getScale(int param) throws SQLException {
        this.checkValidIndex(param);
        if (this.compressedStatement != null) {
            return this.scale[this.compressedStatement.compressedBinds[param - 1]];
        }
        return this.scale[param - 1];
    }

    @Override
    public int getParameterType(int param) throws SQLException {
        this.checkValidIndex(param);
        if (this.compressedStatement != null) {
            return this.parameterType[this.compressedStatement.compressedBinds[param - 1]];
        }
        return this.parameterType[param - 1];
    }

    @Override
    public String getParameterTypeName(int param) throws SQLException {
        this.checkValidIndex(param);
        if (this.compressedStatement != null) {
            return this.parameterTypeName[this.compressedStatement.compressedBinds[param - 1]];
        }
        return this.parameterTypeName[param - 1];
    }

    @Override
    public String getParameterClassName(int param) throws SQLException {
        this.checkValidIndex(param);
        if (this.compressedStatement != null) {
            return this.parameterClassName[this.compressedStatement.compressedBinds[param - 1]];
        }
        return this.parameterClassName[param - 1];
    }

    @Override
    public int getParameterMode(int param) throws SQLException {
        this.checkValidIndex(param);
        if (this.compressedStatement != null) {
            return this.parameterMode[this.compressedStatement.compressedBinds[param - 1]];
        }
        return this.parameterMode[param - 1];
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        if (iface.isInterface()) {
            return iface.isInstance(this);
        }
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 177).fillInStackTrace();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInterface() && iface.isInstance(this)) {
            return (T)this;
        }
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 177).fillInStackTrace();
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    @Override
    public void setACProxy(Object w) {
        this.acProxy = w;
    }

    @Override
    public Object getACProxy() {
        return this.acProxy;
    }

    static {
        Integer parameterMetadataCacheSize = null;
        try {
            parameterMetadataCacheSize = Integer.valueOf(System.getProperty("oracle.jdbc.parameterMetadataCacheSize"));
        }
        catch (NumberFormatException e) {
            parameterMetadataCacheSize = 0;
        }
        if (parameterMetadataCacheSize > 0) {
            LRUParameterMetadataCache myCache = null;
            try {
                myCache = new LRUParameterMetadataCache(parameterMetadataCacheSize);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            cache = myCache;
        } else {
            cache = null;
        }
    }

    static class CompressedStatement {
        private String compressedStatement;
        private int nbBindsInCompressedStatement;
        private int[] compressedBinds;

        private CompressedStatement(String compressedStatement, int nbBindsInCompressedStatement, int[] compressedBinds) {
            this.compressedStatement = compressedStatement;
            this.nbBindsInCompressedStatement = nbBindsInCompressedStatement;
            this.compressedBinds = compressedBinds;
        }
    }
}

