/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.datasource.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.util.Enumeration;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceAlreadyExistsException;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.net.ssl.SSLContext;
import oracle.jdbc.AccessToken;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleHostnameResolver;
import oracle.jdbc.datasource.impl.OracleConnectionBuilderImpl;
import oracle.jdbc.diagnostics.CommonDiagnosable;
import oracle.jdbc.diagnostics.Diagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.internal.AbstractConnectionBuilder;
import oracle.jdbc.internal.CompletionStageUtil;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OpaqueString;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.PropertiesBlinder;
import oracle.jdbc.proxy.ProxyFactory;
import oracle.jdbc.replay.ReplayStatistics;
import oracle.jdbc.replay.driver.NonTxnReplayableArray;
import oracle.jdbc.replay.driver.NonTxnReplayableBase;
import oracle.jdbc.replay.driver.NonTxnReplayableBfile;
import oracle.jdbc.replay.driver.NonTxnReplayableBlob;
import oracle.jdbc.replay.driver.NonTxnReplayableClob;
import oracle.jdbc.replay.driver.NonTxnReplayableConnection;
import oracle.jdbc.replay.driver.NonTxnReplayableNClob;
import oracle.jdbc.replay.driver.NonTxnReplayableOpaque;
import oracle.jdbc.replay.driver.NonTxnReplayableOthers;
import oracle.jdbc.replay.driver.NonTxnReplayableRef;
import oracle.jdbc.replay.driver.NonTxnReplayableResultSet;
import oracle.jdbc.replay.driver.NonTxnReplayableStatement;
import oracle.jdbc.replay.driver.NonTxnReplayableStruct;
import oracle.jdbc.replay.driver.ReplayStatisticsMBeanImpl;
import oracle.jdbc.replay.driver.StatisticsTracker;
import oracle.jdbc.replay.driver.TxnReplayableArray;
import oracle.jdbc.replay.driver.TxnReplayableBase;
import oracle.jdbc.replay.driver.TxnReplayableBfile;
import oracle.jdbc.replay.driver.TxnReplayableBlob;
import oracle.jdbc.replay.driver.TxnReplayableClob;
import oracle.jdbc.replay.driver.TxnReplayableConnection;
import oracle.jdbc.replay.driver.TxnReplayableNClob;
import oracle.jdbc.replay.driver.TxnReplayableOpaque;
import oracle.jdbc.replay.driver.TxnReplayableOthers;
import oracle.jdbc.replay.driver.TxnReplayableRef;
import oracle.jdbc.replay.driver.TxnReplayableResultSet;
import oracle.jdbc.replay.driver.TxnReplayableSqlxml;
import oracle.jdbc.replay.driver.TxnReplayableStatement;
import oracle.jdbc.replay.driver.TxnReplayableStruct;
import oracle.jdbc.replay.internal.ConnectionInitializationCallback;
import oracle.jdbc.replay.internal.ReplayableConnection;

public class OracleDataSource
implements oracle.jdbc.datasource.OracleDataSource,
Diagnosable,
oracle.jdbc.replay.internal.OracleDataSource,
Serializable,
Referenceable,
Monitor {
    static final long serialVersionUID = 3349652938965166731L;
    protected static int unnamedInstanceCount = 0;
    protected static final String DMS_ROOT_NAME = "JDBC";
    protected static final String DMS_DEFAULT_DATASOURCE_NAME = "OracleDataSource";
    private static final String CLASS_NAME = OracleDataSource.class.getName();
    protected static final String DEFAULT_SERVICE_NAME = "SYS$USERS";
    protected PrintWriter logWriter = null;
    protected int loginTimeout = 0;
    protected String databaseName = null;
    protected String serviceName = null;
    protected String dataSourceName = "OracleDataSource";
    protected String description = null;
    protected String networkProtocol = "tcp";
    protected int portNumber = 0;
    protected String user = null;
    protected OpaqueString password = null;
    protected String serverName = null;
    protected String url = null;
    protected String driverType = null;
    protected String tnsEntry = null;
    protected int maxStatements = 0;
    protected boolean implicitCachingEnabled = false;
    protected boolean explicitCachingEnabled = false;
    protected boolean maxStatementsSet = false;
    protected boolean implicitCachingEnabledSet = false;
    protected boolean explicitCachingEnabledSet = false;
    protected Properties connectionProperties = null;
    public boolean isOracleDataSource = true;
    private String roleName = null;
    private boolean urlExplicit = false;
    private boolean useDefaultConnection = false;
    protected transient OracleDriver driver = new OracleDriver();
    private final Monitor.CloseableLock monitorLock = Monitor.newDefaultLock();
    private SSLContext sslContext;
    private boolean allowSingleShardTransaction;
    private OracleHostnameResolver hostnameResolver;
    private Supplier<? extends AccessToken> tokenSupplier;
    private static ProxyFactory PROXY_FACTORY = null;
    private static ProxyFactory NON_TXN_PROXY_FACTORY = null;
    private static final Monitor proxyFactoryLock = Monitor.newInstance();
    private transient ConnectionInitializationCallback connectionInitializationCallback = null;
    protected AtomicBoolean isFirstConnection = new AtomicBoolean(true);
    protected static final String RECONNECT_DELAY_PROPERTY = "AUTH_FAILOVER_DELAY";
    protected static final String RECONNECT_RETRIES_PROPERTY = "AUTH_FAILOVER_RETRIES";
    protected int reconnectDelay = 10;
    protected int reconnectRetries = 30;
    protected static final String FAILOVER_TYPE_PROPERTY = "AUTH_FAILOVER_TYPE";
    protected static final int FAILOVER_TYPE_TRANSACTION = 8;
    protected static final int SESSION_STATE_CONSISTENCY_STATIC = 16;
    protected static final int FAILOVER_TYPE_AUTO = 32;
    protected static final int SESSION_STATE_CONSISTENCY_HYBRID = 256;
    protected static final int FAILOVER_TYPE_ON_REMOTE = 512;
    protected boolean isTransactionReplayEnabled = false;
    protected boolean isAutoACEnabled = false;
    protected static final String SESSION_STATE_PROPERTY = "AUTH_SESSION_STATE_CONSISTENCY";
    protected boolean isReplayInDynamicMode = true;
    protected boolean isHybrid = false;
    protected static final String FAILOVER_RESTORE_PROPERTY = "AUTH_FAILOVER_RESTORE";
    protected static final int FAILOVER_RESTORE_NONE = 0;
    protected static final int FAILOVER_RESTORE_LEVEL1 = 1;
    protected static final int FAILOVER_RESTORE_LEVEL2 = 2;
    protected static final int FAILOVER_RESTORE_AUTO = 3;
    protected ReplayableConnection.StateRestorationType stateRestorationType = ReplayableConnection.StateRestorationType.NONE;
    protected boolean isStateRestorationAuto = false;
    protected static final String INITIATION_TIMEOUT_PROPERTY = "AUTH_FAILOVER_REPLAYTIMEOUT";
    protected int replayInitiationTimeout = 300;
    protected static final String CHECKSUM_PROPERTY = "oracle.jdbc.calculateChecksum";
    protected final String clientChecksum12x = OracleConnection.ChecksumMode.CALCULATE_CHECKSUM_BINDS.toString();
    protected final String clientChecksum11203x = OracleConnection.ChecksumMode.CALCULATE_CHECKSUM_ALL.toString();
    protected static final String IGNORE_AC_CONTEXT_PROPERTY = "oracle.jdbc.ignoreReplayContextFromAuthentication";
    private static final String AC_11203_COMPATIBLE_SYSTEM_PROPERTY = "oracle.jdbc.AC11203Compatible";
    private static final String IMPLICIT_BEGIN_REQUEST_SYSTEM_PROPERTY = "oracle.jdbc.beginRequestAtConnectionCreation";
    protected static final String ENABLE_AC_SUPPORT_PROPERTY = "oracle.jdbc.enableACSupport";
    protected static final String REQUEST_SIZE_LIMIT_PROPERTY = "oracle.jdbc.replay.protectedRequestSizeLimit";
    protected static final String ENABLE_SSS_CURSOR_SUPPORT_PROPERTY = "oracle.jdbc.enableSSSCursor";
    protected boolean isSSSCursorEnabled = false;
    protected final AtomicBoolean trackerInitialized = new AtomicBoolean(false);
    private StatisticsTracker tracker = null;
    protected AtomicBoolean doneDumpOnMemoryPressure = new AtomicBoolean(false);
    private static final String registeredName = "com.oracle.jdbc:type=ReplayStatistics,name=";
    private static ObjectName mbeanName;
    private static final String _Copyright_2014_Oracle_All_Rights_Reserved_;
    public static final boolean TRACE = false;

    protected static String dms_data_source_type() {
        return "JDBC_DataSource";
    }

    @Override
    public Connection getConnection() throws SQLException {
        String localUser = null;
        OpaqueString localPassword = OpaqueString.NULL;
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            localUser = this.user;
            localPassword = this.password;
        }
        return this.getConnection(localUser, localPassword);
    }

    @Override
    public Connection getConnection(String user, @Blind String password) throws SQLException {
        return this.getConnection(user, OpaqueString.newOpaqueString(password));
    }

    protected Connection getConnection(String _user, OpaqueString _passwd) throws SQLException {
        OracleConnectionBuilderImpl connectionBuilder = (OracleConnectionBuilderImpl)((OracleConnectionBuilderImpl)this.createConnectionBuilder().user(_user)).password(_passwd);
        boolean useProxy = this.isACSupportPropertySet();
        return this.getConnectionInternal(connectionBuilder, useProxy);
    }

    protected Connection getConnection(OracleConnectionBuilderImpl builder) throws SQLException {
        Properties prop;
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            OracleDataSource.validateGSSCredentialConfiguration(builder);
            this.makeURL();
            prop = this.connectionProperties == null ? new Properties() : (Properties)this.connectionProperties.clone();
            this.applyDataSourcePropertiesForGetConnectionWithBuilder(prop);
            OracleDataSource.applyBuilderProperties(builder, prop);
        }
        Connection conn = this.getPhysicalConnection(prop, builder);
        if (conn == null) {
            throw (SQLException)DatabaseError.createSqlException(67).fillInStackTrace();
        }
        return conn;
    }

    private final CompletionStage<OracleConnection> getConnectionAsync(OracleConnectionBuilderImpl builder) {
        Properties prop;
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            OracleDataSource.validateGSSCredentialConfiguration(builder);
            this.makeURL();
            prop = this.connectionProperties == null ? new Properties() : (Properties)this.connectionProperties.clone();
            this.applyDataSourcePropertiesForGetConnectionWithBuilder(prop);
            OracleDataSource.applyBuilderProperties(builder, prop);
        }
        catch (SQLException preConnectFailure) {
            return CompletionStageUtil.failedStage(preConnectFailure);
        }
        try {
            return this.getPhysicalConnectionAsync(prop, builder).thenApply(conn -> {
                if (conn == null) {
                    throw new CompletionException(DatabaseError.createSqlException(67).fillInStackTrace());
                }
                return conn;
            });
        }
        catch (Exception exception) {
            return CompletionStageUtil.failedStage(exception);
        }
    }

    private static final void validateGSSCredentialConfiguration(OracleConnectionBuilderImpl builder) throws SQLException {
        if (builder.getGSSCredential() != null && (builder.getUser() != null || builder.getPassword() != null && builder.getPassword() != OpaqueString.NULL)) {
            throw (SQLException)DatabaseError.createSqlException(68, "GSSCredential and user/password cannot both be set in a connection builder.").fillInStackTrace();
        }
    }

    private final void applyDataSourcePropertiesForGetConnectionWithBuilder(@Blind(value=PropertiesBlinder.class) Properties prop) {
        if (this.url != null) {
            prop.setProperty("connection_url", this.url);
        }
        if (this.loginTimeout != 0) {
            prop.setProperty("oracle.jdbc.loginTimeout", String.valueOf(this.loginTimeout));
        }
        if (this.maxStatementsSet) {
            prop.setProperty("stmt_cache_size", String.valueOf(this.maxStatements));
        }
    }

    private static final void applyBuilderProperties(OracleConnectionBuilderImpl builder, @Blind(value=PropertiesBlinder.class) Properties connectionProperties) throws SQLException {
        if (builder.getUser() != null) {
            connectionProperties.setProperty("user", builder.getUser());
        }
        if (!OpaqueString.isNull(builder.getPassword())) {
            connectionProperties.setProperty("password", builder.getPassword().get());
        }
        if (builder.getInstanceName() != null) {
            connectionProperties.setProperty("oracle.jdbc.targetInstanceName", builder.getInstanceName());
        }
        if (builder.getServiceName() != null && !builder.getServiceName().equalsIgnoreCase(DEFAULT_SERVICE_NAME)) {
            connectionProperties.setProperty("oracle.jdbc.targetServiceName", builder.getServiceName());
        }
        if (builder.getShardingKey() != null) {
            String b64EncodedShardingKey = builder.getShardingKey().encodeKeyinB64Format();
            connectionProperties.setProperty("oracle.jdbc.targetShardingKey", b64EncodedShardingKey);
        }
        if (builder.getSuperShardingKey() != null) {
            String b64EncodedSuperKey = builder.getSuperShardingKey().encodeKeyinB64Format();
            connectionProperties.setProperty("oracle.jdbc.targetSuperShardingKey", b64EncodedSuperKey);
        }
        if (builder.getReadOnlyInstanceAllowed()) {
            connectionProperties.setProperty("oracle.jdbc.readOnlyInstanceAllowed", String.valueOf(builder.getReadOnlyInstanceAllowed()));
        }
    }

    private void applyDataSourcePropertiesToBuilder(AbstractConnectionBuilder<?, ?> builder) throws SQLException {
        if (builder == null) {
            return;
        }
        if (this.sslContext != null && builder.getSSLContext() == null) {
            builder.sslContext(this.sslContext);
        }
        if (this.allowSingleShardTransaction && !builder.getAllowSingleShardTransaction()) {
            builder.singleShardTransactionSupport(this.allowSingleShardTransaction);
        }
        if (this.hostnameResolver != null && builder.getHostnameResolver() == null) {
            builder.hostnameResolver(this.hostnameResolver);
        }
        this.configureTokenSupplier(builder);
    }

    private void configureTokenSupplier(AbstractConnectionBuilder<?, ?> builder) throws SQLException {
        Supplier<? extends AccessToken> tokenSupplier = this.tokenSupplier;
        if (tokenSupplier == null) {
            return;
        }
        if (this.isUserOrPasswordConfigured()) {
            throw (SQLException)DatabaseError.createSqlException(null, 1718, "DataSource configured with setTokenSupplier(Supplier) is also configured with a user name or password").fillInStackTrace();
        }
        if (builder == null || builder.getTokenSupplier() != null || builder.getUser() != null || builder.getPassword() != null && !builder.getPassword().isNull()) {
            return;
        }
        builder.setTokenSupplier(tokenSupplier);
    }

    private boolean isUserOrPasswordConfigured() {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            boolean bl = this.user != null || this.password != null && !this.password.isNull() || this.connectionProperties != null && (this.connectionProperties.containsKey("user") || this.connectionProperties.containsKey("oracle.jdbc.user") || this.connectionProperties.containsKey("password") || this.connectionProperties.containsKey("oracle.jdbc.password"));
            return bl;
        }
    }

    protected Connection getPhysicalConnection(@Blind(value=PropertiesBlinder.class) Properties prop, AbstractConnectionBuilder builder) throws SQLException {
        boolean localUseDefaultConnection;
        String localUrl = prop.getProperty("connection_url", this.url);
        String localUser = prop.getProperty("user");
        boolean hasGSSCredential = builder != null && builder.getGSSCredential() != null;
        Properties localProps = this.createPropertiesForPhysicalConnection(prop, hasGSSCredential);
        this.debug(Level.CONFIG, SecurityLabel.UNKNOWN, CLASS_NAME, "getPhysicalConnection", "(point 1) url={0}, user={1}. ", (String)null, (Throwable)null, (Object)localUrl, (Object)localUser);
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            localUseDefaultConnection = this.useDefaultConnection;
            if (this.driver == null) {
                this.driver = new OracleDriver();
            }
            String dmsName = this.dataSourceName == null || this.dataSourceName.length() == 0 ? "OracleDataSource_" + unnamedInstanceCount++ : this.dataSourceName;
            localProps.setProperty("DMSName", dmsName);
            localProps.setProperty("DMSType", OracleDataSource.dms_data_source_type());
            this.applyDataSourcePropertiesToBuilder(builder);
        }
        Connection conn = localUseDefaultConnection ? this.driver.defaultConnection() : this.driver.connect(localUrl, localProps, builder);
        if (conn == null) {
            throw (SQLException)DatabaseError.createSqlException(67).fillInStackTrace();
        }
        this.initializeStatementCacheForPhysicalConnection((oracle.jdbc.internal.OracleConnection)conn, prop);
        return conn;
    }

    private final CompletionStage<OracleConnection> getPhysicalConnectionAsync(@Blind(value=PropertiesBlinder.class) Properties prop, AbstractConnectionBuilder builder) {
        String localUrl = prop.getProperty("connection_url", this.url);
        String localUser = prop.getProperty("user");
        boolean hasGSSCredential = builder != null && builder.getGSSCredential() != null;
        Properties localProps = this.createPropertiesForPhysicalConnection(prop, hasGSSCredential);
        this.debug(Level.CONFIG, SecurityLabel.UNKNOWN, CLASS_NAME, "getPhysicalConnection", "(point 2) url={0}, user={1}. ", (String)null, (Throwable)null, (Object)localUrl, (Object)localUser);
        if (this.useDefaultConnection) {
            return CompletionStageUtil.failedStage(new UnsupportedOperationException("Asynchronous connections are not supported by the server-side internal driver"));
        }
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (this.driver == null) {
                this.driver = new OracleDriver();
            }
            String dmsName = this.dataSourceName == null || this.dataSourceName.length() == 0 ? "OracleDataSource_" + unnamedInstanceCount++ : this.dataSourceName;
            localProps.setProperty("DMSName", dmsName);
            localProps.setProperty("DMSType", OracleDataSource.dms_data_source_type());
            localProps.setProperty("DMSName", dmsName);
            localProps.setProperty("DMSType", OracleDataSource.dms_data_source_type());
            try {
                this.applyDataSourcePropertiesToBuilder(builder);
            }
            catch (SQLException sqlException) {
                CompletionStage<OracleConnection> completionStage = CompletionStageUtil.failedStage(sqlException);
                if (lock != null) {
                    if (var8_8 != null) {
                        try {
                            lock.close();
                        }
                        catch (Throwable throwable) {
                            var8_8.addSuppressed(throwable);
                        }
                    } else {
                        lock.close();
                    }
                }
                return completionStage;
            }
        }
        return this.driver._INTERNAL_ORACLE_connectAsync(localUrl, localProps, builder).thenApply(CompletionStageUtil.normalCompletionHandler(conn -> {
            if (conn == null) {
                throw (SQLException)DatabaseError.createSqlException(67).fillInStackTrace();
            }
            oracle.jdbc.internal.OracleConnection oraConn = (oracle.jdbc.internal.OracleConnection)conn;
            this.initializeStatementCacheForPhysicalConnection(oraConn, prop);
            return oraConn;
        }));
    }

    @Blind(value=PropertiesBlinder.class)
    private final Properties createPropertiesForPhysicalConnection(@Blind(value=PropertiesBlinder.class) Properties internalProperties, boolean hasGSSCredential) {
        String localLoginTimeout;
        String isReadOnlyInstanceAllowed;
        String superShardingKeyStr;
        String shardingKeyStr;
        String localServiceName;
        String localInstanceName;
        Properties physicalConnectionProperties;
        String localUser = internalProperties.getProperty("user");
        String localPassword = internalProperties.getProperty("password");
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (!hasGSSCredential) {
                if (localUser == null && this.user != null) {
                    localUser = this.user;
                    internalProperties.put("user", localUser);
                }
                if (localPassword == null && this.password != null && this.password != OpaqueString.NULL) {
                    localPassword = this.password.get();
                    internalProperties.put("password", localPassword);
                }
            }
            if (this.connectionProperties == null) {
                Properties properties = internalProperties;
                return properties;
            }
            physicalConnectionProperties = (Properties)this.connectionProperties.clone();
        }
        if (localUser != null) {
            physicalConnectionProperties.setProperty("user", localUser);
        }
        if (localPassword != null) {
            physicalConnectionProperties.put("password", localPassword);
        }
        if ((localInstanceName = internalProperties.getProperty("oracle.jdbc.targetInstanceName")) != null) {
            physicalConnectionProperties.put("oracle.jdbc.targetInstanceName", localInstanceName);
        }
        if ((localServiceName = internalProperties.getProperty("oracle.jdbc.targetServiceName")) != null) {
            physicalConnectionProperties.put("oracle.jdbc.targetServiceName", localServiceName);
        }
        if ((shardingKeyStr = internalProperties.getProperty("oracle.jdbc.targetShardingKey")) != null) {
            physicalConnectionProperties.put("oracle.jdbc.targetShardingKey", shardingKeyStr);
        }
        if ((superShardingKeyStr = internalProperties.getProperty("oracle.jdbc.targetSuperShardingKey")) != null) {
            physicalConnectionProperties.put("oracle.jdbc.targetSuperShardingKey", superShardingKeyStr);
        }
        if ("true".equalsIgnoreCase(isReadOnlyInstanceAllowed = internalProperties.getProperty("oracle.jdbc.readOnlyInstanceAllowed"))) {
            physicalConnectionProperties.put("oracle.jdbc.readOnlyInstanceAllowed", isReadOnlyInstanceAllowed);
        }
        if ((localLoginTimeout = internalProperties.getProperty("oracle.jdbc.loginTimeout")) == null) {
            localLoginTimeout = physicalConnectionProperties.getProperty("LoginTimeout");
        }
        if (localLoginTimeout != null) {
            physicalConnectionProperties.setProperty("oracle.jdbc.loginTimeout", localLoginTimeout);
        }
        return physicalConnectionProperties;
    }

    private final void initializeStatementCacheForPhysicalConnection(oracle.jdbc.internal.OracleConnection physicalConnection, Properties internalProperties) throws SQLException {
        int cacheSizePropertyValue;
        String cacheSizeProperty = internalProperties.getProperty("stmt_cache_size");
        int n = cacheSizePropertyValue = cacheSizeProperty == null ? 0 : Integer.parseInt(cacheSizeProperty);
        if (cacheSizeProperty != null) {
            physicalConnection.setStatementCacheSize(cacheSizePropertyValue);
        }
        String enableExplicitProperty = internalProperties.getProperty("ExplicitStatementCachingEnabled");
        boolean enableExplicitPropertyValue = "true".equals(enableExplicitProperty);
        if (enableExplicitProperty != null) {
            physicalConnection.setExplicitCachingEnabled(enableExplicitPropertyValue);
        } else if (this.explicitCachingEnabled) {
            physicalConnection.setExplicitCachingEnabled(true);
        }
        String enableImplicitProperty = internalProperties.getProperty("ImplicitStatementCachingEnabled");
        boolean enableImplicitPropertyValue = "true".equals(enableImplicitProperty);
        if (enableImplicitProperty != null) {
            physicalConnection.setImplicitCachingEnabled(enableImplicitPropertyValue);
        } else if (this.implicitCachingEnabled) {
            physicalConnection.setImplicitCachingEnabled(true);
        }
        if (cacheSizePropertyValue > 0 && !enableExplicitPropertyValue && !enableImplicitPropertyValue) {
            physicalConnection.setImplicitCachingEnabled(true);
            physicalConnection.setExplicitCachingEnabled(true);
        }
    }

    @Override
    public int getLoginTimeout() {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            int n = this.loginTimeout;
            return n;
        }
    }

    @Override
    public void setLoginTimeout(int timeout) {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.loginTimeout = timeout;
        }
    }

    @Override
    public void setLogWriter(PrintWriter pw) {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.logWriter = pw;
        }
    }

    @Override
    public PrintWriter getLogWriter() {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            PrintWriter printWriter = this.logWriter;
            return printWriter;
        }
    }

    public void setTNSEntryName(String dbname) {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.tnsEntry = dbname;
        }
    }

    public String getTNSEntryName() {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            String string = this.tnsEntry;
            return string;
        }
    }

    @Override
    public void setDataSourceName(String dsname) {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.dataSourceName = dsname;
        }
    }

    @Override
    public String getDataSourceName() {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            String string = this.dataSourceName;
            return string;
        }
    }

    @Override
    public String getDatabaseName() {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            String string = this.databaseName;
            return string;
        }
    }

    @Override
    public void setDatabaseName(String dbname) {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.databaseName = dbname;
        }
    }

    public void setServiceName(String svcname) {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.serviceName = svcname;
        }
    }

    public String getServiceName() {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            String string = this.serviceName;
            return string;
        }
    }

    @Override
    public void setServerName(String sn) {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.serverName = sn;
        }
    }

    @Override
    public String getServerName() {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            String string = this.serverName;
            return string;
        }
    }

    @Override
    public void setURL(String url) {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.url = url;
            if (this.url != null) {
                this.urlExplicit = true;
            }
        }
    }

    @Override
    public String getURL() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (!this.urlExplicit) {
                this.makeURL();
            }
            String string = this.url;
            return string;
        }
    }

    @Override
    public void setUser(String userName) {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.user = userName;
        }
    }

    @Override
    public String getUser() {
        return this.user;
    }

    private void setPassword(OpaqueString os) {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.password = os;
        }
    }

    @Override
    public void setPassword(@Blind String pd) {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.setPassword(OpaqueString.newOpaqueString(pd));
        }
    }

    protected OpaqueString getPassword() {
        return this.password;
    }

    @Override
    public String getDescription() {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            String string = this.description;
            return string;
        }
    }

    @Override
    public void setDescription(String des) {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.description = des;
        }
    }

    public String getDriverType() {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            String string = this.driverType;
            return string;
        }
    }

    public void setDriverType(String dt) {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.driverType = dt;
        }
    }

    @Override
    public String getNetworkProtocol() {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            String string = this.networkProtocol;
            return string;
        }
    }

    @Override
    public void setNetworkProtocol(String np) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.networkProtocol = np;
        }
    }

    @Override
    public void setPortNumber(int pn) {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.portNumber = pn;
        }
    }

    @Override
    public int getPortNumber() {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            int n = this.portNumber;
            return n;
        }
    }

    @Override
    public Reference getReference() throws NamingException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            Reference ref = new Reference(this.getClass().getName(), "oracle.jdbc.datasource.impl.OracleDataSourceFactory", null);
            this.addRefProperties(ref);
            Reference reference = ref;
            return reference;
        }
    }

    protected void addRefProperties(Reference ref) {
        if (this.url != null) {
            ref.add(new StringRefAddr("url", this.url));
        }
        if (this.user != null) {
            ref.add(new StringRefAddr("userName", this.user));
        }
        if (this.password != null && this.password != OpaqueString.NULL) {
            ref.add(new StringRefAddr("passWord", this.password.get()));
        }
        if (this.description != null) {
            ref.add(new StringRefAddr("description", this.description));
        }
        if (this.driverType != null) {
            ref.add(new StringRefAddr("driverType", this.driverType));
        }
        if (this.serverName != null) {
            ref.add(new StringRefAddr("serverName", this.serverName));
        }
        if (this.databaseName != null) {
            ref.add(new StringRefAddr("databaseName", this.databaseName));
        }
        if (this.serviceName != null) {
            ref.add(new StringRefAddr("serviceName", this.serviceName));
        }
        if (this.networkProtocol != null) {
            ref.add(new StringRefAddr("networkProtocol", this.networkProtocol));
        }
        if (this.portNumber != 0) {
            ref.add(new StringRefAddr("portNumber", Integer.toString(this.portNumber)));
        }
        if (this.tnsEntry != null) {
            ref.add(new StringRefAddr("tnsentryname", this.tnsEntry));
        }
        if (this.connectionProperties != null && this.connectionProperties.size() > 0) {
            ref.add(new StringRefAddr("connectionProperties", this.connectionProperties.toString()));
        }
        if (this.maxStatementsSet) {
            ref.add(new StringRefAddr("maxStatements", Integer.toString(this.maxStatements)));
        }
        if (this.implicitCachingEnabledSet) {
            ref.add(new StringRefAddr("implicitCachingEnabled", this.implicitCachingEnabled ? "true" : "false"));
        }
        if (this.explicitCachingEnabledSet) {
            ref.add(new StringRefAddr("explicitCachingEnabled", this.explicitCachingEnabled ? "true" : "false"));
        }
    }

    protected void makeURL() throws SQLException {
        if (this.urlExplicit) {
            return;
        }
        if (this.driverType == null || !this.driverType.equals("oci8") && !this.driverType.equals("oci") && !this.driverType.equals("thin") && !this.driverType.equals("kprb")) {
            throw (SQLException)DatabaseError.createSqlException(67, "OracleDataSource.makeURL").fillInStackTrace();
        }
        if (this.driverType.equals("kprb")) {
            this.useDefaultConnection = true;
            this.url = "jdbc:oracle:kprb:@";
            this.debug(Level.CONFIG, SecurityLabel.UNKNOWN, CLASS_NAME, "makeURL", "useDefaultConnection={0}, url={1}. ", (String)null, (Throwable)null, (Object)this.useDefaultConnection, (Object)this.url);
            return;
        }
        if ((this.driverType.equals("oci8") || this.driverType.equals("oci")) && this.networkProtocol != null && this.networkProtocol.equals("ipc")) {
            this.url = "jdbc:oracle:oci:@";
            this.debug(Level.CONFIG, SecurityLabel.UNKNOWN, CLASS_NAME, "makeURL", "url={0}. ", (String)null, (Throwable)null, (Object)this.url);
            return;
        }
        if (this.tnsEntry != null) {
            this.url = "jdbc:oracle:" + this.driverType + ":@" + this.tnsEntry;
            this.debug(Level.CONFIG, SecurityLabel.UNKNOWN, CLASS_NAME, "makeURL", "url={0}. ", (String)null, (Throwable)null, (Object)this.url);
            return;
        }
        if (this.serviceName != null) {
            this.url = "jdbc:oracle:" + this.driverType + ":@(DESCRIPTION=(ADDRESS=(PROTOCOL=" + this.networkProtocol + ")(PORT=" + this.portNumber + ")(HOST=" + this.serverName + "))(CONNECT_DATA=(SERVICE_NAME=" + this.serviceName + ")))";
        } else {
            this.url = "jdbc:oracle:" + this.driverType + ":@(DESCRIPTION=(ADDRESS=(PROTOCOL=" + this.networkProtocol + ")(PORT=" + this.portNumber + ")(HOST=" + this.serverName + "))(CONNECT_DATA=(SID=" + this.databaseName + ")))";
            DatabaseError.addSqlWarning(null, new SQLWarning("URL with SID jdbc:subprotocol:@host:port:sid will be deprecated in 10i\nPlease use URL with SERVICE_NAME as jdbc:subprotocol:@//host:port/service_name"));
        }
        this.debug(Level.CONFIG, SecurityLabel.UNKNOWN, CLASS_NAME, "makeURL", "url={0}. ", (String)null, (Throwable)null, (Object)this.url);
    }

    @Override
    public void setMaxStatements(int max) throws SQLException {
        if (max < 0) {
            throw (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
        }
        this.maxStatementsSet = true;
        this.maxStatements = max;
    }

    @Override
    public int getMaxStatements() throws SQLException {
        return this.maxStatements;
    }

    @Override
    public void setImplicitCachingEnabled(boolean cache) throws SQLException {
        this.implicitCachingEnabledSet = true;
        this.implicitCachingEnabled = cache;
    }

    @Override
    public boolean getImplicitCachingEnabled() throws SQLException {
        return this.implicitCachingEnabled;
    }

    @Override
    public void setExplicitCachingEnabled(boolean cache) throws SQLException {
        this.explicitCachingEnabledSet = true;
        this.explicitCachingEnabled = cache;
    }

    @Override
    public boolean getExplicitCachingEnabled() throws SQLException {
        return this.explicitCachingEnabled;
    }

    @Override
    public void setConnectionProperties(@Blind(value=PropertiesBlinder.class) Properties properties) throws SQLException {
        if (properties == null || properties.size() == 0) {
            return;
        }
        if (this.connectionProperties == null || this.connectionProperties.size() == 0) {
            this.connectionProperties = (Properties)properties.clone();
            return;
        }
        Enumeration<?> keys = properties.propertyNames();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            this.connectionProperties.put(key, properties.get(key));
        }
    }

    @Override
    public void setRoleName(String roleName) throws SQLException {
        this.roleName = roleName;
    }

    @Override
    public String getRoleName() {
        return this.roleName;
    }

    @Override
    @Blind(value=PropertiesBlinder.class)
    public Properties getConnectionProperties() throws SQLException {
        return OracleDataSource.filterConnectionProperties(this.connectionProperties);
    }

    @Override
    public String getConnectionProperty(String propertyName) throws SQLException {
        if (OracleDataSource.isSensitiveProperty(propertyName)) {
            return null;
        }
        return this.connectionProperties == null ? null : this.connectionProperties.getProperty(propertyName);
    }

    @Override
    public void setConnectionProperty(String name, String value) throws SQLException {
        if (value == null || value.equals("")) {
            throw new IllegalArgumentException();
        }
        if (this.connectionProperties == null) {
            this.connectionProperties = new Properties();
        }
        this.connectionProperties.setProperty(name, value);
    }

    @Blind(value=PropertiesBlinder.class)
    public static final Properties filterConnectionProperties(@Blind(value=PropertiesBlinder.class) Properties prop) {
        Properties result = null;
        if (prop != null) {
            result = (Properties)prop.clone();
            Enumeration<?> enu = result.propertyNames();
            Object c = null;
            while (enu.hasMoreElements()) {
                String key = (String)enu.nextElement();
                if (!OracleDataSource.isSensitiveProperty(key)) continue;
                result.remove(key);
            }
        }
        return result;
    }

    private static boolean isSensitiveProperty(String name) {
        if (name == null) {
            return false;
        }
        switch (name) {
            case "oracle.jdbc.passwordAuthentication": {
                return false;
            }
            case "oracle.jdbc.accessToken": {
                return true;
            }
            case "oracle.jdbc.clientSecret": {
                return true;
            }
        }
        return name.matches(".*[Pp][Aa][Ss][Ss][Ww][Oo][Rr][Dd].*");
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException, SQLException {
        in.defaultReadObject();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        if (iface.isInterface()) {
            return iface.isInstance(this);
        }
        throw (SQLException)DatabaseError.createSqlException(177).fillInStackTrace();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInterface() && iface.isInstance(this)) {
            return (T)this;
        }
        throw (SQLException)DatabaseError.createSqlException(177).fillInStackTrace();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return Logger.getLogger("oracle");
    }

    @Override
    public final void setSSLContext(SSLContext sslContext) {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.sslContext = sslContext;
        }
    }

    @Override
    public void setSingleShardTransactionSupport(boolean allow) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.allowSingleShardTransaction = allow;
        }
    }

    @Override
    public void setHostnameResolver(OracleHostnameResolver hostnameResolver) {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.hostnameResolver = hostnameResolver;
        }
    }

    protected oracle.jdbc.internal.OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    @Override
    public OracleConnectionBuilderImpl createConnectionBuilder() {
        return new OracleConnectionBuilderImpl(){

            @Override
            public CompletionStage<OracleConnection> buildAsyncOracle() throws SQLException {
                this.ensureMutableState();
                this.verifyBuildConfiguration();
                CompletableFuture<OracleConnection> connectionFuture = new CompletableFuture<OracleConnection>();
                OracleDataSource.this.getConnectionAsync(this).whenComplete((connection, error) -> {
                    if (error == null) {
                        connectionFuture.complete((OracleConnection)connection);
                    } else {
                        Throwable errorCause = CompletionStageUtil.unwrapCompletionException(error);
                        connectionFuture.completeExceptionally(errorCause);
                    }
                });
                return connectionFuture;
            }

            @Override
            public oracle.jdbc.internal.OracleConnection build() throws SQLException {
                OracleDataSource.this.debug(Level.CONFIG, SecurityLabel.UNKNOWN, CLASS_NAME + ".OracleConnectionBuilder", "build", "url={0}. ", (String)null, (Throwable)null, (Object)OracleDataSource.this.url);
                this.ensureMutableState();
                this.verifyBuildConfiguration();
                boolean useProxy = OracleDataSource.this.isACSupportPropertySet();
                return (oracle.jdbc.internal.OracleConnection)OracleDataSource.this.getConnectionInternal(this, useProxy);
            }
        };
    }

    private final boolean isACSupportPropertySet() throws SQLException {
        String tempval = OracleDataSource.getSystemProperty(ENABLE_AC_SUPPORT_PROPERTY, null);
        if (tempval == null) {
            tempval = this.getConnectionProperty(ENABLE_AC_SUPPORT_PROPERTY);
        }
        if (tempval == null) {
            tempval = "true";
        }
        return tempval != null && tempval.equalsIgnoreCase("true");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getConnectionNoProxy(OracleConnectionBuilderImpl connBuilder) throws SQLException {
        int retries = 1;
        Connection conn = null;
        Exception exc = null;
        do {
            try {
                this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "getConnectionNoProxy", "Reconnecting. RETRY={0}. ", (String)null, (Throwable)null, (Object)retries);
                exc = null;
                connBuilder.instanceName(null);
                conn = this.getConnectionInternal(connBuilder, false);
                oracle.jdbc.internal.OracleConnection oconn = (oracle.jdbc.internal.OracleConnection)conn;
                if (oconn.isDRCPEnabled()) {
                    oconn.attachServerConnection();
                    this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "getConnectionNoProxy", "DRCP attach completed. ", null, null);
                }
            }
            catch (Exception e) {
                conn = null;
                exc = e;
                this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "getConnectionNoProxy", "Reconnect FAILED. ", null, e);
            }
            finally {
                if (conn != null && exc == null) {
                    return conn;
                }
                ++retries;
            }
            try {
                if (this.reconnectDelay <= 0) continue;
                this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "getConnectionNoProxy", "Reconnecting. delay={0}sec. ", (String)null, (Throwable)null, (Object)this.reconnectDelay);
                Thread.sleep(this.reconnectDelay * 1000);
            }
            catch (InterruptedException sleepExc) {
                this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "getConnectionNoProxy", null, null, sleepExc);
            }
        } while (retries <= this.reconnectRetries);
        return null;
    }

    private Connection getConnectionInternal(OracleConnectionBuilderImpl builder, boolean useProxy) throws SQLException {
        Connection conn = null;
        if (this.isFirstConnection.get()) {
            this.setupACSpecificProperties(useProxy);
        }
        conn = this.getConnection(builder);
        if (useProxy) {
            conn = this.enableACAndProxifyIfNecessary(conn, builder);
        }
        this.isFirstConnection.set(false);
        return conn;
    }

    protected void setupACSpecificProperties(boolean useProxy) throws SQLException {
        if (useProxy) {
            this.setConnectionProperty(CHECKSUM_PROPERTY, this.clientChecksum12x);
        } else {
            this.setConnectionProperty(IGNORE_AC_CONTEXT_PROPERTY, "true");
        }
    }

    protected Connection enableACAndProxifyIfNecessary(Connection conn, OracleConnectionBuilderImpl connBuilder) throws SQLException {
        String initiationTimeout;
        String failoverType;
        String failoverRetries;
        boolean useProxy = true;
        short dbVersion = 0;
        oracle.jdbc.internal.OracleConnection oconn = (oracle.jdbc.internal.OracleConnection)conn;
        Properties sessionProperties = oconn.getServerSessionInfo();
        String failoverDelay = sessionProperties.getProperty(RECONNECT_DELAY_PROPERTY);
        if (failoverDelay != null && !"".equals(failoverDelay)) {
            int _delay = Integer.parseInt(failoverDelay);
            if (_delay > 0) {
                this.reconnectDelay = _delay;
            } else {
                this.debug(Level.CONFIG, SecurityLabel.UNKNOWN, CLASS_NAME, "enableACAndProxifyIfNecessary", "Server FAILOVER_DELAY={0}, using driver default. ", (String)null, (Throwable)null, (Object)_delay);
            }
        }
        if ((failoverRetries = sessionProperties.getProperty(RECONNECT_RETRIES_PROPERTY)) != null && !"".equals(failoverRetries)) {
            int _retries = Integer.parseInt(failoverRetries);
            if (_retries > 0) {
                this.reconnectRetries = _retries;
            } else {
                this.debug(Level.CONFIG, SecurityLabel.UNKNOWN, CLASS_NAME, "enableACAndProxifyIfNecessary", "Server FAILOVER_RETRIES={0}, using driver default. ", (String)null, (Throwable)null, (Object)_retries);
            }
        }
        if ((failoverType = sessionProperties.getProperty(FAILOVER_TYPE_PROPERTY)) != null && !"".equals(failoverType)) {
            int wiredValue;
            try {
                wiredValue = Integer.parseInt(failoverType);
            }
            catch (NumberFormatException exc) {
                wiredValue = 0;
            }
            boolean isFailoverOnRemote = (wiredValue & 0x200) == 512;
            this.isAutoACEnabled = !isFailoverOnRemote && (wiredValue & 0x20) == 32;
            this.isTransactionReplayEnabled = this.isAutoACEnabled || !isFailoverOnRemote && (wiredValue & 8) == 8;
            this.isReplayInDynamicMode = (wiredValue & 0x10) == 0;
            this.isHybrid = (wiredValue & 0x100) == 256;
            this.isSSSCursorEnabled = this.getSSSCursorProperty();
        } else {
            this.debug(Level.WARNING, SecurityLabel.UNKNOWN, CLASS_NAME, "enableACAndProxifyIfNecessary", "AC is disabled because service does not return FAILOVER_TYPE attribute. conn={0}. ", (String)null, (Throwable)null, (Object)conn);
            useProxy = false;
        }
        String failoverRestore = sessionProperties.getProperty(FAILOVER_RESTORE_PROPERTY);
        if (failoverRestore != null && !"".equals(failoverRestore) && "thin".equals(oconn.getProtocolType())) {
            int _restore = Integer.parseInt(failoverRestore);
            this.stateRestorationType = ReplayableConnection.StateRestorationType.values()[_restore];
            if (this.stateRestorationType.compareTo(ReplayableConnection.StateRestorationType.NONE) > 0) {
                boolean bl = this.isStateRestorationAuto = this.stateRestorationType.compareTo(ReplayableConnection.StateRestorationType.LEVEL2) >= 0;
                if (this.isAutoACEnabled && !this.isStateRestorationAuto) {
                    this.debug(Level.WARNING, SecurityLabel.UNKNOWN, CLASS_NAME, "enableACAndProxifyIfNecessary", "AC is disabled because FAILOVER_TYPE at server is AUTO, while FAILOVER_RESTORE is not. conn={0}. ", (String)null, (Throwable)null, (Object)conn);
                    useProxy = false;
                }
            } else {
                this.debug(Level.CONFIG, SecurityLabel.UNKNOWN, CLASS_NAME, "enableACAndProxifyIfNecessary", "Server FAILOVER_RESTORE={0}, disabling driver AC state restoration.", (String)null, (Throwable)null, (Object)_restore);
            }
        }
        if ((initiationTimeout = sessionProperties.getProperty(INITIATION_TIMEOUT_PROPERTY)) != null && !"".equals(initiationTimeout)) {
            this.replayInitiationTimeout = Integer.parseInt(initiationTimeout);
        }
        if ((dbVersion = oconn.getVersionNumber()) < 11203) {
            this.debug(Level.WARNING, SecurityLabel.UNKNOWN, CLASS_NAME, "enableACAndProxifyIfNecessary", "AC is disabled because server version does not support AC. conn={0}.", (String)null, (Throwable)null, (Object)conn);
            useProxy = false;
        } else if (dbVersion >= 12100 && !this.isTransactionReplayEnabled) {
            this.debug(Level.WARNING, SecurityLabel.UNKNOWN, CLASS_NAME, "enableACAndProxifyIfNecessary", "AC is disabled because FAILOVER_TYPE service attribute is not set to TRANSACTION in server. conn={0}. ", (String)null, (Throwable)null, (Object)conn);
            useProxy = false;
        } else if (dbVersion >= 11203 && dbVersion < 12100) {
            boolean enableAC11203 = "true".equalsIgnoreCase(OracleDataSource.getSystemProperty(AC_11203_COMPATIBLE_SYSTEM_PROPERTY, "false"));
            if (enableAC11203) {
                conn.close();
                this.setConnectionProperty(CHECKSUM_PROPERTY, this.clientChecksum11203x);
                conn = this.getConnection(connBuilder);
                try (Monitor.CloseableLock lock = proxyFactoryLock.acquireCloseableLock();){
                    PROXY_FACTORY = NON_TXN_PROXY_FACTORY;
                }
            } else {
                this.debug(Level.WARNING, SecurityLabel.UNKNOWN, CLASS_NAME, "enableACAndProxifyIfNecessary", "AC is disabled because server version does not support AC. conn={0}. ", (String)null, (Throwable)null, (Object)conn);
                useProxy = false;
            }
        }
        if (useProxy) {
            oconn.enableDiagnoseFirstFailureDump(false);
            if (this.trackerInitialized.compareAndSet(false, true)) {
                this.tracker = new StatisticsTracker();
                ReplayStatisticsMBeanImpl.SOLE_INSTANCE.addTrackerForDS(this.tracker);
            }
            Connection connProxy = PROXY_FACTORY.proxyFor(conn);
            ReplayableConnection rconn = (ReplayableConnection)((Object)connProxy);
            rconn.initialize(this, connBuilder);
            if (dbVersion >= 12100) {
                rconn.setReplayInitiationTimeout(this.replayInitiationTimeout);
                rconn.setAutoAC(this.isAutoACEnabled);
                rconn.setSessionStateConsistency(!this.isReplayInDynamicMode);
                rconn.setSessionStateRestoration(this.stateRestorationType);
                rconn.setSSSCursorEnabled(this.isSSSCursorEnabled);
                rconn.setHybrid(this.isSSSCursorEnabled && this.isHybrid);
            }
            ((oracle.jdbc.internal.OracleConnection)conn).getReplayContext();
            boolean enableImplicitBeginRequest = "true".equalsIgnoreCase(OracleDataSource.getSystemProperty(IMPLICIT_BEGIN_REQUEST_SYSTEM_PROPERTY, "true"));
            if (this.isAutoACEnabled && enableImplicitBeginRequest && !oconn.isDRCPEnabled()) {
                rconn.beginRequest();
            }
            return connProxy;
        }
        return conn;
    }

    @Override
    public void registerConnectionInitializationCallback(ConnectionInitializationCallback cbk) throws SQLException {
        if (cbk == null) {
            throw DatabaseError.createSqlException(68);
        }
        this.connectionInitializationCallback = cbk;
        this.debug(Level.CONFIG, SecurityLabel.UNKNOWN, CLASS_NAME, "registerConnectionInitializationCallback", "cbk={0}. ", (String)null, (Throwable)null, (Object)cbk);
    }

    @Override
    public void unregisterConnectionInitializationCallback(ConnectionInitializationCallback cbk) throws SQLException {
        if (cbk == null || this.connectionInitializationCallback != cbk) {
            throw DatabaseError.createSqlException(68);
        }
        this.connectionInitializationCallback = null;
        this.debug(Level.CONFIG, SecurityLabel.UNKNOWN, CLASS_NAME, "unregisterConnectionInitializationCallback", "cbk={0}. ", (String)null, (Throwable)null, (Object)cbk);
    }

    @Override
    public ConnectionInitializationCallback getConnectionInitializationCallback() {
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "getConnectionInitializationCallback", "cbk={0}. ", (String)null, (Throwable)null, (Object)this.connectionInitializationCallback);
        return this.connectionInitializationCallback;
    }

    @Override
    public ReplayStatistics getReplayStatistics() {
        return this.tracker.getReplayStatistics();
    }

    @Override
    public void clearDoneDumpOnMemoryPressure() {
        this.doneDumpOnMemoryPressure.set(false);
    }

    @Override
    public String getReplayStatisticsString() {
        if (this.doneDumpOnMemoryPressure.compareAndSet(false, true)) {
            return null;
        }
        return this.tracker.getReplayStatisticsString();
    }

    @Override
    public void clearReplayStatistics() {
        this.tracker.clearReplayStatistics();
    }

    @Override
    public void updateReplayStatistics(oracle.jdbc.replay.internal.ReplayStatistics newStats) {
        this.tracker.updateReplayStatistics(this.getDataSourceName(), newStats);
    }

    @Override
    public void removeReplayStatistics(oracle.jdbc.replay.internal.ReplayStatistics stats) {
        this.tracker.removeReplayStatistics(stats);
    }

    protected static String getSystemProperty(String property, String defaultValue) {
        if (property != null) {
            final String propStr = property;
            final String propDefVal = defaultValue;
            final String[] rets = new String[]{defaultValue};
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    rets[0] = System.getProperty(propStr, propDefVal);
                    return null;
                }
            });
            return rets[0];
        }
        return defaultValue;
    }

    @Override
    public int getRequestSizeLimit() throws SQLException {
        int limit = Integer.MAX_VALUE;
        String tempval = OracleDataSource.getSystemProperty(REQUEST_SIZE_LIMIT_PROPERTY, null);
        if (tempval == null) {
            tempval = this.getConnectionProperty(REQUEST_SIZE_LIMIT_PROPERTY);
        }
        if (tempval == null) {
            tempval = Integer.toString(Integer.MAX_VALUE);
        }
        try {
            limit = Integer.parseInt(tempval);
        }
        catch (NumberFormatException nfe) {
            this.debug(Level.WARNING, SecurityLabel.UNKNOWN, CLASS_NAME, "getRequestSizeLimit", "Request-size-limit property is set to an incorrect value with number format problem. ", null, null);
            limit = Integer.MAX_VALUE;
        }
        return limit;
    }

    protected final boolean getSSSCursorProperty() throws SQLException {
        String tempval = OracleDataSource.getSystemProperty(ENABLE_SSS_CURSOR_SUPPORT_PROPERTY, null);
        if (tempval == null) {
            tempval = this.getConnectionProperty(ENABLE_SSS_CURSOR_SUPPORT_PROPERTY);
        }
        if (tempval == null) {
            tempval = "false";
        }
        return tempval != null && tempval.equalsIgnoreCase("true");
    }

    @Override
    public ProxyFactory getProxyFactory() throws SQLException {
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "getProxyFactory", "PROXY_FACTORY={0}. ", (String)null, (Throwable)null, (Object)PROXY_FACTORY);
        return PROXY_FACTORY;
    }

    public static void registerMBean() {
        block14: {
            try {
                MBeanServer mbs = null;
                try {
                    Class<?> cls = Class.forName("oracle.as.jmx.framework.PortableMBeanFactory");
                    Object factory = cls.newInstance();
                    Method mthd = cls.getMethod("getMBeanServer", new Class[0]);
                    mbs = (MBeanServer)mthd.invoke(factory, new Object[0]);
                }
                catch (NoClassDefFoundError ex) {
                    mbs = ManagementFactory.getPlatformMBeanServer();
                }
                catch (ClassNotFoundException ex) {
                    mbs = ManagementFactory.getPlatformMBeanServer();
                }
                catch (NoSuchMethodException ex) {
                    CommonDiagnosable.getInstance().debug(Level.WARNING, SecurityLabel.UNKNOWN, CLASS_NAME, "registerMBean", "Found Oracle Apps MBeanServer but not the getMBeanServer method. ", null, ex);
                    mbs = ManagementFactory.getPlatformMBeanServer();
                }
                catch (InstantiationException ex) {
                    CommonDiagnosable.getInstance().debug(Level.WARNING, SecurityLabel.UNKNOWN, CLASS_NAME, "registerMBean", "Found Oracle Apps MBeanServer but could not create an instance. ", null, ex);
                    mbs = ManagementFactory.getPlatformMBeanServer();
                }
                catch (IllegalAccessException ex) {
                    CommonDiagnosable.getInstance().debug(Level.WARNING, SecurityLabel.UNKNOWN, CLASS_NAME, "registerMBean", "Found Oracle Apps MBeanServer but could not access the getMBeanServer method. ", null, ex);
                    mbs = ManagementFactory.getPlatformMBeanServer();
                }
                catch (InvocationTargetException ex) {
                    CommonDiagnosable.getInstance().debug(Level.WARNING, SecurityLabel.UNKNOWN, CLASS_NAME, "registerMBean", "Found Oracle Apps MBeanServer but the getMBeanServer method threw an exception. ", null, ex);
                    mbs = ManagementFactory.getPlatformMBeanServer();
                }
                if (mbs != null) {
                    ClassLoader loader = ReplayStatisticsMBeanImpl.class.getClassLoader();
                    String loaderName = loader == null ? "nullLoader" : loader.getClass().getName();
                    int count = 0;
                    while (true) {
                        String nameSuffix = loaderName + "@" + Integer.toHexString((loader == null ? 0 : loader.hashCode()) + count++);
                        mbeanName = new ObjectName(registeredName + nameSuffix);
                        try {
                            mbs.registerMBean(ReplayStatisticsMBeanImpl.SOLE_INSTANCE, mbeanName);
                            break block14;
                        }
                        catch (InstanceAlreadyExistsException ex) {
                            CommonDiagnosable.getInstance().debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "registerMBean", "AC statistics MBean with the same name already registered. ", null, null);
                            continue;
                        }
                        break;
                    }
                }
                CommonDiagnosable.getInstance().debug(Level.WARNING, SecurityLabel.UNKNOWN, CLASS_NAME, "registerMBean", "Unable to find an MBeanServer so no MBears are registered. ", null, null);
            }
            catch (JMException ex) {
                CommonDiagnosable.getInstance().debug(Level.WARNING, SecurityLabel.UNKNOWN, CLASS_NAME, "registerMBean", "Error while registering Oracle JDBC AC statistics MBean. ", null, ex);
            }
            catch (Throwable ex) {
                CommonDiagnosable.getInstance().debug(Level.WARNING, SecurityLabel.UNKNOWN, CLASS_NAME, "registerMBean", "Error while registering Oracle JDBC AC statistics MBean. ", null, ex);
            }
        }
    }

    public static void unregisterMBean() {
        try {
            MBeanServer mbs = null;
            try {
                Class<?> cls = Class.forName("oracle.as.jmx.framework.PortableMBeanFactory");
                Object factory = cls.newInstance();
                Method mthd = cls.getMethod("getMBeanServer", new Class[0]);
                mbs = (MBeanServer)mthd.invoke(factory, new Object[0]);
            }
            catch (Throwable ex) {
                mbs = ManagementFactory.getPlatformMBeanServer();
            }
            if (mbs != null) {
                try {
                    ClassLoader loader = ReplayStatisticsMBeanImpl.class.getClassLoader();
                    String loaderName = loader == null ? "nullLoader" : loader.getClass().getName();
                    int count = 0;
                    String nameSuffix = loaderName + "@" + Integer.toHexString((loader == null ? 0 : loader.hashCode()) + count++);
                    mbeanName = new ObjectName(registeredName + nameSuffix);
                    mbs.unregisterMBean(mbeanName);
                }
                catch (Throwable ex) {
                    CommonDiagnosable.getInstance().debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "unregisterMBean", "Unable to unregister Oracle JDBC AC statistics MBean.", null, ex);
                }
            } else {
                CommonDiagnosable.getInstance().debug(Level.WARNING, SecurityLabel.UNKNOWN, CLASS_NAME, "unregisterMBean", "Unable to find an MBeanServer to unregister Oracle JDBC AC statistics MBean. ", null, null);
            }
        }
        catch (Throwable ex) {
            CommonDiagnosable.getInstance().debug(Level.WARNING, SecurityLabel.UNKNOWN, CLASS_NAME, "unregisterMBean", "Error while unregistering Oracle JDBC AC statistics MBean. ", null, ex);
        }
    }

    public static void cleanup() {
        OracleDataSource.unregisterMBean();
    }

    protected void finalize() throws Throwable {
        try {
            if (this.tracker != null) {
                ReplayStatisticsMBeanImpl.SOLE_INSTANCE.removeTrackerForDS(this.tracker);
                this.tracker = null;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.finalize();
    }

    @Override
    public Diagnosable getDiagnosable() {
        return CommonDiagnosable.getInstance();
    }

    @Override
    public final Monitor.CloseableLock getMonitorLock() {
        return this.monitorLock;
    }

    @Override
    public final void setTokenSupplier(Supplier<? extends AccessToken> tokenSupplier) {
        this.tokenSupplier = Objects.requireNonNull(tokenSupplier, "tokenSuplier is null");
    }

    static {
        try (Monitor.CloseableLock lock = proxyFactoryLock.acquireCloseableLock();){
            if (PROXY_FACTORY == null) {
                NON_TXN_PROXY_FACTORY = ProxyFactory.createProxyFactory(NonTxnReplayableBase.class, NonTxnReplayableConnection.class, NonTxnReplayableStatement.class, NonTxnReplayableResultSet.class, NonTxnReplayableArray.class, NonTxnReplayableBfile.class, NonTxnReplayableBlob.class, NonTxnReplayableClob.class, NonTxnReplayableNClob.class, NonTxnReplayableOpaque.class, NonTxnReplayableRef.class, NonTxnReplayableStruct.class, NonTxnReplayableOthers.class);
                PROXY_FACTORY = ProxyFactory.createProxyFactory(TxnReplayableBase.class, TxnReplayableConnection.class, TxnReplayableStatement.class, TxnReplayableResultSet.class, TxnReplayableArray.class, TxnReplayableBfile.class, TxnReplayableBlob.class, TxnReplayableClob.class, TxnReplayableNClob.class, TxnReplayableOpaque.class, TxnReplayableRef.class, TxnReplayableSqlxml.class, TxnReplayableStruct.class, TxnReplayableOthers.class);
            }
        }
        mbeanName = null;
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                OracleDataSource.registerMBean();
                return null;
            }
        });
        _Copyright_2014_Oracle_All_Rights_Reserved_ = null;
    }
}

