/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.layout;

import com.openhtmltopdf.css.constants.CSSName;
import com.openhtmltopdf.css.constants.IdentValue;
import com.openhtmltopdf.css.style.CalculatedStyle;
import com.openhtmltopdf.css.style.CssContext;
import com.openhtmltopdf.extend.FSTextBreaker;
import com.openhtmltopdf.layout.LayoutContext;
import com.openhtmltopdf.layout.LineBreakContext;
import com.openhtmltopdf.layout.SharedContext;
import com.openhtmltopdf.layout.TextUtil;
import com.openhtmltopdf.render.FSFont;
import java.util.function.ToIntFunction;

public class Breaker {
    public static final char SOFT_HYPHEN = '\u00ad';
    public static final TextBreakerSupplier STANDARD_CHARACTER_BREAKER = new CharacterBreakerSupplier();
    public static final TextBreakerSupplier STANDARD_LINE_BREAKER = new LineBreakerSupplier();

    public static void breakFirstLetter(LayoutContext c, LineBreakContext context, int avail, CalculatedStyle style) {
        FSFont font = style.getFSFont(c);
        float letterSpacing = style.hasLetterSpacing() ? style.getFloatPropertyProportionalWidth(CSSName.LETTER_SPACING, 0.0f, c) : 0.0f;
        context.setEnd(Breaker.getFirstLetterEnd(context.getMaster(), context.getStart()));
        context.setWidth(c.getTextRenderer().getWidth(c.getFontContext(), font, context.getCalculatedSubstring()) + (int)letterSpacing);
        if (context.getWidth() > avail) {
            context.setNeedsNewLine(true);
            context.setUnbreakable(true);
        }
    }

    private static int getFirstLetterEnd(String text, int start) {
        int currentChar;
        boolean letterFound = false;
        int end = text.length();
        for (int i = start; i < end; i += Character.charCount(currentChar)) {
            currentChar = text.codePointAt(i);
            if (TextUtil.isFirstLetterSeparatorChar(currentChar)) continue;
            if (letterFound) {
                return i;
            }
            letterFound = true;
        }
        return end;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static LineBreakContext.LineBreakResult breakText(LayoutContext c, LineBreakContext context, int avail, CalculatedStyle style, boolean tryToBreakAnywhere, int lineWidth) {
        LineBreakContext.LineBreakResult result;
        float letterSpacing;
        FSFont font = style.getFSFont(c);
        IdentValue whitespace = style.getWhitespace();
        float f = letterSpacing = style.hasLetterSpacing() ? style.getFloatPropertyProportionalWidth(CSSName.LETTER_SPACING, 0.0f, c) : 0.0f;
        if (whitespace == IdentValue.NOWRAP) {
            int width = Breaker.getTextWidthWithLetterSpacing(c, font, context.getMaster(), letterSpacing);
            if (width <= avail) {
                c.setLineBreakedBecauseOfNoWrap(false);
                context.setEnd(context.getLast());
                context.setWidth(width);
                return LineBreakContext.LineBreakResult.WORD_BREAKING_FINISHED;
            }
            if (!c.isLineBreakedBecauseOfNoWrap()) {
                c.setLineBreakedBecauseOfNoWrap(true);
                context.setEnd(context.getStart());
                context.setWidth(0);
                context.setNeedsNewLine(true);
                return LineBreakContext.LineBreakResult.WORD_BREAKING_NEED_NEW_LINE;
            }
            c.setLineBreakedBecauseOfNoWrap(false);
            context.setEnd(context.getLast());
            context.setWidth(width);
            return LineBreakContext.LineBreakResult.WORD_BREAKING_FINISHED;
        }
        if (whitespace == IdentValue.PRE || whitespace == IdentValue.PRE_WRAP || whitespace == IdentValue.PRE_LINE) {
            int n = context.getStartSubstring().indexOf("\n");
            if (n > -1) {
                context.setEnd(context.getStart() + n + 1);
                context.setWidth(Breaker.getTextWidthWithLetterSpacing(c, font, context.getCalculatedSubstring(), letterSpacing));
                context.setNeedsNewLine(true);
                context.setEndsOnNL(true);
            } else if (whitespace == IdentValue.PRE) {
                context.setEnd(context.getLast());
                context.setWidth(Breaker.getTextWidthWithLetterSpacing(c, font, context.getCalculatedSubstring(), letterSpacing));
            }
        }
        if (whitespace == IdentValue.PRE || context.isNeedsNewLine() && context.getWidth() <= avail) {
            LineBreakContext.LineBreakResult lineBreakResult;
            if (context.isNeedsNewLine()) {
                lineBreakResult = LineBreakContext.LineBreakResult.WORD_BREAKING_NEED_NEW_LINE;
                return lineBreakResult;
            }
            lineBreakResult = LineBreakContext.LineBreakResult.WORD_BREAKING_FINISHED;
            return lineBreakResult;
        }
        context.setEndsOnNL(false);
        if (style.getWordWrap() != IdentValue.BREAK_WORD) {
            return Breaker.doBreakText(c, context, avail, style, tryToBreakAnywhere);
        }
        int originalStart = context.getStart();
        int totalWidth = 0;
        block7: while (true) {
            int savedEnd = context.getEnd();
            result = Breaker.doBreakText(c, context, avail, style, tryToBreakAnywhere);
            switch (result) {
                case WORD_BREAKING_FINISHED: 
                case CHAR_BREAKING_FINISHED: 
                case CHAR_BREAKING_NEED_NEW_LINE: {
                    totalWidth += context.getWidth();
                    break block7;
                }
                case CHAR_BREAKING_UNBREAKABLE: {
                    if (totalWidth == 0 && avail == lineWidth) {
                        totalWidth += context.getWidth();
                        break block7;
                    }
                    context.setEnd(savedEnd);
                    break block7;
                }
                case CHAR_BREAKING_FOUND_WORD_BREAK: {
                    tryToBreakAnywhere = false;
                    break;
                }
                case WORD_BREAKING_NEED_NEW_LINE: {
                    if (context.getNextWidth() >= lineWidth) {
                        tryToBreakAnywhere = true;
                        break;
                    }
                    totalWidth += context.getWidth();
                    break block7;
                }
                case WORD_BREAKING_UNBREAKABLE: {
                    if (context.getWidth() >= lineWidth || context.isFirstCharInLine()) {
                        tryToBreakAnywhere = true;
                        context.setEnd(savedEnd);
                        continue block7;
                    }
                    context.setEnd(savedEnd);
                    break block7;
                }
            }
            context.setStart(context.getEnd());
            avail -= context.getWidth();
            totalWidth += context.getWidth();
        }
        context.setStart(originalStart);
        context.setWidth(totalWidth);
        context.setFinishedInCharBreakingMode(tryToBreakAnywhere);
        return result;
    }

    private static LineBreakContext.LineBreakResult doBreakText(LayoutContext c, LineBreakContext context, int avail, CalculatedStyle style, boolean tryToBreakAnywhere) {
        if (!tryToBreakAnywhere) {
            return Breaker.doBreakText(c, context, avail, style, STANDARD_LINE_BREAKER);
        }
        FSFont font = style.getFSFont(c);
        float letterSpacing = style.hasLetterSpacing() ? style.getFloatPropertyProportionalWidth(CSSName.LETTER_SPACING, 0.0f, c) : 0.0f;
        ToIntFunction<String> measurer = str -> c.getTextRenderer().getWidth(c.getFontContext(), font, (String)str);
        String currentString = context.getStartSubstring();
        FSTextBreaker lineIterator = STANDARD_LINE_BREAKER.getBreaker(currentString, c.getSharedContext());
        FSTextBreaker charIterator = STANDARD_CHARACTER_BREAKER.getBreaker(currentString, c.getSharedContext());
        return Breaker.doBreakCharacters(currentString, lineIterator, charIterator, context, avail, letterSpacing, measurer);
    }

    static LineBreakContext.LineBreakResult doBreakCharacters(String currentString, FSTextBreaker lineIterator, FSTextBreaker charIterator, LineBreakContext context, int avail, float letterSpacing, ToIntFunction<String> measurer) {
        int graphicsLength;
        int splitWidth;
        int nextCharBreak;
        int nextWordBreak = lineIterator.next();
        if (nextWordBreak == 0) {
            nextWordBreak = lineIterator.next();
        }
        if (nextWordBreak < 0) {
            nextWordBreak = currentString.length();
        }
        if ((nextCharBreak = charIterator.next()) < 0) {
            nextCharBreak = nextWordBreak;
        }
        int left = 0;
        int lastGoodWrap = 0;
        int lastGoodGraphicsLength = 0;
        for (graphicsLength = 0; nextCharBreak >= 0 && nextCharBreak <= nextWordBreak && graphicsLength < avail; graphicsLength += splitWidth) {
            String subString = currentString.substring(left, nextCharBreak);
            float extraSpacing = (float)(nextCharBreak - left) * letterSpacing;
            splitWidth = (int)((float)measurer.applyAsInt(subString) + extraSpacing);
            lastGoodWrap = left;
            left = nextCharBreak;
            lastGoodGraphicsLength = graphicsLength;
            nextCharBreak = charIterator.next();
        }
        if (graphicsLength == avail && graphicsLength > 0) {
            boolean needNewLine = currentString.length() > left;
            context.setNeedsNewLine(needNewLine);
            context.setEnd(left + context.getStart());
            context.setWidth(graphicsLength);
            if (left >= currentString.length()) {
                return LineBreakContext.LineBreakResult.CHAR_BREAKING_FINISHED;
            }
            if (left >= nextWordBreak) {
                return LineBreakContext.LineBreakResult.CHAR_BREAKING_FOUND_WORD_BREAK;
            }
            return LineBreakContext.LineBreakResult.CHAR_BREAKING_NEED_NEW_LINE;
        }
        if (nextCharBreak < 0) {
            nextCharBreak = nextWordBreak;
        }
        if (graphicsLength < avail) {
            lastGoodWrap = nextCharBreak;
            lastGoodGraphicsLength = graphicsLength;
            nextCharBreak = nextWordBreak;
            float extraSpacing = (float)(nextCharBreak - left) * letterSpacing;
            int splitWidth2 = (int)((float)measurer.applyAsInt(currentString.substring(left, nextCharBreak)) + extraSpacing);
            graphicsLength += splitWidth2;
        }
        if (graphicsLength <= avail && graphicsLength > 0) {
            context.setWidth(graphicsLength);
            context.setEnd(nextCharBreak + context.getStart());
            context.setEndsOnWordBreak(nextCharBreak == nextWordBreak);
            if (nextCharBreak >= currentString.length()) {
                return LineBreakContext.LineBreakResult.CHAR_BREAKING_FINISHED;
            }
            if (nextCharBreak >= nextWordBreak) {
                return LineBreakContext.LineBreakResult.CHAR_BREAKING_FOUND_WORD_BREAK;
            }
            return LineBreakContext.LineBreakResult.CHAR_BREAKING_NEED_NEW_LINE;
        }
        context.setNeedsNewLine(true);
        if (lastGoodWrap != 0) {
            context.setWidth(lastGoodGraphicsLength);
            context.setEnd(lastGoodWrap + context.getStart());
            context.setEndsOnWordBreak(lastGoodWrap == nextWordBreak);
            if (lastGoodWrap >= currentString.length()) {
                return LineBreakContext.LineBreakResult.CHAR_BREAKING_FINISHED;
            }
            if (lastGoodWrap >= nextWordBreak) {
                return LineBreakContext.LineBreakResult.CHAR_BREAKING_FOUND_WORD_BREAK;
            }
            return LineBreakContext.LineBreakResult.CHAR_BREAKING_NEED_NEW_LINE;
        }
        if (!currentString.isEmpty()) {
            int end = 1;
            float extraSpacing = letterSpacing;
            splitWidth = (int)((float)measurer.applyAsInt(currentString.substring(0, end)) + extraSpacing);
            context.setUnbreakable(true);
            context.setEnd(end + context.getStart());
            context.setEndsOnWordBreak(end == nextWordBreak);
            context.setWidth(splitWidth);
            return LineBreakContext.LineBreakResult.CHAR_BREAKING_UNBREAKABLE;
        }
        context.setEnd(context.getStart());
        context.setWidth(0);
        context.setNeedsNewLine(false);
        return LineBreakContext.LineBreakResult.CHAR_BREAKING_FINISHED;
    }

    public static LineBreakContext.LineBreakResult doBreakText(LayoutContext c, LineBreakContext context, int avail, CalculatedStyle style, TextBreakerSupplier lineBreaker) {
        FSFont font = style.getFSFont(c);
        float letterSpacing = style.hasLetterSpacing() ? style.getFloatPropertyProportionalWidth(CSSName.LETTER_SPACING, 0.0f, c) : 0.0f;
        ToIntFunction<String> measurer = str -> c.getTextRenderer().getWidth(c.getFontContext(), font, (String)str);
        String currentString = context.getStartSubstring();
        FSTextBreaker lineIterator = lineBreaker.getBreaker(currentString, c.getSharedContext());
        return Breaker.doBreakTextWords(currentString, context, avail, lineIterator, letterSpacing, measurer);
    }

    static LineBreakContext.LineBreakResult doBreakTextWords(String currentString, LineBreakContext context, int avail, FSTextBreaker iterator, float letterSpacing, ToIntFunction<String> measurer) {
        float extraSpacing;
        int lastWrap = 0;
        AppBreakOpportunity current = new AppBreakOpportunity();
        AppBreakOpportunity prev = new AppBreakOpportunity();
        current.right = iterator.next();
        if (current.right == 0) {
            current.right = iterator.next();
        }
        int nextUnfittableSplitWidth = 0;
        while (current.right > 0 && current.graphicsLength <= avail) {
            current.copyTo(prev);
            String subString = currentString.substring(current.left, current.right);
            extraSpacing = (float)(current.right - current.left) * letterSpacing;
            int normalSplitWidth = (int)((float)measurer.applyAsInt(subString) + extraSpacing);
            if (currentString.charAt(current.right - 1) == '\u00ad') {
                current.isSoftHyphenBreak = true;
                int withTrailingHyphenSplitWidth = (int)((float)measurer.applyAsInt(subString + '-') + extraSpacing + letterSpacing);
                current.withHyphenGraphicsLength = current.graphicsLength + withTrailingHyphenSplitWidth;
                if (current.withHyphenGraphicsLength >= avail && current.right != currentString.length()) {
                    current.graphicsLength = current.withHyphenGraphicsLength;
                    lastWrap = current.left;
                    current.left = current.right;
                    current.right = iterator.next();
                    break;
                }
            } else {
                current.isSoftHyphenBreak = false;
                current.withHyphenGraphicsLength += normalSplitWidth;
            }
            current.graphicsLength += normalSplitWidth;
            nextUnfittableSplitWidth = normalSplitWidth;
            lastWrap = current.left;
            current.left = current.right;
            current.right = iterator.next();
        }
        if (current.graphicsLength <= avail) {
            lastWrap = current.left;
            current.copyTo(prev);
            current.right = currentString.length();
            float extraSpacing2 = (float)(current.right - current.left) * letterSpacing;
            int splitWidth = (int)((float)measurer.applyAsInt(currentString.substring(current.left)) + extraSpacing2);
            current.graphicsLength += splitWidth;
            nextUnfittableSplitWidth = splitWidth;
        }
        if (current.graphicsLength <= avail) {
            context.setWidth(current.graphicsLength);
            context.setEnd(context.getMaster().length());
            return LineBreakContext.LineBreakResult.WORD_BREAKING_FINISHED;
        }
        context.setNeedsNewLine(true);
        if (lastWrap != 0) {
            if (prev.isSoftHyphenBreak) {
                context.setEndsOnSoftHyphen(true);
                context.setWidth(prev.withHyphenGraphicsLength);
            } else {
                context.setWidth(prev.graphicsLength);
            }
            context.setNextWidth(nextUnfittableSplitWidth);
            context.setEnd(context.getStart() + lastWrap);
            return LineBreakContext.LineBreakResult.WORD_BREAKING_NEED_NEW_LINE;
        }
        if (current.left == 0) {
            current.left = currentString.length();
        }
        context.setEnd(context.getStart() + current.left);
        context.setUnbreakable(true);
        if (current.isSoftHyphenBreak) {
            context.setWidth(current.withHyphenGraphicsLength);
        } else if (current.left == currentString.length()) {
            String text = context.getCalculatedSubstring();
            extraSpacing = (float)text.length() * letterSpacing;
            context.setWidth((int)((float)measurer.applyAsInt(text) + extraSpacing));
        } else {
            context.setWidth(current.graphicsLength);
        }
        return LineBreakContext.LineBreakResult.WORD_BREAKING_UNBREAKABLE;
    }

    public static FSTextBreaker getCharacterBreakStream(String currentString, SharedContext sharedContext) {
        FSTextBreaker i = sharedContext.getCharacterBreaker();
        i.setText(currentString);
        return i;
    }

    public static FSTextBreaker getLineBreakStream(String s, SharedContext shared) {
        FSTextBreaker i = shared.getLineBreaker();
        i.setText(s);
        return i;
    }

    public static int getTextWidthWithLetterSpacing(CssContext c, FSFont font, String text, float letterSpacing) {
        float extraSpace = (float)text.length() * letterSpacing;
        return (int)((float)c.getTextRenderer().getWidth(c.getFontContext(), font, text) + extraSpace);
    }

    public static interface TextBreakerSupplier {
        public FSTextBreaker getBreaker(String var1, SharedContext var2);
    }

    private static class AppBreakOpportunity {
        int left;
        int right;
        int graphicsLength;
        int withHyphenGraphicsLength;
        boolean isSoftHyphenBreak;

        private AppBreakOpportunity() {
        }

        void copyTo(AppBreakOpportunity other) {
            other.left = this.left;
            other.right = this.right;
            other.graphicsLength = this.graphicsLength;
            other.withHyphenGraphicsLength = this.withHyphenGraphicsLength;
            other.isSoftHyphenBreak = this.isSoftHyphenBreak;
        }
    }

    private static class CharacterBreakerSupplier
    implements TextBreakerSupplier {
        private CharacterBreakerSupplier() {
        }

        @Override
        public FSTextBreaker getBreaker(String str, SharedContext sharedContext) {
            return Breaker.getCharacterBreakStream(str, sharedContext);
        }
    }

    private static class LineBreakerSupplier
    implements TextBreakerSupplier {
        private LineBreakerSupplier() {
        }

        @Override
        public FSTextBreaker getBreaker(String str, SharedContext sharedContext) {
            return Breaker.getLineBreakStream(str, sharedContext);
        }
    }
}

