/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus.primitives;

import com.microsoft.azure.servicebus.primitives.ClientConstants;
import com.microsoft.azure.servicebus.primitives.ClientEntity;
import com.microsoft.azure.servicebus.primitives.ExceptionUtil;
import com.microsoft.azure.servicebus.primitives.MessagingFactory;
import com.microsoft.azure.servicebus.primitives.Pair;
import com.microsoft.azure.servicebus.primitives.RequestResponseLink;
import com.microsoft.azure.servicebus.primitives.RequestResponseUtils;
import com.microsoft.azure.servicebus.primitives.StringUtil;
import com.microsoft.azure.servicebus.primitives.TimeoutException;
import com.microsoft.azure.servicebus.primitives.Timer;
import com.microsoft.azure.servicebus.primitives.TimerType;
import com.microsoft.azure.servicebus.primitives.Util;
import com.microsoft.azure.servicebus.rules.RuleDescription;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledFuture;
import org.apache.qpid.proton.amqp.DescribedType;
import org.apache.qpid.proton.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MiscRequestResponseOperationHandler
extends ClientEntity {
    private static final Logger TRACE_LOGGER = LoggerFactory.getLogger(MiscRequestResponseOperationHandler.class);
    private final Object requestResonseLinkCreationLock = new Object();
    private final String entityPath;
    private final String sasTokenAudienceURI;
    private final MessagingFactory underlyingFactory;
    private RequestResponseLink requestResponseLink;
    private CompletableFuture<Void> requestResponseLinkCreationFuture;
    private ScheduledFuture<?> sasTokenRenewTimerFuture;

    private MiscRequestResponseOperationHandler(MessagingFactory factory, String linkName, String entityPath) {
        super(linkName, factory);
        this.underlyingFactory = factory;
        this.entityPath = entityPath;
        this.sasTokenAudienceURI = String.format("amqp://%s/%s", factory.getHostName(), entityPath);
    }

    public static CompletableFuture<MiscRequestResponseOperationHandler> create(MessagingFactory factory, String entityPath) {
        final CompletableFuture<MiscRequestResponseOperationHandler> creationFuture = new CompletableFuture<MiscRequestResponseOperationHandler>();
        final MiscRequestResponseOperationHandler requestResponseOperationHandler = new MiscRequestResponseOperationHandler(factory, StringUtil.getShortRandomString(), entityPath);
        requestResponseOperationHandler.sendSASTokenAndSetRenewTimer(false).handleAsync((v, ex) -> {
            if (ex == null) {
                TRACE_LOGGER.info("Opened MiscRequestResponseOperationHandler");
                creationFuture.complete(requestResponseOperationHandler);
            } else {
                TRACE_LOGGER.error("Opening of MiscRequestResponseOperationHandler failed", ex);
                creationFuture.completeExceptionally(ExceptionUtil.extractAsyncCompletionCause(ex));
            }
            return null;
        });
        Timer.schedule(new Runnable(){

            @Override
            public void run() {
                if (!creationFuture.isDone()) {
                    requestResponseOperationHandler.closeInternals();
                    TimeoutException operationTimedout = new TimeoutException(String.format(Locale.US, "Open operation on CBSLink(%s) on Entity(%s) timed out at %s.", requestResponseOperationHandler.getClientId(), requestResponseOperationHandler.entityPath, ZonedDateTime.now().toString()));
                    TRACE_LOGGER.warn(((Throwable)operationTimedout).getMessage());
                    creationFuture.completeExceptionally(operationTimedout);
                }
            }
        }, factory.getOperationTimeout(), TimerType.OneTimeRun);
        return creationFuture;
    }

    private void closeInternals() {
        this.cancelSASTokenRenewTimer();
        this.closeRequestResponseLink();
    }

    @Override
    protected CompletableFuture<Void> onClose() {
        TRACE_LOGGER.trace("Closing MiscRequestResponseOperationHandler");
        this.closeInternals();
        return CompletableFuture.completedFuture(null);
    }

    private CompletableFuture<Void> sendSASTokenAndSetRenewTimer(boolean retryOnFailure) {
        if (this.getIsClosingOrClosed()) {
            return CompletableFuture.completedFuture(null);
        }
        CompletableFuture<ScheduledFuture<?>> sendTokenFuture = this.underlyingFactory.sendSASTokenAndSetRenewTimer(this.sasTokenAudienceURI, retryOnFailure, () -> this.sendSASTokenAndSetRenewTimer(true));
        return sendTokenFuture.thenAccept(f -> {
            this.sasTokenRenewTimerFuture = f;
            TRACE_LOGGER.debug("Set SAS Token renew timer");
        });
    }

    private void cancelSASTokenRenewTimer() {
        if (this.sasTokenRenewTimerFuture != null && !this.sasTokenRenewTimerFuture.isDone()) {
            TRACE_LOGGER.debug("Cancelling SAS Token renew timer");
            this.sasTokenRenewTimerFuture.cancel(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<Void> createRequestResponseLink() {
        Object object = this.requestResonseLinkCreationLock;
        synchronized (object) {
            if (this.requestResponseLinkCreationFuture == null) {
                this.requestResponseLinkCreationFuture = new CompletableFuture();
                this.underlyingFactory.obtainRequestResponseLinkAsync(this.entityPath).handleAsync((rrlink, ex) -> {
                    if (ex == null) {
                        this.requestResponseLink = rrlink;
                        this.requestResponseLinkCreationFuture.complete(null);
                    } else {
                        Throwable cause = ExceptionUtil.extractAsyncCompletionCause(ex);
                        this.requestResponseLinkCreationFuture.completeExceptionally(cause);
                        Object object = this.requestResonseLinkCreationLock;
                        synchronized (object) {
                            this.requestResponseLinkCreationFuture = null;
                        }
                    }
                    return null;
                });
            }
            return this.requestResponseLinkCreationFuture;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeRequestResponseLink() {
        Object object = this.requestResonseLinkCreationLock;
        synchronized (object) {
            if (this.requestResponseLinkCreationFuture != null) {
                this.requestResponseLinkCreationFuture.thenRun(() -> {
                    this.underlyingFactory.releaseRequestResponseLink(this.entityPath);
                    this.requestResponseLink = null;
                });
                this.requestResponseLinkCreationFuture = null;
            }
        }
    }

    public CompletableFuture<Pair<String[], Integer>> getMessageSessionsAsync(Date lastUpdatedTime, int skip, int top, String lastSessionId) {
        TRACE_LOGGER.debug("Getting message sessions from entity '{}' with lastupdatedtime '{}', skip '{}', top '{}', lastsessionid '{}'", new Object[]{this.entityPath, lastUpdatedTime, skip, top, lastSessionId});
        return this.createRequestResponseLink().thenComposeAsync(v -> {
            HashMap<String, Object> requestBodyMap = new HashMap<String, Object>();
            requestBodyMap.put("last-updated-time", lastUpdatedTime);
            requestBodyMap.put("skip", skip);
            requestBodyMap.put("top", top);
            if (lastSessionId != null) {
                requestBodyMap.put("last-session-id", lastSessionId);
            }
            Message requestMessage = RequestResponseUtils.createRequestMessageFromPropertyBag("com.microsoft:get-message-sessions", requestBodyMap, Util.adjustServerTimeout(this.underlyingFactory.getOperationTimeout()));
            CompletableFuture<Message> responseFuture = this.requestResponseLink.requestAysnc(requestMessage, this.underlyingFactory.getOperationTimeout());
            return responseFuture.thenComposeAsync(responseMessage -> {
                CompletableFuture<Pair<String[], Integer>> returningFuture = new CompletableFuture<Pair<String[], Integer>>();
                int statusCode = RequestResponseUtils.getResponseStatusCode(responseMessage);
                if (statusCode == 200) {
                    Map responseBodyMap = RequestResponseUtils.getResponseBody(responseMessage);
                    int responseSkip = (Integer)responseBodyMap.get("skip");
                    String[] sessionIds = (String[])responseBodyMap.get("sessions-ids");
                    TRACE_LOGGER.debug("Received '{}' sessions from entity '{}'. Response skip '{}'", new Object[]{sessionIds.length, this.entityPath, responseSkip});
                    returningFuture.complete(new Pair<String[], Integer>(sessionIds, responseSkip));
                } else if (statusCode == 204 || statusCode == 404 && ClientConstants.SESSION_NOT_FOUND_ERROR.equals(RequestResponseUtils.getResponseErrorCondition(responseMessage))) {
                    TRACE_LOGGER.debug("Received no sessions from entity '{}'.", (Object)this.entityPath);
                    returningFuture.complete(new Pair<String[], Integer>(new String[0], 0));
                } else {
                    TRACE_LOGGER.debug("Receiving sessions from entity '{}' failed with status code '{}'", (Object)this.entityPath, (Object)statusCode);
                    returningFuture.completeExceptionally(RequestResponseUtils.genereateExceptionFromResponse(responseMessage));
                }
                return returningFuture;
            });
        });
    }

    public CompletableFuture<Void> removeRuleAsync(String ruleName) {
        TRACE_LOGGER.debug("Removing rule '{}' from entity '{}'", (Object)ruleName, (Object)this.entityPath);
        return this.createRequestResponseLink().thenComposeAsync(v -> {
            HashMap<String, String> requestBodyMap = new HashMap<String, String>();
            requestBodyMap.put("rule-name", ruleName);
            Message requestMessage = RequestResponseUtils.createRequestMessageFromPropertyBag("com.microsoft:remove-rule", requestBodyMap, Util.adjustServerTimeout(this.underlyingFactory.getOperationTimeout()));
            CompletableFuture<Message> responseFuture = this.requestResponseLink.requestAysnc(requestMessage, this.underlyingFactory.getOperationTimeout());
            return responseFuture.thenComposeAsync(responseMessage -> {
                CompletableFuture returningFuture = new CompletableFuture();
                int statusCode = RequestResponseUtils.getResponseStatusCode(responseMessage);
                if (statusCode == 200) {
                    TRACE_LOGGER.debug("Removed rule '{}' from entity '{}'", (Object)ruleName, (Object)this.entityPath);
                    returningFuture.complete(null);
                } else {
                    TRACE_LOGGER.error("Removing rule '{}' from entity '{}' failed with status code '{}'", new Object[]{ruleName, this.entityPath, statusCode});
                    returningFuture.completeExceptionally(RequestResponseUtils.genereateExceptionFromResponse(responseMessage));
                }
                return returningFuture;
            });
        });
    }

    public CompletableFuture<Void> addRuleAsync(RuleDescription ruleDescription) {
        TRACE_LOGGER.debug("Adding rule '{}' to entity '{}'", (Object)ruleDescription.getName(), (Object)this.entityPath);
        return this.createRequestResponseLink().thenComposeAsync(v -> {
            HashMap<String, Object> requestBodyMap = new HashMap<String, Object>();
            requestBodyMap.put("rule-name", ruleDescription.getName());
            requestBodyMap.put("rule-description", RequestResponseUtils.encodeRuleDescriptionToMap(ruleDescription));
            Message requestMessage = RequestResponseUtils.createRequestMessageFromPropertyBag("com.microsoft:add-rule", requestBodyMap, Util.adjustServerTimeout(this.underlyingFactory.getOperationTimeout()));
            CompletableFuture<Message> responseFuture = this.requestResponseLink.requestAysnc(requestMessage, this.underlyingFactory.getOperationTimeout());
            return responseFuture.thenComposeAsync(responseMessage -> {
                CompletableFuture returningFuture = new CompletableFuture();
                int statusCode = RequestResponseUtils.getResponseStatusCode(responseMessage);
                if (statusCode == 200) {
                    TRACE_LOGGER.debug("Added rule '{}' to entity '{}'", (Object)ruleDescription.getName(), (Object)this.entityPath);
                    returningFuture.complete(null);
                } else {
                    TRACE_LOGGER.error("Adding rule '{}' to entity '{}' failed with status code '{}'", new Object[]{ruleDescription.getName(), this.entityPath, statusCode});
                    returningFuture.completeExceptionally(RequestResponseUtils.genereateExceptionFromResponse(responseMessage));
                }
                return returningFuture;
            });
        });
    }

    public CompletableFuture<Collection<RuleDescription>> getRulesAsync(int skip, int top) {
        TRACE_LOGGER.debug("Fetching rules for entity '{}'", (Object)this.entityPath);
        return this.createRequestResponseLink().thenComposeAsync(v -> {
            HashMap<String, Integer> requestBodyMap = new HashMap<String, Integer>();
            requestBodyMap.put("skip", skip);
            requestBodyMap.put("top", top);
            Message requestMessage = RequestResponseUtils.createRequestMessageFromPropertyBag("com.microsoft:enumerate-rules", requestBodyMap, Util.adjustServerTimeout(this.underlyingFactory.getOperationTimeout()));
            CompletableFuture<Message> responseFuture = this.requestResponseLink.requestAysnc(requestMessage, this.underlyingFactory.getOperationTimeout());
            return responseFuture.thenComposeAsync(responseMessage -> {
                CompletableFuture returningFuture = new CompletableFuture();
                ArrayList<RuleDescription> rules = new ArrayList<RuleDescription>();
                int statusCode = RequestResponseUtils.getResponseStatusCode(responseMessage);
                if (statusCode == 200) {
                    Map responseBodyMap = RequestResponseUtils.getResponseBody(responseMessage);
                    ArrayList rulesMap = (ArrayList)responseBodyMap.get("rules");
                    for (Map ruleMap : rulesMap) {
                        DescribedType ruleDescription = ruleMap.getOrDefault("rule-description", null);
                        rules.add(RequestResponseUtils.decodeRuleDescriptionMap(ruleDescription));
                    }
                    TRACE_LOGGER.debug("Fetched {} rules from entity '{}'", (Object)rules.size(), (Object)this.entityPath);
                    returningFuture.complete(rules);
                } else if (statusCode == 204) {
                    returningFuture.complete(rules);
                } else {
                    TRACE_LOGGER.error("Fetching rules for entity '{}' failed with status code '{}'", (Object)this.entityPath, (Object)statusCode);
                    returningFuture.completeExceptionally(RequestResponseUtils.genereateExceptionFromResponse(responseMessage));
                }
                return returningFuture;
            });
        });
    }
}

