/*
 * Decompiled with CFR 0.152.
 */
package com.jolbox.bonecp;

import com.jolbox.bonecp.BoneCP;
import com.jolbox.bonecp.ConnectionHandle;
import com.jolbox.bonecp.ConnectionPartition;
import com.jolbox.bonecp.LIFOQueue;
import java.sql.SQLException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionTesterThread
implements Runnable {
    private long idleConnectionTestPeriodInMs;
    private long idleMaxAgeInMs;
    private ConnectionPartition partition;
    private ScheduledExecutorService scheduler;
    private BoneCP pool;
    private boolean lifoMode;
    private static Logger logger = LoggerFactory.getLogger(ConnectionTesterThread.class);

    protected ConnectionTesterThread(ConnectionPartition connectionPartition, ScheduledExecutorService scheduler, BoneCP pool, long idleMaxAgeInMs, long idleConnectionTestPeriodInMs, boolean lifoMode) {
        this.partition = connectionPartition;
        this.scheduler = scheduler;
        this.idleMaxAgeInMs = idleMaxAgeInMs;
        this.idleConnectionTestPeriodInMs = idleConnectionTestPeriodInMs;
        this.pool = pool;
        this.lifoMode = lifoMode;
    }

    @Override
    public void run() {
        ConnectionHandle connection = null;
        try {
            long nextCheckInMs = this.idleConnectionTestPeriodInMs;
            if (this.idleMaxAgeInMs > 0L) {
                nextCheckInMs = this.idleConnectionTestPeriodInMs == 0L ? this.idleMaxAgeInMs : Math.min(nextCheckInMs, this.idleMaxAgeInMs);
            }
            int partitionSize = this.partition.getAvailableConnections();
            long currentTimeInMs = System.currentTimeMillis();
            for (int i = 0; i < partitionSize; ++i) {
                long tmp;
                connection = (ConnectionHandle)this.partition.getFreeConnections().poll();
                if (connection == null) continue;
                connection.setOriginatingPartition(this.partition);
                if (!connection.isPoison() && connection.isPossiblyBroken() || this.idleMaxAgeInMs > 0L && this.partition.getAvailableConnections() >= this.partition.getMinConnections() && System.currentTimeMillis() - connection.getConnectionLastUsedInMs() > this.idleMaxAgeInMs) {
                    this.closeConnection(connection);
                    continue;
                }
                if (!connection.isPoison() && this.idleConnectionTestPeriodInMs > 0L && currentTimeInMs - connection.getConnectionLastUsedInMs() > this.idleConnectionTestPeriodInMs && currentTimeInMs - connection.getConnectionLastResetInMs() >= this.idleConnectionTestPeriodInMs) {
                    if (!this.pool.isConnectionHandleAlive(connection)) {
                        this.closeConnection(connection);
                        continue;
                    }
                    tmp = this.idleConnectionTestPeriodInMs;
                    if (this.idleMaxAgeInMs > 0L) {
                        tmp = Math.min(tmp, this.idleMaxAgeInMs);
                    }
                } else {
                    tmp = Math.abs(this.idleConnectionTestPeriodInMs - (currentTimeInMs - connection.getConnectionLastResetInMs()));
                    long tmp2 = Math.abs(this.idleMaxAgeInMs - (currentTimeInMs - connection.getConnectionLastUsedInMs()));
                    if (this.idleMaxAgeInMs > 0L) {
                        tmp = Math.min(tmp, tmp2);
                    }
                }
                if (tmp < nextCheckInMs) {
                    nextCheckInMs = tmp;
                }
                if (this.lifoMode) {
                    if (!((LIFOQueue)connection.getOriginatingPartition().getFreeConnections()).offerLast(connection)) {
                        connection.internalClose();
                    }
                } else {
                    this.pool.putConnectionBackInPartition(connection);
                }
                Thread.sleep(20L);
            }
            this.scheduler.schedule(this, nextCheckInMs, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            if (this.scheduler.isShutdown()) {
                logger.debug("Shutting down connection tester thread.");
            }
            logger.error("Connection tester thread interrupted", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeConnection(ConnectionHandle connection) {
        if (connection != null) {
            try {
                connection.internalClose();
            }
            catch (SQLException e) {
                logger.error("Destroy connection exception", (Throwable)e);
            }
            finally {
                this.pool.postDestroyConnection(connection);
            }
        }
    }
}

