/*
 * Decompiled with CFR 0.152.
 */
package jidefx.scene.control.field.verifier;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jidefx.scene.control.field.verifier.CalendarFieldPatternVerifier;
import jidefx.scene.control.field.verifier.PatternVerifier;

public class StringCalendarFieldPatternVerifier
extends CalendarFieldPatternVerifier
implements PatternVerifier.Formatter<Integer>,
PatternVerifier.Parser<Integer>,
PatternVerifier.Enums<String> {
    private final List<String> values = new ArrayList<String>();

    public StringCalendarFieldPatternVerifier(int field, String[] values) {
        super(field);
        Collections.addAll(this.values, values);
    }

    @Override
    public String format(Integer value) {
        return this.values.get(value);
    }

    @Override
    public Integer parse(String text) {
        for (int i = 0; i < this.values.size(); ++i) {
            String value = this.values.get(i);
            if (!value.startsWith(text)) continue;
            return i;
        }
        return -1;
    }

    public Boolean call(String text) {
        for (String value : this.values) {
            if (!value.startsWith(text)) continue;
            return true;
        }
        return this.values.contains(text);
    }

    @Override
    public List<String> getValues() {
        return this.values;
    }
}

