/*
 * Decompiled with CFR 0.152.
 */
package jidefx.scene.control.field.verifier;

import jidefx.scene.control.field.verifier.NumberRangePatternVerifier;
import jidefx.scene.control.field.verifier.PatternVerifier;

public abstract class NumberValuePatternVerifier<T>
extends NumberRangePatternVerifier
implements PatternVerifier.Value<T, Number> {
    private double valueMultiplier = 1.0;
    protected T fieldValue;
    protected Number targetValue;

    public NumberValuePatternVerifier() {
        this(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public NumberValuePatternVerifier(Number min, Number max) {
        super(min, max);
    }

    protected NumberValuePatternVerifier(Number min, Number max, double adjustmentMultiplier) {
        super(min, max, adjustmentMultiplier);
    }

    protected NumberValuePatternVerifier(Number min, Number max, double adjustmentMultiplier, double valueMultiplier) {
        super(min, max, adjustmentMultiplier);
        this.valueMultiplier = valueMultiplier;
    }

    protected double getMultipliedValue(double value) {
        return value * this.valueMultiplier;
    }

    protected double getDemultipliedValue(double value) {
        return value / this.valueMultiplier;
    }

    @Override
    protected Number getGroupValue(double targetValue) {
        this.targetValue = this.getDemultipliedValue(targetValue);
        return super.getGroupValue(targetValue);
    }

    @Override
    protected double getInitialValue(Number groupValue) {
        double newValue = this.targetValue != null ? this.targetValue.doubleValue() : (this.fieldValue != null ? ((Number)this.toTargetValue(this.fieldValue)).doubleValue() : super.getInitialValue(groupValue));
        return this.getMultipliedValue(newValue);
    }

    @Override
    protected Number ensureLessThanMax(Number groupValue) {
        groupValue = super.ensureLessThanMax(groupValue);
        this.targetValue = this.getTargetValue(groupValue);
        this.fieldValue = this.fromTargetValue(this.fieldValue, this.targetValue);
        return null;
    }

    @Override
    protected Number ensureMoreThanMin(Number groupValue) {
        groupValue = super.ensureMoreThanMin(groupValue);
        this.targetValue = this.getTargetValue(groupValue);
        this.fieldValue = this.fromTargetValue(this.fieldValue, this.targetValue);
        return null;
    }

    @Override
    public void setFieldValue(T fieldValue) {
        this.fieldValue = fieldValue;
        this.targetValue = (Number)this.toTargetValue(fieldValue);
    }

    @Override
    public T getFieldValue() {
        return this.fieldValue;
    }
}

