/*
 * Decompiled with CFR 0.152.
 */
package jidefx.scene.control.field.verifier;

import java.text.NumberFormat;
import java.text.ParseException;
import jidefx.scene.control.field.verifier.DateFieldPatternVerifier;
import jidefx.scene.control.field.verifier.PatternVerifier;
import jidefx.utils.CommonUtils;

public class IntegerDateFieldPatternVerifier
extends DateFieldPatternVerifier
implements PatternVerifier.Length,
PatternVerifier.Formatter<Integer>,
PatternVerifier.Parser<Integer> {
    private final boolean fixedLength;

    public IntegerDateFieldPatternVerifier(int field, boolean fixedLength) {
        super(field);
        this.fixedLength = fixedLength;
    }

    public IntegerDateFieldPatternVerifier(int field, int min, int max, boolean fixedLength) {
        super(field, min, max);
        this.fixedLength = fixedLength;
    }

    @Override
    public int getMinLength() {
        return this.fixedLength ? ("" + this.getMax()).length() : 0;
    }

    @Override
    public int getMaxLength() {
        return ("" + this.getMax()).length();
    }

    @Override
    public String format(Integer value) {
        if (value == null) {
            return null;
        }
        NumberFormat format = NumberFormat.getInstance();
        format.setMaximumIntegerDigits(this.getMaxLength());
        format.setMinimumIntegerDigits(this.getMinLength());
        format.setMaximumFractionDigits(0);
        format.setGroupingUsed(false);
        return format.format(value);
    }

    @Override
    public Integer parse(String text) {
        if (text == null || text.trim().isEmpty()) {
            return null;
        }
        NumberFormat format = NumberFormat.getInstance();
        format.setMaximumIntegerDigits(this.getMaxLength());
        format.setMinimumIntegerDigits(this.getMinLength());
        format.setMaximumFractionDigits(0);
        format.setGroupingUsed(false);
        try {
            format.parse(text).intValue();
            return Integer.parseInt(text);
        }
        catch (ParseException e) {
            throw new NumberFormatException(e.getLocalizedMessage());
        }
    }

    public Boolean call(String text) {
        if (text.length() > this.getMaxLength()) {
            return false;
        }
        try {
            int i = this.parse(text);
            if (i >= this.getMin() && i <= this.getMax()) {
                return true;
            }
        }
        catch (NumberFormatException e) {
            CommonUtils.ignoreException((Exception)e);
        }
        return false;
    }
}

