/*
 * Decompiled with CFR 0.152.
 */
package jidefx.scene.control.field;

import java.text.SimpleDateFormat;
import java.time.DateTimeException;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import jidefx.scene.control.field.PopupField;
import jidefx.scene.control.field.verifier.PatternVerifierUtils;
import jidefx.utils.CommonUtils;

public class LocalTimeField
extends PopupField<LocalTime> {
    private static final String STYLE_CLASS_DEFAULT = "local-time-field";
    private ObjectProperty<DateTimeFormatter> _dateTimeFormatProperty;

    public LocalTimeField() {
        this(((SimpleDateFormat)SimpleDateFormat.getTimeInstance()).toPattern());
    }

    public LocalTimeField(String pattern) {
        this(pattern, LocalTime.now());
    }

    public LocalTimeField(String pattern, LocalTime value) {
        this.setPattern(pattern);
        this.setValue(value);
    }

    @Override
    protected void initializeStyle() {
        super.initializeStyle();
        this.getStyleClass().addAll((Object[])new String[]{STYLE_CLASS_DEFAULT});
    }

    @Override
    protected void initializeTextField() {
        super.initializeTextField();
        this.setSpinnersVisible(true);
        this.setPopupButtonVisible(false);
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
        this.patternProperty().addListener(new InvalidationListener(){

            public void invalidated(Observable observable) {
                LocalTimeField.this.setDateTimeFormatter(DateTimeFormatter.ofPattern(LocalTimeField.this.getPattern()));
            }
        });
    }

    @Override
    protected boolean supportFromString() {
        return this.getDateTimeFormatter() != null || super.supportFromString();
    }

    @Override
    protected LocalTime fromString(String text) {
        DateTimeFormatter dateTimeFormatter = this.getDateTimeFormatter();
        if (dateTimeFormatter != null) {
            try {
                TemporalAccessor parse = dateTimeFormatter.parse(text);
                try {
                    return LocalTime.from(parse);
                }
                catch (DateTimeException e) {
                    CommonUtils.ignoreException((Exception)e);
                }
            }
            catch (DateTimeParseException e) {
                CommonUtils.ignoreException((Exception)e);
            }
        }
        return (LocalTime)super.fromString(text);
    }

    @Override
    protected String toString(LocalTime value) {
        DateTimeFormatter formatter = this.getDateTimeFormatter();
        if (formatter != null) {
            try {
                return formatter.format(value);
            }
            catch (Exception e) {
                CommonUtils.ignoreException((Exception)e);
            }
        }
        return super.toString(value);
    }

    public ObjectProperty<DateTimeFormatter> dateTimeFormatterProperty() {
        if (this._dateTimeFormatProperty == null) {
            this._dateTimeFormatProperty = new SimpleObjectProperty<DateTimeFormatter>((Object)this, "dateTimeFormatter"){

                protected void invalidated() {
                    super.invalidated();
                    PatternVerifierUtils.initializePatternVerifiersForDateTimeFormatter(LocalTimeField.this.getPatternVerifiers());
                    LocalTimeField.this.setStringConverter(null);
                }
            };
        }
        return this._dateTimeFormatProperty;
    }

    public DateTimeFormatter getDateTimeFormatter() {
        return (DateTimeFormatter)this.dateTimeFormatterProperty().get();
    }

    public void setDateTimeFormatter(DateTimeFormatter format) {
        this.dateTimeFormatterProperty().set((Object)format);
    }

    public static LocalTimeField createLocalTimeField(String timeFormat, LocalTime initialValue) {
        LocalTimeField field = new LocalTimeField(timeFormat);
        field.setValue(initialValue);
        return field;
    }

    public static LocalTimeField createLocalTimeField(LocalTime initialValue) {
        LocalTimeField field = new LocalTimeField();
        field.setValue(initialValue);
        return field;
    }

    public static LocalTimeField createLocalTimeField() {
        return new LocalTimeField();
    }
}

