/*
 * Decompiled with CFR 0.152.
 */
package jidefx.scene.control.field;

import java.util.ArrayList;
import java.util.List;
import javafx.geometry.Insets;
import javafx.util.Callback;
import jidefx.scene.control.field.DoubleField;
import jidefx.scene.control.field.FormattedTextField;
import jidefx.scene.control.field.PopupField;
import jidefx.scene.control.field.popup.PopupContent;
import jidefx.scene.control.field.popup.ValuesPopupContent;
import jidefx.scene.control.field.verifier.NumberValuePatternVerifier;
import jidefx.utils.converter.ConverterContext;
import jidefx.utils.converter.javafx.InsetsConverter;

public class InsetsField
extends PopupField<Insets> {
    private static final String STYLE_CLASS_DEFAULT = "insets-field";

    @Override
    protected void initializeStyle() {
        super.initializeStyle();
        this.getStyleClass().addAll((Object[])new String[]{STYLE_CLASS_DEFAULT});
    }

    @Override
    protected void initializePattern() {
        super.initializePattern();
        this.setStringConverter(new InsetsConverter(){

            protected String toString(int i, Double o, ConverterContext context) {
                if (o == null) {
                    return "";
                }
                return o.toString();
            }

            protected Double fromString(int i, String s, ConverterContext context) {
                if (s == null || s.trim().isEmpty()) {
                    return null;
                }
                return Double.valueOf(s);
            }
        }.toStringConverter());
        this.getPatternVerifiers().put((Object)"Top", (Object)new NumberValuePatternVerifier<Insets>(){

            @Override
            public Double toTargetValue(Insets fieldValue) {
                return fieldValue.getTop();
            }

            @Override
            public Insets fromTargetValue(Insets previousFieldValue, Number value) {
                double top = value.doubleValue();
                return previousFieldValue != null ? new Insets(top, previousFieldValue.getRight(), previousFieldValue.getBottom(), previousFieldValue.getLeft()) : new Insets(top, 0.0, 0.0, 0.0);
            }
        });
        this.getPatternVerifiers().put((Object)"Right", (Object)new NumberValuePatternVerifier<Insets>(){

            @Override
            public Double toTargetValue(Insets fieldValue) {
                return fieldValue.getRight();
            }

            @Override
            public Insets fromTargetValue(Insets previousFieldValue, Number value) {
                double right = value.doubleValue();
                return previousFieldValue != null ? new Insets(previousFieldValue.getTop(), right, previousFieldValue.getBottom(), previousFieldValue.getLeft()) : new Insets(0.0, right, 0.0, 0.0);
            }
        });
        this.getPatternVerifiers().put((Object)"Bottom", (Object)new NumberValuePatternVerifier<Insets>(){

            @Override
            public Double toTargetValue(Insets fieldValue) {
                return fieldValue.getBottom();
            }

            @Override
            public Insets fromTargetValue(Insets previousFieldValue, Number value) {
                double bottom = value.doubleValue();
                return previousFieldValue != null ? new Insets(previousFieldValue.getTop(), previousFieldValue.getRight(), bottom, previousFieldValue.getLeft()) : new Insets(0.0, 0.0, bottom, 0.0);
            }
        });
        this.getPatternVerifiers().put((Object)"Left", (Object)new NumberValuePatternVerifier<Insets>(){

            @Override
            public Double toTargetValue(Insets fieldValue) {
                return fieldValue.getLeft();
            }

            @Override
            public Insets fromTargetValue(Insets previousFieldValue, Number value) {
                double left = value.doubleValue();
                return previousFieldValue != null ? new Insets(previousFieldValue.getTop(), previousFieldValue.getRight(), previousFieldValue.getBottom(), left) : new Insets(0.0, 0.0, 0.0, left);
            }
        });
        this.setPattern("Top; Right; Bottom; Left");
    }

    @Override
    protected void initializeTextField() {
        super.initializeTextField();
        this.setPopupContentFactory(new Callback<Insets, PopupContent<Insets>>(){

            public PopupContent<Insets> call(Insets param) {
                ValuesPopupContent<Insets, Double> popupContent = new ValuesPopupContent<Insets, Double>(new String[]{InsetsField.this.getResourceString("top"), InsetsField.this.getResourceString("right"), InsetsField.this.getResourceString("bottom"), InsetsField.this.getResourceString("left")}){

                    @Override
                    public List<Double> toValues(Insets value) {
                        ArrayList<Double> list = new ArrayList<Double>(4);
                        list.add(value.getTop());
                        list.add(value.getRight());
                        list.add(value.getBottom());
                        list.add(value.getLeft());
                        return list;
                    }

                    @Override
                    public Insets fromValues(List<Double> values) {
                        return new Insets(values.get(0).doubleValue(), values.get(1).doubleValue(), values.get(2).doubleValue(), values.get(3).doubleValue());
                    }

                    @Override
                    public FormattedTextField<Double> createTextField(String label) {
                        return new DoubleField();
                    }
                };
                popupContent.setValue((Insets)InsetsField.this.getValue());
                return popupContent;
            }
        });
    }
}

