/*
 * Decompiled with CFR 0.152.
 */
package jidefx.scene.control.combobox;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.util.Callback;
import jidefx.scene.control.combobox.FormattedComboBox;
import jidefx.scene.control.field.DateField;
import jidefx.scene.control.field.FormattedTextField;
import jidefx.scene.control.field.popup.PopupContent;

public class DateComboBox
extends FormattedComboBox<Date> {
    private static final String STYLE_CLASS_DEFAULT = "date-combo-box";
    private StringProperty _patternProperty;

    public DateComboBox() {
        this(((SimpleDateFormat)SimpleDateFormat.getDateInstance()).toPattern(), Calendar.getInstance().getTime());
    }

    public DateComboBox(String pattern) {
        this(pattern, Calendar.getInstance().getTime());
    }

    public DateComboBox(Date date) {
        this(((SimpleDateFormat)SimpleDateFormat.getDateInstance()).toPattern(), date);
    }

    public DateComboBox(String pattern, Date date) {
        super(date);
        this.setPattern(pattern);
    }

    @Override
    protected void initializeStyle() {
        super.initializeStyle();
        this.getStyleClass().add((Object)STYLE_CLASS_DEFAULT);
    }

    public StringProperty patternProperty() {
        if (this._patternProperty == null) {
            this._patternProperty = new SimpleStringProperty();
        }
        return this._patternProperty;
    }

    public String getPattern() {
        return (String)this.patternProperty().get();
    }

    public void setPattern(String pattern) {
        this.patternProperty().set((Object)pattern);
    }

    @Override
    protected FormattedTextField<Date> createFormattedTextField() {
        DateField field = new DateField(this.getPattern());
        field.patternProperty().bind((ObservableValue)this.patternProperty());
        return field;
    }

    @Override
    protected void initializeComboBox() {
        super.initializeComboBox();
        this.setPopupContentFactory(new Callback<Date, PopupContent<Date>>(){

            public PopupContent<Date> call(Date param) {
                PopupContent popupContent = (PopupContent)((DateField)DateComboBox.this.getEditor()).getPopupContentFactory().call((Object)param);
                popupContent.valueProperty().addListener((ChangeListener)new ChangeListener<Date>(){

                    public void changed(ObservableValue<? extends Date> observable, Date oldValue, Date newValue) {
                        DateComboBox.this.hide();
                    }
                });
                return popupContent;
            }
        });
    }
}

