/*
 * Decompiled with CFR 0.152.
 */
package com.jerolba.carpet.model;

import com.jerolba.carpet.model.FieldType;
import com.jerolba.carpet.model.FieldTypes;
import com.jerolba.carpet.model.ToBooleanFunction;
import com.jerolba.carpet.model.ToByteFunction;
import com.jerolba.carpet.model.ToFloatFunction;
import com.jerolba.carpet.model.ToShortFunction;
import com.jerolba.carpet.model.WriteField;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;

public final class WriteRecordModelType<T>
implements FieldType {
    private final Class<T> recordClass;
    private final List<WriteField<T>> fields = new ArrayList<WriteField<T>>();
    private final Map<String, WriteField<T>> indexedFields = new HashMap<String, WriteField<T>>();
    private boolean isNotNull = false;

    WriteRecordModelType(Class<T> recordClass) {
        this.recordClass = recordClass;
    }

    static <T> WriteRecordModelType<T> writeRecordModel(Class<T> recordClass) {
        return new WriteRecordModelType<T>(recordClass);
    }

    public Class<T> getClassType() {
        return this.recordClass;
    }

    public WriteRecordModelType<T> notNull() {
        this.isNotNull = true;
        return this;
    }

    @Override
    public boolean isNotNull() {
        return this.isNotNull;
    }

    public List<WriteField<T>> getFields() {
        return this.fields;
    }

    public WriteRecordModelType<T> withField(String parquetFieldName, FieldType type, Function<T, Object> accessor) {
        Objects.requireNonNull(parquetFieldName);
        Objects.requireNonNull(type);
        Objects.requireNonNull(accessor);
        if (this.indexedFields.containsKey(parquetFieldName)) {
            throw new IllegalArgumentException(parquetFieldName + " already defined");
        }
        FunctionFieldInfo<T> field = new FunctionFieldInfo<T>(parquetFieldName, type, accessor);
        this.fields.add(field);
        this.indexedFields.put(parquetFieldName, field);
        return this;
    }

    public WriteRecordModelType<T> withField(String parquetFieldName, ToBooleanFunction<T> accessor) {
        return this.primitiveField(parquetFieldName, FieldTypes.BOOLEAN.notNull(), accessor);
    }

    public WriteRecordModelType<T> withField(String parquetFieldName, ToByteFunction<T> accessor) {
        return this.primitiveField(parquetFieldName, FieldTypes.BYTE.notNull(), accessor);
    }

    public WriteRecordModelType<T> withField(String parquetFieldName, ToShortFunction<T> accessor) {
        return this.primitiveField(parquetFieldName, FieldTypes.SHORT.notNull(), accessor);
    }

    public WriteRecordModelType<T> withField(String parquetFieldName, ToIntFunction<T> accessor) {
        return this.primitiveField(parquetFieldName, FieldTypes.INTEGER.notNull(), accessor);
    }

    public WriteRecordModelType<T> withField(String parquetFieldName, ToLongFunction<T> accessor) {
        return this.primitiveField(parquetFieldName, FieldTypes.LONG.notNull(), accessor);
    }

    public WriteRecordModelType<T> withField(String parquetFieldName, ToFloatFunction<T> accessor) {
        return this.primitiveField(parquetFieldName, FieldTypes.FLOAT.notNull(), accessor);
    }

    public WriteRecordModelType<T> withField(String parquetFieldName, ToDoubleFunction<T> accessor) {
        return this.primitiveField(parquetFieldName, FieldTypes.DOUBLE.notNull(), accessor);
    }

    private WriteRecordModelType<T> primitiveField(String parquetFieldName, FieldType type, Object accessor) {
        Objects.requireNonNull(parquetFieldName);
        Objects.requireNonNull(accessor);
        if (this.indexedFields.containsKey(parquetFieldName)) {
            throw new IllegalArgumentException(parquetFieldName + " already defined");
        }
        if (!type.isNotNull()) {
            throw new IllegalArgumentException(parquetFieldName + " is not defined as not null");
        }
        PrimitiveJavaFieldInfo field = new PrimitiveJavaFieldInfo(parquetFieldName, type, accessor);
        this.fields.add(field);
        this.indexedFields.put(parquetFieldName, field);
        return this;
    }

    public record FunctionFieldInfo<T>(String parquetFieldName, FieldType fieldType, Function<T, Object> accessor) implements WriteField<T>
    {
    }

    public record PrimitiveJavaFieldInfo<T>(String parquetFieldName, FieldType fieldType, Object accessor) implements WriteField<T>
    {
    }
}

