/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.local.server;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.local.server.DynamoDBRequestHandler;
import com.amazonaws.services.dynamodbv2.local.shared.access.LocalDBClient;
import com.amazonaws.services.dynamodbv2.local.shared.access.sqlite.SQLiteDBAccess;
import com.amazonaws.services.dynamodbv2.model.BatchGetItemRequest;
import com.amazonaws.services.dynamodbv2.model.BatchGetItemResult;
import com.amazonaws.services.dynamodbv2.model.BatchWriteItemRequest;
import com.amazonaws.services.dynamodbv2.model.BatchWriteItemResult;
import com.amazonaws.services.dynamodbv2.model.CreateTableRequest;
import com.amazonaws.services.dynamodbv2.model.CreateTableResult;
import com.amazonaws.services.dynamodbv2.model.DeleteItemRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteItemResult;
import com.amazonaws.services.dynamodbv2.model.DeleteTableRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteTableResult;
import com.amazonaws.services.dynamodbv2.model.DescribeTableRequest;
import com.amazonaws.services.dynamodbv2.model.DescribeTableResult;
import com.amazonaws.services.dynamodbv2.model.GetItemRequest;
import com.amazonaws.services.dynamodbv2.model.GetItemResult;
import com.amazonaws.services.dynamodbv2.model.ListTablesRequest;
import com.amazonaws.services.dynamodbv2.model.ListTablesResult;
import com.amazonaws.services.dynamodbv2.model.PutItemRequest;
import com.amazonaws.services.dynamodbv2.model.PutItemResult;
import com.amazonaws.services.dynamodbv2.model.QueryRequest;
import com.amazonaws.services.dynamodbv2.model.QueryResult;
import com.amazonaws.services.dynamodbv2.model.ScanRequest;
import com.amazonaws.services.dynamodbv2.model.ScanResult;
import com.amazonaws.services.dynamodbv2.model.UpdateItemRequest;
import com.amazonaws.services.dynamodbv2.model.UpdateItemResult;
import com.amazonaws.services.dynamodbv2.model.UpdateTableRequest;
import com.amazonaws.services.dynamodbv2.model.UpdateTableResult;
import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class LocalDynamoDBRequestHandler
extends DynamoDBRequestHandler {
    private Map<String, AmazonDynamoDB> dbRequestHandlers;
    private boolean runInMemory = false;
    private String dbFileLocation = null;

    public LocalDynamoDBRequestHandler(int authorityLevel) {
        super(authorityLevel);
        this.dbRequestHandlers = new ConcurrentHashMap<String, AmazonDynamoDB>();
    }

    public LocalDynamoDBRequestHandler(int authorityLevel, boolean runInMemory) {
        super(authorityLevel);
        this.runInMemory = runInMemory;
        this.dbRequestHandlers = new ConcurrentHashMap<String, AmazonDynamoDB>();
    }

    public LocalDynamoDBRequestHandler(int authorityLevel, String dbFileLocation) {
        super(authorityLevel);
        this.dbFileLocation = dbFileLocation;
        this.dbRequestHandlers = new ConcurrentHashMap<String, AmazonDynamoDB>();
    }

    private synchronized AmazonDynamoDB getHandler(String credentials) {
        AmazonDynamoDB ret = this.dbRequestHandlers.get(credentials);
        if (ret == null) {
            ret = this.runInMemory ? new LocalDBClient(new SQLiteDBAccess()) : (this.dbFileLocation != null ? new LocalDBClient(new SQLiteDBAccess(String.valueOf(this.dbFileLocation) + File.separator + credentials + ".db")) : new LocalDBClient(new SQLiteDBAccess(String.valueOf(credentials) + ".db")));
            this.dbRequestHandlers.put(credentials, ret);
        }
        return ret;
    }

    @Override
    public void shutdown() {
        for (AmazonDynamoDB client : this.dbRequestHandlers.values()) {
            client.shutdown();
        }
    }

    @Override
    public BatchGetItemResult batchGetItem(String accessKey, String region, BatchGetItemRequest req) {
        return this.getHandler(this.getCredentialsString(accessKey, region)).batchGetItem(req);
    }

    @Override
    public BatchWriteItemResult batchWriteItem(String accessKey, String region, BatchWriteItemRequest req) {
        return this.getHandler(this.getCredentialsString(accessKey, region)).batchWriteItem(req);
    }

    @Override
    public CreateTableResult createTable(String accessKey, String region, CreateTableRequest req) {
        return this.getHandler(this.getCredentialsString(accessKey, region)).createTable(req);
    }

    @Override
    public DeleteItemResult deleteItem(String accessKey, String region, DeleteItemRequest req) {
        return this.getHandler(this.getCredentialsString(accessKey, region)).deleteItem(req);
    }

    @Override
    public DeleteTableResult deleteTable(String accessKey, String region, DeleteTableRequest req) {
        return this.getHandler(this.getCredentialsString(accessKey, region)).deleteTable(req);
    }

    @Override
    public DescribeTableResult describeTable(String accessKey, String region, DescribeTableRequest req) {
        return this.getHandler(this.getCredentialsString(accessKey, region)).describeTable(req);
    }

    @Override
    public GetItemResult getItem(String accessKey, String region, GetItemRequest req) {
        return this.getHandler(this.getCredentialsString(accessKey, region)).getItem(req);
    }

    @Override
    public ListTablesResult listTables(String accessKey, String region, ListTablesRequest req) {
        return this.getHandler(this.getCredentialsString(accessKey, region)).listTables(req);
    }

    @Override
    public PutItemResult putItem(String accessKey, String region, PutItemRequest req) {
        return this.getHandler(this.getCredentialsString(accessKey, region)).putItem(req);
    }

    @Override
    public QueryResult query(String accessKey, String region, QueryRequest req) {
        return this.getHandler(this.getCredentialsString(accessKey, region)).query(req);
    }

    @Override
    public ScanResult scan(String accessKey, String region, ScanRequest req) {
        return this.getHandler(this.getCredentialsString(accessKey, region)).scan(req);
    }

    @Override
    public UpdateItemResult updateItem(String accessKey, String region, UpdateItemRequest req) {
        return this.getHandler(this.getCredentialsString(accessKey, region)).updateItem(req);
    }

    @Override
    public UpdateTableResult updateTable(String accessKey, String region, UpdateTableRequest req) {
        return this.getHandler(this.getCredentialsString(accessKey, region)).updateTable(req);
    }

    private String getCredentialsString(String accessKey, String region) {
        return String.valueOf(accessKey) + "_" + region;
    }
}

