/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.exceptions;

public enum AmazonServiceExceptionType {
    INCOMPLETE_SIGNATURE(400, "IncompleteSignature", "The request signature does not conform to AWS standards."),
    INTERNAL_FAILURE(500, "InternalFailure", "The request processing has failed because of an unknown error, exception or failure."),
    INVALID_VERSION(400, "InvalidAction", "DynamoDB Local does not support v1 API."),
    INVALID_ACTION(400, "InvalidAction", "The action or operation requested is invalid. Verify that the action is typed correctly."),
    INVALID_CLIENT_TOKEN_ID(400, "InvalidClientTokenId", "The X.509 certificate or AWS access key ID provided does not exist in our records."),
    INVALID_PARAMETER_COMBINATION(400, "InvalidParameterCombination", "Parameters that must not be used together were used together."),
    INVALID_PARAMETER_VALUE(400, "InvalidParameterValue", "An invalid or out-of-range value was supplied for the input parameter."),
    INVALID_QUERY_PARAMETER(400, "InvalidQueryParameter", "AWS query string is malformed, does not adhere to AWS standards."),
    MALFORMED_QUERY_STRING(404, "MalformedQueryString", "The query string contains a syntax error."),
    MISSING_ACTION(400, "MissingAction", "The request is missing an action or a required parameter."),
    MISSING_AUTHENTICATION_TOKEN(400, "MissingAuthenticationToken", "Request must contain either a valid (registered) AWS access key ID or X.509 certificate."),
    MISSING_PARAMETER(400, "MissingParameter", "A required parameter for the specified action is not supplied."),
    OPT_IN_REQUIRED(400, "OptInRequired", "The AWS access key ID needs a subscription for the service."),
    REQUEST_EXPIRED(400, "RequestExpired", "The request reached the service more than 15 minutes after the date stamp on the request or more than 15 minutes after the request expiration date (such as for pre-signed URLs), or the date stamp on the request is more than 15 minutes in the future."),
    SERVICE_UNAVAILABLE(500, "ServiceUnavailable", "The request has failed due to a temporary failure of the server."),
    THROTTLING(400, "Throttling", "Request was denied due to request throttling."),
    ACCESS_DENIED_EXCEPTION(400, "AccessDeniedException", "Access denied."),
    CONDITIONAL_CHECK_FAILED_EXCEPTION(400, "ConditionalCheckFailedException", "The conditional request failed."),
    INCOMPLETE_SIGNATURE_EXCEPTION(400, "IncompleteSignatureException", "The request signature does not conform to AWS standards."),
    LIMIT_EXCEEDED_EXCEPTION(400, "LimitExceededException", "Too many operations for a given subscriber."),
    MISSING_AUTHENTICATION_TOKEN_EXCEPTION(400, "MissingAuthenticationTokenException", "Request must contain a valid (registered) AWS Access Key ID."),
    PROVISIONED_THROUGHPUT_EXCEEDED_EXCEPTION(400, "ProvisionedThroughputExceededException", "You exceeded your maximum allowed provisioned throughput."),
    RESOURCE_IN_USE_EXCEPTION(400, "ResourceInUseException", "The resource which you are attempting to change is in use."),
    RESOURCE_NOT_FOUND_EXCEPTION(400, "ResourceNotFoundException", "The resource which is being requested does not exist."),
    THROTTLING_EXCEPTION(400, "ThrottlingException", "Rate of requests exceeds the allowed throughput."),
    UNRECOGNIZED_CLIENT_EXCEPTION(400, "UnrecognizedClientException", "The Access Key ID or security token is invalid."),
    VALIDATION_EXCEPTION(400, "ValidationException", "One or more required parameter values were missing."),
    REQUEST_TOO_LARGE(413, "(n/a)", "Request Entity Too Large."),
    INTERNAL_SERVER_ERROR(500, "InternalServerError", "The server encountered an internal error trying to fulfill the request."),
    SERVICE_UNAVAILABLE_EXCEPTION(500, "ServiceUnavailableException", "The service is currently unavailable or busy.");

    private int responseStatus;
    private String errorCode;
    private String message;

    private AmazonServiceExceptionType(int responseStatus, String errorCode, String message) {
        this.responseStatus = responseStatus;
        this.errorCode = errorCode;
        this.message = message;
    }

    public int getResponseStatus() {
        return this.responseStatus;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getMessage() {
        return this.message;
    }

    public String toString() {
        return String.valueOf(this.responseStatus) + ", " + this.errorCode + ", " + this.message;
    }
}

