/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.sqlite4java;

import com.almworks.sqlite4java.DirectBuffer;
import com.almworks.sqlite4java.ProgressHandler;
import com.almworks.sqlite4java.SQLiteBlob;
import com.almworks.sqlite4java.SQLiteException;
import com.almworks.sqlite4java.SQLiteLongArray;
import com.almworks.sqlite4java.SQLiteStatement;
import com.almworks.sqlite4java._SQLiteManual;
import java.io.IOException;

abstract class SQLiteController {
    SQLiteController() {
    }

    public abstract void validate() throws SQLiteException;

    public abstract void throwResult(int var1, String var2, Object var3) throws SQLiteException;

    public abstract void dispose(SQLiteStatement var1);

    public abstract void dispose(SQLiteBlob var1);

    public abstract void dispose(SQLiteLongArray var1);

    public abstract _SQLiteManual getSQLiteManual();

    public abstract DirectBuffer allocateBuffer(int var1) throws IOException, SQLiteException;

    public abstract void freeBuffer(DirectBuffer var1);

    public abstract ProgressHandler getProgressHandler() throws SQLiteException;

    public static SQLiteController getDisposed(SQLiteController controller) {
        if (controller instanceof Disposed) {
            return controller;
        }
        boolean debug = false;
        if (!$assertionsDisabled) {
            debug = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (!debug) {
            return Disposed.INSTANCE;
        }
        return new Disposed(controller == null ? "" : controller.toString());
    }

    private static class Disposed
    extends SQLiteController {
        public static final Disposed INSTANCE = new Disposed("");
        private final String myName;

        private Disposed(String namePrefix) {
            this.myName = namePrefix + "[D]";
        }

        public String toString() {
            return this.myName;
        }

        public void validate() throws SQLiteException {
            throw new SQLiteException(-92, "statement is disposed");
        }

        public void throwResult(int resultCode, String message, Object additionalMessage) throws SQLiteException {
        }

        public void dispose(SQLiteStatement statement) {
        }

        public void dispose(SQLiteBlob blob) {
        }

        public void dispose(SQLiteLongArray array) {
        }

        public _SQLiteManual getSQLiteManual() {
            return new _SQLiteManual();
        }

        public DirectBuffer allocateBuffer(int sizeEstimate) throws IOException, SQLiteException {
            throw new IOException();
        }

        public void freeBuffer(DirectBuffer buffer) {
        }

        public ProgressHandler getProgressHandler() {
            return ProgressHandler.DISPOSED;
        }
    }
}

