/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elastictranscoder.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.elastictranscoder.model.Pipeline;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListPipelinesResult
implements Serializable {
    private ListWithAutoConstructFlag<Pipeline> pipelines;

    public List<Pipeline> getPipelines() {
        if (this.pipelines == null) {
            this.pipelines = new ListWithAutoConstructFlag();
            this.pipelines.setAutoConstruct(true);
        }
        return this.pipelines;
    }

    public void setPipelines(Collection<Pipeline> pipelines) {
        if (pipelines == null) {
            this.pipelines = null;
            return;
        }
        ListWithAutoConstructFlag pipelinesCopy = new ListWithAutoConstructFlag(pipelines.size());
        pipelinesCopy.addAll(pipelines);
        this.pipelines = pipelinesCopy;
    }

    public ListPipelinesResult withPipelines(Pipeline ... pipelines) {
        if (this.getPipelines() == null) {
            this.setPipelines(new ArrayList<Pipeline>(pipelines.length));
        }
        for (Pipeline value : pipelines) {
            this.getPipelines().add(value);
        }
        return this;
    }

    public ListPipelinesResult withPipelines(Collection<Pipeline> pipelines) {
        if (pipelines == null) {
            this.pipelines = null;
        } else {
            ListWithAutoConstructFlag pipelinesCopy = new ListWithAutoConstructFlag(pipelines.size());
            pipelinesCopy.addAll(pipelines);
            this.pipelines = pipelinesCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPipelines() != null) {
            sb.append("Pipelines: " + this.getPipelines());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPipelines() == null ? 0 : this.getPipelines().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPipelinesResult)) {
            return false;
        }
        ListPipelinesResult other = (ListPipelinesResult)obj;
        if (other.getPipelines() == null ^ this.getPipelines() == null) {
            return false;
        }
        return other.getPipelines() == null || other.getPipelines().equals(this.getPipelines());
    }
}

