/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.KeyPair;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyPairStaxUnmarshaller
implements Unmarshaller<KeyPair, StaxUnmarshallerContext> {
    private static KeyPairStaxUnmarshaller instance;

    @Override
    public KeyPair unmarshall(StaxUnmarshallerContext context) throws Exception {
        KeyPair keyPair = new KeyPair();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return keyPair;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("keyName", targetDepth)) {
                    keyPair.setKeyName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("keyFingerprint", targetDepth)) {
                    keyPair.setKeyFingerprint(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("keyMaterial", targetDepth)) continue;
                keyPair.setKeyMaterial(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return keyPair;
    }

    public static KeyPairStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new KeyPairStaxUnmarshaller();
        }
        return instance;
    }
}

