/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.store;

import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.util.Named;
import com.hp.hpl.jena.tdb.TDBException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum NodeType implements Named
{
    BNODE{

        public XSDDatatype getDatatype() {
            return null;
        }

        public int getTypeId() {
            return 1;
        }

        public String getName() {
            return "BNode";
        }
    }
    ,
    URI{

        public XSDDatatype getDatatype() {
            return null;
        }

        public int getTypeId() {
            return 2;
        }

        public String getName() {
            return "URI";
        }
    }
    ,
    LITERAL{

        public XSDDatatype getDatatype() {
            return null;
        }

        public int getTypeId() {
            return 3;
        }

        public String getName() {
            return "Literal";
        }
    }
    ,
    OTHER{

        public XSDDatatype getDatatype() {
            return null;
        }

        public int getTypeId() {
            return 50;
        }

        public String getName() {
            return "Other";
        }
    };


    public abstract int getTypeId();

    public abstract XSDDatatype getDatatype();

    public abstract String getName();

    public String toString() {
        return this.getName();
    }

    public static NodeType lookup(Node n) {
        if (n.isURI()) {
            return URI;
        }
        if (n.isBlank()) {
            return BNODE;
        }
        if (n.isLiteral()) {
            return LITERAL;
        }
        return OTHER;
    }

    public static NodeType lookup(int type) {
        if (type == BNODE.getTypeId()) {
            return BNODE;
        }
        if (type == URI.getTypeId()) {
            return URI;
        }
        if (type == LITERAL.getTypeId()) {
            return LITERAL;
        }
        throw new TDBException("Unknown type (" + type + ")");
    }
}

