/*
 * #%L
 * SGQ :: Web
 * $Id: ProductEditAction.java 358 2013-05-07 16:19:59Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-1.1.1/sgq-web/src/main/java/com/herbocailleau/sgq/web/actions/admin/ProductEditAction.java $
 * %%
 * Copyright (C) 2012, 2013 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.web.actions.admin;

import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import com.herbocailleau.sgq.business.SgqBusinessException;
import com.herbocailleau.sgq.business.services.ReferentialService;
import com.herbocailleau.sgq.entities.AnalyzeType;
import com.herbocailleau.sgq.entities.Product;
import com.herbocailleau.sgq.entities.ProductImpl;
import com.herbocailleau.sgq.entities.ProductStatus;
import com.herbocailleau.sgq.web.SgqActionSupport;
import com.opensymphony.xwork2.Preparable;

public class ProductEditAction extends SgqActionSupport implements Preparable {

    /** serialVersionUID. */
    private static final long serialVersionUID = 5564446302091087009L;

    protected ReferentialService referentialService;

    protected String productId;

    protected Product product;

    protected List<String> categories;

    protected List<ProductStatus> status;

    protected List<AnalyzeType> analyzeTypes;

    protected List<String> productStatusIds;

    protected String productStatusName;

    protected String productCategoryName;

    protected List<String> analyzeTypeIds;

    /** Can delete unused product. */
    protected boolean canBeDeleted;

    /** Can be achived product. */
    protected boolean canBeArchived;

    public void setProductId(String productId) {
        this.productId = productId;
    }

    @Override
    public void prepare() throws Exception {
        referentialService = newService(ReferentialService.class);
        status = referentialService.findAllProductStatus();
        analyzeTypes = referentialService.findAllAnalyzeTypes();
        categories = referentialService.findAllProductCategories();
    }

    public List<String> getCategories() {
        return categories;
    }

    public List<ProductStatus> getStatus() {
        return status;
    }

    public List<AnalyzeType> getAnalyzeTypes() {
        return analyzeTypes;
    }

    public void setProductStatusIds(List<String> productStatusIds) {
        this.productStatusIds = productStatusIds;
    }

    public String getProductCategoryName() {
        return productCategoryName;
    }

    public void setProductCategoryName(String productCategoryName) {
        this.productCategoryName = productCategoryName;
    }

    public String getProductStatusName() {
        return productStatusName;
    }

    public void setProductStatusName(String productStatusName) {
        this.productStatusName = productStatusName;
    }

    public void setAnalyzeTypeIds(List<String> analyzeTypeIds) {
        this.analyzeTypeIds = analyzeTypeIds;
    }

    @Override
    @Action(results={@Result(type="redirectAction", params = {"actionName" , "product-list"})})
    public String execute() throws Exception {

        product.clearProductStatus();
        for (String productStatusId : productStatusIds) {
            product.addProductStatus(referentialService.getProductStatusById(productStatusId));
        }

        product.clearAnalyzeType();
        for (String analyzeTypeId : analyzeTypeIds) {
            product.addAnalyzeType(referentialService.findAnalyzeTypeById(analyzeTypeId));
        }

        if (StringUtils.isNotBlank(productCategoryName)) {
            product.setCategory(productCategoryName);
        }
        
        String result = SUCCESS;
        try {
            referentialService.saveProduct(product, productStatusName);
        } catch (SgqBusinessException ex) {
            addActionError(ex.getMessage());
            result = input();
        }

        return result;
    }

    public Product getProduct() {
        if (product == null) {
            String productId = getParameter("productId");
            if (StringUtils.isNotBlank(productId)) {
                product = referentialService.getProductById(productId);
                canBeDeleted = referentialService.canBeDeleteProduct(product);
                canBeArchived = referentialService.canBeArchivedProduct(product);
            } else {
                product = new ProductImpl();
            }
        }
        return product;
    }

    public boolean isCanBeDeleted() {
        return canBeDeleted;
    }

    public boolean isCanBeArchived() {
        return canBeArchived;
    }

    @Action(value="product-delete", results={@Result(type="redirectAction", params = {"actionName" , "product-list"})})
    public String deleteProduct() {
        referentialService.deleteProduct(getProduct());
        return SUCCESS;
    }

    @Action(value="product-archive", results={@Result(type="redirectAction", params = {"actionName" , "product-list"})})
    public String archiveProduct() {
        referentialService.archiveProduct(getProduct());
        return SUCCESS;
    }
    
    @Action(value="product-unarchive", results={@Result(type="redirectAction", params = {"actionName" , "product-list"})})
    public String unArchiveProduct() {
        referentialService.unArchiveProduct(getProduct());
        return SUCCESS;
    }
}
