/*
 * #%L
 * SGQ :: Web
 * $Id: IndexAction.java 381 2013-05-31 14:45:54Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-1.1.1/sgq-web/src/main/java/com/herbocailleau/sgq/web/actions/IndexAction.java $
 * %%
 * Copyright (C) 2012, 2013 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.web.actions;

import java.util.Date;
import java.util.List;

import com.herbocailleau.sgq.business.SgqUtils;
import com.herbocailleau.sgq.business.services.BatchService;
import com.herbocailleau.sgq.business.services.ProductionService;
import com.herbocailleau.sgq.entities.Batch;
import com.herbocailleau.sgq.entities.Zone;
import com.herbocailleau.sgq.web.SgqActionSupport;
import com.opensymphony.xwork2.Preparable;

/**
 * Index class.
 * 
 * Contains only lazy operation on getter (maybe be not called due to security
 * filtering).
 */
public class IndexAction extends SgqActionSupport implements Preparable {

    /** serialVersionUID. */
    private static final long serialVersionUID = -2484601181596627492L;

    protected BatchService batchService;
    protected ProductionService productionService;

    /**
     * Nombre total de lots intégrés.
     */
    protected long batchCount;

    /**
     * Nombre de lots en service.
     */
    protected long operatingBatchCount;

    /**
     * Dernier lot lot entrée en plante conventionnelle.
     */
    protected int lastConventionalBatch;
    
    /**
     * Dernier lot lot entrée en plante biologique.
     */
    protected int lastBiologicalBatch;

    /**
     * La date du dernier import production (FIF_HIST.txt).
     */
    protected Date labelProductionImportDate;

    /**
     * La date du dernier import expedition (FIC_HIST.txt).
     */
    protected Date labelExpeditionImportDate;

    /**
     * alerte pour un lot en attente d'analyse pour lequel il y a déjà une sortie externe.
     */
    protected List<Batch> batchWithOutputAndPendingAnalysis;

    /**
     * Avoir une alerte pour un lot lorsque le cumul des ventes est supérieur à la quantité entrée.
     */
    protected List<Batch> batchWithMoreSellThanStock;

    /**
     * Lots probablement expirés et pour lesquels une étiquette a été émise.
     */
    protected List<Batch> batchWithLabelAfterExpiration;

    /**
     * Avoir une alerte spéciale client dédié pour lesquels la quantité disponible est < ou = à 0
     */
    protected List<Batch> dedicatedClientExpiredBatch;
 
    /** Lot pour lesquels le stock est null ou negatif (suite inventaire) .*/
    protected List<Batch> batchWithNoStock;

    /** Avoir une alerte pour un lot lorsqu'une demande de bulletin doit être faite à un fournisseur. */
    protected List<Batch> batchWithBulletinToAsk;

    /**
     * Import lot en erreur.
     */
    protected Long labelErrorCount;

    /** Now date. */
    protected Date now;

    /**
     * La date d'entrée du dernier produit importé.
     */
    protected Date batchMaxEntryDate;

    @Override
    public void prepare() throws Exception {
        batchService = newService(BatchService.class);
        productionService = newService(ProductionService.class);
    }
    
    @Override
    public String execute() throws Exception {
        batchCount = batchService.getBatchCount();
        operatingBatchCount = batchService.getOperatingBatchCount();
        lastConventionalBatch = batchService.getLastConventionalBatch();
        lastBiologicalBatch = batchService.getLastBiologicalBatch();
        labelProductionImportDate = productionService.getLastImportDate(Zone.ZE);
        labelExpeditionImportDate = productionService.getLastImportDate(Zone.ZP);
        return SUCCESS;
    }

    public long getBatchCount() {
        return batchCount;
    }

    public long getOperatingBatchCount() {
        return operatingBatchCount;
    }

    public int getLastConventionalBatch() {
        return lastConventionalBatch;
    }

    public int getLastBiologicalBatch() {
        return lastBiologicalBatch;
    }

    public Date getLabelProductionImportDate() {
        return labelProductionImportDate;
    }

    public Date getLabelExpeditionImportDate() {
        return labelExpeditionImportDate;
    }

    
    public List<Batch> getBatchWithOutputAndPendingAnalysis() {
        if (batchWithOutputAndPendingAnalysis == null) {
            batchWithOutputAndPendingAnalysis = batchService.getBatchWithOutputAndPendingAnalysis();
        }
        return batchWithOutputAndPendingAnalysis;
    }

    public long getLabelErrorCount() {
        if (labelErrorCount == null) {
            labelErrorCount = productionService.getLabelErrorCount();
        }
        return labelErrorCount;
    }

    public List<Batch> getBatchWithMoreSellThanStock() {
        if (batchWithMoreSellThanStock == null) {
            batchWithMoreSellThanStock = batchService.getBatchWithMoreSellThanStock();
        }
        return batchWithMoreSellThanStock;
    }

    public List<Batch> getDedicatedClientExpiredBatch() {
        if (dedicatedClientExpiredBatch == null) {
            dedicatedClientExpiredBatch = batchService.getDedicatedClientExpiredBatch();
        }
        return dedicatedClientExpiredBatch;
    }

    public List<Batch> getBatchWithNoStock() {
        if (batchWithNoStock == null) {
            batchWithNoStock = batchService.getBatchWithNoStock();
        }
        return batchWithNoStock;
    }

    public List<Batch> getBatchWithLabelAfterExpiration() {
        if (batchWithLabelAfterExpiration == null) {
            batchWithLabelAfterExpiration = productionService.getBatchWithLabelAfterExpiration();
        }
        return batchWithLabelAfterExpiration;
    }

    public List<Batch> getBatchWithBulletinToAsk() {
        if (batchWithBulletinToAsk == null) {
            batchWithBulletinToAsk = batchService.getBatchWithBulletinToAsk();
        }
        return batchWithBulletinToAsk;
    }

    public Date getNow() {
        if (now == null) {
            now = new Date();
        }
        return now;
    }

    public Date getBatchMaxEntryDate() {
        if (batchMaxEntryDate == null) {
            batchMaxEntryDate = batchService.getBatchMaxEntryDate();
        }
        return batchMaxEntryDate;
    }

    /**
     * Utility method for view to compute day between two dates.
     * 
     * @param date1 date 1
     * @param date2 date 2
     * @return days between those dates
     */
    public long daysBetween(Date date1, Date date2) {
        // delegation for jsp
        return SgqUtils.daysBetween(date1, date2);
    }
}
